<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane">
            <div class="pane content-configuration"  style="margin: 0 auto">
                <div class="caption" style="border-radius: 0; padding: 2.5px;">
                    <?php $this->load->view('user/nav') ?>
                </div>
            </div>
            <div class="page-content">
                <?php //debugPrint($logtimes) ?>
                <table class="report-table text-center">
                    <tr>
                        <th colspan="1"><input type="text" id="reportDateFrom" class="form-control" placeholder="Date Form" value="<?php echo $log_start ?>"></th>
                        <th colspan="1"><input type="text" id="reportDateTo" class="form-control" placeholder="Date To" value="<?php echo $log_end ?>"></th>
                        <th colspan="2"><button type="submit" class="btn btn-primary btn-large" style="width: 100%" onclick="filterLogtime()"><i class="icon icon-search text-center" ></i>&nbsp;<?php echo $this->lang->line('filter') . ' ' . sprintf($this->lang->line('dash_report'), $this->lang->line('log_time')) ?></button></th>
                    </tr>
                    <tr class="table-bg">
                        <th><?php echo $this->lang->line('branch') ?></th>
                        <th><?php echo $this->lang->line('user_activity') ?></th>
                        <th><?php echo $this->lang->line('login') ?>&nbsp;IP</th>
                        <th><?php echo $this->lang->line('access_time') ?></th>
                    </tr>
                    <?php if (!empty($logtimes)): ?>
                        <?php foreach ($logtimes as $atime): ?>
                            <tr>
                                <td><?php echo get_title('branch', array('id' => $atime->branch)) ?></td>
                                <td><?php echo $atime->activity ?></td>
                                <td><?php echo $atime->login_ip ?></td>
                                <td><?php echo $atime->access_time !== '0000-00-00 00:00:00' ? date('d-m-Y H:i:s', strtotime($atime->access_time)) : 'in' ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function () {
        $('#reportDateFrom').datetimepicker({
            timepicker: false,
            format: 'd-m-Y',
            maxDate: '<?php echo date('d/m/Y', strtotime('today')) ?>',
            formatDate: 'Y/m/d'
        });
        $('#reportDateTo').datetimepicker({
            timepicker: false,
            format: 'd-m-Y',
            maxDate: '<?php echo date('d/m/Y', strtotime('today')) ?>',
            formatDate: 'Y/m/d'
        });
    });
    function filterLogtime() {
        var reportDateFrom = $.trim($('#reportDateFrom').val()) ? $('#reportDateFrom').val() : 0;
        var reportDateTo = $.trim($('#reportDateTo').val()) ? $('#reportDateTo').val() : 0;
        zamanEposNavigator('', '<?php echo site_url('user/activity/') ?>' + reportDateFrom + '/' + reportDateTo, 'reportIndex');
    }
</script>
<?php $this->load->view('settings/partials/footer') ?>
