<?php

class Passport extends Epos_Template {

    function __construct() {
        parent::__construct();
        $this->load->model('Passport_Model');
    }

    public function index($branch = null, $team = null) {
        if (($branch && (int) $branch > 0 && $this->Passport_Model->exists('branch', 'id', $branch)) && ($team && (int) $team > 0 && $this->Passport_Model->exists('userteam', 'id', $team))) {
            if (!$this->session->userdata('loginBranch')) {
                $this->session->set_userdata('loginBranch', $branch);
            } else {
                $this->session->set_userdata('loginBranch', $branch);
            }
            if (!$this->session->userdata('loginTeam')) {
                $this->session->set_userdata('loginTeam', $team);
            } else {
                $this->session->set_userdata('loginTeam', $team);
            }
            $remotePrimary = 'one';
            $remoteSecondary = 'two';
            $remoteTertiary = 'three';
            if ($this->cookies && !empty($this->cookies) && $this->cookies['primary'] == $remotePrimary && $this->cookies['secondary'] === $remoteSecondary && $this->cookies['tertiary'] === $remoteTertiary) {
                redirect('user/login/index/' . $this->session->userdata('loginBranch') . '/' . $this->session->userdata('loginTeam'));
            } else {
                $activity = array('activity' => ucfirst('unknown entry'));
                $this->Passport_Model->posactivity($activity);
                $this->render('user/passport');
            }
        } else {
            $this->session->unset_userdata('loginBranch');
            $this->session->unset_userdata('loginTeam');
            redirect('érror');
        }
    }

    public function tovalidate() {
        $primary = $this->input->post('primary');
        $secondary = $this->input->post('secondary');
        $tertiary = $this->input->post('tertiary');
        $restaurantName = $this->config->item('general_name');
        $remotePrimary = 'one';
        $remoteSecondary = 'two';
        $remoteTertiary = 'three';
        $longevity = 365;
        if ($primary === $remotePrimary && $secondary === $remoteSecondary && $tertiary === $remoteTertiary) {
            $restaurantNameWithUnderScore = preg_replace('/\s+/', '_', $restaurantName);
            $primaryCookie = array(
                'name' => $restaurantNameWithUnderScore . 'pqr',
                'value' => base64_encode($primary),
                'expire' => 3600 * 24 * (int) $longevity,
            );
            $secondaryCookie = array(
                'name' => $restaurantNameWithUnderScore . 'mno',
                'value' => base64_encode($secondary),
                'expire' => 3600 * 24 * (int) $longevity,
            );
            $tertiaryCookie = array(
                'name' => $restaurantNameWithUnderScore . 'xyz',
                'value' => base64_encode($tertiary),
                'expire' => 3600 * 24 * (int) $longevity,
            );
            $this->input->set_cookie($primaryCookie);
            $this->input->set_cookie($secondaryCookie);
            $this->input->set_cookie($tertiaryCookie);
            echo json_encode(array('status' => true, 'message' => $this->lang->line('ok')));
        } else {
            $activity = array(
                'activity' => ucfirst('unknown entry') . ' has tried to enter application'
            );
            $this->Passport_Model->posactivity($activity);
            echo json_encode(array('status' => false, 'message' => $this->lang->line('invalid_credentials_supplied')));
        }
    }

}
