<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends Epos_Template {

    function __construct() {
        parent::__construct();
        $this->load->model('Login_Model');
    }

    public function index($branch = null, $team = null, $secretKey = null) {
        if ($this->Login_Model->exists('branch', 'id', $branch) && $this->Login_Model->exists('userteam', 'id', $team)) {
            if (!$this->session->userdata('loginBranch')) {
                $this->session->set_userdata('loginBranch', $branch);
            } else {
                $this->session->set_userdata('loginBranch', $branch);
            }
            if (!$this->session->userdata('loginTeam')) {
                $this->session->set_userdata('loginTeam', $team);
            } else {
                $this->session->set_userdata('loginTeam', $team);
            }
            if (!$this->Login_Model->isThisUserAnEposLogger()) {
                if ($secretKey === 'xyz') {
                    $this->session->set_userdata('LoginBoss', 'yes');
                    $data['users'] = array();
                    $this->render('user/login', $data);
                } else if ($secretKey !== 'xyz' && (!$this->cookies || empty($this->cookies))) {
                    redirect('user/passport/index/' . $branch . '/' . $team);
                } else {
                    $this->session->set_userdata('userAccessUrl', base_url(uri_string()));
                    $this->session->set_userdata('LoginBoss', 'no');
                    $data['users'] = $this->Login_Model->get_list('user', array('status' => '3', 'group >=' => '5', 'branch' => (int) $branch, 'team' => $team), null, null, 0, 'group', 'ASC')->result();
                    $data['refresh'] = base_url(uri_string());
                    $this->render('user/login', $data);
                }
            } else {
                $this->session->set_userdata('userAccessUrl', base_url(uri_string()));
                $this->redirectTo($this->session->userdata('group'));
            }
        } else {
            redirect('error');
        }
    }

    public function engineer() {
        $data['users'] = array();
        $this->render('user/engineer', $data);
    }

    private function redirectTo($to) {
        switch ($to) {
            case '2':redirect('settings/index/verified');
            case '3':redirect('report/index/verified');
            case '4':redirect('report/index/verified');
            case '5':redirect('epos');
            case '6':redirect('epos');
            case '7':redirect('epos');
            case '8':redirect('bar');
            case '9':redirect('bakery');
            case '10':redirect('drinks');
            case '11':redirect('collection');
            case '12':redirect('kitchen');
            case '13':redirect('delivery');
            case '15':redirect('webadmin');
            default:redirect('error');
        }
    }

    public function validate() {
        $theUser = null;
        if (trim($this->input->post('eposUserId')) && trim($this->input->post('eposUserEmployeeId')) && trim($this->input->post('eposUsername')) && trim($this->input->post('eposUserPassword'))) {
            $theUser = $this->Login_Model->getUser(trim($this->input->post('eposUsername')), trim($this->input->post('eposUserPassword')), trim($this->input->post('eposUserId')), trim($this->input->post('eposUserEmployeeId')));
        } else {
            if (trim($this->input->post('eposUserNames')) && trim($this->input->post('eposUserPassword'))) {
                $theUser = $this->Login_Model->getUser(trim($this->input->post('eposUserNames')), trim($this->input->post('eposUserPassword')));
            }
        }
        $userData = array();
        if (!empty($theUser)) {
            if (count($theUser) == (int) 1) {
                $theUser = $theUser[0];
                $userData = array(
                    'branch' => $theUser->branch,
                    'loginBranch' => $theUser->branch,
                    'owner' => $theUser->id,
                    'group' => $theUser->group,
                    'team' => $theUser->team > 0 ? $theUser->team : 0,
                    'username' => $theUser->username,
                    'name' => $theUser->display,
                    'eposStyle' => $theUser->eposStyle,
                    'userApps' => trim($theUser->onapp) ? unserialize($theUser->onapp) : array(),
                    'beep' => $theUser->beep,
                    'beepLabel' => $theUser->beepLabel,
                    'isTaxIncluded' => $this->Login_Model->get_single('branch', array('id' => $theUser->branch))->row()->taxIsIncluded
                );
                if ($this->cookies && !empty($this->cookies) || $theUser->group == 2) {
                    $this->session->set_userdata($userData);
                    if ($this->db->update('user', array('lastLoggedIn' => date('Y-m-d H:i:s'), 'isLoggedIn' => 'yes'), array('id' => $theUser->id))) {
                        $accessId = $this->Login_Model->eposUserLogs(array('user' => $theUser->id, 'login' => date('Y-m-d H:i:s')));
                        $this->session->set_userdata('usserAccessID', $accessId);
                        echo json_encode(array('status' => true, 'userData' => $userData));
                    }
                } else {
                    echo json_encode(array('status' => false, 'multi' => false, 'message' => $this->lang->line('you_are_not_a_suscribed_member')));
                }
            } else {
                echo json_encode(array('status' => false, 'multi' => true, 'message' => $this->lang->line('username_password_wrong')));
            }
        } else {
            echo json_encode(array('status' => false, 'message' => $this->lang->line('username_password_wrong')));
        }
    }

    public function validateEnginner() {
        $email = $this->input->post('email');
        $theUser = $this->Login_Model->getEngineer(trim($this->input->post('username')), trim($this->input->post('password')));
        $status = false;
        if (!empty($theUser)) {
            $validatedEmail = 'engineer.access@gksoft.co.uk';
            if (trim($validatedEmail) === trim($email)) {
                $status = true;
            } else {
                $status = false;
            }
        } else {
            $status = false;
        }
        if (true === $status) {
            $userData = array(
                'branch' => 1,
                'loginBranch' => 1,
                'owner' => $theUser->id,
                'group' => $theUser->group,
                'team' => $theUser->team > 0 ? $theUser->team : 0,
                'username' => $theUser->username,
                'name' => $theUser->display,
                'eposStyle' => $theUser->eposStyle,
                'userApps' => trim($theUser->onapp) ? unserialize($theUser->onapp) : array(),
                'beep' => $theUser->beep,
                'beepLabel' => $theUser->beepLabel
            );
            $this->session->set_userdata($userData);
            echo json_encode(array('status' => true, 'userData' => $userData));
        } else {
            echo json_encode(array('status' => false, 'message' => $this->lang->line('username_password_wrong')));
        }
    }

    function exitDesktopApplication() {
        $command = $this->input->post('command');
        $branch = $this->input->post('branch');
        $team = $this->input->post('team');
        $commandObj = $this->Login_Model->get_single('command', array('branch' => $branch, 'team' => $team, 'command' => $command))->row();
        $status = false;
        if (!empty($commandObj)) {
            $status = $this->db->update('command', array('isExecuted' => 'no'), array('branch' => $branch, 'team' => $team, 'command' => $command));
        } else {
            $status = $this->db->insert('command', array('branch' => $branch, 'team' => $team, 'command' => $command, 'isExecuted' => 'no'));
        }
        echo json_encode(array('status' => $status ? true : false));
    }

}
