<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane">
            <div class="pane content-configuration">
                <div class="caption" onclick="zamanEposBlockHideAndShow('restaurantServiceTimeBlock')">
                    <div class="caption-inner" style="padding: 9px;"><?php echo $this->lang->line('make_schedule_for_service_time') ?></div>
                </div>
                <?php if ($this->session->userdata('group') <= 4): ?>
                    <div style="display: none;" id="restaurantServiceTimeBlock">
                        <div class="restaurant-setup-block clearfix">
                            <?php echo form_open('settings/servicetimesave', array('id' => 'breakfastSchedule')); ?>
                            <table class="text-center shcedule-table report-table">
                                <thead style="background: #228ba2">
                                    <tr>
                                        <td colspan="5">
                                            <div class="form-group">
                                                <select name="schedule" class="form-control">
                                                    <option value="0"><?php echo $this->lang->line('select') . ' ' . $this->lang->line('service_time') ?></option>
                                                    <?php foreach ($serviceTimeHeads as $aserviceTimeHead): ?>
                                                        <option value="<?php echo $aserviceTimeHead->id ?>" <?php $activeScheduler && $activeScheduler == $aserviceTimeHead->id ? print'selected="selected"' : '' ?>><?php echo $aserviceTimeHead->title ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr class="caption">
                                        <th><?php echo $this->lang->line('date_day') ?></th>
                                        <th><?php echo $this->lang->line('business') ?></th>
                                        <th><?php echo $this->lang->line('start') ?></th>
                                        <th><?php echo $this->lang->line('end') ?></th>
                                        <th><?php echo $this->lang->line('service') ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><label><?php echo $this->lang->line('cal_sun') ?></label></td>
                                        <td>
                                            <div class="radios">
                                                <label> <input data-error="#breakfastScheduleSun_opened" type="radio" value="3" name="Sun_opened" <?php !empty($daysParams) && $daysParams['Sun']->opened == 3 ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('open') ?></label>
                                                <label> <input data-error="#breakfastScheduleSun_opened" type="radio" value="2" name="Sun_opened" <?php !empty($daysParams) && $daysParams['Sun']->opened == 2 ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('closed') ?></label>
                                            </div>
                                            <div class="clearfix" id="breakfastScheduleSun_opened"></div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="Sun_start" class="form-control" id="Sun_start" value="<?php !empty($daysParams) ? print $daysParams['Sun']->start : '' ?>">
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="Sun_end" class="form-control" id="Sun_end" value="<?php !empty($daysParams) ? print $daysParams['Sun']->end : '' ?>">
                                            </div>
                                        </td>
                                        <td class="text-left">
                                            <div class="form-group">
                                                <?php if ($services['table'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Sun_service[]" value="table" <?php !empty($daysParams) && strpos($daysParams['Sun']->service, 'table') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('table') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['waiting'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Sun_service[]" value="waiting" <?php !empty($daysParams) && strpos($daysParams['Sun']->service, 'waiting') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('waiting') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['bar'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Sun_service[]" value="bar" <?php !empty($daysParams) && strpos($daysParams['Sun']->service, 'bar') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('bar') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['delivery'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Sun_service[]" value="delivery" <?php !empty($daysParams) && strpos($daysParams['Sun']->service, 'delivery') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('delivery') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['collection'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Sun_service[]" value="collection" <?php !empty($daysParams) && strpos($daysParams['Sun']->service, 'collection') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('collection') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['online'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Sun_service[]" value="online" <?php !empty($daysParams) && strpos($daysParams['Sun']->service, 'online') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('online') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['booking'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Sun_service[]" value="booking" <?php !empty($daysParams) && strpos($daysParams['Sun']->service, 'booking') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('booking') ?></label>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label><?php echo $this->lang->line('cal_mon') ?></label>
                                        </td>
                                        <td>
                                            <div class="radios">
                                                <label> <input data-error="#breakfastScheduleMon_opened" type="radio" value="3" name="Mon_opened" <?php !empty($daysParams) && $daysParams['Mon']->opened == 3 ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('open') ?></label>
                                                <label> <input data-error="#breakfastScheduleMon_opened" type="radio" value="2" name="Mon_opened" <?php !empty($daysParams) && $daysParams['Mon']->opened == 2 ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('closed') ?></label>
                                            </div>
                                            <div class="clearfix" id="breakfastScheduleMon_opened"></div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="Mon_start" class="form-control" id="Mon_start" value="<?php !empty($daysParams) ? print $daysParams['Mon']->start : '' ?>">
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="Mon_end" class="form-control" id="Mon_end" value="<?php !empty($daysParams) ? print $daysParams['Mon']->end : '' ?>">
                                            </div>
                                        </td>
                                        <td class="text-left">
                                            <div class="form-group">
                                                <?php if ($services['table'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Mon_service[]" value="table" <?php !empty($daysParams) && strpos($daysParams['Mon']->service, 'table') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('table') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['waiting'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Mon_service[]" value="waiting" <?php !empty($daysParams) && strpos($daysParams['Mon']->service, 'waiting') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('waiting') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['bar'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Mon_service[]" value="bar" <?php !empty($daysParams) && strpos($daysParams['Mon']->service, 'bar') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('bar') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['delivery'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Mon_service[]" value="delivery" <?php !empty($daysParams) && strpos($daysParams['Mon']->service, 'delivery') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('delivery') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['collection'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Mon_service[]" value="collection" <?php !empty($daysParams) && strpos($daysParams['Mon']->service, 'collection') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('collection') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['online'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Mon_service[]" value="online" <?php !empty($daysParams) && strpos($daysParams['Mon']->service, 'online') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('online') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['booking'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Mon_service[]" value="booking" <?php !empty($daysParams) && strpos($daysParams['Mon']->service, 'booking') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('booking') ?></label>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><label><?php echo $this->lang->line('cal_tue') ?></label></td>
                                        <td>
                                            <div class="radios">
                                                <label> <input data-error="#breakfastScheduleTue_opened" type="radio" value="3" name="Tue_opened" <?php !empty($daysParams) && $daysParams['Tue']->opened == 3 ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('open') ?></label>
                                                <label> <input data-error="#breakfastScheduleTue_opened" type="radio" value="2" name="Tue_opened" <?php !empty($daysParams) && $daysParams['Tue']->opened == 2 ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('closed') ?></label>
                                            </div>
                                            <div class="clearfix" id="breakfastScheduleTue_opened"></div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="Tue_start" class="form-control" id="Tue_start" value="<?php !empty($daysParams) ? print $daysParams['Tue']->start : '' ?>">

                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="Tue_end" class="form-control" id="Tue_end" value="<?php !empty($daysParams) ? print $daysParams['Tue']->end : '' ?>">
                                            </div>
                                        </td>
                                        <td class="text-left">
                                            <div class="form-group">
                                                <?php if ($services['table'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Tue_service[]" value="table" <?php !empty($daysParams) && strpos($daysParams['Tue']->service, 'table') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('table') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['waiting'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Tue_service[]" value="waiting" <?php !empty($daysParams) && strpos($daysParams['Tue']->service, 'waiting') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('waiting') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['bar'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Tue_service[]" value="bar" <?php !empty($daysParams) && strpos($daysParams['Tue']->service, 'bar') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('bar') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['delivery'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Tue_service[]" value="delivery" <?php !empty($daysParams) && strpos($daysParams['Tue']->service, 'delivery') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('delivery') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['collection'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Tue_service[]" value="collection" <?php !empty($daysParams) && strpos($daysParams['Tue']->service, 'collection') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('collection') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['online'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Tue_service[]" value="online" <?php !empty($daysParams) && strpos($daysParams['Tue']->service, 'online') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('online') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['booking'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Tue_service[]" value="booking" <?php !empty($daysParams) && strpos($daysParams['Tue']->service, 'booking') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('booking') ?></label>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><label><?php echo $this->lang->line('cal_wed') ?></label></td>
                                        <td>
                                            <div class="radios">
                                                <label> <input data-error="#breakfastScheduleWed_opened" type="radio" value="3"  name="Wed_opened" <?php !empty($daysParams) && $daysParams['Wed']->opened == 3 ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('open') ?></label>
                                                <label> <input data-error="#breakfastScheduleWed_opened" type="radio" value ="2" name="Wed_opened" <?php !empty($daysParams) && $daysParams['Wed']->opened == 2 ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('closed') ?></label>
                                            </div>
                                            <div class="clearfix" id="breakfastScheduleWed_opened"></div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="Wed_start" class="form-control" id="Wed_start" value="<?php !empty($daysParams) ? print $daysParams['Wed']->start : '' ?>">
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="Wed_end" class="form-control" id="Wed_end" value="<?php !empty($daysParams) ? print $daysParams['Wed']->end : '' ?>">
                                            </div>
                                        </td>
                                        <td class="text-left">
                                            <div class="form-group">
                                                <?php if ($services['table'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Wed_service[]" value="table" <?php !empty($daysParams) && strpos($daysParams['Wed']->service, 'table') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('table') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['waiting'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Wed_service[]" value="waiting" <?php !empty($daysParams) && strpos($daysParams['Wed']->service, 'waiting') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('waiting') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['bar'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Wed_service[]" value="bar" <?php !empty($daysParams) && strpos($daysParams['Wed']->service, 'bar') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('bar') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['delivery'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Wed_service[]" value="delivery" <?php !empty($daysParams) && strpos($daysParams['Wed']->service, 'delivery') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('delivery') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['collection'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Wed_service[]" value="collection" <?php !empty($daysParams) && strpos($daysParams['Wed']->service, 'collection') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('collection') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['online'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Wed_service[]" value="online" <?php !empty($daysParams) && strpos($daysParams['Wed']->service, 'online') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('online') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['booking'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Wed_service[]" value="booking" <?php !empty($daysParams) && strpos($daysParams['Wed']->service, 'booking') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('booking') ?></label>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><label><?php echo $this->lang->line('cal_thu') ?></label></td>
                                        <td>
                                            <div class="radios">
                                                <label> <input data-error="#breakfastScheduleThu_opened" type="radio" value="3" name="Thu_opened" <?php !empty($daysParams) && $daysParams['Thu']->opened == 3 ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('open') ?></label>
                                                <label> <input data-error="#breakfastScheduleThu_opened" type="radio" value="2" name="Thu_opened" <?php !empty($daysParams) && $daysParams['Thu']->opened == 2 ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('closed') ?></label>
                                            </div>
                                            <div class="clearfix" id="breakfastScheduleThu_opened"></div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="Thu_start" class="form-control" id="Thu_start" value="<?php !empty($daysParams) ? print $daysParams['Thu']->start : '' ?>">

                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="Thu_end" class="form-control" id="Thu_end" value="<?php !empty($daysParams) ? print $daysParams['Thu']->end : '' ?>">
                                            </div>
                                        </td>
                                        <td class="text-left">
                                            <div class="form-group">
                                                <?php if ($services['table'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Thu_service[]" value="table" <?php !empty($daysParams) && strpos($daysParams['Thu']->service, 'table') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('table') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['waiting'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Thu_service[]" value="waiting" <?php !empty($daysParams) && strpos($daysParams['Thu']->service, 'waiting') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('waiting') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['bar'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Thu_service[]" value="bar" <?php !empty($daysParams) && strpos($daysParams['Thu']->service, 'bar') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('bar') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['delivery'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Thu_service[]" value="delivery" <?php !empty($daysParams) && strpos($daysParams['Thu']->service, 'delivery') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('delivery') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['collection'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Thu_service[]" value="collection" <?php !empty($daysParams) && strpos($daysParams['Thu']->service, 'collection') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('collection') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['online'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Thu_service[]" value="online" <?php !empty($daysParams) && strpos($daysParams['Thu']->service, 'online') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('online') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['booking'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Thu_service[]" value="booking" <?php !empty($daysParams) && strpos($daysParams['Thu']->service, 'booking') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('booking') ?></label>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><label><?php echo $this->lang->line('cal_fri') ?></label></td>
                                        <td>
                                            <div class="radios">
                                                <label> <input data-error="#breakfastScheduleFri_opened" type="radio" value="3" name="Fri_opened" <?php !empty($daysParams) && $daysParams['Fri']->opened == 3 ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('open') ?></label>
                                                <label> <input data-error="#breakfastScheduleFri_opened"  type="radio" value="2" name="Fri_opened" <?php !empty($daysParams) && $daysParams['Fri']->opened == 2 ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('closed') ?></label>
                                            </div>
                                            <div class="clearfix" id="breakfastScheduleFri_opened"></div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="Fri_start" class="form-control" id="Fri_start" value="<?php !empty($daysParams) ? print $daysParams['Fri']->start : '' ?>">
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="Fri_end" class="form-control" id="Fri_end" value="<?php !empty($daysParams) ? print $daysParams['Fri']->end : '' ?>">
                                            </div>
                                        </td>
                                        <td class="text-left">
                                            <div class="form-group">
                                                <?php if ($services['table'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Fri_service[]" value="table" <?php !empty($daysParams) && strpos($daysParams['Fri']->service, 'table') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('table') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['waiting'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Fri_service[]" value="waiting" <?php !empty($daysParams) && strpos($daysParams['Fri']->service, 'waiting') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('waiting') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['bar'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Fri_service[]" value="bar" <?php !empty($daysParams) && strpos($daysParams['Fri']->service, 'bar') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('bar') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['delivery'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Fri_service[]" value="delivery" <?php !empty($daysParams) && strpos($daysParams['Fri']->service, 'delivery') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('delivery') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['collection'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Fri_service[]" value="collection" <?php !empty($daysParams) && strpos($daysParams['Fri']->service, 'collection') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('collection') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['online'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Fri_service[]" value="online" <?php !empty($daysParams) && strpos($daysParams['Fri']->service, 'online') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('online') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['booking'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Fri_service[]" value="booking" <?php !empty($daysParams) && strpos($daysParams['Fri']->service, 'booking') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('booking') ?></label>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><label><?php echo $this->lang->line('cal_sat') ?></label></td>
                                        <td>
                                            <div class="radios">
                                                <label> <input data-error="#breakfastScheduleSat_opened" type="radio" value="3" name="Sat_opened" <?php !empty($daysParams) && $daysParams['Sat']->opened == 3 ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('open') ?></label>
                                                <label> <input data-error="#breakfastScheduleSat_opened" type="radio" value="2" name="Sat_opened" <?php !empty($daysParams) && $daysParams['Sat']->opened == 2 ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('closed') ?></label>
                                            </div>
                                            <div class="clearfix" id="breakfastScheduleSat_opened"></div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="Sat_start" class="form-control" id="Sat_start" value="<?php !empty($daysParams) ? print $daysParams['Sat']->start : '' ?>">
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-group">
                                                <input type="text" name="Sat_end" class="form-control" id="Sat_end" value="<?php !empty($daysParams) ? print $daysParams['Sat']->end : '' ?>">
                                            </div>
                                        </td>
                                        <td class="text-left">
                                            <div class="form-group">
                                                <?php if ($services['table'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Sat_service[]" value="table" <?php !empty($daysParams) && strpos($daysParams['Sat']->service, 'table') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('table') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['waiting'] === '3'): ?> 
                                                    <label><input type="checkbox" name="Sat_service[]" value="waiting" <?php !empty($daysParams) && strpos($daysParams['Sat']->service, 'waiting') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('waiting') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['bar'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Sat_service[]" value="bar" <?php !empty($daysParams) && strpos($daysParams['Sat']->service, 'bar') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('bar') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['delivery'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Sat_service[]" value="delivery" <?php !empty($daysParams) && strpos($daysParams['Sat']->service, 'delivery') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('delivery') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['collection'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Sat_service[]" value="collection" <?php !empty($daysParams) && strpos($daysParams['Sat']->service, 'collection') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('collection') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['online'] === '3'): ?> 
                                                    <label><input type="checkbox" name="Sat_service[]" value="online" <?php !empty($daysParams) && strpos($daysParams['Sat']->service, 'online') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('online') ?>&nbsp;</label>
                                                <?php endif; ?>
                                                <?php if ($services['booking'] === '3'): ?>   
                                                    <label><input type="checkbox" name="Sat_service[]" value="booking" <?php !empty($daysParams) && strpos($daysParams['Sat']->service, 'booking') !== false ? print 'checked="checked"' : '' ?>><?php echo $this->lang->line('booking') ?></label>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr> 
                                </tbody>
                            </table>
                            <div class="tab-group config-submit">
                                <button type="submit" onclick="saveServiceTime('breakfastSchedule')" style="padding: 10px; font-size: 12px;"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
                            </div>
                            <?php echo form_close() ?>
                        </div>  
                        <div class="block-inner" id="expenseFormBlock">
                            <div class="caption">
                                <div class="caption-inner" style="padding: 9px;"><?php echo $this->lang->line('add_new') . ' ' . $this->lang->line('service_time') ?></div>
                            </div>
                            <?php echo form_open('settings/saveServiceTimeHead/', array('id' => 'serviceTimeHeadForm')); ?>
                            <div class="form-group">
                                <input type="text" name="title" id="serviceTimeHead" placeholder="<?php echo $this->lang->line('add_new') . ' ' . $this->lang->line('service_time') ?>" class="form-control">
                            </div>
                            <div class="tab-group config-submit">
                                <button type="submit" onclick="saveServiceTimeHead('serviceTimeHeadForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
                            </div>
                            <?php echo form_close() ?>
                        </div>
                    </div>
                    <script type="text/javascript">
                        $('document').ready(function () {
                            $('#Sun_start,#Sun_end,#Mon_start,#Mon_end,#Tue_start,#Tue_end,#Wed_start,#Wed_end,#Thu_start,#Thu_end,#Fri_start,#Fri_end,#Sat_start,#Sat_end').datetimepicker({
                                datepicker: false,
                                format: 'h:i a',
                                formatTime: 'h:i a',
                                step: 15
                            });
                        });
                        function saveServiceTime(formId) {
                            if (!$('.page-loader').is(":visible")) {
                                $('#' + formId).validate({
                                    submitHandler: function () {
                                        var myform = document.getElementById(formId);
                                        var formdata = new FormData(myform);
                                        if (checkInternetConnection()) {
                                            $.ajax({
                                                url: $('#' + formId).attr('action'),
                                                data: formdata,
                                                cache: false,
                                                processData: false,
                                                contentType: false,
                                                type: 'POST',
                                                dataType: 'json',
                                                beforeSend: function () {
                                                    $('.page-loader').show();
                                                },
                                                success: function (response) {
                                                    if (response.status) {
                                                        $('.page-loader').hide();
                                                        zamanEposNavigator('settingIndex', '<?php echo site_url('settings/servicetime') ?>', 'settingIndex');
                                                    } else {
                                                        warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                                                    }
                                                }
                                            });
                                        } else {
                                            warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                                        }
                                    },
                                    errorClass: "has-error",
                                    highlight: function (e) {
                                        $(e).closest('.form-group').addClass('has-error');
                                    },
                                    unhighlight: function (e) {
                                        $(e).closest('.form-group').removeClass('has-error');
                                    },
                                    rules: {
                                        schedule: {required: true, min: 1},
                                        Sun_opened: {required: true},
                                        Mon_opened: {required: true},
                                        Tue_opened: {required: true},
                                        Wed_opened: {required: true},
                                        Thu_opened: {required: true},
                                        Fri_opened: {required: true},
                                        Sat_opened: {required: true},
                                        Sun_start: {required: true},
                                        Mon_start: {required: true},
                                        Tue_start: {required: true},
                                        Wed_start: {required: true},
                                        Thu_start: {required: true},
                                        Fri_start: {required: true},
                                        Sat_start: {required: true},
                                        Sun_end: {required: true},
                                        Mon_end: {required: true},
                                        Tue_end: {required: true},
                                        Wed_end: {required: true},
                                        Thu_end: {required: true},
                                        Fri_end: {required: true},
                                        Sat_end: {required: true},
                                        'Sun_service[]': {required: true},
                                        'Mon_service[]': {required: true},
                                        'Tue_service[]': {required: true},
                                        'Wed_service[]': {required: true},
                                        'Thu_service[]': {required: true},
                                        'Fri_service[]': {required: true},
                                        'Sat_service[]': {required: true},
                                    },
                                    messages: {
                                        schedule: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('service_time') . ' ' . $this->lang->line('title')) ?>'
                                    },
                                    errorPlacement: function (error, element) {
                                        errorPlacement(error, element);
                                    }
                                });
                            }
                        }
                        function saveServiceTimeHead(formId) {
                            $('#' + formId).validate({
                                submitHandler: function () {
                                    var myform = document.getElementById(formId);
                                    var formdata = new FormData(myform);
                                    $.ajax({
                                        url: $('#' + formId).attr('action'),
                                        data: formdata,
                                        cache: false,
                                        processData: false,
                                        contentType: false,
                                        type: 'POST',
                                        dataType: 'json',
                                        beforeSend: function () {
                                            $('.page-loader').show();
                                        },
                                        success: function (response) {
                                             $('.page-loader').hide();
                                            if (response.status) {
                                                zamanEposNavigator('settingIndex', '<?php echo site_url('settings/servicetime') ?>', 'settingIndex');
                                            } else {
                                                warning('Error', response.message, 'Close');
                                            }
                                        }
                                    });
                                },
                                errorClass: "has-error",
                                highlight: function (e) {
                                    $(e).closest('.form-group').addClass('has-error');
                                },
                                unhighlight: function (e) {
                                    $(e).closest('.form-group').removeClass('has-error');
                                },
                                rules: {
                                    title: {
                                        required: true,
                                        remote: {
                                            url: "<?php echo site_url('settings/checkServiceTimeHead') ?>",
                                            type: "post",
                                            data: {
                                                value: function () {
                                                    return $("#serviceTimeHead").val();
                                                },
                                                column: 'title'
                                            }
                                        }
                                    }
                                },
                                messages: {
                                    title: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('service_time')) ?>'
                                },
                                errorPlacement: function (error, element) {
                                    errorPlacement(error, element);
                                }
                            });

                        }
                        function deleteServiceTime(id, title) {
                            if (!$('.page-loader').is(":visible")) {
                                $.confirm({
                                    title: '<?php echo $this->lang->line('warning') ?>',
                                    message: '<?php echo $this->lang->line('delete_warning_message') ?>' + title,
                                    buttons: {
                                        '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                                            'class': 'positive',
                                            'action': function () {
                                                if (checkInternetConnection()) {
                                                    $.ajax({
                                                        url: '<?php echo site_url('settings/deleteServiceTime/') ?>' + id,
                                                        type: 'GET',
                                                        dataType: 'json',
                                                        success: function (response) {
                                                            if (response.status) {
                                                                zamanEposNavigator('settingIndex', '<?php echo site_url('settings/servicetime') ?>', 'settingIndex');
                                                            } else {
                                                                warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                                                            }
                                                        }
                                                    });
                                                } else {
                                                    warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                                                }
                                            }
                                        },
                                        '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                                            'class': 'negative',
                                            'action': function () {
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    </script>
                <?php endif; ?>
                <table class="report-table text-center">
                    <tr class="table-bg">
                        <th><?php echo $this->lang->line('service_time') ?></th>
                        <th><?php echo $this->lang->line('open') ?></th>
                        <th><?php echo $this->lang->line('status') ?></th>
                        <?php if ($this->session->userdata('group') <= 4): ?>
                            <th><?php echo $this->lang->line('edit') ?></th>
                        <?php endif ?>
                    </tr>
                    <?php if (!empty($serviceTimeHeads)): ?>
                        <?php foreach ($serviceTimeHeads as $scheduler): ?>
                            <?php $dayScheduler = get_record_list('servicetime', array('schedule' => $scheduler->id, 'branch' => $this->session->userdata('branch'))) ?>
                            <tr>
                                <td><?php echo $scheduler->title ?></td> 
                                <td>
                                    <table class="report-table text-center">
                                        <tr class="table-bg">
                                            <th><?php echo $this->lang->line('date_day') ?></th>
                                            <th><?php echo $this->lang->line('opened') ?></th>
                                            <th><?php echo $this->lang->line('start') ?></th>
                                            <th><?php echo $this->lang->line('end') ?></th>
                                        </tr>
                                        <?php foreach ($dayScheduler as $ds): ?>
                                            <tr>
                                                <td> <?php echo $ds->day ?></td>
                                                <td> <?php echo $ds->opened == '3' ? $this->lang->line('yes') : $this->lang->line('no') ?></td>
                                                <td> <?php echo $ds->start ?></td>
                                                <td> <?php echo $ds->end ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </table>
                                </td>
                                <td><?php echo $scheduler->status == '3' ? $this->lang->line('active') : $this->lang->line('inactive') ?></td> 
                                <?php if ($this->session->userdata('group') <= 4): ?>
                                    <td><span onclick="zamanEposNavigator('settingIndex', '<?php echo site_url('settings/servicetime/' . $scheduler->id) ?>', 'settingIndex')" class="icon icon-pencil"></span>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;<span onclick="deleteServiceTime('<?php echo $scheduler->id ?>', '<?php echo $scheduler->title ?>')" class="icon icon-trash"></span></td>
                                    <?php endif; ?>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </table>
            </div>
            <?php //debugPrint($daysPrams) ?>
        </div>
    </div>

</div>
<?php $this->load->view('settings/partials/footer') ?>
