<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane-one-third">
            <?php echo form_open('settings/servicesave', array('id' => 'serviceSetting')); ?>  
            <div class="restaurant-setup-block clearfix">
                <table class="report-table">
                    <tr class="table-bg text-capitalize text-center">
                        <th colspan="2"><?php echo $this->lang->line('add_new') . ' ' . $this->lang->line('restaurant_service') ?></th>
                    </tr>
                    <tr class="table-bg" style="font-size: 25px;">
                        <td style="color: #eee; padding: 5px 20px;"><?php echo $this->lang->line('branch') ?></td>
                        <td style="color: #eee;padding: 5px 20px;">
                            <select name="branch" class="form-control" style="height: 35px;">
                                <option value="0"><?php echo $this->lang->line('select_branch') ?></option>
                                <?php foreach ($branches as $abranch): ?>
                                    <option value="<?php echo $abranch->id ?>" <?php !empty($branchService) && $branchService['branch'] === $abranch->id ? print 'selected="selected"' : '' ?>><?php echo $abranch->title ?></option>
                                <?php endforeach; ?>
                            </select>
                        </td>
                    </tr>
                    <tr class="table-bg" style="font-size: 25px;">
                        <td style="color: #eee; padding: 5px 20px;"><?php echo $this->lang->line('table') ?>:</td>
                        <td style="color: #eee;padding: 5px 20px;">
                            <label><input data-error="#serviceSettingTable" type="radio" name="table" value="3" <?php !empty($branchService) && $branchService['table'] === '3' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('yes') ?>&nbsp;</label>
                            <label><input data-error="#serviceSettingTable" type="radio" name="table" value="2" <?php !empty($branchService) && $branchService['table'] === '2' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('no') ?></label>
                        </td>
                    </tr>
                    <tr class="table-bg" style="font-size: 25px;">
                        <td style="color: #eee; padding: 5px 20px;"><?php echo $this->lang->line('waiting') ?>:</td>
                        <td style="color: #eee; padding: 5px 20px;">
                            <label><input data-error="#serviceSettingWaiting" type="radio" name="waiting" value="3" <?php !empty($branchService) && $branchService['waiting'] === '3' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('yes') ?>&nbsp;</label>
                            <label><input data-error="#serviceSettingWaiting" type="radio" name="waiting" value="2" <?php !empty($branchService) && $branchService['waiting'] === '2' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('no') ?></label>
                        </td>
                    </tr>
                    <tr class="table-bg" style="font-size: 25px;">
                        <td style="color: #eee; padding: 5px 20px;"><?php echo $this->lang->line('bar') ?>:</td>
                        <td style="color: #eee; padding: 5px 20px;">
                            <label><input data-error="#serviceSettingBar" type="radio" name="bar" value="3" <?php !empty($branchService) && $branchService['bar'] === '3' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('yes') ?>&nbsp;</label>
                            <label><input data-error="#serviceSettingBar" type="radio" name="bar" value="2" <?php !empty($branchService) && $branchService['bar'] === '2' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('no') ?></label>
                        </td>
                    </tr>
                    <tr class="table-bg" style="font-size: 25px;">
                        <td style="color: #eee; padding: 5px 20px;"><?php echo $this->lang->line('collection') ?>:</td>
                        <td style="color: #eee; padding: 5px 20px;">
                            <label><input data-error="#serviceSettingCollection" type="radio" name="collection" value="3" <?php !empty($branchService) && $branchService['collection'] === '3' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('yes') ?>&nbsp;</label>
                            <label><input data-error="#serviceSettingCollection" type="radio" name="collection" value="2" <?php !empty($branchService) && $branchService['collection'] === '2' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('no') ?></label>
                        </td>
                    </tr>
                    <tr class="table-bg" style="font-size: 25px;">
                        <td style="color: #eee; padding: 5px 20px;"><?php echo $this->lang->line('delivery') ?>:</td>
                        <td style="color: #eee; padding: 5px 20px;">
                            <label><input data-error="#serviceSettingDelivery" type="radio" name="delivery" value="3" <?php !empty($branchService) && $branchService['delivery'] === '3' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('yes') ?>&nbsp;</label>
                            <label><input data-error="#serviceSettingDelivery" type="radio" name="delivery" value="2" <?php !empty($branchService) && $branchService['delivery'] === '2' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('no') ?></label>
                        </td>
                    </tr>
                    <tr class="table-bg" style="font-size: 25px;">
                        <td style="color: #eee; padding: 5px 20px;"><?php echo $this->lang->line('online') ?>:</td>
                        <td style="color: #eee; padding: 5px 20px;">
                            <label><input data-error="#serviceSettingOnline" type="radio" name="online" value="3" <?php !empty($branchService) && $branchService['online'] === '3' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('yes') ?>&nbsp;</label>
                            <label><input data-error="#serviceSettingOnline" type="radio" name="online" value="2" <?php !empty($branchService) && $branchService['online'] === '2' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('no') ?></label>
                        </td>
                    </tr>
                    <tr class="table-bg" style="font-size: 25px;">
                        <td style="color: #eee; padding: 5px 20px;"><?php echo $this->lang->line('booking') ?>:</td>
                        <td style="color: #eee; padding: 5px 20px;">
                            <label><input data-error="#serviceSettingBooking" type="radio" name="booking" value="3"  <?php !empty($branchService) && $branchService['booking'] === '3' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('yes') ?>&nbsp;</label>
                            <label><input data-error="#serviceSettingBooking" type="radio" name="booking" value="2"  <?php !empty($branchService) && $branchService['booking'] === '2' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('no') ?></label>
                        </td>
                    </tr>
                    <tr class="table-bg" style="font-size: 25px;">
                        <td style="color: #eee; padding: 5px 20px;"><?php echo $this->lang->line('caller_device') ?>:</td>
                        <td style="color: #eee; padding: 5px 20px;">
                            <label><input data-error="#serviceSettingCallerId" type="radio" name="callerId" value="3"  <?php !empty($branchService) && $branchService['callerId'] === '3' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('yes') ?>&nbsp;</label>
                            <label><input data-error="#serviceSettingCallerId" type="radio" name="callerId" value="2"  <?php !empty($branchService) && $branchService['callerId'] === '2' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('no') ?></label>
                        </td>
                    </tr>
                    <tr class="table-bg" style="font-size: 25px;">
                        <td style="color: #eee; padding: 5px 20px;"><?php echo $this->lang->line('app_receiver') ?>:</td>
                        <td style="color: #eee; padding: 5px 20px;">
                            <label><input data-error="#serviceSettingCallerId" type="radio" name="appReceiver" value="3"  <?php !empty($branchService) && $branchService['appReceiver'] === '3' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('yes') ?>&nbsp;</label>
                            <label><input data-error="#serviceSettingCallerId" type="radio" name="appReceiver" value="2"  <?php !empty($branchService) && $branchService['appReceiver'] === '2' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('no') ?></label>
                        </td>
                    </tr>
                    <tr class="table-bg" style="font-size: 25px;">
                        <td colspan="2"> <div class="login-pad">
                                <div class="tab-group config-submit">
                                    <button type="submit" onclick="serviceSetting('serviceSetting')"  style="color: #eee;"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
                                </div>
                            </div>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="clearfix"></div>
            <?php echo form_close() ?>
        </div>
        <div class="pane">
            <table class="report-table text-center text-capitalize">
                <tr class="table-bg">
                    <th><?php echo $this->lang->line('branch') ?></th>
                    <th><?php echo $this->lang->line('table') ?></th>
                    <th><?php echo $this->lang->line('waiting') ?></th>
                    <th><?php echo $this->lang->line('bar') ?></th>
                    <th><?php echo $this->lang->line('collection') ?></th>
                    <th><?php echo $this->lang->line('delivery') ?></th>
                    <th><?php echo $this->lang->line('online') ?></th>
                    <th><?php echo $this->lang->line('booking') ?></th>
                    <th><?php echo $this->lang->line('caller_device') ?></th>
                    <th><?php echo $this->lang->line('app_receiver') ?></th>
                    <th><?php echo $this->lang->line('edit') ?></th>
                </tr>
                <?php if (!empty($services)): ?>
                    <?php $serviceStatus = array(2 => 'No', 3 => 'yes') ?>
                    <?php foreach ($services as $aService): ?>
                        <tr>
                            <td><?php echo get_title('branch', array('id' => $aService->branch)) ?></td>
                            <td><?php echo $serviceStatus[$aService->table] ?></td>
                            <td><?php echo $serviceStatus[$aService->waiting] ?></td>
                            <td><?php echo $serviceStatus[$aService->bar] ?></td>
                            <td><?php echo $serviceStatus[$aService->collection] ?></td>
                            <td><?php echo $serviceStatus[$aService->delivery] ?></td>
                            <td><?php echo $serviceStatus[$aService->online] ?></td>
                            <td><?php echo $serviceStatus[$aService->booking] ?></td>
                            <td><?php echo $serviceStatus[$aService->callerId] ?></td>
                            <td><?php echo $serviceStatus[$aService->appReceiver] ?></td>
                            <td><i class="icon icon-pencil" onclick="zamanEposNavigator('settingIndex', '<?php echo site_url('settings/service/' . $aService->branch) ?>', 'settingIndex')"></i></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                <?php endif; ?>
            </table>
        </div>
    </div>
</div>
<style>
    label {
        margin-bottom: -4px;
        font-size: 20px;
    }
</style>
<script type="text/javascript">
    function serviceSetting(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    $.ajax({
                        url: $('#' + formId).attr('action'),
                        data: formdata,
                        cache: false,
                        processData: false,
                        contentType: false,
                        type: 'POST',
                        dataType: 'json',
                        beforeSend: function () {
                            $('.page-loader').show();
                        },
                        success: function (response) {
                            $('.page-loader').hide();
                            if (response.status) {
                                zamanEposNavigator('', '<?php echo site_url('settings/service') ?>', 'settingIndex');
                            } else {
                                warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('close') ?>');
                            }
                        }
                    });
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    branch: {required: true, min: 1},
                    table: {required: true, min: 2},
                    bar: {required: true, min: 2},
                    waiting: {required: true, min: 2},
                    collection: {required: true, min: 2},
                    delivery: {required: true, min: 2},
                    booking: {required: true, min: 2},
                    online: {required: true, min: 2},
                    callerId: {required: true, min: 2},
                    appReceiver: {required: true, min: 2}
                },
                message: {
                    branch: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('branch')) ?>',
                    table: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('table')) ?>',
                    bar: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('bar')) ?>',
                    waiting: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('bar')) ?>',
                    collection: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('collection')) ?>',
                    delivery: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('delivery')) ?>',
                    booking: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('booking')) ?>',
                    online: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('online')) ?>',
                    callerId: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('caller_device')) ?>',
                    appReceiver: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('app_receiver')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
</script>
<?php
$this->load->view('settings/partials/footer')?>