<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <?php
            $discountPlanStatus = array('2' => 'Pending', '3' => 'Active', '4' => 'Dissolve');
            $discountPlanDays = array(
                '1' => $this->lang->line('cal_sun'),
                '2' => $this->lang->line('cal_mon'),
                '3' => $this->lang->line('cal_tue'),
                '4' => $this->lang->line('cal_wed'),
                '5' => $this->lang->line('cal_thu'),
                '6' => $this->lang->line('cal_fri'),
                '7' => $this->lang->line('cal_sat'),
            );
            $discountPlanOrderType = array(
                '1' => $this->lang->line('table'),
                '2' => $this->lang->line('waiting'),
                '3' => $this->lang->line('bar'),
                '4' => $this->lang->line('delivery'),
                '5' => $this->lang->line('collection'),
                '6' => $this->lang->line('online'),
            );
            ?>
            <table class="report-table text-center">
                <?php if ($this->session->userdata('group') <= 4): ?>
                    <caption style="padding: 15px;" onclick="zamanEposNavigator('promo', '<?php echo site_url('settings/promoadd') ?>','promo')"><span class="icon icon-plus"></span>&nbsp;<?php echo $this->lang->line('promotional_offer') ?></caption>
                <?php else: ?>
                    <caption style="padding: 15px;" ><span class="icon icon-list"></span>&nbsp;<?php echo $this->lang->line('promotional_offer') ?></caption>
                <?php endif; ?>
                <thead class="table-bg">
                    <tr>
                        <?php if ($this->session->userdata('group') <= 3): ?>
                            <th><?php echo $this->lang->line('branch') ?></th>
                        <?php endif; ?>
                        <th><?php echo $this->lang->line('promocode') ?></th>
                        <th><?php echo $this->lang->line('minimum_order_amount') ?></th>
                        <th><?php echo $this->lang->line('discount') ?></th>
                        <th><?php echo $this->lang->line('plan_applicable_days') ?></th>
                        <th><?php echo $this->lang->line('plan_applicable_order_types') ?></th>
                        <th><?php echo $this->lang->line('plan_applicable_item_types') ?></th>
                        <th><?php echo $this->lang->line('date_validity') ?></th>
                        <th><?php echo $this->lang->line('time_validity') ?></th>
                        <th><?php echo $this->lang->line('status') ?></th>
                        <?php if ($this->session->userdata('group') <= 4): ?>
                            <th><?php echo $this->lang->line('edit') ?></th>
                            <th><?php echo $this->lang->line('delete') ?></th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($plans)): ?>
                        <?php foreach ($plans as $aplan): ?>
                            <tr>
                                <?php if ($this->session->userdata('group') <= 3): ?>
                                    <td><?php echo get_title('branch', array('id' => $this->session->userdata('branch'))) ?></td>
                                <?php endif; ?>
                                <td><?php echo $aplan->promocode ?></td>
                                <td><?php echo to_currency($aplan->min_order) ?></td>
                                <td><?php echo to_currency_no_money($aplan->discount) ?><?php echo $aplan->onfunc == '2' ? '%' : '' ?></td>
                                <td>
                                    <?php
                                    $appDays = unserialize($aplan->onday);
                                    foreach ($appDays as $aday) {
                                        echo $discountPlanDays[$aday] . ' ';
                                    }
                                    ?>

                                </td>
                                <td>
                                    <?php
                                    $appTypes = unserialize($aplan->onapp);
                                    foreach ($appTypes as $atype) {
                                        echo $discountPlanOrderType[$atype] . ' ';
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?php
                                    $itemTypes = unserialize($aplan->onitem);
                                    foreach ($itemTypes as $aItemType) {
                                        echo $aItemType . ' ';
                                    }
                                    ?>
                                </td>
                                <td><?php echo date('d/m/Y', strtotime($aplan->start_date)) ?> - <?php echo date('d/m/Y', strtotime($aplan->end_date)) ?> </td>
                                <td><?php echo $aplan->start_time ?> - <?php echo $aplan->end_time ?> </td>
                                <td><?php echo $discountPlanStatus[$aplan->status] ?></td>
                                <?php if ($this->session->userdata('group') <= 4): ?>
                                    <td><span class="icon icon-pencil" onclick="zamanEposNavigator('promo', '<?php echo site_url('settings/promoadd/' . $aplan->id) ?>','promo')"></span></td>
                                    <td><span class="icon icon-trash"></span></td>
                                 <?php endif; ?>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="12"> <?php echo sprintf($this->lang->line('not_found'), $this->lang->line('promotional_offer')) ?></td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>