<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="caption">
                <div class="caption-inner" style="padding: 9px;">Stripe Payment Gateway</div>
            </div>
            <?php if ($this->session->userdata('group') <= 4): ?>
                <div class="employee-add-block collection-bg">
                    <?php echo form_open('settings/paymentstripe_save', array('id' => 'paymentstripeForm')); ?>
                    <?php if (!empty($stripe)): ?>
                        <input type="hidden" name="id" value="<?php echo $stripe['id'] ?>">
                    <?php endif; ?>
                    <div class="pane-one-half">
                        <div class="block-inner" style="padding: 2px;">
                            <div class="form-group">
                                <label>Test Publishable key</label>
                                <input name="pk_test" value="<?php !empty($stripe) ? print $stripe['pk_test'] : '' ?>" id="deleveryPlanArea" type="text" class="form-control" placeholder="Publishable key">
                            </div>
                        </div>
                    </div>
                    <div class="pane-one-half">
                        <div class="block-inner" style="padding: 2px;">
                            <div class="form-group">
                                <label>Test Secret key</label>
                                <input name="sk_test" value="<?php !empty($stripe) ? print $stripe['sk_test'] : '' ?>"  type="text" class="form-control" placeholder="Test Secret key">
                            </div>
                        </div>
                    </div>
                    <div class="pane-one-half">
                        <div class="block-inner" style="padding: 2px;">
                            <div class="form-group">
                                <label>Live Publishable key</label>
                                <input name="pk_live" value="<?php !empty($stripe) ? print $stripe['pk_live'] : '' ?>" type="text" class="form-control" placeholder="Live Publishable key">
                            </div>
                        </div>
                    </div>
                    <div class="pane-one-half">
                        <div class="block-inner" style="padding: 2px;">
                            <div class="form-group">
                                <label>Live Secret Key</label>
                                <input name="sk_live" value="<?php !empty($stripe) ? print $stripe['sk_live'] : '' ?>" type="text" class="form-control" placeholder="Live Secret Key">
                            </div>
                        </div>
                    </div>
                    <div class="pane-one-half">
                        <div class="block-inner" style="padding: 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('mode') ?></label>
                                <select name="mode" class="form-control">
                                    <option value="2" <?php !empty($stripe) && $stripe['mode'] == 2 ? print 'selected="selected"' : '' ?>>Test</option>
                                    <option value="3" <?php !empty($stripe) && $stripe['mode'] == 3 ? print 'selected="selected"' : '' ?>>Live</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="pane-one-half">
                        <div class="block-inner" style="padding: 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('status') ?></label>
                                <select name="status" class="form-control">
                                    <option value="3" <?php !empty($stripe) && $stripe['status'] == 3 ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('active') ?></option>
                                    <option value="2" <?php !empty($stripe) && $stripe['status'] == 2 ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('inactive') ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="tab-group config-submit">
                        <button type="submit" onclick="savePaymentstripeForm('paymentstripeForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<script>
    function savePaymentstripeForm(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    zamanEposNavigator('controllPanel', '<?php echo site_url('settings/paymentstripe') ?>', 'controllPanel');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }

                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                ignore: ":hidden",
                rules: {
                    pk_test: {required: true},
                    sk_test: {required: true},
                    pk_live: {required: true},
                    sk_live: {required: true},
                    mode: {required: true},
                    status: {required: true}
                },
                messages: {
                    pk_test: '<?php echo sprintf($this->lang->line('item_required'), 'Test Publishable key') ?>',
                    sk_test: '<?php echo sprintf($this->lang->line('item_required'), 'Test Secret key') ?>',
                    pk_live: '<?php echo sprintf($this->lang->line('item_required'), 'Test Publishable key') ?>',
                    sk_live: '<?php echo sprintf($this->lang->line('item_required'), 'Test Secret key') ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
</script>
<?php $this->load->view('settings/partials/footer') ?>

