<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="pane">
                <div class="pane-one-half">
                    <div class="caption">
                        <div class="caption-inner"><?php echo $this->lang->line('add_payment_type') ?></div>
                    </div>
                    <?php echo form_open('settings/save_paymentoptions', array('id' => 'paymentOptionForm')); ?>
                    <?php if (isset($paymentOption) && !empty($paymentOption)): ?>
                        <input type="hidden" name="id" value="<?php echo $paymentOption['id'] ?>">
                        <input type="hidden" id="updatePaymentOptionTitle" value="yes">
                        <input type="hidden" id="oldPaymentOptionTitle" value="<?php echo $paymentOption['title'] ?>">
                    <?php endif; ?>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('name') ?></label>
                        <input type="text" name="title" value="<?php echo!empty($paymentOption) ? $paymentOption['title'] : '' ?>" id="paymentOptionTitle" class="form-control" placeholder="name">
                    </div>
                    <div class="form-actions">
                        <label><?php echo $this->lang->line('status') ?></label>
                        <label><input data-error="#statusFieldError" type="radio" name="status" value="3" <?php echo!empty($paymentOption) && $paymentOption['status'] === '3' ? 'checked="checked"' : '' ?>>&nbsp;Active&nbsp;</label>
                        <label><input data-error="#statusFieldError" type="radio" name="status" value="2" <?php echo!empty($paymentOption) && $paymentOption['status'] === '2' ? 'checked="checked"' : '' ?>>&nbsp;Inactive</label>
                    </div>
                    <div id="statusFieldError"></div>
                    <div class="tab-group config-submit">
                        <button type="submit" onclick="savePaymentOption('paymentOptionForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
                    </div>
                    <?php echo form_close() ?>
                </div>
                <div class="pane-one-half">
                    <table class="report-table text-center">
                        <caption><?php echo $this->lang->line('payment_type') ?></caption>
                        <thead class="table-bg">
                            <tr>
                                <th><?php echo $this->lang->line('payment_type') ?></th>
                                <th><?php echo $this->lang->line('status') ?></th>
                                <th><?php echo $this->lang->line('update') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($paymentOptions)): ?>
                                <?php foreach ($paymentOptions as $aPaymentOption): ?>
                                    <tr>
                                        <td><?php echo $aPaymentOption->title ?></td>
                                        <td><?php $aPaymentOption->status === '3' ? print 'Active' : print 'Inactive' ?></td>
                                        <td><span class="icon icon-pencil" onclick="zamanEposNavigator('', '<?php echo site_url('settings/paymentoption/' . $aPaymentOption->id) ?>', '');"></span></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="setting-general-keyboard text-center"></div>
            <div class="clearfix padded-top-more text-right"><span class="icon icon-keyboard btn-keyboard-close" onclick="zamanToogleEposVirtualKeyboard('setting-general-keyboard')">&nbsp;<?php echo $this->lang->line('open_virtual_keyboard') ?></span></div>
        </div>
    </div>
</div>
<script type="text/javascript">
    function savePaymentOption(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    zamanDbEposPaymentoption('mono');
                                    zamanEposNavigator('', '<?php echo site_url('settings/paymentoption') ?>', '');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                ignore: ":hidden",
                rules: {
                    status: {required: true},
                    title: {
                        required: true,
                        alphaonly: true,
                        remote: {
                            url: "<?php echo site_url('settings/checkpaymentoption') ?>",
                            type: "post",
                            data: {
                                value: function () {
                                    return $("#paymentOptionTitle").val();
                                },
                                column: 'title',
                                old: function () {
                                    if ($('#oldPaymentOptionTitle').length > 0) {
                                        return $('#oldPaymentOptionTitle').val();
                                    } else {
                                        return 'none';
                                    }
                                },
                                update: function () {
                                    if ($('#updatePaymentOptionTitle').length > 0) {
                                        return 'yes';
                                    } else {
                                        return 'no';
                                    }
                                }
                            }
                        }
                    }
                },
                messages: {
                    status: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('status')) ?>',
                    title: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('name')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
</script>
<?php
$this->load->view('settings/partials/footer')?>