<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="caption" onclick="zamanEposNavigator('multidiscount', '<?php echo site_url('settings/multidiscount') ?>', 'multidiscount')">
                <div class="caption-inner" style="padding: 9px;"><span class="icon icon-list"></span>&nbsp;<?php echo $this->lang->line('multi_discount') ?></div>
            </div>
            <?php echo form_open('settings/save_multidiscount', array('id' => 'itemMultiDiscountForm')); ?>
            <?php if (!empty($loaded_plan)): ?>
                <input type="hidden" name="id" value="<?php echo $loaded_plan['id'] ?>">
            <?php endif; ?>
            <div class="pane-one-third block-inner">
                <div class="form-group">
                    <label><?php echo $this->lang->line('discount_title') ?></label>
                    <input type="text" name="title" class="form-control" value="<?php echo!empty($loaded_plan) ? $loaded_plan['title'] : '' ?>" <?php echo!empty($loaded_plan) && trim($loaded_plan['title']) != null ? 'disabled="disabled"' : '' ?>>
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('category') ?></label>
                    <select name="category" class="form-control" id="itemCategory" onchange="getCategoryMenus(this.value)" <?php echo!empty($loaded_plan) && trim($loaded_plan['category']) != null ? 'disabled="disabled"' : '' ?>>
                        <option value="0">Select item Category</option>
                        <?php if (!empty($categories)): ?>
                            <?php foreach ($categories as $acategory): ?>
                                <option value="<?php echo $acategory->id ?>" <?php echo!empty($loaded_plan) && trim($loaded_plan['category']) == $acategory->id ? 'selected="selected"' : '' ?>><?php echo $acategory->title ?></option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('menu') ?></label>
                    <select name="menu" class="form-control" id="categoryMenus" onchange="getMenuSelection(this.value)"  <?php echo!empty($loaded_plan) && trim($loaded_plan['menu']) != null ? 'disabled="disabled"' : '' ?>>
                        <?php if (!empty($loaded_plan)): ?>
                            <option value="<?php echo $loaded_plan['menu'] ?>"><?php echo get_title('menu', array('id' => $loaded_plan['menu'])) ?></option>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('selection') ?></label>
                    <select name="selection" class="form-control" id="MenuSelections" <?php echo!empty($loaded_plan) && trim($loaded_plan['selection']) > 0 ? 'disabled="disabled"' : '' ?>>
                        <?php if (!empty($loaded_plan) && $loaded_plan['selection'] > 0): ?>
                            <option value="<?php echo $loaded_plan['selection'] ?>"><?php echo get_title('menuselection', array('id' => $loaded_plan['selection'])) ?></option>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('how_to_apply') ?></label>
                    <div class="radio-group">
                        <label><input data-error='#howToApplyFieldError' type="radio" name="rel" value="2" <?php echo!empty($loaded_plan) && $loaded_plan['rel'] == '2' ? 'checked="checked"' : '' ?> <?php echo!empty($loaded_plan) ? 'disabled="disabled"' : '' ?>>&nbsp;<?php echo $this->lang->line('override_discount_plan') ?>&nbsp;</label>
                        <label><input ata-error='#howToApplyFieldError' type="radio" name="rel" value="3" <?php echo!empty($loaded_plan) && $loaded_plan['rel'] == '3' ? 'checked="checked"' : '' ?> <?php echo!empty($loaded_plan) ? 'disabled="disabled"' : '' ?>>&nbsp;<?php echo $this->lang->line('overflow_discount_plan') ?></label>
                    </div>
                </div>
                <div id='howToApplyFieldError'></div>

            </div>
            <div class="pane-one-third block-inner">
                <div class="form-group">
                    <label><?php echo $this->lang->line('minimum_order_amount') ?></label>
                    <input type="text" name="min_order" class="form-control" value="<?php echo!empty($loaded_plan) ? $loaded_plan['min_order'] : '' ?>" <?php echo!empty($loaded_plan) && trim($loaded_plan['min_order']) != null ? 'disabled="disabled"' : '' ?>>
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('buy') ?></label>
                    <input type="text" name="buy" value="<?php echo!empty($loaded_plan) ? $loaded_plan['buy'] : '' ?>"  class="form-control">
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('get_free') ?></label>
                    <input type="text" name="get" value="<?php echo!empty($loaded_plan) ? $loaded_plan['get'] : '' ?>" class="form-control">
                </div>

                <div class="form-group">
                    <label><?php echo $this->lang->line('discount_start_date') ?></label>
                    <input type="text" name="start_date" class="form-control" id="discountStartDate" value="<?php echo!empty($loaded_plan) ? date('d/m/Y', strtotime($loaded_plan['start_date'])) : '' ?>" <?php echo!empty($loaded_plan) && trim($loaded_plan['start_date']) != null ? 'disabled="disabled"' : '' ?>>
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('discount_end_date') ?></label>
                    <input type="text" name="end_date" class="form-control" id="discountEndDate" value="<?php echo!empty($loaded_plan) ? date('d/m/Y', strtotime($loaded_plan['end_date'])) : '' ?>">
                </div>
            </div>
            <div class="pane-one-third block-inner">
                <div class="form-group">
                    <label><?php echo $this->lang->line('discount_start_time') ?></label>
                    <input type="text" name="start_time" class="form-control" id="discountStartTime" value="<?php echo!empty($loaded_plan) ? $loaded_plan['start_time'] : '' ?>">
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('discount_end_time') ?></label>
                    <input type="text" name="end_time" class="form-control" id="discountEndTime" value="<?php echo!empty($loaded_plan) ? $loaded_plan['end_time'] : '' ?>">
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('plan_applicable_days') ?></label>
                    <?php $ondays = !empty($loaded_plan) ? unserialize($loaded_plan['onday']) : array(); ?>
                    <div class="checkbox-group">
                        <label><input data-error="#discountPlanFormOnday" type="checkbox" name="onday[]" value="1" <?php in_array('1', $ondays) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('cal_sun') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnday" type="checkbox" name="onday[]" value="2" <?php in_array('2', $ondays) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('cal_mon') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnday" type="checkbox" name="onday[]" value="3" <?php in_array('3', $ondays) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('cal_tue') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnday" type="checkbox" name="onday[]" value="4" <?php in_array('4', $ondays) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('cal_wed') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnday" type="checkbox" name="onday[]" value="5" <?php in_array('5', $ondays) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('cal_thu') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnday" type="checkbox" name="onday[]" value="6" <?php in_array('6', $ondays) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('cal_fri') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnday" type="checkbox" name="onday[]" value="7" <?php in_array('7', $ondays) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('cal_sat') ?>&nbsp;</label>
                    </div>
                </div>
                <div id="discountPlanFormOnday"></div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('plan_applicable_order_types') ?></label>
                    <?php $onapps = !empty($loaded_plan) ? unserialize($loaded_plan['onapp']) : array(); ?>
                    <div class="checkbox-group">
                        <label><input data-error="#discountPlanFormOnapp" type="checkbox" name="onapp[]" value="1" <?php in_array('1', $onapps) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('table') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnapp" type="checkbox" name="onapp[]" value="2" <?php in_array('2', $onapps) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('waiting') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnapp" type="checkbox" name="onapp[]" value="3" <?php in_array('3', $onapps) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('bar') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnapp" type="checkbox" name="onapp[]" value="4" <?php in_array('4', $onapps) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('delivery') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnapp" type="checkbox" name="onapp[]" value="5" <?php in_array('5', $onapps) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('collection') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnapp" type="checkbox" name="onapp[]" value="6" <?php in_array('6', $onapps) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('online') ?>&nbsp;</label>
                    </div>
                </div>
                <div id="discountPlanFormOnapp"></div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('status') ?></label>
                    <div class="radio-group">
                        <label><input data-error='#statusFieldError' type="radio" name="status" value="3" <?php !empty($loaded_plan) && $loaded_plan['status'] == '3' ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('active') ?>&nbsp;</label>
                        <label><input data-error='#statusFieldError' type="radio" name="status" value="2" <?php !empty($loaded_plan) && $loaded_plan['status'] == '2' ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('inactive') ?>&nbsp;</label>
                    </div>
                </div>
                <div id='statusFieldError'></div>
            </div>
            <div class="tab-group config-submit">
                <button type="submit" onclick="saveMultiPlanDiscount('itemMultiDiscountForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
            </div>
            <?php echo form_close() ?>
            <div class="setting-general-keyboard text-center"></div>
            <div class="clearfix padded-top-more text-right"><span class="icon icon-keyboard btn-keyboard-close" onclick="zamanToogleEposVirtualKeyboard('setting-general-keyboard')">&nbsp;<?php echo $this->lang->line('open_virtual_keyboard') ?></span></div>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<script type="text/javascript">
    $('document').ready(function () {
        $('#discountStartDate,#discountEndDate').datetimepicker({
            timepicker: false,
            format: 'd/m/Y',
            minDate: '<?php echo date('d/m/Y', strtotime('today')) ?>',
            formatDate: 'Y/m/d'
        });
        $('#discountStartTime,#discountEndTime').datetimepicker({
            datepicker: false,
            format: 'h:i a',
            formatTime: 'h:i a',
            MinTime: '5:00 pm',
            MaxTime: '11:59 pm',
            step: 30
        });
    });
    function getCategoryMenus(catid) {
        if (!$('.page-loader').is(":visible")) {
            if (Number(catid) > 0) {
                $.ajax({
                    url: '<?php echo site_url('settings/getmenusbycat') ?>',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        id: catid
                    },
                    beforeSend: function (xhr) {
                        $('.page-loader').show();
                    },
                    success: function (response) {
                        $('.page-loader').hide();
                        if (response.status) {
                            var items = response.menus;
                            var html = '<option value="0">Select Menus</option>';
                            items.forEach(function (item) {
                                html += '<option value="' + item.id + '">' + item.title + '</option>';
                            });
                            $('#categoryMenus').html(html);
                        }
                    }
                });
            } else {
                $('#categoryMenus').html('');
            }
        }
    }

    function getMenuSelection(menu) {
        if (!$('.page-loader').is(":visible")) {
            if (Number(menu) > 0) {
                $.ajax({
                    url: '<?php echo site_url('settings/getselectionsbymenu') ?>',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        id: menu
                    },
                    beforeSend: function (xhr) {
                        $('.page-loader').show();
                    },
                    success: function (response) {
                        $('.page-loader').hide();
                        if (response.status) {
                            var items = response.selections;
                            var html = '<option value="0">Select Selection</option>';
                            items.forEach(function (item) {
                                html += '<option value="' + item.id + '">' + item.title + '</option>';
                            });
                            $('#MenuSelections').html(html);
                        } else {
                            $('#MenuSelections').html('');
                        }
                    }
                });
            } else {
                $('#MenuSelections').html('');
            }
        }
    }


    function saveMultiPlanDiscount(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    zamanDbEposDiscountmulti('mono');
                                    warning('<?php echo $this->lang->line('success') ?>', '<?php echo $this->lang->line('data_saved_successfully') ?>', '<?php echo $this->lang->line('ok') ?>');
                                    zamanEposNavigator('multidiscount', '<?php echo site_url('settings/multidiscountadd/') ?>' + response.id, 'multidiscount');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }

                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    title: {required: true, alphanumeric: true},
                    category: {number: true, min: 1, required: true},
                    menu: {number: true, min: 1, required: true},
                    min_order: {number: true, required: true},
                    buy: {number: true, required: true},
                    get: {number: true, required: true},
                    rel: {number: true, required: true},
                    start_date: {required: true},
                    end_date: {required: true},
                    start_time: {required: true},
                    end_time: {required: true},
                    'onday[]': {required: true},
                    onitem: {required: true},
                    'onapp[]': {required: true},
                    status: {required: true},
                },
                messages: {
                    title: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('discount_title')) ?>',
                    category: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('category')) ?>',
                    menu: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('menu')) ?>',
                    min_order: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('minimum_order_amount')) ?>',
                    buy: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('buy')) ?>',
                    get: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('get_free')) ?>',
                    rel: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('how_to_apply')) ?>',
                    start_date: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('discount_start_date')) ?>',
                    end_date: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('discount_end_date')) ?>',
                    start_time: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('discount_start_time')) ?>',
                    end_time: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('discount_end_time')) ?>',
                    'onday[]': '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('plan_applicable_days')) ?>',
                    'onapp[]': '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('plan_applicable_order_types')) ?>',
                    status: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
</script>
