<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="caption" onclick="zamanEposNavigator('discountplan', '<?php echo site_url('settings/discountplan') ?>', 'discountplan')">
                <div class="caption-inner" style="padding: 9px;"><?php echo $this->lang->line('discount_plan') ?></div>
            </div>
            <?php echo form_open('settings/save_discountplan', array('id' => 'discountPlanForm')); ?>
            <?php if (!empty($loaded_plan)): ?>
                <input type="hidden" name="id" value="<?php echo $loaded_plan['id'] ?>">
            <?php endif; ?>
            <div class="pane-one-third block-inner">
                <div class="form-group">
                    <label><?php echo $this->lang->line('discount_title') ?></label>
                    <input type="text" name="title" class="form-control" value="<?php echo!empty($loaded_plan) ? $loaded_plan['title'] : '' ?>" <?php echo!empty($loaded_plan) && trim($loaded_plan['title']) != null ? 'disabled="disabled"' : '' ?>>
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('minimum_order_amount') ?></label>
                    <input type="text" name="min_order" class="form-control" value="<?php echo!empty($loaded_plan) ? $loaded_plan['min_order'] : '' ?>" <?php echo!empty($loaded_plan) && trim($loaded_plan['min_order']) != null ? 'disabled="disabled"' : '' ?>>
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('discount') ?></label>
                    <input type="text" name="discount" class="form-control" value="<?php echo!empty($loaded_plan) ? $loaded_plan['discount'] : '' ?>" <?php echo!empty($loaded_plan) && trim($loaded_plan['discount']) != null ? 'disabled="disabled"' : '' ?>>
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('function') ?></label>
                    <div class="radio-group">
                        <label><input data-error='#discountOnFunctionError' type="radio" name="onfunc" value="2" <?php echo!empty($loaded_plan) && $loaded_plan['onfunc'] == '2' ? 'checked="checked"' : '' ?> <?php echo!empty($loaded_plan) ? 'disabled="disabled"' : '' ?>>&nbsp;<?php echo $this->lang->line('percentage') ?>&nbsp;</label>
                        <label><input data-error='#discountOnFunctionError' type="radio" name="onfunc" value="3" <?php echo!empty($loaded_plan) && $loaded_plan['onfunc'] == '3' ? 'checked="checked"' : '' ?> <?php echo!empty($loaded_plan) ? 'disabled="disabled"' : '' ?>>&nbsp;<?php echo $this->lang->line('amount') ?></label>
                    </div>
                </div>
                <div id='discountOnFunctionError'></div>
            </div>
            <div class="pane-one-third block-inner">
                <div class="form-group">
                    <label><?php echo $this->lang->line('discount_start_date') ?></label>
                    <input type="text" name="start_date" class="form-control" id="discountStartDate" value="<?php echo!empty($loaded_plan) ? date('d/m/Y', strtotime($loaded_plan['start_date'])) : '' ?>" <?php echo!empty($loaded_plan) && trim($loaded_plan['start_date']) != null ? 'disabled="disabled"' : '' ?>>
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('discount_end_date') ?></label>
                    <input type="text" name="end_date" class="form-control" id="discountEndDate" value="<?php echo!empty($loaded_plan) ? date('d/m/Y', strtotime($loaded_plan['end_date'])) : '' ?>">
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('discount_start_time') ?></label>
                    <input type="text" name="start_time" class="form-control" id="discountStartTime" value="<?php echo!empty($loaded_plan) ? $loaded_plan['start_time'] : '' ?>">
                </div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('discount_end_time') ?></label>
                    <input type="text" name="end_time" class="form-control" id="discountEndTime" value="<?php echo!empty($loaded_plan) ? $loaded_plan['end_time'] : '' ?>">
                </div>
            </div>
            <div class="pane-one-third block-inner">
                <div class="form-group">
                    <label><?php echo $this->lang->line('plan_applicable_days') ?></label>
                    <?php $ondays = !empty($loaded_plan) ? unserialize($loaded_plan['onday']) : array(); ?>
                    <div class="checkbox-group">
                        <label><input data-error="#discountPlanFormOnday" type="checkbox" name="onday[]" value="1" <?php in_array('1', $ondays) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('cal_sun') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnday" type="checkbox" name="onday[]" value="2" <?php in_array('2', $ondays) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('cal_mon') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnday" type="checkbox" name="onday[]" value="3" <?php in_array('3', $ondays) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('cal_tue') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnday" type="checkbox" name="onday[]" value="4" <?php in_array('4', $ondays) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('cal_wed') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnday" type="checkbox" name="onday[]" value="5" <?php in_array('5', $ondays) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('cal_thu') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnday" type="checkbox" name="onday[]" value="6" <?php in_array('6', $ondays) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('cal_fri') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnday" type="checkbox" name="onday[]" value="7" <?php in_array('7', $ondays) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('cal_sat') ?>&nbsp;</label>
                    </div>
                </div>
                <div id="discountPlanFormOnday"></div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('plan_applicable_item_types') ?></label>
                    <?php $onitems = !empty($loaded_plan) ? unserialize($loaded_plan['onitem']) : array(); ?>
                    <div class="radio-group">
                        <label><input data-error='#discountOnitemError' type="checkbox" name="onitem[]" value="kitchen" <?php in_array('kitchen', $onitems) ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('kitchen') ?>&nbsp;</label>
                        <label><input data-error='#discountOnitemError' type="checkbox" name="onitem[]" value="bar" <?php in_array('bar', $onitems) ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('bar') ?>&nbsp;</label>
                        <label><input data-error='#discountOnitemError' type="checkbox"name="onitem[]" value="bakery" <?php in_array('bakery', $onitems) ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('bakery') ?>&nbsp;</label>
                        <label><input data-error='#discountOnitemError' type="checkbox" name="onitem[]" value="drinks" <?php in_array('drinks', $onitems) ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('drinks') ?>&nbsp;</label>
                    </div>
                </div>
                <div id='discountOnitemError'></div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('plan_applicable_order_types') ?></label>
                    <?php $onapps = !empty($loaded_plan) ? unserialize($loaded_plan['onapp']) : array(); ?>
                    <div class="checkbox-group">
                        <label><input data-error="#discountPlanFormOnapp" type="checkbox" name="onapp[]" value="1" <?php in_array('1', $onapps) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('table') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnapp" type="checkbox" name="onapp[]" value="2" <?php in_array('2', $onapps) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('waiting') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnapp" type="checkbox" name="onapp[]" value="3" <?php in_array('3', $onapps) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('bar') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnapp" type="checkbox" name="onapp[]" value="4" <?php in_array('4', $onapps) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('delivery') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnapp" type="checkbox" name="onapp[]" value="5" <?php in_array('5', $onapps) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('collection') ?>&nbsp;</label>
                        <label><input data-error="#discountPlanFormOnapp" type="checkbox" name="onapp[]" value="6" <?php in_array('6', $onapps) ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('online') ?>&nbsp;</label>
                    </div>
                </div>
                <div id="discountPlanFormOnapp"></div>
                <div class="form-group">
                    <label><?php echo $this->lang->line('status') ?></label>
                    <div class="radio-group">
                        <label><input data-error='#discountStatusError' type="radio" name="status" value="3" <?php !empty($loaded_plan) && $loaded_plan['status'] == '3' ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('active') ?>&nbsp;</label>
                        <label><input type="radio" name="status" value="2" <?php !empty($loaded_plan) && $loaded_plan['status'] == '2' ? print'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('inactive') ?>&nbsp;</label>
                    </div>
                </div>
                <div id='discountStatusError'></div>
            </div>
            <div class="tab-group config-submit">
                <button type="submit" onclick="saveDiscountPlan('discountPlanForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
            </div>
            <?php echo form_close() ?>
            <div class="setting-general-keyboard text-center"></div>
            <div class="clearfix padded-top-more text-right"><span class="icon icon-keyboard btn-keyboard-close" onclick="zamanToogleEposVirtualKeyboard('setting-general-keyboard')">&nbsp;<?php echo $this->lang->line('open_virtual_keyboard') ?></span></div>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<script type="text/javascript">
    $(document).ready(function () {
        $('#discountStartDate,#discountEndDate').datetimepicker({
            timepicker: false,
            format: 'd/m/Y',
            minDate: '<?php echo date('d/m/Y', strtotime('today')) ?>',
            formatDate: 'Y/m/d'
        });
        $('#discountStartTime,#discountEndTime').datetimepicker({
            datepicker: false,
            format: 'h:i a',
            formatTime: 'h:i a',
            MinTime: '5:00 pm',
            MaxTime: '11:59 pm',
            step: 30
        });

    });
    function saveDiscountPlan(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    warning('<?php echo $this->lang->line('success') ?>', '<?php echo $this->lang->line('data_saved_successfully') ?>', '<?php echo $this->lang->line('ok') ?>');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    title: {required: true},
                    min_order: {number: true, required: true},
                    discount: {number: true, required: true},
                    onfunc: {number: true, required: true},
                    start_date: {required: true},
                    end_date: {required: true},
                    start_time: {required: true},
                    end_time: {required: true},
                    'onday[]': {required: true},
                    'onitem[]': {required: true},
                    'onapp[]': {required: true},
                    status: {required: true}
                },
                messages: {
                    title: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('discount_title')) ?>',
                    min_order: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('minimum_order_amount')) ?>',
                    discount: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('discount')) ?>',
                    onfunc: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('function')) ?>',
                    start_date: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('discount_start_date')) ?>',
                    end_date: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('discount_end_date')) ?>',
                    start_time: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('discount_start_time')) ?>',
                    end_time: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('discount_end_date')) ?>',
                    'onday[]': '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('plan_applicable_days')) ?>',
                    'onitem[]': '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('plan_applicable_item_types')) ?>',
                    'onapp[]': '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('plan_applicable_order_types')) ?>',
                    status: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('status')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
</script>
