<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="caption">
                <div class="caption-inner" style="padding: 9px;" onclick="zamanEposBlockHideAndShow('deliveryFormBlock')"><?php echo $this->lang->line('delivery_plan') ?></div>
            </div>
            <?php if ($this->session->userdata('group') <= 5): ?>
                <div class="employee-add-block collection-bg" id="deliveryFormBlock" style="display: none">
                    <?php echo form_open('settings/save_deliveryplan', array('id' => 'deliveryPlanForm')); ?>
                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('area') ?></label>
                                <input onfocus="setTargetKeyboard('keyboard-fixed-orderpage', 'setting-pagination-keyboard')" name="area" id="deleveryPlanArea" type="text" class="form-control text-uppercase" placeholder="CF5 4">
                            </div>
                        </div>
                    </div>
                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('minimum_order_amount') ?></label>
                                <input onfocus="setTargetKeyboard('keyboard-fixed-orderpage', 'setting-pagination-keyboard')" name="min_order" type="text" class="form-control" placeholder="<?php echo $this->lang->line('minimum_order_amount') ?>">
                            </div>
                        </div>
                    </div>
                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('delivery_waiting_time') ?></label>
                                <input onfocus="setTargetKeyboard('keyboard-fixed-orderpage', 'setting-pagination-keyboard')" name="waiting_time" type="text" class="form-control" placeholder="<?php echo $this->lang->line('delivery_waiting_time') ?>">
                            </div>
                        </div>
                    </div>
                    <div class="one-fifth">
                        <div class="block-inner" style="padding: 2px;">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('delivery_charge') ?></label>
                                <input onfocus="setTargetKeyboard('keyboard-fixed-orderpage', 'setting-pagination-keyboard')" name="delivery_charge" type="text" class="form-control" placeholder="<?php echo $this->lang->line('delivery_charge') ?>">
                            </div>
                        </div>
                    </div>
                    <div class="tab-group config-submit">
                        <button type="submit" onclick="saveDeliveryPlan('deliveryPlanForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
                    </div>
                </div>
            <?php endif; ?>
            <table class="text-center report-table" id="deliveryPlanListTable">
                <?php $planStatus = array('3' => $this->lang->line('active'), '2' => $this->lang->line('inactive')) ?>
                <thead class="table-bg">
                    <tr>
                        <th><?php echo $this->lang->line('area') ?></th>
                        <th><?php echo $this->lang->line('minimum_order_amount') ?></th>
                        <th><?php echo $this->lang->line('delivery_waiting_time') ?></th>
                        <th><?php echo $this->lang->line('delivery_charge') ?></th>
                        <?php if ($this->session->userdata('group') <= 3): ?>
                            <th><?php echo $this->lang->line('branch') ?></th>
                        <?php endif; ?>
                        <th><?php echo $this->lang->line('status') ?></th>    
                        <?php if ($this->session->userdata('group') <= 4): ?>
                            <th><?php echo $this->lang->line('delete') ?></th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody style="margin-bottom: 50px;">
                    <?php if (!empty($plans)): ?>
                        <?php foreach ($plans as $plan): ?>
                            <tr>
                                <td><?php echo $plan->area ?></td>
                                <td>
                                    <span><?php echo $this->config->item('locale_currencyicon') ?></span>
                                    <a href="javascript:void(0)" onclick="updateDeliveryPlanCell('<?php echo"min_order" . $plan->id ?>')" data-type="text" id="min_order<?php echo $plan->id ?>" data-name="min_order" data-pk="<?php echo $plan->id ?>" data-url="<?php echo site_url('settings/updateDeliveryCell') ?>" data-title="Update Min Order">
                                        <?php echo to_currency_no_money($plan->min_order) ?>
                                    </a>
                                </td>
                                <td>
                                    <a href="javascript:void(0)" onclick="updateDeliveryPlanCell('<?php echo"waiting_time" . $plan->id ?>')" data-type="text" id="waiting_time<?php echo $plan->id ?>" data-name="waiting_time" data-pk="<?php echo $plan->id ?>" data-url="<?php echo site_url('settings/updateDeliveryCell') ?>" data-title="Update Waiting Time">
                                        <?php echo $plan->waiting_time ?>
                                    </a><span>mins</span>
                                </td>
                                <td>
                                    <span><?php echo $this->config->item('locale_currencyicon') ?></span>
                                    <a href="javascript:void(0)" onclick="updateDeliveryPlanCell('<?php echo"delivery_charge" . $plan->id ?>')" data-type="text" id="delivery_charge<?php echo $plan->id ?>" data-name="delivery_charge" data-pk="<?php echo $plan->id ?>" data-url="<?php echo site_url('settings/updateDeliveryCell') ?>" data-title="Update Waiting Time">
                                        <?php echo to_currency_no_money($plan->delivery_charge) ?>
                                    </a>
                                </td>
                                <?php if ($this->session->userdata('group') <= 3): ?>
                                    <td><?php echo get_title('branch', array('id' => $plan->branch)) ?></td>
                                <?php endif; ?>
                                <td>
                                    <a href="javascript:void(0)" onclick="updateDeliveryPlanCell('<?php echo"plan_status_" . $plan->id ?>')" data-type="select" id="plan_status_<?php echo $plan->id ?>" data-name="status" data-pk="<?php echo $plan->id ?>" data-value="<?php echo $plan->status ?>" data-url="<?php echo site_url('settings/updateDeliveryCell') ?>" data-title="Update Status">
                                        <?php echo $planStatus[$plan->status] ?>
                                    </a>
                                </td>
                                <?php if ($this->session->userdata('group') <= 4): ?>
                                    <td id="plan-<?php echo $plan->id ?>"><span class="icon icon-trash" onclick="deleteDelveryPlan(<?php echo $plan->id ?>)"></span></td>
                                    <?php endif; ?> 
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<script type="text/javascript">
    function saveDeliveryPlan(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    var plan = response.plan;
                                    var userData = zamanEposCart.getUserData();
                                    if (Number(userData.group) <= 3) {
                                        $('#deliveryPlanListTable').append('<tr><td class="text-center">' + plan.area + '</td><td class="text-center">' + toCurrency(plan.min_order) + '</td><td class="text-center">' + plan.waiting_time + ' mins</td><td class="text-center">' + toCurrency(plan.delivery_charge) + '</td><td class="text-center">' + plan.branchTitle + '</td><td class="text-center">' + plan.statusTitle + '</td><td class="text-center"><span class="icon icon-trash" onclick="deleteDelveryPlan(' + plan.id + ')"></span></td></tr>');
                                    } else {
                                        $('#deliveryPlanListTable').append('<tr><td class="text-center">' + plan.area + '</td><td class="text-center">' + toCurrency(plan.min_order) + '</td><td class="text-center">' + plan.waiting_time + ' mins</td><td class="text-center">' + toCurrency(plan.delivery_charge) + '</td><td class="text-center">' + plan.statusTitle + '</td><td class="text-center"><span class="icon icon-trash" onclick="deleteDelveryPlan(' + plan.id + ')"></span></td></tr>');
                                    }
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }

                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                ignore: ":hidden",
                rules: {
                    area: {required: true},
                    waiting_time: {number: true, required: true},
                    delivery_charge: {number: true, required: true}
                },
                messages: {
                    area: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('area')) ?>',
                    waiting_time: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('delivery_waiting_time')) ?>',
                    delivery_charge: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('default_delivery_charge')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
    function deleteDelveryPlan(id) {
        if (!$('.page-loader').is(":visible")) {
            $.confirm({
                title: '<?php echo $this->lang->line('warning') ?>',
                message: '<?php echo $this->lang->line('delete_warning_message') ?>',
                buttons: {
                    '<span class="icon icon-check"><?php echo $this->lang->line('yes') ?></span>': {
                        'class': 'positive',
                        'action': function () {
                            if (checkInternetConnection()) {
                                $.ajax({
                                    url: '<?php echo site_url('settings/deleteDeliveryPlan') ?>',
                                    data: {id: id},
                                    type: 'POST',
                                    dataType: 'json',
                                    beforeSend: function () {
                                        $('.page-loader').show();
                                    },
                                    success: function (response) {
                                        if (response.status) {
                                            $('#plan-' + id).closest('tr').remove();
                                        }
                                        $('.page-loader').hide();
                                    }
                                });
                            } else {
                                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                            }
                        }
                    },
                    '<span class="icon icon-cancel"><?php echo $this->lang->line('no') ?></span>': {
                        'class': 'negative',
                        'action': function () {}
                    }
                }
            });
        }
    }
    function updateDeliveryPlanCell(field) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + field).editable({
                mode: 'inline',
                source: function () {
                    if (field.includes("status")) {
                        return [
                            {value: 3, text: '<?php echo $this->lang->line('active') ?>'},
                            {value: 2, text: '<?php echo $this->lang->line('inactive') ?>'}
                        ];
                    }
                }
            });
        }
    }
</script>
<?php $this->load->view('settings/partials/footer') ?>
