<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="pane-group text-center ">
                <div class="pane content-configuration">
                    <div class="caption"><span class="icon icon-list"></span>&nbsp;<?php echo $this->lang->line('city') ?></div>
                    <?php if (!empty($cities)): ?>
                        <div class="clearfix">
                            <table class="collection-bg">
                                <tr>
                                    <th class="text-center"><?php echo $this->lang->line('name') ?></th>
                                    <th class="text-center"><?php echo $this->lang->line('action') ?></th>
                                </tr>
                                <?php foreach ($cities as $acity): ?>
                                    <tr>
                                        <td class="text-center"><?php echo $acity->title ?></td>
                                        <td class="text-center">
                                            <span class="icon icon-eye" onclick="zamanEposNavigator('', '<?php echo site_url('settings/location/dooraddress/' . $acity->id) ?>', 'location')"></span>
                                            <?php if ($this->session->userdata('group') === '2'): ?>
                                                &nbsp;&nbsp;&nbsp;<span class="icon icon-trash" onclick="deleteCityById('<?php echo $acity->id ?>')"></span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="pane content-configuration">
                    <div class="caption"><span class="icon icon-list-add"></span>&nbsp;<?php echo!empty($activeCity) ? $activeCity['title'] . '-' : '' ?> <?php echo $this->lang->line('area') ?></div>
                    <?php if (!empty($areas)): ?>
                        <div class="clearfix">
                            <table class="collection-bg">
                                <tr>
                                    <th class="text-center"><?php echo $this->lang->line('name') ?></th>
                                    <th class="text-center"><?php echo $this->lang->line('action') ?></th>
                                </tr>
                                <?php foreach ($areas as $area): ?>
                                    <tr>
                                        <td class="text-center"><?php echo $area->title ?></td>
                                        <td class="text-center">
                                            <span class="icon icon-eye" onclick="zamanEposNavigator('dooraddress', '<?php echo site_url('settings/location/dooraddress/' . $area->city . '/' . $area->id) ?>', 'dooraddress')"></span>
                                            <?php if ($this->session->userdata('group') === '2'): ?>
                                                &nbsp;&nbsp;&nbsp;<span class="icon icon-trash" onclick="deleteAreaById('<?php echo $area->id ?>')"></span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="pane-one-seventh content-configuration" style="padding: 0px 3px;">
                    <div class="caption"><span class="icon icon-list"></span>&nbsp;<?php echo!empty($activeArea) ? $activeArea['title'] . ' - ' . $this->lang->line('postcode') : $this->lang->line('postcode') ?></div>
                    <?php if (!empty($activeCity) && !empty($activeArea)): ?>                        
                        <?php echo form_open('settings/location/savepostcode/' . $activeCity['id'] . '/' . $activeArea['id'], array('id' => 'locationPostcodeForm')); ?>
                        <div class="form-group">
                            <input class="form-control" name="title" type="text" id="postcodeTitle" value="<?php !empty($activePostcode) ? print $activePostcode['title'] : print $activeArea['title'] ?>">
                        </div>
                        <div class="tab-group config-submit" style="border-radius: 0px;">
                            <button style="border-radius: 0px;" type="submit" onclick="saveLocationPostcode('locationPostcodeForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
                        </div>
                        <?php echo form_close() ?>
                        <table class="collection-bg" id="postcodeListTable">
                            <?php foreach ($postcodes as $apostcode): ?>
                                <tr>
                                    <td class="text-center"><?php echo $apostcode->title ?></td>
                                    <td class="text-center">
                                        <span class="icon icon-eye" onclick="zamanEposNavigator('dooraddress', '<?php echo site_url('settings/location/dooraddress/' . $activeCity['id'] . '/' . $activeArea['id'] . '/' . $apostcode->id) ?>', 'dooraddress')"></span>
                                        <?php if ($this->session->userdata('group') === '2'): ?>
                                            &nbsp;&nbsp;&nbsp;<span class="icon icon-trash" onclick="deletePostcodeById('<?php echo $apostcode->id ?>')"></span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </table>
                    <?php endif; ?>
                </div>
                <div class="pane ontent-configuration" style="padding: 0px 3px;">
                    <div class="caption"><span class="icon icon-list-add"></span>&nbsp;<?php echo!empty($activePostcode) ? $activePostcode['title'] . ' - ' . $this->lang->line('door_address') : $this->lang->line('door_address') ?></div>
                    <?php if (!empty($activeCity) && !empty($activeArea) && !empty($activePostcode)): ?>    
                        <?php echo form_open('settings/location/savepostcodeDooraddress/' . $activeCity['id'] . '/' . $activeArea['id'] . '/' . $activePostcode['id'], array('id' => 'locationPostcodeDooraddressForm')); ?>
                        <div style="width: 20%; float: left;">
                            <div class="form-group" style="padding: 0px 1px">
                                <input type="text" name="street_number" class="form-control" placeholder="Door">
                            </div>
                        </div>
                        <div style="width: 40%; float: left;">
                            <div class="form-group" style="padding: 0px 1px">
                                <input type="text" name="route"  class="form-control" placeholder="Street">
                            </div>
                        </div>
                        <div style="width: 40%; float: right;">
                            <div class="form-group" style="padding: 0px 1px">
                                <input type="text" name="postal_town"  class="form-control" placeholder="Postal Town">
                            </div>
                        </div>
                        <div class="tab-group config-submit" style="border-radius: 0px;">
                            <button style="border-radius: 0px;" type="submit" onclick="saveLocationPostcodeDooraddress('locationPostcodeDooraddressForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
                        </div>
                        <?php echo form_close() ?>

                        <table class="collection-bg" id="postcodeDoorAddressListTable" >
                            <?php if (!empty($dooraddress)): ?>
                                <?php foreach ($dooraddress as $anAddress): ?>
                                    <tr>
                                        <td class="text-left"><?php echo $anAddress->street_number . ' ' . $anAddress->route . '  ' . $anAddress->postal_town . ' , ' . $anAddress->administrative_area_level_2 . ' , ' . $anAddress->postal_code ?> &nbsp;&nbsp;<i class="icon icon-trash" id="doorAddress-<?php echo $anAddress->id ?>" onclick="deleteDoorAddress('<?php echo $anAddress->id ?>')"></i></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </table>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $this->load->view('epos/partials/footer') ?>
<script type="text/javascript">
    function saveLocationPostcode(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    var postcodeObj = response.obj;
                                    $('#postcodeListTable').append('<tr><td class="text-center">' + postcodeObj.title + '</td><td class="text-center"><span class="icon icon-eye" onclick="alert(\'Refresh First\')"></span><td></tr>');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    title: {required: true, postcodeUK: true}
                },
                messages: {title: 'Please specify a valid UK postcode'},
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
    function saveLocationPostcodeDooraddress(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    var postcodeObj = response.obj;
                                    var addressString = '';
                                    if (postcodeObj.postal_town) {
                                        addressString += postcodeObj.street_number + ' ' + postcodeObj.route + '  ' + postcodeObj.postal_town + ' , ' + postcodeObj.administrative_area_level_2 + ' , ' + postcodeObj.postal_code;
                                    } else {
                                        addressString += postcodeObj.street_number + ' ' + postcodeObj.route + ' , ' + postcodeObj.administrative_area_level_2 + ' , ' + postcodeObj.postal_code;
                                    }
                                    $('#postcodeDoorAddressListTable').append('<tr><td class="text-left">' + addressString + '&nbsp;&nbsp;<span class="icon icon-trash" id="doorAddress-' + postcodeObj.id + '" onclick="deleteDoorAddress(' + postcodeObj.id + ')"></span></td></tr>');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    route: {required: true}
                },
                messages: {door: 'Door is required'},
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
    function deleteDoorAddress(id) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.ajax({
                    url: '<?php echo site_url('settings/location/deleteDoorAddress') ?>',
                    data: {
                        id: id
                    },
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        $('.page-loader').show();
                    },
                    success: function (response) {
                        if (response.status) {
                            $('#doorAddress-' + id).closest('tr').remove();
                        }
                        $('.page-loader').hide();
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }

        }
    }

    function deleteCityById(id) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {

                $.confirm({
                    title: '<?php echo $this->lang->line('warning') ?>',
                    message: '<?php echo $this->lang->line('delete_warning_message') ?>',
                    buttons: {
                        '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                            'class': 'positive',
                            'action': function () {
                                playBeepSound();
                                $.ajax({
                                    url: '<?php echo site_url('settings/location/deleteCityById/') ?>' + id + '/yes',
                                    type: 'GET',
                                    dataType: 'json',
                                    beforeSend: function () {
                                        $('.page-loader').show();
                                    },
                                    success: function (response) {
                                        $('.page-loader').hide();
                                        if (response.status) {
                                            zamanEposNavigator('dooraddress', '<?php echo site_url('settings/location/dooraddress/') ?>', 'dooraddress');
                                        }
                                    }
                                });
                            }
                        },
                        '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                            'class': 'negative',
                            'action': function () {
                                playBeepSound();
                                $.confirm.hide();
                            }
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
    function deleteAreaById(id) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.confirm({
                    title: '<?php echo $this->lang->line('warning') ?>',
                    message: '<?php echo $this->lang->line('delete_warning_message') ?>',
                    buttons: {
                        '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                            'class': 'positive',
                            'action': function () {
                                playBeepSound();
                                $.ajax({
                                    url: '<?php echo site_url('settings/location/deleteAreaById/') ?>' + id + '/yes',
                                    type: 'GET',
                                    dataType: 'json',
                                    beforeSend: function () {
                                        $('.page-loader').show();
                                    },
                                    success: function (response) {
                                        $('.page-loader').hide();
                                        if (response.status) {
                                            zamanEposNavigator('dooraddress', '<?php echo site_url('settings/location/dooraddress/') ?>', 'dooraddress');
                                        }
                                    }
                                });
                            }
                        },
                        '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                            'class': 'negative',
                            'action': function () {
                                playBeepSound();
                                $.confirm.hide();
                            }
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
    function deletePostcodeById(id) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.confirm({
                    title: '<?php echo $this->lang->line('warning') ?>',
                    message: '<?php echo $this->lang->line('delete_warning_message') ?>',
                    buttons: {
                        '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                            'class': 'positive',
                            'action': function () {
                                playBeepSound();
                                $.ajax({
                                    url: '<?php echo site_url('settings/location/deletePostcodeById/') ?>' + id + '/yes',
                                    type: 'GET',
                                    dataType: 'json',
                                    beforeSend: function () {
                                        $('.page-loader').show();
                                    },
                                    success: function (response) {
                                        $('.page-loader').hide();
                                        if (response.status) {
                                            zamanEposNavigator('dooraddress', '<?php echo site_url('settings/location/dooraddress/') ?>', 'dooraddress');
                                        }
                                    }
                                });
                            }
                        },
                        '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                            'class': 'negative',
                            'action': function () {
                                playBeepSound();
                                $.confirm.hide();
                            }
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
</script>

