<?php if (!empty($loaded_country_region)): ?>
    <div class="pane">
        <div class="caption"><span class="icon icon-list-add"></span>&nbsp;<?php echo $this->lang->line('add_city') ?> - <?php echo $loaded_region['title'] ?></div>
        <?php echo form_open('settings/location/save_city/' . $loaded_country['id'] . '/' . $loaded_region['id'], array('id' => 'locationCityForm')); ?>
        <?php if (!empty($loaded_city)): ?>
            <div><span class="btn btn-positive" style="width: 100%" onclick="resetForm('locationCityForm')"><?php echo $this->lang->line('clear_form_add_new') ?></span></div>
            <input type="hidden" name="id" value="<?php echo $loaded_city['id'] ?>">
            <input type="hidden" id="updateCity" value="yes">
            <input type="hidden" id="oldCityTitle" value="<?php echo $loaded_city['title'] ?>">
        <?php endif; ?>
        <div class="form-group">
            <input class="form-control" name="title" id="cityTitle" type="text" value="<?php !empty($loaded_city) ? print $loaded_city['title'] : '' ?>">
        </div>
        <div class="tab-group config-submit">
            <button type="submit" onclick="saveLocationCity('locationCityForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
        </div>
        <?php echo form_close() ?>
        <?php if (!empty($loaded_region_cities)): ?>
            <div class="clearfix">
                <table class="collection-bg">
                    <caption><?php echo $loaded_region['title'] . ' ' . $this->lang->line('city_list') ?></caption>
                    <tr>
                        <th class="text-center"><?php echo $this->lang->line('name') ?></th>
                        <th class="text-center"><?php echo $this->lang->line('up_down') ?></th>
                        <th class="text-center"><?php echo $this->lang->line('edit') ?></th>
                    </tr>
                    <?php foreach ($loaded_region_cities as $acity): ?>
                        <tr>
                            <td class="text-center"><?php echo $acity->title ?></td>
                            <td class="text-center"><span class="icon icon-up-open-big btn btn-positive" onclick="sortCity('<?php echo $acity->id ?>', '<?php echo $acity->position ?>', '<?php echo 'down' ?>')"></span>&nbsp;&nbsp;<span class="icon icon-down-open-big btn btn-positive" onclick="sortCity('<?php echo $acity->id ?>', '<?php echo $acity->position ?>', '<?php echo 'up' ?>')"></span></td>
                            <td class="text-center">
                                <span class="icon icon-pencil" onclick="zamanEposNavigator('', '<?php echo site_url('settings/location/index/' . $loaded_country['id'] . '/' . $loaded_region['id'] . '/' . $acity->id) ?>', 'location')"></span>
                                <?php if ($this->session->userdata('group') === '2'): ?>
                                    &nbsp;&nbsp;&nbsp;<span class="icon icon-trash" onclick="deleteCityById('<?php echo $acity->id ?>')"></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </table>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>
<script type="text/javascript">
    function saveLocationCity(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    zamanEposNavigator('', '<?php echo site_url('settings/location/index/') ?>' + response.country + '/' + response.region + '/' + response.city, 'location');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    title: {
                        required: true,
                        alphaonly: true,
                        remote: {
                            url: "<?php echo site_url('settings/location/checkcity') ?>",
                            type: "post",
                            data: {
                                value: function () {
                                    return $("#cityTitle").val();
                                },
                                column: 'title',
                                old: function () {
                                    return $("#oldCityTitle").val();
                                },
                                update: function () {
                                    return $("#updateCity").val();
                                },
                                region: '<?php echo $loaded_region['id'] ?>'
                            }
                        }
                    }
                },
                messages: {
                    title: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('city')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
    function sortCity(id, position, func) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.ajax({
                    url: '<?php echo site_url('settings/location/sortcity') ?>',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        id: id,
                        position: position,
                        func: func
                    },
                    beforeSend: function () {
                        $('.page-loader').show();
                    },
                    success: function (response) {
                        $('.page-loader').hide();
                        if (response.status) {
                            zamanEposNavigator('', '<?php echo site_url('settings/location/index/' . $loaded_country['id'] . '/' . $loaded_region['id']) ?>', 'location');
                        } else {
                            warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
    function deleteCityById(id) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.confirm({
                    title: '<?php echo $this->lang->line('warning') ?>',
                    message: '<?php echo $this->lang->line('delete_warning_message') ?>',
                    buttons: {
                        '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                            'class': 'positive',
                            'action': function () {
                                playBeepSound();
                                $.ajax({
                                    url: '<?php echo site_url('settings/location/deleteCityById/') ?>' + id + '/yes',
                                    type: 'GET',
                                    dataType: 'json',
                                    beforeSend: function () {
                                        $('.page-loader').show();
                                    },
                                    success: function (response) {
                                        $('.page-loader').hide();
                                        if (response.status) {
                                            zamanEposNavigator('location', '<?php echo site_url('settings/location/index/') ?>', 'location');
                                        }
                                    }
                                });
                            }
                        },
                        '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                            'class': 'negative',
                            'action': function () {
                                playBeepSound();
                                $.confirm.hide();
                            }
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
</script>