<?php if (!empty($loaded_region_cities)): ?>
    <div class="pane">
        <div class="caption"><span class="icon icon-list-add"></span>&nbsp;<?php echo $this->lang->line('add_area') ?> - <?php echo $loaded_city['title'] ?></div>
        <?php echo form_open('settings/location/save_area/' . $loaded_country['id'] . '/' . $loaded_region['id'] . '/' . $loaded_city['id'], array('id' => 'locationAreaForm')); ?>
        <?php if (!empty($loaded_area)): ?>
            <div><span class="btn btn-positive" style="width: 100%" onclick="resetForm('locationAreaForm')"><?php echo $this->lang->line('clear_form_add_new') ?></span></div>
            <input type="hidden" name="id" value="<?php echo $loaded_area['id'] ?>">
            <input type="hidden" id="updateArea" value="yes">
            <input type="hidden" id="oldAreaTitle" value="<?php echo $loaded_area['title'] ?>">
        <?php endif; ?>
        <div class="form-group">
            <input class="form-control" name="title" type="text" id="areaTitle" value="<?php !empty($loaded_area) ? print $loaded_area['title'] : '' ?>">
        </div>
        <div class="tab-group config-submit">
            <button type="submit" onclick="saveLocationArea('locationAreaForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
        </div>
        <?php echo form_close() ?>
        <?php if ($loaded_city_areas): ?>
            <div class="clearfix">
                <table class="collection-bg">
                    <caption><?php echo $loaded_city['title'] . ' ' . $this->lang->line('area_list') ?></caption>
                    <tr>
                        <th class="text-center"><?php echo $this->lang->line('name') ?></th>
                        <th class="text-center"><?php echo $this->lang->line('up_down') ?></th>
                        <th class="text-center"><?php echo $this->lang->line('edit') ?></th>
                    </tr>
                    <?php foreach ($loaded_city_areas as $area): ?>
                        <tr>
                            <td class="text-center"><?php echo $area->title ?></td>
                            <td class="text-center"><span class="icon icon-up-open-big btn btn-positive" onclick="sortArea('<?php echo $area->id ?>', '<?php echo $area->position ?>', '<?php echo 'down' ?>')"></span>&nbsp;&nbsp;<span class="icon icon-down-open-big btn btn-positive" onclick="sortArea('<?php echo $area->id ?>', '<?php echo $area->position ?>', '<?php echo 'up' ?>')"></span></td>
                            <td class="text-center">
                                <span class="icon icon-pencil" onclick="zamanEposNavigator('', '<?php echo site_url('settings/location/index/' . $loaded_country['id'] . '/' . $loaded_region['id'] . '/' . $loaded_city['id'] . '/' . $area->id) ?>', 'location')"></span>
                                <?php if ($this->session->userdata('group') === '2'): ?>
                                    &nbsp;&nbsp;&nbsp;<span class="icon icon-trash" onclick="deleteAreaById('<?php echo $area->id ?>')"></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </table>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>
<script type="text/javascript">
    function saveLocationArea(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    zamanEposNavigator('', '<?php echo site_url('settings/location/index/') ?>' + response.country + '/' + response.region + '/' + response.city, 'location');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    title: {
                        required: true,
                        alphanumeric: true,
                        remote: {
                            url: "<?php echo site_url('settings/location/checkarea') ?>",
                            type: "post",
                            data: {
                                value: function () {
                                    return $("#areaTitle").val();
                                },
                                column: 'title',
                                old: function () {
                                    return $("#oldAreaTitle").val();
                                },
                                update: function () {
                                    return $("#updateArea").val();
                                },
                                city: '<?php echo $loaded_city['id'] ?>'
                            }
                        }
                    },
                },
                messages: {
                    title: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('area')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
    function sortArea(id, position, func) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.ajax({
                    url: '<?php echo site_url('settings/location/sortarea') ?>',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        id: id,
                        position: position,
                        func: func
                    },
                    beforeSend: function () {
                        $('.page-loader').show();
                    },
                    success: function (response) {
                        $('.page-loader').hide();
                        if (response.status) {
                            zamanEposNavigator('', '<?php echo site_url('settings/location/index/' . $loaded_country['id'] . '/' . $loaded_region['id'] . '/' . $loaded_city['id']) ?>', 'location');
                        } else {
                            warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
    function deleteAreaById(id) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.confirm({
                    title: '<?php echo $this->lang->line('warning') ?>',
                    message: '<?php echo $this->lang->line('delete_warning_message') ?>',
                    buttons: {
                        '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                            'class': 'positive',
                            'action': function () {
                                playBeepSound();
                                $.ajax({
                                    url: '<?php echo site_url('settings/location/deleteAreaById/') ?>' + id + '/yes',
                                    type: 'GET',
                                    dataType: 'json',
                                    beforeSend: function () {
                                        $('.page-loader').show();
                                    },
                                    success: function (response) {
                                        $('.page-loader').hide();
                                        if (response.status) {
                                            zamanEposNavigator('location', '<?php echo site_url('settings/location/index/') ?>', 'location');
                                        }
                                    }
                                });
                            }
                        },
                        '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                            'class': 'negative',
                            'action': function () {
                                playBeepSound();
                                $.confirm.hide();
                            }
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
</script>