<?php

class Settings_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function save_deliveryplan($data, $id = NULL) {
        $this->_table_name = 'deliveryplan';
        $this->_primary_key = 'id';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = $this->session->userdata('owner');
        } else {
            $data['created_by'] = $this->session->userdata('owner');
        }
        return parent::save($data, $id);
    }

    public function save_branch($data, $id = NULL) {
        $this->_table_name = 'branch';
        $this->_primary_key = 'id';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = $this->session->userdata('owner');
        } else {
            $data['created_by'] = $this->session->userdata('owner');
        }
        return parent::save($data, $id);
    }

    public function save_discountplan($data, $id = NULL) {
        $this->_table_name = 'discountplan';
        $this->_primary_key = 'id';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = $this->session->userdata('owner');
        } else {
            $data['created_by'] = $this->session->userdata('owner');
        }
        return parent::save($data, $id);
    }

    public function save_promoplan($data, $id = NULL) {
        $this->_table_name = 'discountpromo';
        $this->_primary_key = 'id';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = $this->session->userdata('owner');
        } else {
            $data['created_by'] = $this->session->userdata('owner');
        }
        return parent::save($data, $id);
    }

    public function get_promo_code($length) {
        $key = self::_generate_promo_code($length);
        if ($key) {
            return $key;
        }
    }

    private function _generate_promo_code($length = 10) {
        do {
            $newkey = substr(str_shuffle(str_repeat($x = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil($length / strlen($x)))), 1, $length);
        } while (self::_promo_code_exists($newkey));
        return $newkey;
    }

    private function _promo_code_exists($key) {
        return $this->db->where('promocode', $key)->count_all_results('discountpromo') > 0;
    }

    public function save_multidiscount($data, $id = NULL) {
        $this->_table_name = 'discountmulti';
        $this->_primary_key = 'id';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = $this->session->userdata('owner');
        } else {
            $data['created_by'] = $this->session->userdata('owner');
        }
        return parent::save($data, $id);
    }

    public function checkpaymentOption($column, $value, $update = 'no') {
        $this->_table_name = 'paymentoption';
        $this->_primary_key = 'id';
        if ($update == 'yes') {
            $old = $this->input->post('old');
            if (trim(strtolower($old)) === trim(strtolower($value))) {
                return false;
            } else {
                return $this->exists($this->_table_name, $column, $value);
            }
        } else {
            return $this->exists($this->_table_name, $column, $value);
        }
    }

    public function save_paymentoptions($data, $id = NULL) {
        $this->_table_name = 'paymentoption';
        $this->_primary_key = 'id';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = $this->session->userdata('owner');
        } else {
            $data['created_by'] = $this->session->userdata('owner');
        }
        return parent::save($data, $id);
    }

    public function get_voucher_code($length) {
        $key = self::_generate_voucher_code($length);
        if ($key) {
            return $key;
        }
    }

    private function _generate_voucher_code($length = 10) {
        do {
            $newkey = substr(str_shuffle(str_repeat($x = '0123456789', ceil($length / strlen($x)))), 1, $length);
        } while (self::_voucher_code_exists($newkey));
        return $newkey;
    }

    private function _voucher_code_exists($key) {
        return $this->db->where('code', $key)->count_all_results('voucher') > 0;
    }

    public function save_voucher($data, $id = NULL) {
        $this->_table_name = 'voucher';
        $this->_primary_key = 'id';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = $this->session->userdata('owner');
        } else {
            $data['created_by'] = $this->session->userdata('owner');
        }
        return parent::save($data, $id);
    }

    public function save_paymentstripe($data, $id = NULL) {
        $this->_table_name = 'paymentstripe';
        $this->_primary_key = 'id';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = $this->session->userdata('owner');
        } else {
            $data['created_by'] = $this->session->userdata('owner');
        }
        return parent::save($data, $id);
    }

    public function save_itemoffer($data, $id = NULL) {
        $this->_table_name = 'discountitem';
        $this->_primary_key = 'id';
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = $this->session->userdata('owner');
        } else {
            $data['created_by'] = $this->session->userdata('owner');
        }
        return parent::save($data, $id);
    }

}
