<?php $this->load->view('settings/partials/header') ?>
<div class="window-content" id="WindowContent">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <table class="text-center report-table">
                <thead class="table-bg">
                    <tr>
                        <th colspan="3"><input type="text" id="reportDateFrom" class="form-control" placeholder="Date Form" value="<?php trim($filterData[0]) ? print $filterData[0] : '' ?>"></th>
                        <th colspan="3"><input type="text" id="reportDateTo" class="form-control" placeholder="Date To" value="<?php trim($filterData[1]) ? print $filterData[1] : '' ?>"></th>
                        <?php if (count($branches) > 1 && $this->session->userdata('group') <= 3): ?>
                            <th colspan="2">
                                <select id="reportBranch" class="form-control">
                                    <?php foreach ($branches as $aBranch): ?>
                                        <option value="<?php echo $aBranch->id ?>" <?php trim($filterData[2] == $aBranch->id) ? print 'selected="selected"' : '' ?>><?php echo$aBranch->title . ' ' . $this->config->item('general_name') ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </th>
                        <?php endif; ?>
                        <th colspan="<?php count($branches) > 1 && $this->session->userdata('group') <= 3 ? print '1' : print '3' ?>"><button type="submit" class="btn btn-primary btn-large" style="width: 100%" onclick="filterBookingReport()"><i class="icon icon-search text-center" ></i>&nbsp;Filter Report</button></th>
                    </tr>
                    <tr>
                        <th><?php echo $this->lang->line('customer') ?></th>
                        <th><?php echo $this->lang->line('email') ?></th>
                        <th><?php echo $this->lang->line('phone') ?></th>
                        <th><?php echo $this->lang->line('guest_quantity') ?></th>
                        <th><?php echo $this->lang->line('date') ?></th>
                        <th><?php echo $this->lang->line('time') ?></th>
                        <th><?php echo $this->lang->line('note') ?></th>
                        <th><?php echo $this->lang->line('status') ?></th>
                        <th><?php echo $this->lang->line('action') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($orderList)): ?>
                        <?php $statusArr = array('1' => $this->lang->line('pending'), '2' => $this->lang->line('confirmed'), '3' => $this->lang->line('rejected')) ?>
                        <?php foreach ($orderList as $aBooking): ?>
                            <tr>
                                <td class="text-capitalize"><?php echo $aBooking->first_name . ' ' . $aBooking->last_name ?></td>
                                <td><?php echo $aBooking->email ?></td>
                                <td><?php echo $aBooking->phone ?></td>
                                <td><?php echo $aBooking->guest_qty ?></td>
                                <td><?php echo date('d-m-Y', strtotime($aBooking->date)) ?></td>
                                <td><?php echo $aBooking->time ?></td>
                                <td><?php echo $aBooking->note ?></td>
                                <td><?php echo $statusArr[$aBooking->status] ?></td>
                                <td>
                                    <select class="form-control" style="height: 25px" id="bookingRow-<?php echo $aBooking->id ?>" onchange="changeBookingStatus(this.value, '<?php echo $aBooking->id ?>')">
                                        <option value="1" <?php $aBooking->status === '1' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('pending') ?></option>
                                        <option value="2" <?php $aBooking->status === '2' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('confirmed') ?></option>
                                        <option value="3" <?php $aBooking->status === '3' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('rejected') ?></option>
                                        <?php if ($this->session->userdata('group') <= 4): ?>
                                            <option value="5" <?php $aBooking->status === '5' ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('delete') ?></option>
                                        <?php endif; ?>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="9"><?php echo $this->lang->line('no_booking_found') ?></td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<script type="text/javascript">
    $('document').ready(function () {
        $('#reportDateFrom').datetimepicker({
            timepicker: false,
            format: 'd-m-Y',
            formatDate: 'Y/m/d'
        });
        $('#reportDateTo').datetimepicker({
            timepicker: false,
            format: 'd-m-Y',
            formatDate: 'Y/m/d'
        });
    });
    function filterBookingReport() {
        if (!$('.page-loader').is(":visible")) {
            var reportDateFrom = $.trim($('#reportDateFrom').val()) ? $('#reportDateFrom').val() : 0;
            var reportDateTo = $.trim($('#reportDateTo').val()) ? $('#reportDateTo').val() : 0;
            var reportBranch = 0;
            if ($('#reportBranch').length > 0) {
                reportBranch = $('#reportBranch').val();
            }
            zamanEposNavigator('', '<?php echo site_url('report/booking/index/') ?>' + reportDateFrom + '/' + reportDateTo + '/' + reportBranch, 'reportIndex');
        }
    }

    function changeBookingStatus(status, id) {
        if (!$('.page-loader').is(":visible")) {
            var data = new Array();
            data['1'] = '<?php echo $this->lang->line('pending') ?>';
            data['2'] = '<?php echo $this->lang->line('confirmed') ?>';
            data['3'] = '<?php echo $this->lang->line('rejected') ?>';
            data['5'] = '<?php echo $this->lang->line('delete') ?>';
            if (Number(status) >= 1 && Number(status) <= 5) {
                if (Number(status) === 5) {
                    $.confirm({
                        title: '<?php echo $this->lang->line('warning') ?>',
                        message: '<?php echo $this->lang->line('booking_status_cahnge_msg_prefix') ?> "' + data[status] + '" ?',
                        buttons: {
                            '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                                'class': 'positive',
                                'action': function () {
                                    deleteBooking(id);
                                }
                            },
                            '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                                'class': 'negative',
                                'action': function () {}
                            }
                        }
                    });
                } else {
                    $.confirm({
                        title: '<?php echo $this->lang->line('warning') ?>',
                        message: '<?php echo $this->lang->line('booking_status_cahnge_msg_prefix') ?> "' + data[status] + '" ?',
                        buttons: {
                            '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                                'class': 'positive',
                                'action': function () {
                                    updateBooking(id, status);
                                }
                            },
                            '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                                'class': 'negative',
                                'action': function () {}
                            }
                        }
                    });
                }
            }
        }
    }
    function deleteBooking(id) {
        $.ajax({
            url: '<?php echo site_url('report/booking/delete/') ?>' + id,
            type: 'Get',
            dataType: 'json',
            beforeSend: function () {
                $('.page-loader').show();
            },
            success: function (response) {
                $('.page-loader').hide();
                if (response.status) {
                    $('#bookingRow-' + id).closest('tr').remove();
                } else {
                    warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('delete_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                }
            },
            error: function () {
                $('.page-loader').hide();
                warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('delete_failed') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        });
    }
    function updateBooking(id, status) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.ajax({
                    url: '<?php echo site_url('api/update_booking_status') ?>',
                    data: {id: id, status: status},
                    dataType: 'json',
                    type: 'POST',
                    beforeSend: function () {
                        $('.page-loader').show();
                    },
                    success: function (response) {
                        $('.page-loader').hide();
                        if (response.status) {
                            zamanEposNavigator('reportIndex', '<?php echo $refresh ?>', 'reportIndex');
                        } else {
                            warning('<?php echo $this->lang->line('success') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('ok') ?>');
                        }
                    },
                    error: function () {
                        $('.page-loader').hide();
                        warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
</script>