<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane">
            <div class="content-inner">
                <div class="content-form" style="width: 80%; float: left; background: #087692; padding: 20px;">
                    <div class="block">
                        <?php echo form_open('page/saveExternallink', array('id' => 'externallinkForm')); ?>
                        <div class="block-inner">
                            <?php if (!empty($externallink)): ?>
                                <?php foreach ($externallink as $link): ?>
                                    <div class="form-group">
                                        <label class="text-capitalize"><?php echo $link->title ?></label>
                                        <input name="<?php echo $link->slug ?>" value="<?php echo $link->link ?>" class="form-control">
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                            <div class="tab-group config-submit">
                                <button type="submit" onclick="saveExternalLink('externallinkForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
                            </div>
                            <?php echo form_close() ?>
                        </div>
                    </div>
                </div>
                <div class="content-sidebar-nav" style="width: 20%; float: right;">
                    <div class="block">
                          <?php $this->load->view('page/page_nav')?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="setting-general-keyboard text-center"></div>
<?php $this->load->view('settings/partials/footer') ?>
<script type="text/javascript">
    function saveExternalLink(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                if (response.status) {
                                    $('.page-loader').hide();
                                    zamanEposNavigator('page', '<?php echo site_url('page/externallink') ?>', 'page');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
</script>
