<?php if (!empty($loaded_category)): ?>
    <div class="pane category-list-block list-block">
        <div class="caption" onclick="zamanEposBlockHideAndShow('nattFormBlock')">
            <div class="caption-inner" style="padding: 9px"> <?php echo sprintf($this->lang->line('add_new_topping'), $loaded_category['title']) ?></div>
        </div>
        <div class="block-inner" id="nattFormBlock" style="display: none;">
            <?php echo form_open('menu/nattr/save/' . $loaded_category['id'], array('id' => 'nattrForm')); ?>
            <table>
                <tr><td colspan="3"><span class="btn btn-positive" onclick="resetForm('nattrForm')"><?php echo $this->lang->line('clear_form_add_new') ?></span></td></tr>
                <tr>
                    <td class="text-right"><?php echo $this->lang->line('title') ?></td>
                    <td>
                        <input value="<?php !empty($loaded_attr) ? print $loaded_attr['title'] : '' ?>"  type="text" data-error="#nattrFormTitle" name="title" id="nattrTitle" class="form-control" placeholder="<?php echo $this->lang->line('title') ?>">
                        <div class="clearfix" id="nattrFormTitle"></div>
                        <?php if (!empty($loaded_attr)): ?>
                            <input type="hidden" name="id" value="<?php echo $loaded_attr['id'] ?>">
                            <input type="hidden" id="updateNattr" value="yes">
                            <input type="hidden" id="oldNattrTitle" value="<?php echo $loaded_attr['title'] ?>">
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <td colspan="1" class="text-right"><?php echo $this->lang->line('base_price') ?></td>
                    <td colspan="3">
                        <input type="text" data-error="#nattrFormPrice" name="price" value="<?php !empty($loaded_attr) ? print $loaded_attr['price'] : '' ?>" class="form-control" placeholder="<?php echo $this->lang->line('base_price') ?>">
                        <div class="clearfix" id="nattrFormPrice"></div>
                    </td>
                </tr>
            </table>
            <div class="tab-group config-submit">
                <button type="submit" onclick="nattrForm('nattrForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
            </div>
            <?php echo form_close() ?>
        </div>
        <div class="clearfix item-group">
            <div class="menu-list special-modify-btn-groups">
                <?php if (!empty($loaded_category_attr)): ?>
                    <?php foreach ($loaded_category_attr as $lca): ?>
                        <div class="menu-button" onclick="zamanEposNavigator('', '<?php echo site_url('menu/nattr/index/' . $lca->nattrcategory . '/' . $lca->id) ?>')"><div class="menu-button-inner"><?php echo ucwords($lca->title) ?></div></div>
                        <?php endforeach; ?>
                    <?php endif; ?>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        function nattrForm(formId) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                if (response.status) {
                                    zamanDbEposNattr('how');
                                    $('.page-loader').hide();
                                    zamanEposNavigator('', '<?php echo site_url('menu/nattr/index/') ?>' + response.category + '/' + response.nattr);
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    title: {
                        required: true,
                        remote: {
                            url: "<?php echo site_url('menu/nattr/checkme') ?>",
                            type: "post",
                            data: {
                                value: function () {
                                    return $("#nattrTitle").val();
                                },
                                column: 'title',
                                old: function () {
                                    if ($('#oldNattrTitle').length > 0) {
                                        return $('#oldNattrTitle').val();
                                    } else {
                                        return 'none';
                                    }
                                },
                                update: function () {
                                    if ($('#updateNattr').length > 0) {
                                        return 'yes';
                                    } else {
                                        return 'no';
                                    }
                                },
                                category: '<?php echo $loaded_category['id'] ?>'
                            }
                        }
                    },
                    price: {number: true, min: 0, required: true},
                    status: {required: true}
                },
                messages: {
                    title: '<?php echo $this->lang->line('title_required_msg') ?>',
                    status: '<?php echo $this->lang->line('status_required_msg') ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }

        function sortNattrCategory(id, position, func) {
            if (checkInternetConnection()) {
                $.ajax({
                    url: '<?php echo site_url('menu/nattr/sortcategory') ?>',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        id: id,
                        position: position,
                        func: func
                    },
                    success: function (response) {
                        if (response.status) {
                            zamanDbEposNattrCategory('mono');
                            zamanEposNavigator('', '<?php echo site_url('menu/nattr') ?>');
                        } else {
                            warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    </script>
<?php endif; ?>