<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Modifier_Model extends MY_Model {

    function __construct() {
        parent::__construct();
        $this->_order_by = 'position';
        $this->_primary_key = 'id';
        $this->_table_name = 'modifier';
    }

    public function checkme($column, $value, $update = 'no') {
        if ($update == 'yes') {
            $old = $this->input->post('old');
            if (trim(strtolower($old)) === trim(strtolower($value))) {
                return false;
            } else {
                return $this->doesModifierExist($this->_table_name, $column, $value);
            }
        } else {
            return $this->doesModifierExist($this->_table_name, $column, $value);
        }
    }

    private function doesModifierExist($table, $column, $value) {
        return $this->db->where(array($column => $value, 'branch' => $this->session->userdata('branch')))->count_all_results($table) > 0;
    }

    public function save($data, $id = NULL) {
        if ($id !== NULL && $id > 0) {
            $data['updated_by'] = $this->session->userdata('owner');
        }
        return parent::save($data, $id);
    }

}
