<div style="display: none;">
    <div id="eposNewOrderInfoPage">
        <div class="popup-header toolbar-header">
            <div class="popup-title">Order Information</div>
            <div class="popup-close-btn" onclick="zamanEposPopupcloser()"><span class="icon icon-cancel"></span></div>
        </div>
        <div class="popup-content">
            <div class="order-new-order">
                <table id="OrderInformationTable"></table>
            </div>
        </div>
        <div class="tab-group" id="orderUpdateToolsBtn"></div>
    </div>
</div>
<script type="text/javascript">
    function zamanOrderInfoControllerPopup() {
        var currentOrderId = zamanEposCart.getEposCurrentId();
        if ($.trim(currentOrderId) && Number(currentOrderId) > 0) {
            zamanEposDb.epos_order.get({orderId: Number(currentOrderId)}).then(function (anOrder) {
                if (typeof (anOrder) !== 'undefined') {
                    $.colorbox({
                        inline: true,
                        scrolling: false,
                        href: "#eposNewOrderInfoPage",
                        width: '450px',
                        height: 'auto',
                        maxWidth: "100%",
                        open: true,
                        closeButton: false,
                        transition: 'none',
                        overlayClose: false,
                        className: 'transparent-overlay',
                        onOpen: function () {
                            playBeepSound();
                        },
                        onComplete: function () {
                            var orderInfoHtml = '';
                            orderInfoHtml += `<tr>
                                <td class="text-right" style="width: 50%">Reference:</td>
                                <td class="text-left">&nbsp;&nbsp;` + anOrder.sid + '/' + anOrder.orderId + `</td>
                            </tr>
                            <tr>
                                <td class="text-right">Order Type:</td>
                                <td class="text-left text-capitalize">` + anOrder.type + `</td>
                            </tr>`;
                            if (anOrder.type === 'table') {
                                orderInfoHtml += `<tr>
                                <td class="text-right">Table Number:</td>
                                <td class="text-left">` + anOrder.orderInfo.tableNumber + `</td>
                                </tr>
                                    <tr>
                                    <td class="text-right">Guest Quantity:</td>
                                    <td class="text-left">` + anOrder.orderInfo.guestQty + `</td>
                                </tr>`;
                                var hours = anOrder.dateInfo.hours >= 12 ? anOrder.dateInfo.hours % 12 : anOrder.dateInfo.hours;
                                var amPm = anOrder.dateInfo.hours >= 12 && anOrder.dateInfo.minutes > 0 ? `PM` : 'AM';
                                var seatedTime = hours + `:` + anOrder.dateInfo.minutes + `:` + anOrder.dateInfo.seconds + ` ` + amPm;
                                orderInfoHtml += `<tr>
                                <td class="text-right">Seated Time:</td>
                                <td class="text-left">` + seatedTime + `</td>
                                </tr>
                                <tr>
                                   <td class="text-right">First Taken At:</td>
                                   <td class="text-left">` + anOrder.firstTakenAt + `</td>
                               </tr>       
                                <tr>
                                    <td class="text-right">Last Taken At:</td>
                                    <td class="text-left">` + anOrder.lastTakenAt + `</td>
                                </tr>`;
                            } else {
                                orderInfoHtml += `<tr>
                                    <td class="text-right">Customer Name:</td>
                                    <td class="text-left text-capitalize">` + anOrder.orderInfo.name + `</td>
                                </tr>
                                <tr>
                                   <td class="text-right">Customer Phone:</td>
                                   <td class="text-left text-capitalize">` + anOrder.orderInfo.phone + `</td>
                               </tr>`;
                            }
                            if (anOrder.type === 'delivery') {
                                var deliveryAddress = '';
                                if ($.trim(anOrder.orderInfo.apartment)) {
                                    deliveryAddress += `Apt: ` + anOrder.orderInfo.apartment + `, `;
                                }
                                if ($.trim(anOrder.orderInfo.floor)) {
                                    deliveryAddress += `Floor: ` + anOrder.orderInfo.floor + `, `;
                                }
                                if ($.trim(anOrder.orderInfo.building)) {
                                    deliveryAddress += `Building: ` + anOrder.orderInfo.building + `<br/> `;
                                }
                                if ($.trim(anOrder.orderInfo.sector)) {
                                    deliveryAddress += anOrder.orderInfo.sector + `, `;
                                }
                                if ($.trim(anOrder.orderInfo.street)) {
                                    deliveryAddress += anOrder.orderInfo.street + `, `;
                                }

                                if ($.trim(anOrder.orderInfo.area) && anOrder.orderInfo.country === 'Bangladesh') {
                                    deliveryAddress += anOrder.orderInfo.area + `<br/>`;
                                }

                                if ($.trim(anOrder.orderInfo.postcode)) {
                                    deliveryAddress += formatPostcode(anOrder.orderInfo.postcode) + `, `;
                                }
                                if ($.trim(anOrder.orderInfo.city)) {
                                    deliveryAddress += anOrder.orderInfo.city + `, `;
                                }
                                orderInfoHtml += `<tr>
                                    <td class="text-right">Delivery Address:</td>
                                    <td class="text-left">` + deliveryAddress + `</td>
                                </tr>
                                <tr>
                                    <td class="text-right">Delivery Time:</td>
                                    <td class="text-left">` + anOrder.orderInfo.deliveryTime + `</td>
                                </tr>`;
                            }

                            if (anOrder.type === 'collection') {
                                orderInfoHtml += `<tr>
                                    <td class="text-right">Collection Time:</td>
                                    <td class="text-left">` + anOrder.orderInfo.collectionTime + `</td>
                                </tr>`;
                            }
                            $('#OrderInformationTable').html(orderInfoHtml);
                            var orderUpdateToolsBtn = '';
                            if (anOrder.type === 'table') {
                                orderUpdateToolsBtn += `<div class="tab-item zaman-epos-nav quantity-digit" style="padding: 15px;" onclick="zamanPlaceTableOrder(` + anOrder.orderId + `,` + anOrder.orderInfo.tableNumber + `,` + anOrder.orderInfo.guestQty + `,'','')"><span><?php echo $this->lang->line('edit') ?></span></div>
                                            <div class="tab-item zaman-epos-nav quantity-digit" style="padding: 15px;" onclick="zamanPlaceTableOrder(` + anOrder.orderId + `,` + anOrder.orderInfo.tableNumber + `,` + anOrder.orderInfo.guestQty + `)"><span><?php echo $this->lang->line('shift') ?></span></div>
                                            <div class="tab-item zaman-epos-nav quantity-digit" style="padding: 15px;" onclick="alert('comming soon')"><span><?php echo $this->lang->line('join') ?></span></div>
                                            <div class="tab-item zaman-epos-nav quantity-digit" style="padding: 15px;" onclick="zamanOrderCovertControllerPopup(` + anOrder.orderId + `,'` + anOrder.type + `')"><span><?php echo $this->lang->line('convert') ?></span></div>`;
                            }
                            if (anOrder.type === 'waiting') {
                                orderUpdateToolsBtn += `<div class="tab-item zaman-epos-nav quantity-digit" style="padding: 15px;" onclick="zamanPlaceWaitingOrder(` + anOrder.orderId + `,'` + anOrder.orderInfo.name + `','` + anOrder.orderInfo.phone + `','','')"><span class="icon icon-check"><?php echo $this->lang->line('edit') ?></span></div>
                                     <div class="tab-item zaman-epos-nav quantity-digit" style="padding: 15px;" onclick="zamanOrderCovertControllerPopup(` + anOrder.orderId + `,'` + anOrder.type + `')"><span class="icon icon-cc"><?php echo $this->lang->line('convert') ?></span></div>`;
                            }
                            if (anOrder.type === 'bar') {
                                orderUpdateToolsBtn += `<div class="tab-item zaman-epos-nav quantity-digit" style="padding: 15px;" onclick="zamanPlaceBarOrder(` + anOrder.orderId + `,'` + anOrder.orderInfo.name + `','` + anOrder.orderInfo.phone + `','','')"><span class="icon icon-check"><?php echo $this->lang->line('edit') ?></span></div>
                                     <div class="tab-item zaman-epos-nav quantity-digit" style="padding: 15px;" onclick="zamanOrderCovertControllerPopup(` + anOrder.orderId + `,'` + anOrder.type + `')"><span class="icon icon-cc"><?php echo $this->lang->line('convert') ?></span></div>`;
                            }
                            if (anOrder.type === 'collection') {
                                orderUpdateToolsBtn += `<div class="tab-item zaman-epos-nav quantity-digit" style="padding: 15px;" onclick="zamanPlaceCollectionOrder(` + anOrder.orderId + `,'` + anOrder.orderInfo.name + `','` + anOrder.orderInfo.phone + `','` + anOrder.orderInfo.collectionTime + `','','')"><span class="icon icon-check"><?php echo $this->lang->line('edit') ?></span></div>
                                     <div class="tab-item zaman-epos-nav quantity-digit" style="padding: 15px;" onclick="zamanOrderCovertControllerPopup(` + anOrder.orderId + `,'` + anOrder.type + `')"><span class="icon icon-cc"><?php echo $this->lang->line('convert') ?></span></div>`;
                            }
                            if (anOrder.type === 'delivery') {
                                orderUpdateToolsBtn += `<div class="tab-item" onclick="zamanPlaceDeliveryOrder(` + anOrder.orderId + `,'` + anOrder.orderInfo.name + `','` + anOrder.orderInfo.phone + `','` + anOrder.orderInfo.apartment + `','` + anOrder.orderInfo.floor + `','` + anOrder.orderInfo.building + `','` + anOrder.orderInfo.sector + `','` + anOrder.orderInfo.street + `','` + anOrder.orderInfo.postcode + `','` + anOrder.orderInfo.area + `','` + anOrder.orderInfo.city + `','` + anOrder.orderInfo.region + `','` + anOrder.orderInfo.country + `','` + anOrder.orderInfo.deliveryTime + `','','')"><span class="icon icon-check">&nbsp;<?php echo $this->lang->line('edit') ?></span></div>
                                     <div class="tab-item" onclick="zamanOrderCovertControllerPopup(` + anOrder.orderId + `,'` + anOrder.type + `')"><span class="icon icon-cc">&nbsp;<?php echo $this->lang->line('convert') ?></span></div>`;
                            }
                            $('#orderUpdateToolsBtn').html(orderUpdateToolsBtn);
                            $('#colorbox').colorbox.resize();
                        }
                    });
                } else {
                    settleDownNewOrderOption();
                }
            });
        } else {
            settleDownNewOrderOption();
        }
    }
</script>