<div style="display: none;">
    <div id="eposOnlineOrderPage" class="epos-order-list-page">
        <div class="popup-header toolbar-header">
            <div class="popup-title">My Online Orders</div>
            <div class="popup-close-btn" onclick="zamanEposPopupcloser()"><span class="icon icon-cancel"></span></div>
        </div>
        <div class="tab-group page-order-tab" style="width: 100%;margin-top: -3px;">
            <div  class="tab-item order-process-status-1"><?php echo $this->lang->line('pending') ?></div>
            <div  class="tab-item order-process-status-2"><?php echo $this->lang->line('processing') ?></div>
            <div  class="tab-item order-process-status-3"><?php echo $this->lang->line('ready') ?></div>
            <div  class="tab-item order-process-status-4"><?php echo $this->lang->line('payment_waiting') . ' / ' . $this->lang->line('close') ?></div>
        </div>
        <div class="popup-content">
            <div id="onlineorderList"></div>
            <div class="clearfix"></div>
            <div id="onlineOrderDetail"></div>
        </div>
    </div>
</div>
<script type="text/javascript">
    function showOnlineOrderDetail(sid) {
        if ($('#onlineOrderId-' + sid).is(':visible')) {
            $('#onlineOrderId-' + sid).hide();
        } else {
            $('.online-order-detail-table').hide();
            $('#onlineOrderId-' + sid).show();
        }
        $('#colorbox').colorbox.resize();
    }
    function zamanOnlineOrderPageControllerPopup() {
        $.ajax({
            url: '<?php echo site_url('api/getOnlineOrder') ?>',
            type: 'post',
            dataType: 'json',
            success: function (orders) {
                if (orders.length > 0) {
                    var onlineHtml = '';
                    var onlineOrderDetailHtml = '';
                    orders.forEach(function (order) {
                        var isPaid = Number(order.isPaid) === 3 ? '(<?php echo $this->lang->line('paid') ?> ' + toCurrency(order.grandTotal) + ')' : toCurrency(order.grandTotal);
                        if (order.type === 'collection') {
                            onlineHtml += `<div class="pane-content" onclick=showOnlineOrderDetail('` + order.sid + `')>
                        <div class="zaman-nav-item-pane">
                            <div class="order-item-img-block pull-left collection-bg order-process-status-` + order.status + `">
                                <p class="text-capitalize" style="line-height:0.9;">` + isPaid + `<br/><img class="collection-icon" alt="" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwAQMAAABtzGvEAAAAA1BMVEX///+nxBvIAAAAAXRSTlMAQObYZgAAAA1JREFUeNpjYBgF1AQAAVAAATS4OtkAAAAASUVORK5CYII=" style="width:30px;"><br/>` + order.orderInfo.name + `<br/>` + order.orderInfo.collectionTime + `</p>
                            </div>
                        </div>
                    </div>`;
                        } else {
                            onlineHtml += `<div class="pane-content" onclick=showOnlineOrderDetail('` + order.sid + `')>
                        <div class="zaman-nav-item-pane">
                            <div class="order-item-img-block pull-left delivery-bg order-process-status-` + order.status + `">
                                <p class="text-capitalize" style="line-height:0.9;">` + isPaid + `<br/> <img class="delivery-icon" alt="" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwAQMAAABtzGvEAAAAA1BMVEX///+nxBvIAAAAAXRSTlMAQObYZgAAAA1JREFUeNpjYBgF1AQAAVAAATS4OtkAAAAASUVORK5CYII=" style="width:36px; height:30px"><br/>` + order.orderInfo.name + `<br/>` + order.orderInfo.deliveryTime + `</p>
                            </div>
                        </div>
                    </div>`;
                        }
                        onlineOrderDetailHtml += renderOnlineOrderDetail(order);
                    });
                    $('#onlineorderList').html(onlineHtml);
                    $('#onlineOrderDetail').html(onlineOrderDetailHtml);
                } else {
                    $('#onlineorderList').html('');
                    $('#onlineOrderDetail').html('');
                }
            }
        });
        $.colorbox({inline: true, scrolling: false, href: "#eposOnlineOrderPage", width: '80%', height: 'auto', maxWidth: "100%", open: true, closeButton: false, transition: 'none', overlayClose: false, className: 'transparent-overlay',
            onClosed: function () {
                $('#onlineorderList').html('');
                $('#onlineOrderDetail').html('');
            }
        });
    }

    function renderOnlineOrderDetail(order) {
        var cart = order.cart;
        var OrderHtml = '<table class="report-table online-order-detail-table" id="onlineOrderId-' + order.sid + '" style="display:none;">';
        OrderHtml += '<caption>Ref#&nbsp;' + order.sid + '/' + order.orderId + '</caption>';
        OrderHtml += '<tr><td class="text-right" style="width: 50%">Source&nbsp;</td><td class="text-left text-capitalize" style="width: 50%">&nbsp;' + order.source + '</td></tr>';
        OrderHtml += '<tr><td class="text-right">Type&nbsp;</td><td class="text-left">&nbsp;' + order.type + '</td></tr>';
        OrderHtml += '<tr><td class="text-right">Amount&nbsp;</td><td class="text-left">&nbsp;' + toCurrency(order.grandTotal) + '</td></tr>';
        var paidString = Number(order.isPaid) === 3 ? '<?php echo $this->lang->line('paid') ?>' : '<?php echo $this->lang->line('unpaid') ?>';
        OrderHtml += '<tr><td class="text-right">Payment&nbsp;</td><td class="text-left">&nbsp;' + paidString + '</td></tr>';
        OrderHtml += '<tr><td class="text-right">Name&nbsp;</td><td class="text-left">&nbsp;' + order.orderInfo.name + '</td></tr>';
        OrderHtml += ' <tr><td class="text-right">Phone&nbsp;</td><td class="text-left">&nbsp; ' + order.orderInfo.phone + '</td></tr>';
        if (order.type === 'delivery') {
            var address = '';
            address += $.trim(order.orderInfo.building) ? order.orderInfo.building + ', ' : '';
            address += order.orderInfo.sector + ' ' + order.orderInfo.street + ', ' + order.orderInfo.city + ', ' + order.orderInfo.postcode;
            OrderHtml += '<tr><td class="text-right">Delivery Address&nbsp;</td><td class="text-left">&nbsp;' + address + '</td></tr>';
            OrderHtml += '<tr><td class="text-right">Delivery Time&nbsp;</td><td class="text-left">&nbsp;' + order.orderInfo.deliveryTime + '</td></tr>';
        } else {
            OrderHtml += '<tr><td class="text-right">Collection Time&nbsp;</td><td class="text-left">&nbsp;' + order.orderInfo.collectionTime + '</td></tr>';
        }
        var splitedDatetime = order.created_at.split(' ');
        var splitedDateParts = splitedDatetime[0].split('-');
        var onlineOrderDatePartString = splitedDateParts[2] + '/' + splitedDateParts[1] + '/' + splitedDateParts[0];
        OrderHtml += '<tr><td class="text-right">Date&nbsp;</td><td class="text-left">&nbsp;' + onlineOrderDatePartString + '</td></tr>';
        OrderHtml += '<tr><td colspan="2"><div class="tab-group">';
        if (order.status_online === '2') {
            OrderHtml += '<div class="tab-item" style="background:green;" onclick="showOnlineOrderAcceptTimeSlot(\'onlineOrderAcceptTimeSlot-' + order.sid + '\')">Accept</div>';
        }
        if (order.status >= 2) {
            OrderHtml += '<div class="tab-item" onclick=resendOnlineOrder(\'' + order.sid + '\')>Resend</div>';
            OrderHtml += '<div class="tab-item" onclick=printBillOnlineOrder(\'' + order.sid + '\')>Print Bill</div>';
        }
        if (order.isPaid !== '3' && order.status >= 2) {
            OrderHtml += '<div class="tab-item" onclick="paymentOnlineOrder(\'' + order.sid + '\',\'' + order.orderId + '\',\'' + order.grandTotal + '\')">Payment</div>';
        }

        if (order.isPaid === '3' && order.status >= 2) {
            OrderHtml += '<div class="tab-item" onclick="closeOnlineOrder(\'' + order.sid + '\')">Close</div>';
        }
        if (order.status_online === '2') {
            OrderHtml += '<div class="tab-item" style="background:red;" onclick="showOnlineOrderRejectMessageSlot(\'onlineOrderRejectMsg-' + order.sid + '\')">Reject</div>';
        }
        OrderHtml += '</div></td></tr>';
        if (order.status_online === '2') {
            OrderHtml += '<tr  style="display:none" class="online-order-accept-time-slot" id="onlineOrderAcceptTimeSlot-' + order.sid + '"><td colspan="2">';
            OrderHtml += '<div class="text-center">';
            var deliveryTime = order.type === "collection" ? order.orderInfo.collectionTime : order.orderInfo.deliveryTime;
            OrderHtml += deliveryTime + ' + Extra time in mins';
            OrderHtml += '</div>';
            OrderHtml += '<div class="tab-group">';
            OrderHtml += '<div class="tab-item" onclick="acceptOnlineOrder(\'' + 0 + '\',\'' + order.sid + '\')">00</div><div class="tab-item" onclick="acceptOnlineOrder(\'' + 5 + '\',\'' + order.sid + '\')">05</div><div class="tab-item" onclick="acceptOnlineOrder(\'' + 10 + '\',\'' + order.sid + '\')">10</div><div class="tab-item" onclick="acceptOnlineOrder(\'' + 15 + '\',\'' + order.sid + '\')">15</div><div onclick="acceptOnlineOrder(\'' + 20 + '\',\'' + order.sid + '\')" class="tab-item">20</div>';
            OrderHtml += '<div class="tab-item" onclick="acceptOnlineOrder(\'' + 25 + '\',\'' + order.sid + '\')">25</div><div class="tab-item" onclick="acceptOnlineOrder(\'' + 30 + '\',\'' + order.sid + '\')">30</div><div class="tab-item" onclick="acceptOnlineOrder(\'' + 35 + '\',\'' + order.sid + '\')">35</div><div class="tab-item" onclick="acceptOnlineOrder(\'' + 40 + '\',\'' + order.sid + '\')">40</div>';
            OrderHtml += '<div class="tab-item" onclick="acceptOnlineOrder(\'' + 45 + '\',\'' + order.sid + '\')">45</div><div class="tab-item" onclick="acceptOnlineOrder(\'' + 50 + '\',\'' + order.sid + '\')">50</div><div class="tab-item" onclick="acceptOnlineOrder(\'' + 55 + '\',\'' + order.sid + '\')">55</div><div class="tab-item" onclick="acceptOnlineOrder(\'' + 60 + '\',\'' + order.sid + '\')">60</div>';
            OrderHtml += '</div>';
            OrderHtml += '</td></tr>';
        }
        if (order.status_online === '2') {
            OrderHtml += '<tr  style="display:none;" class="online-order-reject-msg" id="onlineOrderRejectMsg-' + order.sid + '"><td colspan="2">';
            OrderHtml += '<div class="text-center">';
            OrderHtml += 'Your reject reason message?';
            OrderHtml += '</div>';
            OrderHtml += '<div class="tab-group">';
            OrderHtml += '<div class="tab-item" onclick="rejectOnlineOrderMsg(\' \',\'' + order.sid + '\')">Blank</div>';
            OrderHtml += '<div class="tab-item" onclick="rejectOnlineOrderMsg(\'Sorry! we are busy now\',\'' + order.sid + '\')">Sorry! we are busy now</div>';
            OrderHtml += '<div class="tab-item" onclick="rejectOnlineOrderMsg(\'Sorry! some item not available now\',\'' + order.sid + '\')">Sorry! some item not available now</div>';
            OrderHtml += '<div class="tab-item" onclick="rejectOnlineOrderMsg(\'Sorry! we are going off now\',\'' + order.sid + '\')">Sorry! we are going off now</div>';
            OrderHtml += '</div>';
            OrderHtml += '<div class="tab-group">';
            OrderHtml += '<div class="tab-item" onclick="rejectOnlineOrderMsg(\'Sorry! we are not available now \',\'' + order.sid + '\')">Sorry! we are not available now</div>';
            OrderHtml += '<div class="tab-item" onclick="rejectOnlineOrderMsg(\'Sorry! driver not available to delivery your order\',\'' + order.sid + '\')">Sorry! driver not available to delivery your order</div>';
            OrderHtml += '<div class="tab-item" onclick="rejectOnlineOrderMsg(\'Sorry! we are not ready to handle this order\',\'' + order.sid + '\')">Sorry! we are not ready to handle this order</div>';
            OrderHtml += '</div>';
            OrderHtml += '</td></tr>';
        }
        OrderHtml += '<tr>';
        OrderHtml += '<td colspan="2">';
        OrderHtml += '<table>';
        OrderHtml += '<tr class="table-bg"><th class="text-left" style="padding-left: 10px;"><strong><?php echo $this->lang->line('item') ?></strong></th><th class="text-right"><strong style="color: #eee;padding-right:10px;"><?php echo $this->lang->line('price') ?></strong></th><th class="text-center"><strong style="color: #eee"><?php echo $this->lang->line('qty') ?></strong></th><th class="text-right"><strong style="padding-right: 10px;">Total</strong></th></tr>';
        for (var i in cart) {
            OrderHtml += '<tr>';
            OrderHtml += '<td>';
            OrderHtml += $.trim(cart[i].selectionTitle) ? cart[i].menuTitle + '-' + cart[i].selectionTitle : cart[i].menuTitle;
            if (cart[i].setItem.length > 0) {
                OrderHtml += '<br/>';
                cart[i].setItem.forEach(function (aSetItem) {
                    OrderHtml += '&nbsp;&nbsp;<span class="icon icon-right-open-mini" style="color:#000;">&nbsp;' + aSetItem.title + '</span><br/>';
                });
            }
            if (cart[i].Topping.length > 0) {
                OrderHtml += '<br/>';
                cart[i].Topping.forEach(function (aTop) {
                    OrderHtml += '&nbsp;&nbsp;<span class="icon icon-right-open-mini" style="color:#000;">&nbsp;' + aTop.qty + '&nbsp;' + aTop.title + '&nbsp;&nbsp;' + toCurrency(aTop.total) + '</span><br/>';
                });
            }
            OrderHtml += '</td>';
            OrderHtml += '<td class="text-right" style="padding-right:10px;">' + toCurrency(cart[i].price) + '</td>';
            OrderHtml += '<td class="text-center">' + cart[i].qty + '</td>';
            OrderHtml += '<td class="text-right" style="padding-right: 10px;">' + toCurrency(cart[i].total) + '</td>';
            OrderHtml += '</tr>';
        }
        OrderHtml += '<tr class="table-bg"> <th colspan="3" class="text-right" style="width: 90%;"><strong><?php echo $this->lang->line('subtotal') ?></strong>&nbsp;</th><th class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;<strong>' + toCurrency(order.subTotal) + '</strong></th></tr>';
        if (Number(order.tax > 0)) {
            OrderHtml += '<tr><td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('tax') ?>&nbsp;</td><td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;' + toCurrency(order.tax) + '</td></tr>';
        } else {
            if (order.taxIsIncluded === 'yes') {
                OrderHtml += '<tr><td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('tax') ?>&nbsp;</td><td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;Included</td></tr>';
            }
        }
        if (Number(order.deliveryCharge) > 0) {
            OrderHtml += '<tr><td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('delivery_charge') ?>&nbsp;</td><td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;' + toCurrency(order.deliveryCharge) + '</td></tr>';
        }
        if (Number(order.serviceCharge) > 0) {
            OrderHtml += '<tr><td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('service_charge') ?>&nbsp;</td><td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;' + toCurrency(order.serviceCharge) + '</td></tr>';
        }
        if (Number(order.ccFee) > 0) {
            OrderHtml += '<tr><td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('ccFee') ?>&nbsp;</td><td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;' + toCurrency(order.ccFee) + '</td></tr>';
        }
        if (Number(order.cbFee) > 0) {
            OrderHtml += '<tr><td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('cbFee') ?>&nbsp;</td><td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;' + toCurrency(order.cbFee) + '</td></tr>';
        }
        if (Number(order.discount) > 0) {
            OrderHtml += '<tr><td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('discount') ?>&nbsp;</td><td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;' + toCurrency(order.discount) + '</td></tr>';
        }
        if (Number(order.promo) > 0) {
            OrderHtml += '<tr><td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('promo') ?>&nbsp;</td><td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;' + toCurrency(order.promo) + '</td></tr>';
        }
        if (Number(order.multiDiscount) > 0) {
            OrderHtml += '<tr><td colspan="3" class="text-right" style="width: 90%"><?php echo $this->lang->line('multi_discount') ?>&nbsp;</td><td class="text-right" style="width: 10%; padding-right: 10px;">&nbsp;' + toCurrency(order.multiDiscount) + '</td></tr>';
        }
        OrderHtml += '<tr class="table-bg"><th colspan="3" class="text-right" style="width: 90%;"><strong><?php echo $this->lang->line('total') ?></strong>&nbsp;</th><th class="text-right" style="width: 10%; padding-right: 10px; color: #eee;">&nbsp;<strong>' + toCurrency(order.grandTotal) + '</strong></th></tr>';
        OrderHtml += '</table>';
        OrderHtml += '</td>';
        OrderHtml += '</tr>';
        OrderHtml += '</table>';
        return OrderHtml;
    }
    function showOnlineOrderAcceptTimeSlot(id) {
        $('.online-order-reject-msg').hide();
        $('#' + id).toggle();
    }
    function showOnlineOrderRejectMessageSlot(id) {
        $('.online-order-accept-time-slot').hide();
        $('#' + id).toggle();
    }
    function acceptOnlineOrder(extraTime, sid) {
        $.ajax({
            url: '<?php echo site_url('api/acceptOnlineOrder') ?>',
            type: 'POST',
            dataType: 'json',
            data: {extraTime: extraTime, sid: sid},
            success: function (response) {
                zamanOnlineOrderPageControllerPopup();
            }
        });
    }
    function rejectOnlineOrderMsg(rejectMsg, sid) {
        $.ajax({
            url: '<?php echo site_url('api/rejectOnlineOrder') ?>',
            type: 'POST',
            dataType: 'json',
            data: {rejectMsg: rejectMsg, sid: sid},
            success: function (response) {
                zamanOnlineOrderPageControllerPopup();
            }
        });
    }
    function resendOnlineOrder(sid) {
        $.ajax({
            url: '<?php echo site_url('api/resendOnlineOrder') ?>',
            type: 'POST',
            dataType: 'json',
            data: {sid: sid},
            success: function (response) {
                if (response.status) {
                    warning('Resend', 'Resend successfully', 'Close');
                }
            }
        });
    }
    function printBillOnlineOrder(sid) {
        $.ajax({
            url: '<?php echo site_url('api/printBillOnlineOrder') ?>',
            type: 'POST',
            dataType: 'json',
            data: {sid: sid},
            success: function (response) {
                if (response.status) {
                    zamanOnlineOrderPageControllerPopup();
                }
            }
        });
    }
    function paymentOnlineOrder(sid, orderId, grandTotal) {
        zamanEposPopupcloser();
        sleep(1000).then(function () {
            remoteOrderPaymentProcessor(sid, orderId, grandTotal);
        });
    }
    function closeOnlineOrder(sid) {
        $.confirm({
            title: 'Warning',
            message: 'Would you like print customer bill copy?',
            buttons: {
                'Yes': {
                    'class': '',
                    'action': function () {
                        performCloseOperationForOnlineOrder(sid, 'yes');
                        $.confirm.hide();
                    }
                },
                'No': {
                    'class': '',
                    'action': function () {
                        performCloseOperationForOnlineOrder(sid, 'no');
                        $.confirm.hide();
                    }
                },
                'Cancel': {
                    'class': '',
                    'action': function () {
                    }
                }
            }
        });
    }
    function performCloseOperationForOnlineOrder(sid, action) {
        $.ajax({
            url: '<?php echo site_url('api/closeOnlineOrder') ?>',
            type: 'POST',
            dataType: 'json',
            data: {sid: sid, action: action},
            success: function (response) {
                if (response.status) {
                    zamanOnlineOrderPageControllerPopup();
                }
            }
        });
    }

</script>






