<div class="tab-group" style="padding-right: 5px;">
    <div  class="tab-item zaman-epos-nav tab-sort-menucategory active" id="tab-sort-menucategory-all" style="padding: 13px 5px" onclick="setCategoryType('all')"><?php echo $this->lang->line('all') ?></div>
    <div  class="tab-item zaman-epos-nav tab-sort-menucategory" id="tab-sort-menucategory-kitchen"style="padding: 13px 5px;" onclick="setCategoryType('kitchen')"><?php echo $this->lang->line('kitchen') ?></div>
    <!--<div  class="tab-item zaman-epos-nav tab-sort-menucategory" id="tab-sort-menucategory-bar"style="padding: 13px 5px;" onclick="setCategoryType('bar')"><?php echo $this->lang->line('bar') ?></div>-->
    <div  class="tab-item zaman-epos-nav tab-sort-menucategory" id="tab-sort-menucategory-drinks"style="padding: 13px 5px;" onclick="setCategoryType('drinks')"><?php echo $this->lang->line('drinks') ?></div>
    <!--<div  class="tab-item zaman-epos-nav tab-sort-menucategory" id="tab-sort-menucategory-bakery"style="padding: 13px 5px;" onclick="setCategoryType('bakery')"><?php echo $this->lang->line('bakery') ?></div>-->
</div>
<div class="padded-bottom" id="eposCategoryList"></div>
<div class="menu-paginations" style="bottom: 0px; position: fixed; width: 25.2%">
    <div class="previous" onclick="categoryPagination('prev')">
        <div class="menu-button-inner" style="border-radius: 0px;"><span class="icon icon-left-open-big"></span></div>
    </div>
    <div class="page">
        <div class="menu-button-inner"><span id="categoryCurrentPage"></span>&nbsp;&frasl;&nbsp;<span id="categoryTotalPage"></span></div>
    </div>
    <div class="next" onclick="categoryPagination('next')">
        <div class="menu-button-inner"style="border-radius: 0px;"><span class="icon icon-right-open-big"></span></div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        checkDataStorageIfLoadIsRequired();
        processCategoryPagination($('#CategoryOptionType').val());
        zamanEposMenuCategory();
    });
    function setCategoryType(type) {
        $('#CategoryOptionType').val(type);
        processCategoryPagination(type);
        zamanEposMenuCategory();
        playBeepSound();
        $('.tab-sort-menucategory').removeClass('active');
        $('#tab-sort-menucategory-' + type).addClass('active');
    }
    function checkDataStorageIfLoadIsRequired() {
        Dexie.exists('zamanEposDb').then(function (exists) {
            if (!exists) {
                $('#forgeLocalDataFromRemote').show();
                if ($('#updateUserDataFromRemoteSource').length > 0) {
                    $('#updateUserDataFromRemoteSource').hide();
                }
            } else {
                zamanEposDb.transaction('rw', [zamanEposDb.epos_branch, zamanEposDb.epos_menucategory, zamanEposDb.epos_menu, zamanEposDb.epos_menuselection, zamanEposDb.epos_order], function () {
                    var userData = zamanEposCart.getUserData();
                    zamanEposDb.epos_branch.get({'id': userData.branch}).then(function (branch) {
                        if (typeof (branch) !== 'undefined') {
                            if (jQuery.isEmptyObject(branch)) {
                                $('#forgeLocalDataFromRemote').show();
                                if ($('#updateUserDataFromRemoteSource').length > 0) {
                                    $('#updateUserDataFromRemoteSource').hide();
                                }
                            } else {
                                $('#forgeLocalDataFromRemote').hide();
                                if ($('#updateUserDataFromRemoteSource').length > 0) {
                                    $('#updateUserDataFromRemoteSource').show();
                                }
                            }
                        } else {
                            $('#forgeLocalDataFromRemote').show();
                            if ($('#updateUserDataFromRemoteSource').length > 0) {
                                $('#updateUserDataFromRemoteSource').hide();
                            }
                        }
                    });
                });
            }
        });

    }
    function processCategoryPagination(type) {
        zamanEposDb.transaction('rw', [zamanEposDb.epos_menucategory, zamanEposDb.epos_branch, zamanEposDb.epos_order], function () {
            if (type === 'all') {
                zamanEposDb.epos_menucategory.where({'status': '3'}).count(function (count) {
                    var userData = zamanEposCart.getUserData();
                    zamanEposDb.epos_branch.get({'id': userData.branch}).then(function (branch) {
                        if (!jQuery.isEmptyObject(branch) && count > 0) {
                            var pages = Math.ceil(Number(count) / Number(branch.pagination_category));
                            $('#categoryCurrentPage').text('1');
                            $('#categoryTotalPage').text(pages);
                        }
                    });
                });
            } else {
                zamanEposDb.epos_menucategory.where({'status': '3', 'type': type}).count(function (count) {
                    var userData = zamanEposCart.getUserData();
                    zamanEposDb.epos_branch.get({'id': userData.branch}).then(function (branch) {
                        if (!jQuery.isEmptyObject(branch) && count > 0) {
                            var pages = Math.ceil(Number(count) / Number(branch.pagination_category));
                            $('#categoryCurrentPage').text('1');
                            $('#categoryTotalPage').text(pages);
                        }
                    });
                });
            }
        });
    }
    function zamanEposMenuCategory() {
        zamanEposDb.transaction('rw', [zamanEposDb.epos_branch, zamanEposDb.epos_menucategory, zamanEposDb.epos_order], function () {
            var userData = zamanEposCart.getUserData();
            zamanEposDb.epos_branch.get({'id': userData.branch}).then(function (branch) {
                if (typeof (branch) !== 'undefined') {
                    var CategoryOptionType = $('#CategoryOptionType').val();
                    var limit = Number(branch.pagination_category);
                    var offset = limit * Number($('#categoryPaginationBtnValue').val());
                    zamanEposDb.epos_menucategory.orderBy('lid').filter(function (item) {
                        if ($.trim(CategoryOptionType) === $.trim('all')) {
                            return item.status === '3' && item.inline === '3' && item.branch === branch.id;
                        } else {
                            return item.status === '3' && item.inline === '3' && item.branch === branch.id && item.type === CategoryOptionType;
                        }
                    }).distinct().offset(offset).limit(limit).raw().toArray().then(function (items) {
                        if (items[0]) {
                            $('.breadcurmb-category').text(items[0].title);
                            var htm = '';
                            items.forEach(function (item) {
                                htm += '<div class="menu-button"><div class="menu-category menu-button-inner text-capitalize" id="category-' + item.id + '" style="margin-top:3px;" onclick="zamanEposMenu(\'' + item.id + '\')">' + item.title + '</div></div>';
                            });
                            $('#eposCategoryList').html(htm);
                            $('#categoryCurrentPage').text(Number($('#categoryPaginationBtnValue').val()) + 1);
                        } else {
                            $('#eposCategoryList').html('');
                            $('#selectionPaginationBtnValue').val('0');
                            $('#menuPaginationBtnValue').val('0');
                            $('#categoryPaginationBtnValue').val('0');
                            zamanEposMenuCategory();
                        }
                    });
                }
            });
        });
    }
    function categoryPagination(btn) {
        var currentValue = Number($('#categoryPaginationBtnValue').val());
        if ($.trim(btn) === $.trim('next')) {
            if (currentValue >= 0) {
                currentValue++;
                playBeepSound();
            }
        } else {
            if (currentValue >= 1) {
                currentValue--;
                playBeepSound();
            }
        }
        $('#categoryPaginationBtnValue').val(currentValue);
        zamanEposMenuCategory();
    }
</script>