<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="caption">
                <?php $this->load->view('employee/nav') ?>
            </div>
            <table class="text-center report-table">
                <tr style="background: #228ba2;">
                    <th colspan="3" style="border: none;">
                        <div class="block-inner"><input class="form-control" id="employeeId" placeholder="<?php echo $this->lang->line('id') ?>" value="<?php echo isset($filterData) && trim($filterData['id']) ? $filterData['id'] : '' ?>"/></div>
                    </th>
                    <th colspan="3"  style="border: none;">
                        <div class="block-inner">
                            <select name="dept" id="employeeDept" class="form-control" onchange="getDepartmentManager(this.value)" style="padding: 6.5px 0px">
                                <option value="0"><?php echo $this->lang->line('select') . ' ' . $this->lang->line('department') ?></option>
                                <?php if (!empty($departments)): ?>
                                    <?php foreach ($departments as $aDept): ?>
                                        <option value="<?php echo $aDept->id ?>" <?php (isset($filterData) && $aDept->id === $filterData['dept']) ? print 'selected="selected"' : '' ?>><?php echo $aDept->title ?></option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </th>
                    <th colspan="<?php $this->session->userdata('group') <= '3' ? print 3 : print 2 ?>"  style="border: none;">
                        <div class="block-inner">
                            <select name="manager" class="form-control" id="employeeManager" style="padding: 6.5px 0px">
                                <option><?php echo $this->lang->line('select') . ' ' . $this->lang->line('manager') ?></option>
                                <?php if (!empty($managers)): ?>
                                    <?php foreach ($managers as $aDeptManager): ?>
                                        <option value="<?php echo $aDeptManager->id ?>" <?php (isset($filterData) && $aDeptManager->id === $filterData['manager']) ? print 'selected="selected"' : '' ?>><?php echo $aDeptManager->title ?></option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </th>
                    <th colspan="2"  style="border: none;"><span class="btn btn-large btn-primary" style="width: 100%" onclick="filterEmployee()"><?php echo $this->lang->line('filter')?></span></th>
                </tr>
                <tr class="table-bg">
                    <th><?php echo $this->lang->line('serial') ?></th>
                    <th><?php echo $this->lang->line('first_name') ?></th>
                    <th><?php echo $this->lang->line('last_name') ?></th>
                    <th><?php echo $this->lang->line('email') ?></th>
                    <th><?php echo $this->lang->line('mobile') ?></th>
                    <th><?php echo $this->lang->line('post') ?></th>
                    <th><?php echo $this->lang->line('department') ?></th>
                    <th><?php echo $this->lang->line('manager') ?></th>
                    <?php if ($this->session->userdata('group') <= 3): ?>
                        <th><?php echo $this->lang->line('branch') ?></th>
                    <?php endif; ?>
                    <th><?php echo $this->lang->line('status') ?></th>
                    <th><?php echo $this->lang->line('action') ?></th>
                </tr>
                <?php if (!empty($employees)): ?>
                    <?php $index = 1; ?>
                    <?php foreach ($employees as $anEmployee): ?>
                        <tr>
                            <td><?php echo $index ?></td>
                            <td><?php echo $anEmployee->first_name ?></td>
                            <td><?php echo $anEmployee->last_name ?></td>
                            <td><?php echo $anEmployee->email ?></td>
                            <td><?php echo $anEmployee->mobile ?></td>
                            <td><?php echo $anEmployee->post ?></td>
                            <td><?php echo get_title('employeedept', array('id' => $anEmployee->dept)) ?></td>
                            <td><?php echo get_title('employeemanager', array('id' => $anEmployee->manager)) ?></td>
                            <?php if ($this->session->userdata('group') <= 3): ?>
                                <td><?php echo get_title('branch', array('id' => $anEmployee->branch)) ?></td>
                            <?php endif; ?>
                            <td><?php echo $anEmployee->status === '3' ? $this->lang->line('active') : $this->lang->line('inactive') ?></td>
                            <td><span class="icon icon-eye" onclick="zamanEposNavigator('', '<?php echo site_url('employee/view/' . $anEmployee->id) ?>','')"></span> &nbsp; &nbsp;<span class="icon icon-pencil" onclick="zamanEposNavigator('', '<?php echo site_url('employee/add/' . $anEmployee->id) ?>','')"></span></td>
                        </tr>
                        <?php $index++; ?>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="<?php $this->session->userdata('group') <= '3' ? print 11 : print 10 ?>"><?php echo sprintf($this->lang->line('not_found'), $this->lang->line('employee')) ?></td></tr>
                <?php endif; ?>
            </table>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<script>
    function filterEmployee() {
        var employeeId = $.trim($('#employeeId').val()) ? $('#employeeId').val() : 0;
        var employeeDept = Number($.trim($('#employeeDept').val())) > 0 ? $('#employeeDept').val() : 0;
        var employeeManager = Number($.trim($('#employeeManager').val())) > 0 ? $('#employeeManager').val() : 0;
        var employeeBranch = Number($.trim($('#employeeBranch').val())) > 0 ? $('#employeeBranch').val() : 0;
        zamanEposNavigator('Employee List', '<?php echo site_url('employee/index/') ?>' + employeeId + '/' + employeeDept + '/' + employeeManager + '/' + employeeBranch,'');
    }

    function getDepartmentManager(department) {
        var branch = $('#employeeBranch').val();
        if (Number(department) > 0) {
            $.ajax({
                url: '<?php echo site_url('employee/getDepartmentManager') ?>',
                type: 'post',
                dataType: 'json',
                data: {
                    dept: department,
                    branch: Number(branch) ? Number(branch) : 0
                },
                beforeSend: function (xhr) {
                    $('.page-loader').show();
                },
                success: function (response) {
                    $('.page-loader').hide();
                    if (response.status) {
                        var items = response.managers;
                        var html = '<option value="0">Select Manager</option>';
                        items.forEach(function (item) {
                            html += '<option value="' + item.id + '">' + item.title + '</option>';
                        });
                        $('#employeeManager').html(html);
                    } else {
                        $('#employeeManager').html('');
                    }
                }
            });
        } else {
            $('#employeeManager').html('');
        }
    }
</script>
