<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Printer_Model extends MY_Model {

    function __construct() {
        parent::__construct();
        $this->load->helper('epos');
    }

    public function printingdata($branch, $team) {
        $success = false;
        $branchInfo = $this->get_single('branch', array('id' => $branch), array('title', 'address_street', 'address_postcode', 'address_city', 'general_phone', 'general_mobile', 'general_email', 'receipt_law', 'locale_currencyicon', 'default_tinnumber', 'kitchenPrinterIp', 'default_tax'))->row();
        $resturantInfo = array(
            'name' => $this->config->item('general_name'),
            'branch' => $branchInfo->title,
            'logo' => EPOS_UPLOAD_PATH . $this->config->item('general_logo'),
            'street' => $branchInfo->address_street,
            'address' => $branchInfo->address_city . ', ' . $branchInfo->address_postcode,
            'city' => $branchInfo->address_city,
            'postcode' => $branchInfo->address_postcode,
            'phone' => $branchInfo->general_phone,
            'mobile' => $branchInfo->general_mobile,
            'email' => $branchInfo->general_email,
            'currency' => $this->config->item('locale_currencyicon'),
            'receiptText' => $branchInfo->receipt_law,
            'tin' => $branchInfo->default_tinnumber,
            'date' => date('d/m/Y'),
            'time' => date('h:i a'),
            'kitchenPrinterIp' => $branchInfo->kitchenPrinterIp,
        );
        $this->db->select('P.sid as printId,P.lid as printLocalId, P.team,P.branch,P.type as printType,P.sent as sentType, P.isPrinted,P.additionals, O.group,O.type as OrderType,O.status as orderStatus,O.orderInfo,O.cart,O.subTotal,O.tax,O.taxIsIncluded,O.taxIncludedPercent,O.deliveryCharge,O.serviceCharge, O.ccFee, O.cbFee, O.discount,O.promo,O.multiDiscount,O.grandTotal,O.payment,O.isPaid,O.changeAmount,O.changeAsTips');
        $this->db->from('printing P');
        $this->db->join('order O', 'P.sid=O.sid', 'inner');
        $this->db->where('P.isPrinted', 2);
        $this->db->where('P.branch', $branch);
        $this->db->where('P.team', $team);
        $this->db->group_by('P.sid');
        $this->db->order_by('P.created_at', 'ASC');
        $this->db->limit(1);
        $data = $this->db->get()->result();
        $PrintingData = $data;
        $operationType = null;
        if (!empty($data)) {
            $operationType = 'PrintOrder';
            foreach ($data as $key => $anOrder) {
                $PrintingData[$key]->orderInfo = unserialize($anOrder->orderInfo);
                $PrintingData[$key]->cart = (array) unserialize($anOrder->cart);
                $PrintingData[$key]->payment = unserialize($anOrder->payment);
                $success = $this->db->update('printing', array('isPrinted' => 3), array('sid' => $anOrder->printId));
            }
        } else {
            $ktcmsg = $this->db->where('sent', 'no')->order_by('created_at', 'ASC')->limit(1)->get('ktchmsg')->row();
            if (!empty($ktcmsg)) {
                $theOrder = $this->get_single('order', array('sid' => $ktcmsg->sid), array('orderInfo', 'type'))->row();
                if (!empty($theOrder)) {
                    $operationType = 'printKtcMsg';
                    $PrintingData['msg'] = $ktcmsg;
                    $PrintingData['orderType'] = $theOrder->type;
                    $PrintingData['orderInfo'] = unserialize($theOrder->orderInfo);
                    $PrintingData['date'] = date('d/m/Y');
                    $PrintingData['time'] = date('h:i a');
                    $success = $this->db->update('ktchmsg', array('sent' => 'yes'), array('sid' => $ktcmsg->sid));
                }
            }
            if (empty($PrintingData)) {
                $transaction = $this->get_single('transactionsummary', array('branch' => $branch, 'team' => $team, 'isPrinted' => 'no'))->row();
                if (!empty($transaction)) {
                    $operationType = 'transactionSummary';
                    $PrintingData = unserialize($transaction->data);
                    $success = $this->db->update('transactionsummary', array('isPrinted' => 'yes'), array('id' => $transaction->id));
                } else {
                    $PrintingData = array();
                }
            }
            if (empty($PrintingData)) {
                $voucher = $this->get_single('voucher', array('branch' => $branch, 'team' => $team, 'isPrinted' => 'no'))->row();
                if (!empty($voucher)) {
                    $operationType = 'voucherPrint';
                    $voucher->start = date('d/m/Y', strtotime($voucher->start));
                    $voucher->end = date('d/m/Y', strtotime($voucher->end));
                    $voucher->printDateTime = date('d/m/Y H:i');
                    $PrintingData = $voucher;
                    $success = $this->db->update('voucher', array('isPrinted' => 'yes'), array('id' => $voucher->id));
                } else {
                    $PrintingData = array();
                }
            }
            if (empty($PrintingData)) {
                $theCommand = $this->get_single('command', array('branch' => $branch, 'team' => $team, 'isExecuted' => 'no'))->row();
                if (!empty($theCommand)) {
                    $PrintingData['command'] = $theCommand->command;
                    $operationType = 'executeCommand';
                    $success = $this->db->update('command', array('isExecuted' => 'yes'), array('id' => $theCommand->id));
                } else {
                    $PrintingData = array();
                }
            }
        }
        return array('success' => $success, 'operationType' => $operationType, 'orders' => $PrintingData, 'restaurant' => $resturantInfo);
    }

}
