<?php

defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';

use Restserver\Libraries\REST_Controller;

class Phone extends REST_Controller {

    function __construct($config = 'rest') {
        parent::__construct($config);
    }

    public function index_get() {
        $branch = $this->get('branch');
        $team = $this->get('team');
        $phone = $this->get('phone');
        $user = !empty($this->get('user')) ? $this->get('user') : '0';
        $status = false;
        if ((int) trim($branch) > 0 && (int) trim($team) > 0 && $phone) {
            $status = $status = $this->db->insert('callerphone', array('phone' => $phone, 'branch' => $branch, 'team' => $team, 'user' => $user, 'received' => 'no', 'current' => 'no'));
        }
        $this->response(array('status' => $status), REST_Controller::HTTP_OK);
    }

    public function index_post() {
        $branch = $this->post('branch');
        $team = $this->post('team');
        $phone = $this->post('phone');
        $user = !empty($this->post('user')) ? $this->post('user') : '0';
        $status = false;
        if ((int) trim($branch) > 0 && (int) trim($team) > 0 && $phone) {
            $status = $status = $this->db->insert('callerphone', array('phone' => $phone, 'branch' => $branch, 'team' => $team, 'user' => $user, 'received' => 'no', 'current' => 'no'));
        }
        $this->response(array('status' => $status), REST_Controller::HTTP_OK);
    }

}
