<?php

defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';

use Restserver\Libraries\REST_Controller;

class App extends REST_Controller {

    function __construct($config = 'rest') {
        parent::__construct($config);
        $this->load->model('App_Model');
    }

    public function index_post() {
        $branch = $this->post('branch');
        $orders = $this->App_Model->get_list('order', array('source' => 'online', 'status_online' => '2', 'branch' => $branch), null, 1, 0, 'sid', 'ASC')->result();
        $resturantInfo = array();
        if (!empty($orders)) {
            foreach ($orders as $key => $order) {
                $orders[$key]->orderInfo = unserialize($order->orderInfo);
                $orders[$key]->cart = unserialize($order->cart);
                if (trim($order->payment) && $order->isPaid == 3) {
                    $orders[$key]->payment = unserialize($order->payment);
                }
                if (trim($order->onlinePaymentDetails) && $order->isPaid == 3) {
                    $orders[$key]->onlinePaymentDetails = unserialize($order->onlinePaymentDetails);
                }
            }
            $branchInfo = $this->App_Model->get_single('branch', array('id' => $branch), array('title', 'address_street', 'address_postcode', 'address_city', 'general_phone', 'general_mobile', 'general_email', 'receipt_law', 'locale_currencyicon', 'default_tinnumber', 'kitchenPrinterIp', 'default_tax'))->row();
            $resturantInfo = array(
                'name' => $this->config->item('general_name'),
                'branch' => $branchInfo->title,
                'logo' => EPOS_UPLOAD_PATH . $this->config->item('general_logo'),
                'street' => $branchInfo->address_street,
                'city' => $branchInfo->address_city,
                'postcode' => $branchInfo->address_postcode,
                'phone' => $branchInfo->general_phone,
                'mobile' => $branchInfo->general_mobile,
                'email' => $branchInfo->general_email,
                'receiptText' => $branchInfo->receipt_law,
                'tin' => $branchInfo->default_tinnumber,
                'date' => date('d/m/Y'),
                'time' => date('h:i a'),
            );
        }
        $this->response(array('status' => !empty($orders) ? true : false, 'restaurantInfo' => $resturantInfo, 'data' => $orders), REST_Controller::HTTP_OK);
    }

    public function accept_post() {
        $extraTime = $this->post('extraTime');
        $sid = $this->post('sid');
        $order = $this->App_Model->get_single('order', array('sid' => $sid))->row();
        $orderInfo = unserialize($order->orderInfo);
        if ($order->type === 'collection') {
            $collectionTimeObj = new DateTime($orderInfo['collectionTime']);
            $collectionTimeObj->add(new DateInterval('PT' . $extraTime . 'M'));
            $nowTime = $collectionTimeObj->format('h:i a');
            $orderInfo['collectionTime'] = $nowTime;
        } else {
            $deliveryTimeObj = new DateTime($orderInfo['deliveryTime']);
            $deliveryTimeObj->add(new DateInterval('PT' . $extraTime . 'M'));
            $nowTime = $deliveryTimeObj->format('h:i a');
            $orderInfo['deliveryTime'] = $nowTime;
        }
        $s1 = $this->App_Model->save(array('orderInfo' => serialize($orderInfo), 'status' => 2, 'status_online' => 3), $sid);
        $this->response(array('status' => $s1 ? true : false), REST_Controller::HTTP_OK);
    }

    public function reject_post() {
        $rejectMsg = $this->post('rejectMsg');
        $sid = $this->post('sid');
        $s1 = $this->App_Model->save(array('rejectMsg' => $rejectMsg, 'status_online' => 4), $sid);
        $this->response(array('status' => $s1 ? true : false), REST_Controller::HTTP_OK);
    }

}
