var API_URL = baseUrl;
var zamanEposDb = new Dexie("zamanEposDb");
function initializeZamanDbTableStructure() {
    zamanEposDb.version(1).stores({
        epos_branch: 'id,title,status,address_street,address_country,address_city,address_region,address_area,address_postcode,general_phone,general_mobile,general_email,receipt_law,default_time_table,default_time_bar,default_time_waiting,default_time_collection,default_time_delivery,default_tinnumber,default_tax,default_discount,default_sercharge,default_ccFee',
        epos_configuration: 'key,value',
        epos_menucategory: '++lid,id,branch, title,code,unit,position,content,type,image,tax,discount,status,online,inline,updated_at,updated_by,created_at,created_by',
        epos_menu: '++lid,id,branch,category,title,code,base_price,in_price,out_price,content,image,tax,tax_option,discount,discount_option,deal_type,has_topping,has_modifier,ctop,cmod, position,status,online,inline,printat,breakfast,launch,dinner,updated_at,updated_by,created_at,created_by',
        epos_menuselection: '++lid,id,branch,category,menu,title,code,base_price,in_price,out_price,content,image,tax,tax_option,discount,discount_option,deal_type,has_topping,has_modifier,ctop,cmod,position,status,online,inline,printat,breakfast,launch,dinner,updated_at,updated_by,created_at,created_by',
        epos_menuset: '++lid,id,branch,title,min,max,rel,category,menu,selection,status,updated_at,updated_by,created_at,created_by',
        epos_menusetitem: '++lid,id,branch,set,category,menu,selection,qty,status,updated_at,updated_by,created_at,created_by',
        epos_menuattrcategory: '++lid,id,branch,title,status,category,menu,selection,set,rel,rel_with,min,max,free,updated_at,updated_by,created_at,created_by',
        epos_menuattr: '++lid,id,branch,title,price,qty,is_default,menuttrcategory,status,updated_at,updated_by,created_at,created_by',
        epos_modifiercategory: '++lid,id,branch,title,status,category,menu,selection,set,updated_at,updated_by,created_at,created_by',
        epos_modifiermenu: '++lid,id,branch,title,status,modcategory,updated_at,updated_by,created_at,created_by',
        epos_nattrcategory: '++lid,id,branch,title,status,position,updated_at,updated_by,created_at,created_by',
        epos_nattr: '++lid,id,branch,title,status,position,nattrcategory,price,updated_at,updated_by,created_at,created_by',
        epos_modifier: '++lid,id,branch,title,status,position,updated_at,updated_by,created_at,created_by',
        epos_menufixeddeal: '++lid,id,branch,category,menu,selection,deal,qty,deal_category,deal_menu,deal_selection,status,updated_at,updated_by,created_at,created_by',
        epos_discountitem: '++lid,id,title,order,qty,status,type,item',
        epos_order: '++orderId,branch,cid,dateInfo,owner,manager,status,source,type,orderInfo,cart,firstTakenAt,lastTakenAt,subTotal,tax,taxIsIncluded,taxIncludedPercent,deliveryCharge,serviceCharge,ccFee,cbFee, discount,promo,multiDiscount,grandTotal,payment,isPaid,changeAmount,changeAsTips,sid',
        epos_table: '++lid,branch,tableNumber,status,guestQty',
        epos_lcountry: '++lid,id,branch,title,position,status',
        epos_lregion: '++lid,id,branch,title,country,position,status',
        epos_lcity: '++lid,id,branch,title,region,position,status',
        epos_larea: '++lid,id,branch,title,city,position,status',
        epos_lpostcode: '++lid,id,city,area,title',
        epos_ldooraddress: '++lid,[postal_code+street_number],id,street_number,route,postal_town,administrative_area_level_2,administrative_area_level_1,country,postal_code',
        epos_customer: '++lid,id,branch,name,phone,email',
        epos_customer_address: '++lid, lcid,cid,sector,country,region,city,area,postcode,street,building,floor,apartment,deliveryTime',
        epos_discountplan: '++lid,id,branch,title,min_order,discount,onfunc,onday,onitem,onapp,start_date,end_date,start_time,end_time,status,created_at,created_by,updated_at,updated_by',
        epos_discountmulti: '++lid,id,branch,title,category,menu,selection,rel,min_order,buy,get,onday,onapp,start_date,end_date,start_time,end_time,status,created_at,created_by,updated_at,updated_by',
        epos_deliveryplan: '++lid,id,branch,title,country,region,city,area,street,postcode,max_distance,free_distance,km_rate,min_order,waiting_time,delivery_charge, status,created_at,created_by,updated_at,updated_by',
        epos_paymentoption: 'id,title,status',
        epos_voucher: 'id,branch,code,amount,balance,status,start,end',
        epos_menuconvert: 'id,data,maskPrice,item,qty,status,title,branch,team'
    });
}
initializeZamanDbTableStructure();
zamanEposDb.open();

function zamanDbEposConfiguration() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_configuration.clear();
        return zamanEposDb.epos_configuration.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_configuration', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_configuration, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('System configuration data');
                            data.forEach(function (item) {
                                zamanEposDb.epos_configuration.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('System configuration data');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposBranch() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_branch.clear();
        return zamanEposDb.epos_branch.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_branch', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_branch, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Branch Information');
                            data.forEach(function (item) {
                                zamanEposDb.epos_branch.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Branch Information');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposMenuCategory() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_menucategory.clear();
        return zamanEposDb.epos_menucategory.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_menucategory', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_menucategory, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Adding category');
                            data.forEach(function (item) {
                                zamanEposDb.epos_menucategory.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Adding category');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposMenu() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_menu.clear();
        return zamanEposDb.epos_menu.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_menu', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_menu, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Adding menus');
                            data.forEach(function (item) {
                                zamanEposDb.epos_menu.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Adding menus');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposMenuSelection() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_menuselection.clear();
        return zamanEposDb.epos_menuselection.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_menuselection', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_menuselection, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Adding menu selections');
                            data.forEach(function (item) {
                                zamanEposDb.epos_menuselection.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Adding menu selections');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposMenuSet() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_menuset.clear();
        return zamanEposDb.epos_menuset.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_menuset', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_menuset, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Adding menu set data');
                            data.forEach(function (item) {
                                zamanEposDb.epos_menuset.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Adding menu set data');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposMenuSetItem() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_menusetitem.clear();
        return zamanEposDb.epos_menusetitem.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_menusetitem', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_menusetitem, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Adding set items');
                            data.forEach(function (item) {
                                zamanEposDb.epos_menusetitem.add(item);

                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Adding set items');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposMenuAttrCategory() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_menuattrcategory.clear();
        return zamanEposDb.epos_menuattrcategory.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_menuattrcategory', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_menuattrcategory, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Populating menu topping category');
                            data.forEach(function (item) {
                                zamanEposDb.epos_menuattrcategory.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Populating menu topping category');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposMenuAttr() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_menuattr.clear();
        return zamanEposDb.epos_menuattr.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_menuattr', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_menuattr, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Adding menu topping');
                            data.forEach(function (item) {
                                zamanEposDb.epos_menuattr.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Adding menu topping');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposModifierCategory() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_modifiercategory.clear();
        return zamanEposDb.epos_modifiercategory.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_modifiercategory', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_modifiercategory, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Populating modifier category');
                            data.forEach(function (item) {
                                zamanEposDb.epos_modifiercategory.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Populating modifier category');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposModifierMenu() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_modifiermenu.clear();
        return zamanEposDb.epos_modifiermenu.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_modifiermenu', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_modifiermenu, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Populating menu attached modifier');
                            data.forEach(function (item) {
                                zamanEposDb.epos_modifiermenu.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Populating menu attached modifier');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposNattrCategory() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_nattrcategory.clear();
        return zamanEposDb.epos_nattrcategory.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_nattrcategory', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_nattrcategory, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Adding global topping category');
                            data.forEach(function (item) {
                                zamanEposDb.epos_nattrcategory.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Adding global topping category');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposNattr() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_nattr.clear();
        return zamanEposDb.epos_nattr.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_nattr', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_nattr, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Adding global topping');
                            data.forEach(function (item) {
                                zamanEposDb.epos_nattr.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Adding global topping');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposModifier() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_modifier.clear();
        return zamanEposDb.epos_modifier.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_modifier', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_modifier, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Adding global modifier');
                            data.forEach(function (item) {
                                zamanEposDb.epos_modifier.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Adding global modifier');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposFixedDealItems() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_menufixeddeal.clear();
        return zamanEposDb.epos_menufixeddeal.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_menufixeddeal', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_menufixeddeal, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            data.forEach(function (item) {
                                $('#systemUpdateInformationHook').text('Adding fixed deal items');
                                zamanEposDb.epos_menufixeddeal.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Adding fixed deal items');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposDiscountItem() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_discountitem.clear();
        return zamanEposDb.epos_discountitem.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_discountitem', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_discountitem, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            data.forEach(function (item) {
                                $('#systemUpdateInformationHook').text('Adding item offer');
                                zamanEposDb.epos_discountitem.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Adding item offer');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposCountry() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_lcountry.clear();
        return zamanEposDb.epos_lcountry.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_lcountry', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_lcountry, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Adding country');
                            data.forEach(function (item) {
                                zamanEposDb.epos_lcountry.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Adding country');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposRegion() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_lregion.clear();
        return zamanEposDb.epos_lregion.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_lregion', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_lregion, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Populating region');
                            data.forEach(function (item) {
                                zamanEposDb.epos_lregion.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Populating region');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposCity() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_lcity.clear();
        return zamanEposDb.epos_lcity.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_lcity', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_lcity, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Populating cities');
                            data.forEach(function (item) {
                                zamanEposDb.epos_lcity.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Populating cities');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposArea() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_larea.clear();
        return zamanEposDb.epos_larea.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_larea', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_larea, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Populating areas');
                            data.forEach(function (item) {
                                zamanEposDb.epos_larea.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Populating areas');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposPostcode() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_lpostcode.clear();
        return zamanEposDb.epos_lpostcode.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_lpostcode', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_lpostcode, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Populating postcode');
                            data.forEach(function (item) {
                                zamanEposDb.epos_lpostcode.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Populating postcode');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposDoorAddress() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_ldooraddress.clear();
        return zamanEposDb.epos_ldooraddress.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_ldooraddress', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_ldooraddress, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Populating door address');
                            data.forEach(function (item) {
                                zamanEposDb.epos_ldooraddress.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Populating door address');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposCustomer() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_customer.clear();
        return zamanEposDb.epos_customer.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_customer', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_customer, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Populating customer');
                            data.forEach(function (item) {
                                zamanEposDb.epos_customer.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Populating customer');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposCustomerAddress() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_customer_address.clear();
        return zamanEposDb.epos_customer_address.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_customer_address', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_customer_address, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Populating customer address');
                            data.forEach(function (item) {
                                zamanEposDb.epos_customer_address.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Populating customer address');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposDiscountplan() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_discountplan.clear();
        return zamanEposDb.epos_discountplan.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_discountplan', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_discountplan, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Populating discount plan');
                            data.forEach(function (item) {
                                zamanEposDb.epos_discountplan.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Populating discount plan');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposDiscountmulti() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_discountmulti.clear();
        return zamanEposDb.epos_discountmulti.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_discountmulti', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_discountmulti, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Populating multi discount plan');
                            data.forEach(function (item) {
                                zamanEposDb.epos_discountmulti.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Populating multi discount plan');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposDeliveryplan() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_deliveryplan.clear();
        return zamanEposDb.epos_deliveryplan.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_deliveryplan', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_deliveryplan, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Populating delivery plan');
                            data.forEach(function (item) {
                                zamanEposDb.epos_deliveryplan.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Populating delivery plan');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposPaymentoption() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_paymentoption.clear();
        return zamanEposDb.epos_paymentoption.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_paymentoption', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_paymentoption, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Populating payment options');
                            data.forEach(function (item) {
                                zamanEposDb.epos_paymentoption.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Populating payment options');
                        }
                    });
                });
            }
        });
    });
}
function zamanDbEposVoucher() {
    zamanEposDb.on('ready', function () {
        zamanEposDb.epos_voucher.clear();
        return zamanEposDb.epos_voucher.count(function (count) {
            if (count <= 0) {
                return new Promise(function (resolve, reject) {
                    $.ajax(API_URL + 'api/epos_voucher', {
                        type: 'get',
                        dataType: 'json',
                        error: function (xhr, textStatus) {
                            reject(textStatus);
                        },
                        success: function (data) {
                            resolve(data);
                        }
                    });
                }).then(function (data) {
                    return zamanEposDb.transaction('rw', zamanEposDb.epos_voucher, function () {
                        if (!jQuery.isEmptyObject(data)) {
                            $('#systemUpdateInformationHook').text('Populating vouchers');
                            data.forEach(function (item) {
                                zamanEposDb.epos_voucher.add(item);
                            });
                        } else {
                            $('#systemUpdateInformationHook').text('Populating vouchers');
                        }
                    });
                });
            }
        });
    });
}
/*
 * use the listed function call on project initialization
 * 
 */

function initiateAllZamanEposTables() {
    var ajaxStopped = 0;
    zamanDbEposBranch();
    zamanDbEposConfiguration();
    zamanDbEposPaymentoption();
    zamanDbEposMenuCategory();
    zamanDbEposMenu();
    zamanDbEposMenuSelection();
    zamanDbEposMenuSet();
    zamanDbEposMenuSetItem();
    zamanDbEposMenuAttrCategory();
    zamanDbEposMenuAttr();
    zamanDbEposModifierCategory();
    zamanDbEposModifierMenu();
    zamanDbEposNattrCategory();
    zamanDbEposNattr();
    zamanDbEposModifier();
    zamanDbEposFixedDealItems();
    zamanDbEposDiscountplan();
    zamanDbEposDiscountmulti();
    zamanDbEposDiscountItem();
    zamanDbEposDeliveryplan();
    zamanDbEposVoucher();
    zamanDbEposCustomer();
    zamanDbEposCustomerAddress();
    zamanDbEposCountry();
    zamanDbEposRegion();
    zamanDbEposCity();
    zamanDbEposArea();
    zamanDbEposPostcode();
    zamanDbEposDoorAddress();
    $(document).ajaxStop(function () {
        ajaxStopped++;
        if (ajaxStopped >= 2) {
            setTimeout(function () {
                $('.page-loader').hide();
                location.reload();
            }, 30000);
        }
    });
}




