var zamanEposCart = (function () {
    var cart = [];
    var itemAttrs = [];
    var itemMods = [];
    var dealSetItems = [];
    var eposCurrentOrderId;
    var eposCartNewQty;
    var payments = [];
    var itemOffer = [];
    loadCurrentId();
    loadCart();
    loadNewQty();
    loadPayments();
    function loadCurrentId() {
        eposCurrentOrderId = localStorage.getItem("EposCurrentId");
        if (typeof (eposCurrentOrderId) === 'undefinded' || eposCurrentOrderId === null) {
            eposCurrentOrderId = 0;
        } else {
            loadCart();
            saveCart();
        }
    }
    function loadNewQty() {
        eposCartNewQty = localStorage.getItem("EposCartNewQty-" + eposCurrentOrderId);
        if (typeof (eposCartNewQty) === 'undefinded' || eposCartNewQty === null) {
            eposCartNewQty = 0;
        }
    }
    /*--------------------------------------
     * [Add cart item section Start]
     *--------------------------------------*/
    function Item(category, categoryTitle, type, menu, menuTitle, selection, selectionTitle, price, qty, tax, taxOption, taxPercent, discount, discountOption, setItem, Topping, modifier, sent, newQty, total, basePrice, inPrice, outPrice, printat, isFree, isFreeRule) {
        this.category = category;
        this.categoryTitle = categoryTitle;
        this.type = type;
        this.menu = menu;
        this.menuTitle = menuTitle;
        this.selection = selection;
        this.selectionTitle = selectionTitle;
        this.price = price;
        this.qty = qty;
        this.tax = tax;
        this.taxOption = taxOption;
        this.taxPercent = taxPercent;
        this.discount = discount;
        this.discountOption = discountOption;
        this.setItem = setItem;
        this.Topping = Topping;
        this.modifier = modifier;
        this.sent = sent;
        this.newQty = newQty;
        this.total = total;
        var totalPlus = 0;
        if (Topping && Topping.length > 0) {
            Topping.forEach(function (atooping) {
                totalPlus += parseInt(Number(atooping.qty)) * parseFloat(Number(atooping.price));
            });
        }
        this.total = parseFloat(total) + totalPlus;
        this.basePrice = basePrice;
        this.inPrice = inPrice;
        this.outPrice = outPrice;
        this.printat = printat;
        this.isFree = isFree;
        this.isFreeRule = isFreeRule;

    }
    function saveCart() {
        if (eposCurrentOrderId > 0) {
            localStorage.setItem("EposCart-" + eposCurrentOrderId, JSON.stringify(cart));
        }
    }
    function loadCart() {
        if (eposCurrentOrderId > 0) {
            cart = JSON.parse(localStorage.getItem("EposCart-" + eposCurrentOrderId));
            if (cart === null) {
                cart = [];
            }
        }
    }
    function payment(id, type, amount, code) {
        this.id = id;
        this.type = type;
        this.amount = amount;
        this.code = code;
    }
    function savePayments() {
        if (eposCurrentOrderId > 0) {
            localStorage.setItem("EposCartPayments-" + eposCurrentOrderId, JSON.stringify(payments));
        }
    }
    function loadPayments() {
        if (eposCurrentOrderId > 0) {
            payments = JSON.parse(localStorage.getItem("EposCartPayments-" + eposCurrentOrderId));
            if (payments === null) {
                payments = [];
            }
        }
    }
    var obj = {};
    obj.setEposCurrentId = function (id) {
        if ($.trim(id) && Number(id) > 0) {
            localStorage.setItem("EposCurrentId", id);
            if (this.getEposCurrentId() > 0) {
                loadCurrentId();
            }
        } else {
            localStorage.removeItem('EposCurrentId');
            setEposCurrentId = null;
        }
    };
    obj.getEposCurrentId = function () {
        return localStorage.getItem("EposCurrentId");
    };
    obj.clearEposCurrentId = function () {
        return localStorage.removeItem("EposCurrentId");
    };
    obj.addItem = function (cartData) {
        for (var i in cart) {
            if (cart[i].category === cartData['category']
                    && cart[i].menu === cartData['menu']
                    && cart[i].selection === cartData['selection']
                    && cart[i].price === cartData['price']
                    //&& cart[i].sent === 'no'
                    && JSON.stringify(cart[i].setItem) === JSON.stringify(cartData['setItem'])
                    && JSON.stringify(cart[i].Topping) === JSON.stringify(cartData['Topping'])
                    && JSON.stringify(cart[i].modifier) === JSON.stringify(cartData['modifier'])
                    ) {
                cart[i].qty += cartData['qty'];
                if (cart[i].sent === 'yes') {
                    cart[i].newQty += cartData['newQty'];
                } else {
                    cart[i].newQty = 0;
                }
                cart[i].total = (cart[i].qty * cart[i].price);
                var itemToppingTotal = 0;
                if (JSON.stringify(cart[i].Topping) === JSON.stringify(cartData['Topping'])) {
                    for (var t in cart[i].Topping) {
                        for (var ct in cartData['Topping']) {
                            if (cart[i].Topping[t].id === cartData['Topping'][ct].id) {
                                cart[i].Topping[t].qty += parseInt(Number(cartData['Topping'][ct].qty));
                                cart[i].Topping[t].total = (parseFloat(cartData['Topping'][ct].price) * cart[i].Topping[t].qty);
                                itemToppingTotal += parseFloat(Number(cart[i].Topping[t].total));
                            }
                        }
                    }
                }
                cart[i].total = parseFloat(Number(cart[i].total)) + itemToppingTotal;
                saveCart();
                loadCart();
                return i;
            }
        }
        var item = new Item(
                cartData.category,
                cartData.categoryTitle,
                cartData.type,
                cartData.menu,
                cartData.menuTitle,
                cartData.selection,
                cartData.selectionTitle,
                cartData.price,
                cartData.qty,
                cartData.tax,
                cartData.taxOption,
                cartData.taxPercent,
                cartData.discount,
                cartData.discountOption,
                cartData.setItem,
                cartData.Topping,
                cartData.modifier,
                cartData.sent,
                cartData.newQty,
                (cartData.price * cartData.qty),
                cartData.basePrice,
                cartData.inPrice,
                cartData.outPrice,
                cartData.printat,
                cartData.isFree,
                cartData.isFreeRule
                );
        cart.push(item);
        saveCart();
        loadCart();
        return cart.length - 1;
    };
    obj.setEposCartNewQty = function (id, qty) {
        var oldQty = Number(this.getEposCartNewQty(id));
        var totalNewQty = oldQty + Number(qty);
        localStorage.setItem("EposCartNewQty-" + id, totalNewQty);
        loadNewQty();
    };
    obj.getEposCartNewQty = function (id) {
        return localStorage.getItem("EposCartNewQty-" + id);
    };
    obj.clearNewQty = function () {
        localStorage.removeItem("EposCartNewQty-" + eposCurrentOrderId);
    };
    obj.plusItem = function (i, qty) {
        if (!jQuery.isEmptyObject(cart[i])) {
            if (cart[i].isFree === 'no') {
                cart[i].qty = parseInt(Number(cart[i].qty)) + parseInt(Number(qty));
                var newTotal = (parseFloat(Number(cart[i].price)) * parseInt(Number(qty)));
                cart[i].total = parseFloat(Number(cart[i].total)) + parseFloat(Number(newTotal));
            }
            if (cart[i].sent === 'yes') {
                cart[i].newQty += qty;
                eposCartNewQty = Number(eposCartNewQty) + Number(qty);
            } else {
                if (cart[i].newQty > 0) {
                    cart[i].newQty += qty;
                    eposCartNewQty = Number(eposCartNewQty) + Number(qty);
                } else {
                    cart[i].newQty = 0;
                }
            }
            saveCart();
            localStorage.setItem("EposCartNewQty-" + eposCurrentOrderId, eposCartNewQty);
            loadNewQty();
            loadCart();
            return i;
        }
    };
    obj.minusItem = function (i, sentDelete) {
        if (!jQuery.isEmptyObject(cart[i])) {
            var currentQty = 0;
            if (cart[i].sent === 'yes') {
                if (cart[i].newQty > 0) {
                    cart[i].qty--;
                    cart[i].newQty--;
                    eposCartNewQty--;
                    currentQty = cart[i].qty;
                    cart[i].total = parseFloat(Number(cart[i].total)) - parseFloat(Number(cart[i].price));
                    if (cart[i].qty === 0) {
                        currentQty = 0;
                        cart.splice(i, 1);
                    }
                } else {
                    if (sentDelete === 'yes') {
                        cart[i].qty--;
                        currentQty = cart[i].qty;
                        cart[i].total = parseFloat(Number(cart[i].total)) - parseFloat(Number(cart[i].price));
                        if (cart[i].qty === 0) {
                            currentQty = 0;
                            cart.splice(i, 1);
                        }
                    }
                }
            } else {
                cart[i].qty--;
                currentQty = cart[i].qty;
                if (cart[i].newQty > 0) {
                    cart[i].newQty--;
                    eposCartNewQty--;
                }
                cart[i].total = parseFloat(Number(cart[i].total)) - parseFloat(Number(cart[i].price));
                if (cart[i].qty === 0) {
                    currentQty = 0;
                    cart.splice(i, 1);
                }
            }
            saveCart();
            localStorage.setItem("EposCartNewQty-" + eposCurrentOrderId, eposCartNewQty);
            loadNewQty();
            loadCart();
            return currentQty === 0 ? '' : i;
        }
    };
    obj.deleteItem = function (i, sentDelete) {
        if (!jQuery.isEmptyObject(cart[i])) {
            if (cart[i].sent === 'yes') {
                if (cart[i].newQty > 0) {
                    cart[i].total = parseFloat(Number(cart[i].total)) - (parseFloat(Number(cart[i].price) * cart[i].newQty));
                    eposCartNewQty -= cart[i].newQty;
                    cart[i].qty -= cart[i].newQty;
                    cart[i].newQty = 0;
                    if (cart[i].qty <= 0) {
                        cart.splice(i, 1);
                    }
                } else {
                    if (sentDelete === 'yes') {
                        cart.splice(i, 1);
                    }
                }
            } else {
                if (cart[i].newQty > 0) {
                    eposCartNewQty -= cart[i].newQty;
                }
                cart.splice(i, 1);
            }
            localStorage.setItem("EposCartNewQty-" + eposCurrentOrderId, eposCartNewQty);
            saveCart();
            loadNewQty();
            loadCart();
            return i;
        }
    };
    obj.clearCart = function () {
        if (cart.length > 0) {
            for (var i in cart) {
                if (cart[i].sent === 'no') {
                    cart.splice(i);
                } else {
                    if (cart[i].newQty > 0) {
                        var qty = cart[i].qty -= cart[i].newQty;
                        eposCartNewQty -= cart[i].newQty;
                        cart[i].newQty = 0;
                        if (qty <= 0) {
                            cart.splice(i);
                        }
                    }
                }
            }
            localStorage.setItem("EposCartNewQty-" + eposCurrentOrderId, eposCartNewQty);
            loadNewQty();
            saveCart();
            loadCart();
        }
    };
    obj.listCart = function () {
        if (cart.length > 0) {
            var cartCopy = [];
            for (var i in cart) {
                var item = cart[i];
                var itemCopy = {};
                for (var p in item) {
                    itemCopy[p] = item[p];
                }
                cartCopy.push(itemCopy);
            }
            return cartCopy;
        } else {
            return [];
        }
    };
    obj.getLineItem = function (i) {
        return cart[i];
    };

    /*--------------------------------------
     * [Add cart item tooping Start]
     *--------------------------------------*/
    function ItemTopping(id, title, qty, price, category, set, total) {
        this.id = id;
        this.title = title;
        this.qty = qty;
        this.price = price;
        this.category = category;
        this.set = set;
        this.total = total;
    }
    function saveItemTopping() {
        localStorage.setItem("EposItemAttrs", JSON.stringify(itemAttrs));
    }
    function loadItemTopping() {
        itemAttrs = JSON.parse(localStorage.getItem("EposItemAttrs"));
        if (itemAttrs === null) {
            itemAttrs = [];
        }
    }
    loadItemTopping();
    obj.addItemTopping = function (attrData) {
        for (var i in itemAttrs) {
            if (itemAttrs[i].id === attrData['id'] && itemAttrs[i].category === attrData['category']) {
                itemAttrs[i].qty += attrData['qty'];
                itemAttrs[i].total = (itemAttrs[i].qty * itemAttrs[i].price);
                saveItemTopping();
                return;
            }
        }
        var item = new ItemTopping(
                attrData.id,
                attrData.title,
                attrData.qty,
                attrData.price,
                attrData.category,
                attrData.set,
                attrData.price * attrData.qty
                );
        itemAttrs.push(item);
        saveItemTopping();
        return true;
    };
    obj.addGlobalTop = function (index, top) {
        var item = cart[index];
        var topPrice = 0;
        topPrice += parseFloat(Number(top.qty)) * parseFloat(Number(top.price));
        var ItemTotal = parseFloat(Number(item.total));
        top.id = 9999;
        top.category = 99999;
        var found = null;
        if (item.Topping.length > 0) {
            for (var i in item.Topping) {
                if (item.Topping[i].id === top['id'] && item.Topping[i].category === top['category']) {
                    if (item.Topping[i].title === top['title']) {
                        item.Topping[i].qty += top['qty'];
                        found = i;
                        break;
                    } else {
                        top.id += 1;
                        top.category += 1;
                    }
                }
            }
        }
        if (found === null) {
            item.Topping.push(top);
        }
        item.total = (ItemTotal + topPrice);
        cart[index] = item;
        saveCart();
        loadCart();
        return index;
    };
    obj.listItemTopping = function () {
        var listCopy = [];
        for (var i in itemAttrs) {
            var item = itemAttrs[i];
            var itemCopy = {};
            for (var p in item) {
                itemCopy[p] = item[p];
            }
            listCopy.push(itemCopy);
        }
        return listCopy;
    };
    obj.clearItemTopping = function () {
        itemAttrs = [];
        saveItemTopping();
    };
    obj.updateToppingInfo = function (itemIndex, toppingIndex, action) {
        var toppings = cart[itemIndex].Topping;
        var newTopping = [];
        var itemToppingTotal = 0;
        toppings.forEach(function (aTop, index) {
            var object = {};
            if (Number(toppingIndex) === Number(index)) {
                if (action === 'plus') {
                    aTop.qty += 1;
                    aTop.total = aTop.qty * aTop.price;
                    itemToppingTotal += aTop.total;
                    object = aTop;
                    newTopping.push(object);
                }
                if (action === 'minus' && aTop.qty > 1) {
                    aTop.qty -= 1;
                    aTop.total = aTop.qty * aTop.price;
                    itemToppingTotal += aTop.total;
                    object = aTop;
                    newTopping.push(object);
                }

            } else {
                itemToppingTotal += aTop.total;
                object = aTop;
                newTopping.push(object);
            }
        });
        cart[itemIndex].total = parseFloat((cart[itemIndex].qty * parseFloat(cart[itemIndex].price)) + itemToppingTotal);
        cart[itemIndex].Topping = newTopping;
        saveCart();
        loadCart();
        return itemIndex;

    };

    /*--------------------------------------
     * [Add cart item Modifier Start]
     *--------------------------------------*/
    function ItemModifier(title) {
        this.title = title;
    }
    function saveItemModifier() {
        localStorage.setItem("EposItemMods", JSON.stringify(itemMods));
    }
    function loadItemModifier() {
        itemMods = JSON.parse(localStorage.getItem("EposItemMods"));
        if (itemMods === null) {
            itemMods = [];
        }
    }
    loadItemModifier();
    obj.addItemModifier = function (modData, index) {
        for (var i in itemMods) {
            if (itemMods[i].title === modData.title) {
                return;
            }
        }
        var item = new ItemModifier(modData.title);
        itemMods.push(item);
        saveItemModifier();
        return true;
    };
    obj.listItemModifier = function () {
        var listCopy = [];
        for (var i in itemMods) {
            var item = itemMods[i];
            var itemCopy = {};
            for (var p in item) {
                itemCopy[p] = item[p];
            }
            listCopy.push(itemCopy);
        }
        return listCopy;
    };
    obj.clearItemModifier = function () {
        itemMods = [];
        saveItemModifier();
    };
    obj.addGlobalMod = function (index, mod) {
        var item = cart[index];
        var found = null;
        if (item.modifier.length > 0) {
            for (var i in item.modifier) {
                if (item.modifier[i].title === mod['title']) {
                    found = i;
                    break;
                }
            }
        }
        if (found === null) {
            item.modifier.push(mod);
            cart[index] = item;
            saveCart();
        }
        return index;
    };
    obj.updateModifierInfo = function (itemIndex, modIndex) {
        var modifiers = cart[itemIndex].modifier;
        var newModifiers = [];
        for (var i in modifiers) {
            if (i !== modIndex) {
                newModifiers.push(modifiers[i]);
            }
        }
        cart[itemIndex].modifier = newModifiers;
        saveCart();
        loadCart();
        return itemIndex;
    };
    /*--------------------------------------
     * [Add cart Deal Set Item Start]
     *--------------------------------------*/
    function setItem(id, title, qty, set, setTitle) {
        this.id = id;
        this.title = title;
        this.qty = qty;
        this.set = set;
        this.setTitle = setTitle;
    }
    function saveSetItem() {
        localStorage.setItem("EposDealSetItems", JSON.stringify(dealSetItems));
    }
    function loadSetItem() {
        dealSetItems = JSON.parse(localStorage.getItem("EposDealSetItems"));
        if (dealSetItems === null) {
            dealSetItems = [];
        }
    }
    loadSetItem();
    obj.addSetItem = function (aSetItem) {
        for (var i in dealSetItems) {
            if (dealSetItems[i].id === aSetItem['id'] && dealSetItems[i].set === aSetItem['set']) {
                dealSetItems[i].qty += aSetItem['qty'];
                saveSetItem();
                return;
            }
        }
        var item = new setItem(aSetItem['id'], aSetItem['title'], aSetItem['qty'], aSetItem['set'], aSetItem['setTitle']);
        dealSetItems.push(item);
        saveSetItem();
        loadSetItem();
        return true;
    };
    obj.listSetItem = function () {
        var listCopy = [];
        for (var i in dealSetItems) {
            var item = dealSetItems[i];
            var itemCopy = {};
            for (var p in item) {
                itemCopy[p] = item[p];
            }
            listCopy.push(itemCopy);
        }
        return listCopy;
    };
    obj.clearSetItem = function () {
        dealSetItems = [];
        saveSetItem();
    };
    obj.updateSetItemInfo = function (itemIndex, setItemIndex, action) {
        var setitems = cart[itemIndex].setItem;
        var newSetItems = [];
        for (var i in setitems) {
            if (i === setItemIndex) {
                if (action === 'plus') {
                    setitems[i].qty += 1;
                    newSetItems.push(setitems[i]);
                }
                if (action === 'minus') {
                    if (setitems[i].qty > 1) {
                        setitems[i].qty -= 1;
                        newSetItems.push(setitems[i]);
                    }
                }
            } else {
                newSetItems.push(setitems[i]);
            }
        }
        cart[itemIndex].setItem = newSetItems;
        saveCart();
        loadCart();
        return itemIndex;
    };
    obj.cartSubtotal = function () {
        var itemSubtotal = 0;
        for (var i in cart) {
            itemSubtotal += Number(cart[i].total);
        }
        return Number(itemSubtotal);
    };
    obj.cartTax = function () {
        var totalTax = 0;
        for (var i in cart) {
            var taxPercent = cart[i].taxPercent;
            if (taxPercent > 0) {
                taxPercent = taxPercent / 100;
            }
            var itemTotal = cart[i].total;
            totalTax += itemTotal * taxPercent;
        }
        return totalTax;
    };
    obj.setPromoDiscountPlan = function () {
        zamanEposDb.transaction('rw', [zamanEposDb.epos_order, zamanEposDb.epos_discountplan], function () {
            zamanEposDb.epos_order.get({orderId: Number(eposCurrentOrderId)}).then(function (anOrder) {
                if (typeof (anOrder) !== 'undefined') {
                    zamanEposDb.epos_discountplan.where({'status': '3'}).filter(function (aPlan) {
                        console.log(aPlan)
                        var currentDate = new Date();
                        var currentTime = new Date().toLocaleTimeString().split(' ');
                        console.log(currentTime);
                        var currentTimeHMS = currentTime[0].split(':');
                        var currentTimeTotalSecond = 0;
                        if ((currentTime[1] === 'PM' || currentTime[1] === 'pm')) {
                            if (Number(currentTimeHMS[0]) < 12) {
                                currentTimeTotalSecond = parseInt((Number(currentTimeHMS[0]) + 12) * 3600) + parseInt(Number(currentTimeHMS[1]) * 60) + parseInt(Number(currentTimeHMS[2]));
                            } else {
                                currentTimeTotalSecond = parseInt((Number(currentTimeHMS[0])) * 3600) + parseInt(Number(currentTimeHMS[1]) * 60) + parseInt(Number(currentTimeHMS[2]));
                            }
                        } else {
                            currentTimeTotalSecond = parseInt((Number(currentTimeHMS[0])) * 3600) + parseInt(Number(currentTimeHMS[1]) * 60) + parseInt(Number(currentTimeHMS[2]));
                        }
                        var startTime = (aPlan.start_time).split(' ');
                        var startTimeHMS = startTime[0].split(':');
                        var startTimeTotalSecond = 0;
                        if (startTime[1] === 'PM' || startTime[1] === 'pm') {
                            if (Number(startTimeHMS[0]) < 12) {
                                startTimeTotalSecond += parseInt((Number(startTimeHMS[0]) + 12) * 3600) + parseInt(Number(startTimeHMS[1]) * 60) + parseInt(Number(startTimeHMS[2]));
                            } else {
                                startTimeTotalSecond = parseInt((Number(startTimeHMS[0])) * 3600) + parseInt(Number(startTimeHMS[1]) * 60) + parseInt(Number(startTimeHMS[2]));
                            }

                        } else {
                            startTimeTotalSecond = parseInt((Number(startTimeHMS[0])) * 3600) + parseInt(Number(startTimeHMS[1]) * 60) + parseInt(Number(startTimeHMS[2]));
                        }
                        var endTime = (aPlan.end_time).split(' ');
                        var endTimeHMS = endTime[0].split(':');
                        var endTimeTotalSecond = 0;
                        if (endTime[1] === 'PM' || endTime[1] === 'pm') {
                            if (Number(startTimeHMS[0]) < 12) {
                                endTimeTotalSecond += parseInt((Number(endTimeHMS[0]) + 12) * 3600) + parseInt(Number(endTimeHMS[1]) * 60) + parseInt(Number(endTimeHMS[2]));
                            } else {
                                endTimeTotalSecond = parseInt((Number(endTimeHMS[0])) * 3600) + parseInt(Number(endTimeHMS[1]) * 60) + parseInt(Number(endTimeHMS[2]));
                            }
                        } else {
                            endTimeTotalSecond = parseInt((Number(endTimeHMS[0])) * 3600) + parseInt(Number(endTimeHMS[1]) * 60) + parseInt(Number(endTimeHMS[2]));
                        }
                        var startDate = new Date(aPlan.start_date);
                        var endDate = new Date(aPlan.end_date);
                        var checkType = '0';
                        if (anOrder.type === 'table') {
                            checkType = '1';
                        } else if (anOrder.type === 'waiting') {
                            checkType = '2';
                        } else if (anOrder.type === 'bar') {
                            checkType = '3';
                        } else if (anOrder.type === 'delivery') {
                            checkType = '4';
                        } else if (anOrder.type === 'collection') {
                            checkType = '5';
                        } else {
                            checkType = '0';
                        }
                        var today = new Date().getDay() + 1;
                        if (currentDate.getTime() >= startDate.getTime()
                                && currentDate.getTime() <= endDate.getTime()
                                && aPlan.onapp.indexOf(checkType) > -1
                                && aPlan.onday.indexOf(today.toString()) > -1
                                && currentTimeTotalSecond >= startTimeTotalSecond
                                && currentTimeTotalSecond <= endTimeTotalSecond
                                ) {
                            return true;
                        } else {
                            return false;
                        }
                    }).toArray().then(function (allPlan) {
                        var arrayLength = allPlan.length;
                        if (arrayLength > 0) {
                            if (arrayLength > 1) {
                                allPlan.sort(function (a, b) {
                                    if (a.min_order >= b.min_order)
                                        return -1;
                                    if (a.min_order < b.min_order)
                                        return 1;
                                    return 0;
                                });
                            }
                            localStorage.setItem("EposCartDiscountPlan-" + eposCurrentOrderId, JSON.stringify(allPlan));
                            JSON.parse(localStorage.getItem("EposCartDiscountPlan-" + eposCurrentOrderId));
                        } else {
                            localStorage.removeItem("EposCartDiscountPlan-" + eposCurrentOrderId);
                        }
                    });
                } else {
                    localStorage.removeItem("EposCartDiscountPlan-" + eposCurrentOrderId);
                }
            });
        });
    };
    obj.cartPromoDiscount = function () {
        var discountPlan = JSON.parse(localStorage.getItem("EposCartDiscountPlan-" + eposCurrentOrderId));
        var fixedDiscount = 0;
        var totalDiscount = 0;
        var thisDiscountPlan = [];
        var kitchenTotal = 0;
        var barTotal = 0;
        var drinksTotal = 0;
        var bakeryTotal = 0;
        var allTotal = 0;

        for (var i in cart) {
            if (cart[i].discountOption === 3) {
                console.log('dont delete this console it is for time consuming');
                if (discountPlan !== null && discountPlan.length > 0) {
                    console.log('dont delete this console it is for time consuming');
                    for (var aplan in discountPlan) {
                        if (Number(this.cartSubtotal()) >= Number(discountPlan[aplan].min_order)) {
                            thisDiscountPlan.discount = discountPlan[aplan].discount;
                            thisDiscountPlan.onfunc = discountPlan[aplan].onfunc;
                            thisDiscountPlan.onitem = discountPlan[aplan].onitem;
                            break;
                        } else {
                            continue;
                        }
                    }
                    if (thisDiscountPlan.onfunc === '2') {
                        if ((thisDiscountPlan.onitem).indexOf('kitchen') > -1 && cart[i].type === 'kitchen') {
                            var result = this.checkDiscountMulti(cart[i]);
                            if (result.length > 0) {
                                if (result[result.length - 1].rel === '3') {
                                    kitchenTotal += Number(cart[i].total);
                                }
                            } else {
                                kitchenTotal += Number(cart[i].total);
                            }
                        } else if ((thisDiscountPlan.onitem).indexOf('bar') > -1 && cart[i].type === 'bar') {
                            var result = this.checkDiscountMulti(cart[i]);
                            if (result.length > 0) {
                                if (result[result.length - 1].rel === '3') {
                                    barTotal += Number(cart[i].total);
                                }
                            } else {
                                barTotal += Number(cart[i].total);
                            }
                        } else if ((thisDiscountPlan.onitem).indexOf('drinks') > -1 && cart[i].type === 'drinks') {
                            var result = this.checkDiscountMulti(cart[i]);
                            if (result.length > 0) {
                                if (result[result.length - 1].rel === '3') {
                                    drinksTotal += Number(cart[i].total);
                                }
                            } else {
                                drinksTotal += Number(cart[i].total);
                            }
                        } else if ((thisDiscountPlan.onitem).indexOf('bakery') > -1 && cart[i].type === 'bakery') {
                            var result = this.checkDiscountMulti(cart[i]);
                            if (result.length > 0) {
                                if (result[result.length - 1].rel === '3') {
                                    bakeryTotal += Number(cart[i].total);
                                }
                            } else {
                                bakeryTotal += Number(cart[i].total);
                            }
                        } else {
                            var result = this.checkDiscountMulti(cart[i]);
                            if (result.length > 0) {
                                if (result[result.length - 1].rel === '3') {
                                    allTotal += Number(cart[i].total);
                                }
                            } else {
                                allTotal += Number(cart[i].total);
                            }
                        }
                    } else {
                        fixedDiscount = Number(thisDiscountPlan.discount);
                    }
                }
            } else {
                console.log('dont delete this console it is for time consuming');
                var result = this.checkDiscountMulti(cart[i]);
                if (result.length > 0) {
                    if (result[result.length - 1].rel === '3') {
                        var discountPercent = Number(cart[i].discount);
                        if (discountPercent > 0) {
                            discountPercent = discountPercent / 100;
                        }
                        var itemTotal = Number(cart[i].total);
                        totalDiscount += itemTotal * discountPercent;
                    }
                } else {
                    var discountPercent = Number(cart[i].discount);
                    if (discountPercent > 0) {
                        discountPercent = discountPercent / 100;
                    }
                    var itemTotal = Number(cart[i].total);
                    totalDiscount += itemTotal * discountPercent;
                }
            }
        }
        if (fixedDiscount > 0) {
            totalDiscount += fixedDiscount;
        } else {
            if (kitchenTotal > 0) {
                totalDiscount += (kitchenTotal * thisDiscountPlan.discount) / 100;
            }
            if (barTotal > 0) {
                totalDiscount += (barTotal * thisDiscountPlan.discount) / 100;
            }
            if (drinksTotal > 0) {
                totalDiscount += (drinksTotal * thisDiscountPlan.discount) / 100;
            }
            if (bakeryTotal > 0) {
                totalDiscount += (bakeryTotal * thisDiscountPlan.discount) / 100;
            }
            if (allTotal > 0) {
                totalDiscount += (allTotal * thisDiscountPlan.discount) / 100;
            }
        }
        console.log('dont delete this console it is for time consuming');
        return totalDiscount;
    };
    obj.clearPromoDiscountPlan = function () {
        localStorage.removeItem("EposCartDiscountPlan-" + eposCurrentOrderId);
    };
    obj.setDiscountmulti = function () {
        zamanEposDb.transaction('rw', [zamanEposDb.epos_order, zamanEposDb.epos_discountmulti], function () {
            zamanEposDb.epos_order.get({orderId: Number(eposCurrentOrderId)}).then(function (anOrder) {
                if (typeof (anOrder) !== 'undefined') {
                    zamanEposDb.epos_discountmulti.where({'status': '3'}).filter(function (aPlan) {
                        var currentDate = new Date();
                        var currentTime = new Date().toLocaleTimeString().split(' ');
                        var currentTimeHMS = currentTime[0].split(':');
                        var currentTimeTotalSecond = 0;
                        if (currentTime[1] === 'PM' && parseInt(Number(currentTimeHMS[0])) !== 12) {
                            currentTimeTotalSecond += ((parseInt(Number(currentTimeHMS[0])) + 12) * 3600) + (parseInt(Number(currentTimeHMS[1])) * 60) + (parseInt(Number(currentTimeHMS[2])));
                        } else {
                            currentTimeTotalSecond += (parseInt(Number(currentTimeHMS[0])) * 3600) + (parseInt(Number(currentTimeHMS[1])) * 60) + parseInt(Number(currentTimeHMS[2]));
                        }
                        var startTime = (aPlan.start_time).split(' ');
                        var startTimeHMS = startTime[0].split(':');
                        var startTimeTotalSecond = 0;
                        if (startTime[1] === 'PM' && parseInt(Number(startTimeHMS[0])) !== 12) {
                            startTimeTotalSecond += ((parseInt(Number(startTimeHMS[0])) + 12) * 3600) + (parseInt(Number(startTimeHMS[1])) * 60) + (parseInt(Number(startTimeHMS[2])));
                        } else {
                            startTimeTotalSecond += (parseInt(Number(startTimeHMS[0])) * 3600) + (parseInt(Number(startTimeHMS[1])) * 60) + parseInt(Number(startTimeHMS[2]));
                        }
                        var endTime = (aPlan.end_time).split(' ');
                        var endTimeHMS = endTime[0].split(':');
                        var endTimeTotalSecond = 0;
                        if (endTime[1] === 'PM' && parseInt(Number(endTimeHMS[0])) !== 12) {
                            endTimeTotalSecond += ((parseInt(Number(endTimeHMS[0])) + 12) * 3600) + (parseInt(Number(endTimeHMS[1])) * 60) + (parseInt(Number(endTimeHMS[2])));
                        } else {
                            endTimeTotalSecond += (parseInt(Number(endTimeHMS[0])) * 3600) + (parseInt(Number(endTimeHMS[1])) * 60) + parseInt(Number(endTimeHMS[2]));
                        }
                        var startDate = new Date(aPlan.start_date);
                        var endDate = new Date(aPlan.end_date);
                        var checkType = '0';
                        if (anOrder.type === 'table') {
                            checkType = '1';
                        } else if (anOrder.type === 'waiting') {
                            checkType = '2';
                        } else if (anOrder.type === 'bar') {
                            checkType = '3';
                        } else if (anOrder.type === 'delivery') {
                            checkType = '4';
                        } else if (anOrder.type === 'collection') {
                            checkType = '5';
                        } else {
                            checkType = '0';
                        }
                        var today = new Date().getDay() + 1;
                        if (currentDate.getTime() >= startDate.getTime()
                                && currentDate.getTime() <= endDate.getTime()
                                && aPlan.onapp.indexOf(checkType) > -1
                                && aPlan.onday.indexOf(today.toString()) > -1
                                && currentTimeTotalSecond >= startTimeTotalSecond
                                && currentTimeTotalSecond <= endTimeTotalSecond
                                ) {
                            return true;
                        } else {
                            return false;
                        }
                    }).toArray().then(function (allPlan) {
                        var arrayLength = allPlan.length;
                        if (arrayLength > 0) {
                            if (arrayLength > 1) {
                                allPlan.sort(function (a, b) {
                                    if (a.min_order >= b.min_order)
                                        return -1;
                                    if (a.min_order < b.min_order)
                                        return 1;
                                    return 0;
                                });
                            }
                            localStorage.setItem("EposCartDiscountMulti-" + eposCurrentOrderId, JSON.stringify(allPlan));
                        } else {
                            localStorage.removeItem("EposCartDiscountMulti-" + eposCurrentOrderId);
                        }
                    });
                } else {
                    localStorage.removeItem("EposCartDiscountMulti-" + eposCurrentOrderId);
                }
            });
        });
    };
    obj.cartMultiDiscount = function () {
        var MultiDiscountTotal = 0;
        if (cart.length > 0) {
            for (var i in cart) {
                var result = this.checkDiscountMulti(cart[i]);
                if (result.length > 0 && (typeof (result) !== 'undefined' || typeof (result) !== null)) {
                    if (Number(cart[i].qty) >= (Number(result[0].buy) + Number(result[0].get))) {
                        if (Number(result[0].buy) === Number(result[0].get)) {
                            var mask = parseInt(Number(cart[i].qty) / 2);
                            MultiDiscountTotal += mask * cart[i].price;
                        } else {
                            if (Number(result[0].buy) <= 1) {
                                var mask = Number(cart[i].qty) * Number(result[0].get);
                                MultiDiscountTotal += mask * cart[i].price;
                            } else {
                                var mask = parseInt(Number(cart[i].qty) / Number(result[0].buy));
                                MultiDiscountTotal += (mask * Number(result[0].get)) * cart[i].price;
                            }
                        }
                    }
                }
            }
        }
        return MultiDiscountTotal;
    };
    obj.checkDiscountMulti = function (item) {
        var discountPlanMulti = JSON.parse(localStorage.getItem("EposCartDiscountMulti-" + eposCurrentOrderId));
        var multiDiscount = [];
        if (discountPlanMulti !== null && discountPlanMulti.length > 0) {
            for (var index in discountPlanMulti) {
                if (Number(discountPlanMulti[index].category) === Number(item.category) && Number(discountPlanMulti[index].menu) === Number(item.menu) && Number(discountPlanMulti[index].selection) === Number(item.selection)) {
                    multiDiscount.push(discountPlanMulti[index]);
                    break;
                } else {
                    continue;
                }
            }
        }
        return multiDiscount;
    };
    obj.clearDiscountMulti = function () {
        localStorage.removeItem("EposCartDiscountMulti-" + eposCurrentOrderId);
    };
    obj.setItemOffer = function () {
        zamanEposDb.transaction('rw', [zamanEposDb.epos_order, zamanEposDb.epos_menucategory, zamanEposDb.epos_menu, zamanEposDb.epos_menuselection, zamanEposDb.epos_discountitem], function () {
            zamanEposDb.epos_order.get({orderId: Number(eposCurrentOrderId)}).then(function (anOrder) {
                if (typeof (anOrder) !== 'undefined') {
                    zamanEposDb.epos_discountitem.where({'status': '3'}).filter(function (aPlan) {
                        return aPlan.type.indexOf(anOrder.type) !== -1 && aPlan.status === '3';
                    }).toArray().then(function (allPlan) {
                        var arrayLength = allPlan.length;
                        if (arrayLength > 0) {
                            if (arrayLength > 1) {
                                allPlan.sort(function (a, b) {
                                    return Number(b.order) - Number(a.order);
                                });
                            }
                            localStorage.setItem("EposCartItemOffer-" + eposCurrentOrderId, JSON.stringify(allPlan));
                        } else {
                            localStorage.removeItem("EposCartItemOffer-" + eposCurrentOrderId);
                        }
                        loadItemOffer();
                    });
                } else {
                    localStorage.removeItem("EposCartItemOffer-" + eposCurrentOrderId);
                }
            });
        });
    };
    function loadItemOffer() {
        if (eposCurrentOrderId > 0) {
            itemOffer = JSON.parse(localStorage.getItem("EposCartItemOffer-" + eposCurrentOrderId));
            if (itemOffer === null) {
                itemOffer = [];
            }
        }
    }
    loadItemOffer();
    obj.getItemOffer = function () {
        if (itemOffer.length > 0) {
            var itemOfferCopy = [];
            for (var i in itemOffer) {
                var item = itemOffer[i];
                var itemCopy = {};
                for (var p in item) {
                    itemCopy[p] = item[p];
                }
                itemOfferCopy.push(itemCopy);
            }
            return itemOfferCopy;
        } else {
            return [];
        }
    };
    obj.clearItemOffer = function () {
        localStorage.removeItem("EposCartItemOffer-" + eposCurrentOrderId);
    };
    obj.setItemOfferExitParam = function (data) {
        localStorage.setItem("ItemOfferExitParam-" + eposCurrentOrderId, JSON.stringify(data));
        this.getItemOfferExitParam();
    };
    obj.getItemOfferExitParam = function () {
        var itemOfferExitParam = [];
        if (eposCurrentOrderId > 0) {
            itemOfferExitParam = JSON.parse(localStorage.getItem("ItemOfferExitParam-" + eposCurrentOrderId));
            if (itemOfferExitParam === null) {
                itemOfferExitParam = [];
            }
        }
        return itemOfferExitParam;
    };
    obj.getItemOfferFreeItem = function () {
        var freeItem = 0;
        for (var i in cart) {
            if (cart[i].isFree === 'yes') {
                freeItem += Number(cart[i].qty);
            }
        }
        return freeItem;
    };
    obj.clearItemOfferExitParam = function () {
        localStorage.removeItem("ItemOfferExitParam-" + eposCurrentOrderId);
        this.getItemOfferExitParam();
    };
    obj.clearPreRuleFreeItem = function (order) {
        if (cart.length > 0) {
            for (var i in cart) {
                if (cart[i].isFree === 'yes' && Number(cart[i].isFreeRule) !== Number(order)) {
                    cart.splice(i, 1);
                }
            }
            loadNewQty();
            saveCart();
            loadCart();
        }
    };
    obj.clearCartSentParam = function () {
        for (var i in cart) {
            var item = cart[i];
            item.sent = 'yes';
            item.newQty = 0;
            cart[i] = item;
        }
        saveCart();
        localStorage.setItem("EposCartNewQty-" + eposCurrentOrderId, 0);
        loadCart();
    };
    obj.setccFee = function (ccFee) {
        localStorage.setItem("ccFee-" + eposCurrentOrderId, ccFee);
        if (this.getccFee() > 0) {
            var cartCalculator = this.cartCalculator();
            zamanEposDb.epos_order.where("orderId").equals(Number(eposCurrentOrderId)).modify({
                ccFee: cartCalculator.cartccFee,
                grandTotal: cartCalculator.Total
            });
        }
    };
    obj.getccFee = function () {
        var ccFee = localStorage.getItem("ccFee-" + eposCurrentOrderId);
        var totalCcFee = 0;
        if (typeof (ccFee) !== 'undefined') {
            totalCcFee = parseFloat(Number(ccFee));
        } else {
            totalCcFee = 0;
        }
        return totalCcFee;
    };
    obj.clearccFee = function () {
        localStorage.removeItem("ccFee-" + eposCurrentOrderId);
    };
    obj.setcbFee = function (cbFee) {
        localStorage.setItem("cbFee-" + eposCurrentOrderId, cbFee);
        var cartCalculator = this.cartCalculator();
        zamanEposDb.epos_order.where("orderId").equals(Number(eposCurrentOrderId)).modify({
            cbFee: cartCalculator.cartcbFee,
            grandTotal: cartCalculator.Total
        });
    };
    obj.getcbFee = function () {
        var cbFee = localStorage.getItem("cbFee-" + eposCurrentOrderId);
        var totalCbFee = 0;
        if (typeof (cbFee) !== 'undefined') {
            totalCbFee = parseFloat(Number(cbFee));
        } else {
            totalCbFee = 0;
        }
        return totalCbFee;
    };
    obj.clearcbFee = function () {
        localStorage.removeItem("cbFee-" + eposCurrentOrderId);
    };
    obj.setDeliveryCharge = function (deliveryCharge) {
        localStorage.setItem("deliveryCharge-" + eposCurrentOrderId, deliveryCharge);
        if (Number(this.getDeliveryCharge()) > 0) {
            var cartCalculator = this.cartCalculator();
            zamanEposDb.epos_order.where("orderId").equals(Number(eposCurrentOrderId)).modify({
                deliveryCharge: cartCalculator.deliveryCharge,
                grandTotal: cartCalculator.Total
            });
        }
    };
    obj.getDeliveryCharge = function () {
        var deliveryCharge = localStorage.getItem("deliveryCharge-" + eposCurrentOrderId);
        var totalDeliveryCharge = 0;
        if (typeof (deliveryCharge) !== 'undefined') {
            totalDeliveryCharge = parseFloat(Number(deliveryCharge));
        } else {
            totalDeliveryCharge = 0;
        }
        return totalDeliveryCharge;
    };
    obj.clearDeliveryCharge = function () {
        localStorage.removeItem("deliveryCharge-" + eposCurrentOrderId);
    };
    obj.setServiceCharge = function (amount, func) {
        var serviceCharge = {};
        serviceCharge.amount = amount;
        serviceCharge.func = func;
        localStorage.setItem("serviceCharge-" + eposCurrentOrderId, JSON.stringify(serviceCharge));
        if (this.getServiceCharge()) {
            var cartCalculator = this.cartCalculator();
            zamanEposDb.epos_order.where("orderId").equals(Number(eposCurrentOrderId)).modify({
                serviceCharge: 0,
                grandTotal: 0
            }).then(function () {
                zamanEposDb.epos_order.where("orderId").equals(Number(eposCurrentOrderId)).modify({
                    serviceCharge: cartCalculator.serviceCharge,
                    grandTotal: cartCalculator.Total
                });
            });

        }
    };
    obj.getServiceCharge = function () {
        var serviceCharge = JSON.parse(localStorage.getItem("serviceCharge-" + eposCurrentOrderId));
        if (typeof (serviceCharge) !== 'undefined' || !jQuery.isEmptyObject(serviceCharge)) {
            return serviceCharge;
        } else {
            return false;
        }
    };
    obj.cartServiceCharge = function () {
        var subtotal = this.cartSubtotal();
        var serviceChargeObj = this.getServiceCharge();
        var serviceChargeTotal = 0;
        if (serviceChargeObj) {
            var amount = Number(serviceChargeObj.amount);
            var func = Number(serviceChargeObj.func);
            if (func === 2) {
                serviceChargeTotal = (amount * subtotal) / 100;
            } else if (func === 3) {
                serviceChargeTotal = amount;
            } else {
                serviceChargeTotal = 0;
            }
        }
        return serviceChargeTotal;
    };
    obj.clearServiceCharge = function () {
        localStorage.removeItem("serviceCharge-" + eposCurrentOrderId);
    };
    obj.setSpecialDiscount = function (amount, func, type) {
        var specialDiscount = {};
        specialDiscount.discount = amount;
        specialDiscount.func = func;
        specialDiscount.type = type;
        localStorage.setItem("specialDiscount-" + eposCurrentOrderId, JSON.stringify(specialDiscount));
        if (this.getSpecialDiscount()) {
            var cartCalculator = this.cartCalculator();
            zamanEposDb.epos_order.where("orderId").equals(Number(eposCurrentOrderId)).modify({
                promo: cartCalculator.specialDiscount,
                grandTotal: cartCalculator.Total
            });
        }
    };
    obj.getSpecialDiscount = function () {
        var specialDiscount = JSON.parse(localStorage.getItem("specialDiscount-" + eposCurrentOrderId));
        if (typeof (specialDiscount) !== 'undefined' || !jQuery.isEmptyObject(specialDiscount)) {
            return specialDiscount;
        } else {
            return false;
        }
    };
    obj.cartSpecialDiscountTotal = function () {
        var totalForDiscount = 0;
        discountTotal = 0;
        var discountObj = this.getSpecialDiscount();
        if (typeof (discountObj) !== 'undefined' && !jQuery.isEmptyObject(discountObj)) {
            if (discountObj.func !== 2) {
                return discountObj.discount;
            } else {
                var cartItems = this.listCart();
                if (discountObj.type === 'kitchen') {
                    for (var item in cartItems) {
                        if (cartItems[item].type === 'kitchen') {
                            totalForDiscount += cartItems[item].total;
                        }
                    }
                } else if (discountObj.type === 'bar') {
                    for (var item in cartItems) {
                        if (cartItems[item].type === 'bar') {
                            totalForDiscount += cartItems[item].total;
                        }
                    }
                } else if (discountObj.type === 'bakery') {
                    for (var item in cartItems) {
                        if (cartItems[item].type === 'bakery') {
                            totalForDiscount += cartItems[item].total;
                        }
                    }
                } else if (discountObj.type === 'drinks') {
                    for (var item in cartItems) {
                        if (cartItems[item].type === 'drinks') {
                            totalForDiscount += cartItems[item].total;
                        }
                    }
                } else {
                    totalForDiscount += parseFloat(Number(this.cartSubtotal()));
                }
                var discountTotal = Number((totalForDiscount * discountObj.discount) / 100);
            }
        }
        return discountTotal;
    };
    obj.clearSpecialDiscount = function () {
        localStorage.removeItem("specialDiscount-" + eposCurrentOrderId);
    };
    obj.cartCalculator = function () {
        var calculationFor = new Array();
        var cartSubtotal = this.cartSubtotal();
        var cartTaxTotal = this.cartTax();
        var cartccFee = this.getccFee();
        var cartcbFee = this.getcbFee();
        var deliveryCharge = this.getDeliveryCharge();
        var serviceCharge = this.cartServiceCharge();
        var specialDiscount = this.cartSpecialDiscountTotal();
        var cartMultiDiscountAmount = this.cartMultiDiscount();
        var cartPromoDiscountAmount = this.cartPromoDiscount();
        var Total = 0;
        Total += (cartSubtotal + cartTaxTotal + cartccFee + cartcbFee + serviceCharge + deliveryCharge) - (specialDiscount + cartPromoDiscountAmount + cartMultiDiscountAmount);
        calculationFor.cartSubtotal = cartSubtotal;
        calculationFor.cartTaxTotal = cartTaxTotal;
        calculationFor.cartccFee = cartccFee;
        calculationFor.cartcbFee = cartcbFee;
        calculationFor.deliveryCharge = deliveryCharge;
        calculationFor.serviceCharge = serviceCharge;
        calculationFor.specialDiscount = specialDiscount;
        calculationFor.cartMultiDiscountAmount = cartMultiDiscountAmount;
        calculationFor.cartPromoDiscountAmount = cartPromoDiscountAmount;
        calculationFor.Total = Total;
        return calculationFor;
    };
    obj.changeToInPrice = function () {
        if (cart.length > 0) {
            for (var i in cart) {
                cart[i].price = Number(cart[i].inPrice) > 0 ? cart[i].inPrice : cart[i].basePrice;
                cart[i].total = (cart[i].price * cart[i].qty);
                var itemToppingTotal = 0;
                if (cart[i].Topping.length > 0) {
                    for (var t in cart[i].Topping) {
                        cart[i].Topping[t].total = (cart[i].Topping[t].price) * cart[i].Topping[t].qty;
                        itemToppingTotal += Number(cart[i].Topping[t].total);
                    }
                }
                cart[i].total += itemToppingTotal;
                saveCart();
                loadCart();
            }
        }
    };
    obj.changeToOutPrice = function () {
        if (cart.length > 0) {
            for (var i in cart) {
                cart[i].price = Number(cart[i].outPrice) > 0 ? cart[i].outPrice : cart[i].basePrice;
                cart[i].total = (cart[i].price * cart[i].qty);
                var itemToppingTotal = 0;
                if (cart[i].Topping.length > 0) {
                    for (var t in cart[i].Topping) {
                        cart[i].Topping[t].total = (cart[i].Topping[t].price) * cart[i].Topping[t].qty;
                        itemToppingTotal += Number(cart[i].Topping[t].total);
                    }
                }
                cart[i].total += itemToppingTotal;
                saveCart();
                loadCart();
            }
        }
    };
    obj.resetAuxiliaryPrams = function () {
        this.clearDeliveryCharge();
        this.clearServiceCharge();
        this.clearSpecialDiscount();
        this.clearccFee();
        this.clearDiscountMulti();
        this.clearPromoDiscountPlan();
        this.clearItemOffer();
    };
    obj.resetOnConvert = function () {
        this.clearDeliveryCharge();
        this.clearServiceCharge();
        this.clearSpecialDiscount();
        this.clearDiscountMulti();
        this.clearPromoDiscountPlan();
        this.clearItemOffer();
    };
    obj.setOnConvert = function () {
        this.setPromoDiscountPlan();
        this.setDiscountmulti();
        this.setItemOffer();
    };
    obj.setAuxiliaryPrams = function () {

    };
    obj.addPayment = function (id, type, amount, code) {
        if (payments.length > 0) {
            for (var i in payments) {
                if (payments[i].id === id && payments[i].type === type) {
                    payments[i].amount += Number(amount);
                    savePayments();
                    loadPayments();
                    return i;
                }
            }
        }
        var paymentData = new payment(id, type, Number(amount), code);
        payments.push(paymentData);
        savePayments();
        loadPayments();
        return payment;
    };
    obj.deletePayment = function (id, type) {
        var deletedPaymentId = null;
        if (payments.length > 0) {
            for (var i in payments) {
                if (payments[i].id === id && payments[i].type === type) {
                    deletedPaymentId = payments[i].id;
                    payments.splice(i, 1);
                }
            }
            savePayments();
            loadPayments();
            return deletedPaymentId;
        }
    };
    obj.listpayments = function () {
        if (payments.length > 0) {
            var paymentsCopy = [];
            for (var i in payments) {
                var item = payments[i];
                var itemCopy = {};
                for (var p in item) {
                    itemCopy[p] = item[p];
                }
                paymentsCopy.push(itemCopy);
            }
            return paymentsCopy;
        } else {
            return [];
        }
    };
    obj.clearPayments = function () {
        payments = [];
        localStorage.removeItem("EposCartPayments-" + eposCurrentOrderId);
    };
    obj.removeCurrentCartOnPayAdnClose = function () {
        localStorage.removeItem("EposCart-" + eposCurrentOrderId);
    };
    obj.clearOnPayAndClose = function () {
        cart = [];
        itemAttrs = [];
        itemMods = [];
        dealSetItems = [];
        payments = [];
        this.removeCurrentCartOnPayAdnClose();
        this.clearNewQty();
        this.clearPayments();
        this.clearDeliveryCharge();
        this.clearServiceCharge();
        this.clearSpecialDiscount();
        this.clearccFee();
        this.clearcbFee();
        this.clearDiscountMulti();
        this.clearPromoDiscountPlan();
        this.clearItemOffer();
        this.clearItemOfferExitParam();
        this.clearEposCurrentId();

    };
    obj.clearOnPayAndCloseForUnsentOrder = function () {
        itemAttrs = [];
        itemMods = [];
        dealSetItems = [];
        payments = [];
        this.clearPayments();
    };
    obj.clearOnPayAndCloseForSentInOrder = function () {
        itemAttrs = [];
        itemMods = [];
        dealSetItems = [];
        payments = [];
        this.clearPayments();
    };
    obj.setUserData = function (userData) {
        sessionStorage.setItem('userData', JSON.stringify(userData));
    };
    obj.getUserData = function () {
        return JSON.parse(sessionStorage.getItem('userData'));
    };
    obj.isUserLoggedIn = function () {
        var user = this.getUserData();
        if (!jQuery.isEmptyObject(user) || user !== null) {
            return user.owner !== false && user.manager !== false && user.manager !== false;
        } else {
            return false;
        }
    };
    obj.userLoggedOut = function () {
        sessionStorage.removeItem('userData');
        return !this.isUserLoggedIn();
    };
    return obj;
})();




