
(function ($) {

    function appendContent($el, content) {
        if (!content)
            return;
        $el.append(content.jquery ? content.clone() : content);
    }

    function appendBody($body, $element, opt) {
        var $content = $element.clone(opt.formValues);
        if (opt.formValues) {
            copyValues($element, $content, 'select, textarea');
        }
        if (opt.removeScripts) {
            $content.find('script').remove();
        }

        if (opt.printContainer) {
            $content.appendTo($body);
        } else {
            $content.each(function () {
                $(this).children().appendTo($body)
            });
        }
    }

    function copyValues(origin, clone, elementSelector) {
        var $originalElements = origin.find(elementSelector);
        clone.find(elementSelector).each(function (index, item) {
            $(item).val($originalElements.eq(index).val());
        });
    }

    var opt;
    $.fn.printThis = function (options) {
        opt = $.extend({}, $.fn.printThis.defaults, options);
        var $element = this instanceof jQuery ? this : $(this);
        var strFrameName = "printThis-" + (new Date()).getTime();
        if (window.location.hostname !== document.domain && navigator.userAgent.match(/msie/i)) {
            var iframeSrc = "javascript:document.write(\"<head><script>document.domain=\\\"" + document.domain + "\\\";</s" + "cript></head><body></body>\")";
            var printI = document.createElement('iframe');
            printI.name = "printIframe";
            printI.id = strFrameName;
            printI.className = "MSIE";
            document.body.appendChild(printI);
            printI.src = iframeSrc;

        } else {
            var $frame = $("<iframe id='" + strFrameName + "' name='printIframe' />");
            $frame.appendTo("body");
        }
        var $iframe = $("#" + strFrameName);
        if (!opt.debug)
            $iframe.css({
                position: "absolute",
                width: "0px",
                height: "0px",
                left: "-600px",
                top: "-600px"
            });

        setTimeout(function () {
            function setDocType($iframe, doctype) {
                var win, doc;
                win = $iframe.get(0);
                win = win.contentWindow || win.contentDocument || win;
                doc = win.document || win.contentDocument || win;
                doc.open();
                doc.write(doctype);
                doc.close();
            }
            if (opt.doctypeString) {
                setDocType($iframe, opt.doctypeString);
            }
            var $doc = $iframe.contents(),
                    $head = $doc.find("head"),
                    $body = $doc.find("body"),
                    $base = $('base'),
                    baseURL;

            if (opt.base === true && $base.length > 0) {
                baseURL = $base.attr('href');
            } else if (typeof opt.base === 'string') {
                baseURL = opt.base;
            } else {
                baseURL = document.location.protocol + '//' + document.location.host;
            }

            $head.append('<base href="' + baseURL + '">');
            if (opt.importCSS)
                $("link[rel=stylesheet]").each(function () {
                    var href = $(this).attr("href");
                    if (href) {
                        var media = $(this).attr("media") || "all";
                        $head.append("<link type='text/css' rel='stylesheet' href='" + href + "' media='" + media + "'>");
                    }
                });
            if (opt.importStyle)
                $("style").each(function () {
                    $(this).clone().appendTo($head);
                });
            if (opt.pageTitle)
                $head.append("<title>" + opt.pageTitle + "</title>");

            if (opt.loadCSS) {
                if ($.isArray(opt.loadCSS)) {
                    jQuery.each(opt.loadCSS, function (index, value) {
                        $head.append("<link type='text/css' rel='stylesheet' href='" + this + "'>");
                    });
                } else {
                    $head.append("<link type='text/css' rel='stylesheet' href='" + opt.loadCSS + "'>");
                }
            }
            var tag = opt.copyTagClasses;
            if (tag) {
                tag = tag === true ? 'bh' : tag;
                if (tag.indexOf('b') !== -1) {
                    $body.addClass($('body')[0].className);
                }
                if (tag.indexOf('h') !== -1) {
                    $doc.find('html').addClass($('html')[0].className);
                }
            }
            appendContent($body, opt.header);
            if (opt.canvas) {
                var canvasId = 0;
                $element.find('canvas').addBack('canvas').each(function () {
                    $(this).attr('data-printthis', canvasId++);
                });
            }

            appendBody($body, $element, opt);

            if (opt.canvas) {
                $body.find('canvas').each(function () {
                    var cid = $(this).data('printthis'),
                            $src = $('[data-printthis="' + cid + '"]');
                    this.getContext('2d').drawImage($src[0], 0, 0);
                    $src.removeData('printthis');
                });
            }
            if (opt.removeInline) {
                if ($.isFunction($.removeAttr)) {
                    $doc.find("body *").removeAttr("style");
                } else {
                    $doc.find("body *").attr("style", "");
                }
            }
            appendContent($body, opt.footer);
            setTimeout(function () {
                if ($iframe.hasClass("MSIE")) {
                    window.frames["printIframe"].focus();
                    $head.append("<script>  window.print(); </s" + "cript>");
                } else {
                    if (document.queryCommandSupported("print")) {
                        $iframe[0].contentWindow.document.execCommand("print", false, null);
                    } else {
                        $iframe[0].contentWindow.focus();
                        $iframe[0].contentWindow.print();
                    }
                }
                if (!opt.debug) {
                    setTimeout(function () {
                        $iframe.remove();
                    }, 1000);
                }

            }, opt.printDelay);
        }, 333);

    };

    $.fn.printThis.defaults = {
        debug: false, // show the iframe for debugging
        importCSS: true, // import parent page css
        importStyle: false, // import style tags
        printContainer: true, // print outer container/$.selector
        loadCSS: "", // load an additional css file - load multiple stylesheets with an array []
        pageTitle: "", // add title to print page
        removeInline: false, // remove all inline styles
        printDelay: 333, // variable print delay
        header: null, // prefix to html
        footer: null, // postfix to html
        formValues: true, // preserve input/form values
        canvas: false, // copy canvas content (experimental)
        base: false, // preserve the BASE tag, or accept a string for the URL
        doctypeString: '<!DOCTYPE html>', // html doctype
        removeScripts: false, // remove script tags before appending
        copyTagClasses: false   // copy classes from the html & body tag
    };
})(jQuery);
