$.fn.extend({
    suggest: function (options) {
        var suggestedAddresses = [];
        const input = this;
        var selectedAddressIndex = -1;
        const fields = options || {
            label: "Formatted address",
            street_number_input: {
                id: "number",
                label: "Street number"
            },
            street_name_input: {
                id: "street",
                label: "Street"
            },
            zip_input: {
                id: "zip",
                label: "Zip code"
            },
            town_input: {
                id: "town",
                label: "Town"
            },
            department_input: {
                id: "department",
                label: "Department"
            },
            region_input: {
                id: "region",
                label: "Region"
            },
            country_input: {
                id: "country",
                label: "Country"
            }
        };
        $("<div class=\"suggestions-container\" id=\"suggestions-container\"></div>").insertAfter(input);
        for (var key in fields) {
            $("label[for = '" + fields[key].id + "']").html(fields[key].label);
        }
        $("label[for = '" + input.attr('id') + "']").html(fields.label);
        $(input).on("input", function () {
            selectedAddressIndex = -1;
            var addressList = new Array();
            var incomingStringArray = SplitTheString(this.value);
            var incomingDoorNumber = null;
            var incomingPostalCode = null;
            if (incomingStringArray.length > 1) {
                incomingPostalCode = incomingStringArray[0];
                incomingDoorNumber = incomingStringArray[1];
            } else {
                incomingPostalCode = incomingStringArray[0];
            }
            if ($.trim(incomingPostalCode) && !$.trim(incomingDoorNumber)) {
                var limit = 10;
                if (formatPostcode(incomingPostalCode)) {
                    incomingPostalCode = formatPostcode(incomingPostalCode)
                    limit = 100;
                }
                zamanEposDb.epos_ldooraddress.where('postal_code').startsWithIgnoreCase(incomingPostalCode).limit(limit).toArray(function (doors) {
                    doors.forEach(function (aDoor) {
                        var oneAddress = {};
                        oneAddress.address_components = aDoor;
                        var formatted_address = '';
                        if ($.trim(aDoor.postal_town)) {
                            formatted_address += aDoor.street_number + ', ' + aDoor.route + ', ' + aDoor.postal_town + ', ' + aDoor.administrative_area_level_2 + ', ' + aDoor.postal_code;
                        } else {
                            formatted_address += aDoor.street_number + ' ' + aDoor.route + ', ' + aDoor.administrative_area_level_2 + ', ' + aDoor.postal_code;
                        }
                        oneAddress.formatted_address = formatted_address;
                        addressList.push(oneAddress);
                    });
                    if (addressList.length) {
                        suggestedAddresses = extract(addressList);
                        $(".suggestions-container").html(format(suggestedAddresses));
                        $(".suggestions-container").show();
                        $("div.suggestions-container-row").hover(function () {
                            selectedAddressIndex = $(this).attr("data-index");
                            $(input).val(suggestedAddresses[selectedAddressIndex].formatted);
                            $(this).focus();
                        }).click(function () {
                            selectedAddressIndex = $(this).attr("data-index");
                            $(input).val(suggestedAddresses[selectedAddressIndex].formatted);
                            fillFields(fields);
                            $(".suggestions-container").hide();
                        });
                    } else {
                        $(".suggestions-container").hide();
                    }

                });
            }
            if ($.trim(incomingPostalCode) && $.trim(incomingDoorNumber)) {
                zamanEposDb.epos_ldooraddress.filter(function (anAddress) {
                    if ($.trim(incomingDoorNumber)) {
                        return anAddress.postal_code === formatPostcode(incomingPostalCode) && (anAddress.street_number).toLowerCase() === (incomingDoorNumber.toString()).toLowerCase();
                    } else {
                        return anAddress.postal_code === formatPostcode(incomingPostalCode);
                    }
                }).limit(1).toArray().then(function (doors) {
                    doors.forEach(function (aDoor) {
                        var oneAddress = {};
                        oneAddress.address_components = aDoor;
                        var formatted_address = '';
                        if ($.trim(aDoor.postal_town)) {
                            formatted_address += aDoor.street_number + ', ' + aDoor.route + ', ' + aDoor.postal_town + ', ' + aDoor.administrative_area_level_2 + ', ' + aDoor.postal_code;
                        } else {
                            formatted_address += aDoor.street_number + ' ' + aDoor.route + ', ' + aDoor.administrative_area_level_2 + ', ' + aDoor.postal_code;
                        }
                        oneAddress.formatted_address = formatted_address;
                        addressList.push(oneAddress);
                    });
                    if (addressList.length) {
                        suggestedAddresses = extract(addressList);
                        $(".suggestions-container").html(format(suggestedAddresses));
                        $(".suggestions-container").show();
                        $("div.suggestions-container-row").hover(function () {
                            selectedAddressIndex = $(this).attr("data-index");
                            $(input).val(suggestedAddresses[selectedAddressIndex].formatted);
                            $(this).focus();
                        }).click(function () {
                            selectedAddressIndex = $(this).attr("data-index");
                            $(input).val(suggestedAddresses[selectedAddressIndex].formatted);
                            fillFields(fields);
                            $(".suggestions-container").hide();
                        });
                    } else {
                        $(".suggestions-container").hide();
                    }
                });
            }
        });
        $(document).keydown(function (e) {
            switch (e.which) {
                case 38:
                {
                    if (selectedAddressIndex > 0) {
                        selectedAddressIndex--;
                    }
                    if (suggestedAddresses.length >= 1) {
                        $(input).val(suggestedAddresses[selectedAddressIndex].formatted);
                        fillFields(fields);
                    }
                    $("#address_" + selectedAddressIndex).focus();
                    break;
                }
                case 40:
                {
                    if (selectedAddressIndex < suggestedAddresses.length - 1) {
                        selectedAddressIndex++;
                    }
                    if (suggestedAddresses.length >= 1) {
                        $(input).val(suggestedAddresses[selectedAddressIndex].formatted);
                        fillFields(fields);
                    }
                    $("#address_" + selectedAddressIndex).focus();
                    break;
                }
                case 13:
                {
                    fillFields(fields);
                    $(".suggestions-container").hide();
                    break;
                }
                case 27:
                {
                    fillFields(fields);
                    $(".suggestions-container").hide();
                    break;
                }
                default:
                    return;
            }
            e.preventDefault();
        });
        function fillFields(fields) {
            if (selectedAddressIndex >= 0) {
                $("#" + fields.street_number_input.id).val(suggestedAddresses[selectedAddressIndex].detail.number);
                $("#" + fields.street_name_input.id).val(suggestedAddresses[selectedAddressIndex].detail.street);
                $("#" + fields.zip_input.id).val(suggestedAddresses[selectedAddressIndex].detail.zip);
                $("#" + fields.town_input.id).val(suggestedAddresses[selectedAddressIndex].detail.town);
                $("#" + fields.department_input.id).val(suggestedAddresses[selectedAddressIndex].detail.department);
                $("#" + fields.region_input.id).val(suggestedAddresses[selectedAddressIndex].detail.region);
                $("#" + fields.country_input.id).val(suggestedAddresses[selectedAddressIndex].detail.country);
            }
        }
        function format(suggestedAddresses) {
            var htmlGlobal = "";
            suggestedAddresses.forEach(function (address, index) {
                var htmlCurrent = "";
                htmlCurrent += "<div class=\"suggestions-container-row\" tabindex=\"" + index + "\" id=\"address_" + index + "\" data-index=\"" + index + "\">";
                htmlCurrent += address.formatted;
                htmlCurrent += "</div>";
                htmlGlobal += htmlCurrent;
            });
            return htmlGlobal;
        }
        function extract(receivedAddresses) {
            var suggestedAddresses = [];
            receivedAddresses.forEach(function (object) {
                var address = {};
                address.formatted = object.formatted_address;
                var component = object.address_components;
                address.detail = {};
                address.detail.number = component.street_number;
                address.detail.street = component.route;
                if ($.trim(component.postal_town)) {
                    address.detail.street += ', ' + component.postal_town;
                }
                address.detail.town = component.postal_town;
                address.detail.department = component.administrative_area_level_2;
                address.detail.region = component.administrative_area_level_1;
                address.detail.country = component.country;
                address.detail.zip = component.postal_code;
                suggestedAddresses.push(address);
            });
            return suggestedAddresses;
        }
    }
});
function SplitTheString(CommaSepStr) {
    var ResultArray = new Array();
    if (CommaSepStr !== null) {
        var SplitChars = ',';
        if (CommaSepStr.indexOf(SplitChars) >= 0) {
            ResultArray = CommaSepStr.split(SplitChars);
        } else {
            ResultArray.push(CommaSepStr);
        }
    }
    return ResultArray;
}
