(function ($) {
    $.confirm = function (params) {
        if ($('#confirmOverlay').length) {
            return false;
        }
        var buttonHTML = '<div class="tab-group">';
        $.each(params.buttons, function (name, obj) {
            buttonHTML += '<a href="#" class="confirm-button tab-item ' + obj['class'] + '">' + name + '<span></span></a>';
            if (!obj.action) {
                obj.action = function () {
                };
            }
        });
        buttonHTML += '</div>';
        var markup = [
            '<div id="confirmOverlay">',
            '<div id="confirmBox">',
            '<h1>', params.title, '</h1>',
            '<p>', params.message, '</p>',
            '<div id="confirmButtons">',
            buttonHTML,
            '</div></div></div>'
        ].join('');

        $(markup).hide().appendTo('body').fadeIn();

        var buttons = $('#confirmBox .confirm-button '),
                i = 0;
        $.each(params.buttons, function (name, obj) {
            buttons.eq(i++).click(function () {
                obj.action();
                $.confirm.hide();
                return false;
            });
        });
    }
    $.confirm.hide = function () {
        $('#confirmOverlay').fadeOut(function () {
            $(this).remove();
        });
    }
})(jQuery);

$.fn.clearForm = function () {
    return this.each(function () {
        var type = this.type, tag = this.tagName.toLowerCase();
        if (tag == 'form') {
            return $(':input', this).clearForm();
        }
        if (type == 'text' || type == 'password' || tag == 'textarea') {
            this.value = '';
        } else if (type == 'hidden') {
            this.value = '';
        } else if (type == 'checkbox' || type == 'radio') {
            //this.checked = true;
        } else if (tag == 'select') {
            this.selectedIndex = -1;
        }
    });
};
var EnglishBanglaDigitsMap = {'0': '০', '1': '১', '2': '২', '3': '৩', '4': '৪', '5': '৫', '6': '৬', '7': '৭', '8': '৮', '9': '৯'};
String.prototype.getBanglaDigit = function () {
    var returnStr = this;
    for (var x in EnglishBanglaDigitsMap) {
        returnStr = returnStr.replace(new RegExp(x, 'g'), EnglishBanglaDigitsMap[x]);
    }
    return returnStr;
};
/*Example*/
//var strEnglishNumber = '12,345.67890';  
//console.log(strEnglishNumber.getBanglaDigit());
/** Example End**/


/*----------Custom Alert---------------------*/
//Start Custom Alert System
var ALERT_TITLE = "Oops!";
var ALERT_BUTTON_TEXT = "Ok";
if (document.getElementById) {
    window.alert = function (txt) {
        zamanCustomAlert(txt);
    }
}
function zamanCustomAlert(txt) {
    d = document;
    if (d.getElementById("modalContainer"))
        return;

    mObj = d.getElementsByTagName("body")[0].appendChild(d.createElement("div"));
    mObj.id = "modalContainer";
    mObj.style.height = d.documentElement.scrollHeight + "px";
    alertObj = mObj.appendChild(d.createElement("div"));
    alertObj.id = "alertBox";
    alertObj.style.top = '30%';
    alertObj.style.left = (d.documentElement.scrollWidth - alertObj.offsetWidth) / 2 + "px";
    alertObj.style.visiblity = "visible";
    h1 = alertObj.appendChild(d.createElement("h1"));
    h1.appendChild(d.createTextNode(ALERT_TITLE));
    msg = alertObj.appendChild(d.createElement("p"));
    msg.innerHTML = txt;
    btn = alertObj.appendChild(d.createElement("a"));
    btn.id = "closeBtn";
    btn.appendChild(d.createTextNode(ALERT_BUTTON_TEXT));
    btn.href = "#";
    btn.focus();
    btn.onclick = function () {
        removeCustomAlert();
        return false;
    };
    alertObj.style.display = "block";
}

function removeCustomAlert() {
    document.getElementsByTagName("body")[0].removeChild(document.getElementById("modalContainer"));
}

/*----------End Of Custom Alert---------------*/

function ZamanEposClock(id) {
    var date = new Date();
    document.getElementById(id).innerHTML = date.toLocaleTimeString();
    setTimeout('ZamanEposClock("' + id + '");', '1000');
    return true;
}
if ($('#ZamanEposClock').length > 0) {
    window.onload = ZamanEposClock('ZamanEposClock');
}

function zamanAlphaPad(inputFiledId, alphaKey, alphaActionKey) {
    jQuery('.' + alphaKey).click(function (event) {
        var numBox = document.getElementById(inputFiledId);
        numBox.value = numBox.value + this.innerHTML;
        playBeepSound();
        event.stopPropagation();
    });
    $('.' + alphaActionKey).click(function (event) {
        if (this.innerHTML == 'DEL') {
            var numBox = document.getElementById(inputFiledId);
            if (numBox.value.length > 0) {
                numBox.value = numBox.value.substring(0, numBox.value.length - 1);
            }
        } else {
            document.getElementById(inputFiledId).value = '';
        }
        playBeepSound();
        event.stopPropagation();
    });
}

function zamanPrimaryNumpad(inputFiledId, numKey, actionKey) {
    jQuery('.' + numKey).click(function (event) {
        var numBox = document.getElementById(inputFiledId);
        numBox.value = numBox.value + this.innerHTML;
        playBeepSound();
        event.stopPropagation();
    });
    $('.' + actionKey).click(function (event) {
        if (this.innerHTML == 'DEL') {
            var numBox = document.getElementById(inputFiledId);
            if (numBox.value.length > 0) {
                numBox.value = numBox.value.substring(0, numBox.value.length - 1);
            }
        } else {
            document.getElementById(inputFiledId).value = '';
            if ($('#eposUserNames').length > 0) {
                document.getElementById('eposUserNames').value = '';
            }
            if ($('#eposUserId').length > 0) {
                document.getElementById('eposUserId').value = '';
            }
            if ($('#eposUserEmployeeId').length > 0) {
                document.getElementById('eposUserEmployeeId').value = '';
            }
            if ($('#eposUsername').length > 0) {
                document.getElementById('eposUsername').value = '';
            }
            if ($('#eposUserEmail').length > 0) {
                document.getElementById('eposUserEmail').value = '';
            }
        }
        playBeepSound();
        event.preventDefault();

    });
}
function zamanSecondaryNumpad(inputFiledId, numKey, actionKey) {
    jQuery('.' + numKey).click(function (event) {
        var numBox = document.getElementById(inputFiledId);
        numBox.value = numBox.value + this.innerHTML;
        playBeepSound();
        event.preventDefault();
    });
    $('.' + actionKey).click(function (event) {
        if (this.innerHTML == 'DEL') {
            var numBox = document.getElementById(inputFiledId);
            if (numBox.value.length > 0) {
                numBox.value = numBox.value.substring(0, numBox.value.length - 1);
            }
        } else {
            document.getElementById(inputFiledId).value = '';

        }
        playBeepSound();
        event.preventDefault();
    });
}
function confirm() {
    $.confirm({
        title: 'Title',
        message: 'Message',
        buttons: {
            'Yes': {
                'class': 'btn btn-primary',
                'action': function () {
                }
            },
            'No': {
                'class': 'btn btn-positive',
                'action': function () {
                }
            },
            'Cancel': {
                'class': 'btn btn-negative',
                'action': function () {
                }
            }
        }
    });
}
function warning(title, message, btnTxt) {
    ALERT_TITLE = title;
    ALERT_BUTTON_TEXT = btnTxt;
    playBeepSound();
    alert(message);
    $('.page-loader').hide();
}

function idleLogout() {
    var t;
    window.onload = resetTimer;
    window.onmousemove = resetTimer;
    window.onmousedown = resetTimer; // catches touchscreen presses
    window.onclick = resetTimer;     // catches touchpad clicks
    window.onscroll = resetTimer;    // catches scrolling with arrow keys
    window.onkeypress = resetTimer;
    function logout() {
        window.location.reload();
    }
    function resetTimer() {
        clearTimeout(t);
        t = setTimeout(logout, 900000);  // time is in milliseconds
    }
}
function zamanKeyboardInitiator() {
    if ($('#Keyboard').length > 0) {
        keyboard('Keyboard');
    }
    if ($('#ConfigurationKeyboard').length > 0) {
        keyboard('ConfigurationKeyboard');
    }
    if ($('#zamanAlphaKeyboard').length > 0) {
        zamanAlphaPad('zamanAlphaKeyboard');
    }
    if ($('#zamanPrimaryNumpad').length > 0) {
        zamanPrimaryNumpad('zamanPrimaryNumpad');
    }
    if ($('#zamanSecondaryNumpad').length > 0) {
        zamanSecondaryNumpad('zamanSecondaryNumpad');
    }
}
function zamanToogleEposVirtualKeyboard(keyboardClass) {
    if ($('.' + keyboardClass).attr('id')) {
        $('#Keyboard').empty();
        $('#Keyboard').removeAttr('id');
        $('.' + keyboardClass).hide();
    } else {
        $('.' + keyboardClass).attr('id', 'Keyboard');
        $('.' + keyboardClass).show();
        if ($('#Keyboard').is(":visible")) {
            keyboard('Keyboard');
            $('#keyboardHeader').html('<p class="text-center"><span class="icon icon-cancel" onclick="zamanToogleEposVirtualKeyboard(\'' + keyboardClass + '\')">&nbsp;Close</span></p>');
        }
    }
}
function ShowPhonePad() {
    if ($('#Keyboard').length > 0) {
        $('#Keyboard').empty();
        $('#Keyboard').removeAttr('id');
    }
    if ($('.deliveryExtraTimePad').length > 0) {
        $('.deliveryExtraTimePad').hide();
    }
    $('.commonPhonePadForCustomer').show();
    $('.commonPhonePadForCustomer').closest('input[type=text]').focus();
}
function showTimeNumpad() {
    if ($('#Keyboard').length > 0) {
        $('#Keyboard').empty();
        $('#Keyboard').removeAttr('id');
    }
    if ($('.commonPhonePadForCustomer').length > 0) {
        $('.commonPhonePadForCustomer').hide();
    }
    $('.deliveryExtraTimePad').show();
    $('.deliveryExtraTimePad').closest('input[type=text]').focus();
}
function setTargetKeyboard(show, hide) {
    if ($('.commonPhonePadForCustomer').length > 0) {
        $('.commonPhonePadForCustomer').hide();
    }
    if ($('.' + hide).attr('id')) {
        $('#Keyboard').empty();
        $('#Keyboard').removeAttr('id');
        $('.' + hide).hide();
    }
    if ($('.' + show).attr('id')) {
        $('#Keyboard').empty();
        $('#Keyboard').removeAttr('id');
        $('.' + hide).hide();
    }
    $('.' + show).attr('id', 'Keyboard');
    $('.' + show).show();
    if ($('#Keyboard').is(":visible")) {
        keyboard('Keyboard');
        $('#keyboardHeader').html('<p class="text-center"><span class="icon icon-cancel" onclick="zamanToogleEposVirtualKeyboard(\'' + show + '\')">&nbsp;Close</span></p>');
    }

}
function hideKeyBoard() {
    if ($('#Keyboard').length > 0) {
        $('#Keyboard').hide();
    }
}

function zamanEposToggleKeybord(handler) {
    $(handler).click(function () {
        $('#Keyboard').toggle();
    });
}
function zamanEposBlockHideAndShow(idBlock) {
    $('#' + idBlock).slideToggle('slow');
    $.colorbox.resize();
}

function ZamanEposCheckboxBlockHandler(handler, block) {
    if ($(handler).is(':checked')) {
        $('#' + block).show();
    } else {
        $('#' + block).hide();
    }
}
function ZamanEposRadioBlockHandler(handler, showMe, hideMe) {
    if ($('.' + hideMe).length > 0) {
        $('.' + hideMe).hide();
    }
    if ($(handler).is(':checked')) {
        if ($('#' + showMe).length > 0) {
            $('#' + showMe).show();
        }
    } else {
        if ($('.' + hideMe).length > 0) {
            $('.' + hideMe).hide();
        }
    }
}
function zamanEposPopupcloser() {
    $.colorbox.close();
}
function zamanEposPopupContent(id, width) {
    $.colorbox({
        inline: true,
        scrolling: false,
        href: "#" + id,
        width: width,
        height: 'auto',
        maxWidth: "100%",
        open: true,
        closeButton: false,
        transition: 'none',
        overlayClose: false,
        onOpen: function () {
            $('.page-loader').show();
        },
        onLoad: function () {
        },
        onComplete: function () {
            $('.page-loader').hide();
        },
        onCleanup: function () {
        },
        onClosed: function () {
        }

    });
}

function  switchingToRegiterForm() {
    closeColorbox();
    window.setTimeout(function () {
        openRegisterForm();
    }, 500);
}
function errorPlacement(error, element) {
    var placement = $(element).data('error');
    if (placement) {
        $(placement).append(error)
    } else {
        error.insertAfter(element);
    }
}
function  resetForm(formId) {
    $('#' + formId).clearForm();
}

function additionalValidationMethods() {
    jQuery.validator.addMethod("alphaonly", function (value, element) {
        return this.optional(element) || /^[a-z\s]+$/i.test(value);
    }, "Only alphabetical characters,please ");

    $.validator.addMethod("alphanumeric", function (value, element) {
        return this.optional(element) || /^[\w\-\s]+$/i.test(value);
    }, "Letters, numbers, and underscores only please");

    $.validator.addMethod("nowhitespace", function (value, element) {
        return this.optional(element) || /^\S+$/i.test(value);
    }, "No white space please");

    jQuery.validator.addMethod('phone', function (value, element) {
        return this.optional(element) || value.length > 9 &&
                value.match(/^(((\+44)? ?(\(0\))? ?)|(0))( ?[0-9]{3,4}){3}$/);
    }, 'Please specify a valid phone number');

    $.validator.addMethod("phoneUK", function (phone_number, element) {
        phone_number = phone_number.replace(/\(|\)|\s+|-/g, "");
        return this.optional(element) || phone_number.length > 9 &&
                phone_number.match(/^(?:(?:(?:00\s?|\+)44\s?)|(?:\(?0))(?:\d{2}\)?\s?\d{4}\s?\d{4}|\d{3}\)?\s?\d{3}\s?\d{3,4}|\d{4}\)?\s?(?:\d{5}|\d{3}\s?\d{3})|\d{5}\)?\s?\d{4,5})$/);
    }, "Please specify a valid phone number");

    $.validator.addMethod("postcodeUK", function (value, element) {
        return this.optional(element) || /^((([A-PR-UWYZ][0-9])|([A-PR-UWYZ][0-9][0-9])|([A-PR-UWYZ][A-HK-Y][0-9])|([A-PR-UWYZ][A-HK-Y][0-9][0-9])|([A-PR-UWYZ][0-9][A-HJKSTUW])|([A-PR-UWYZ][A-HK-Y][0-9][ABEHMNPRVWXY]))\s?([0-9][ABD-HJLNP-UW-Z]{2})|(GIR)\s?(0AA))$/i.test(value);
    }, "Please specify a valid UK postcode");

    $.validator.addMethod("username", function (value, element) {
        return this.optional(element) || /^[A-Za-z][a-z0-9\-\s]+$/i.test(value);
    }, "Username must contain only letters, numbers, or dashes.");

    $.validator.addMethod("email", function (value, element) {
        return this.optional(element) || /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/.test(value);
    }, "Please specify valid email addresss");

    $.validator.addMethod("time", function (value, element) {
        return this.optional(element) || /^([01]\d|2[0-3]|[0-9])(:[0-5]\d){1,2}$/.test(value);
    }, "Please enter a valid time, between 00:00 and 23:59");

    $.validator.addMethod("time12h", function (value, element) {
        return this.optional(element) || /^((0?[1-9]|1[012])(:[0-5]\d){1,2}(\ ?[AP]M))$/i.test(value);
    }, "Please enter a valid time in 12-hour am/pm format");

    $.validator.addMethod("dateITA", function (value, element) {
        var check = false,
                re = /^\d{1,2}\/\d{1,2}\/\d{4}$/,
                adata, gg, mm, aaaa, xdata;
        if (re.test(value)) {
            adata = value.split("/");
            gg = parseInt(adata[ 0 ], 10);
            mm = parseInt(adata[ 1 ], 10);
            aaaa = parseInt(adata[ 2 ], 10);
            xdata = new Date(Date.UTC(aaaa, mm - 1, gg, 12, 0, 0, 0));
            if ((xdata.getUTCFullYear() === aaaa) && (xdata.getUTCMonth() === mm - 1) && (xdata.getUTCDate() === gg)) {
                check = true;
            } else {
                check = false;
            }
        } else {
            check = false;
        }
        return this.optional(element) || check;
    }, $.validator.messages.date);
}
function menuAttr(attrType, item, table) {
    var column = null;
    var value = null;
    if (attrType.match('Deal')) {
        if (attrType.match('fixedDeal')) {
            column = 'deal_type';
            if ($('#' + attrType).is(':checked')) {
                value = '3';
            } else {
                value = '0';
            }
        } else if (attrType.match('customDeal')) {
            column = 'deal_type';
            if ($('#' + attrType).is(':checked')) {
                value = '2';
            } else {
                value = '0';
            }
        } else {

        }
    } else {
        if (attrType.match('menuToppings')) {
            column = 'has_topping';
            if ($('#' + attrType).is(':checked')) {
                value = '3';
            } else {
                value = '0';
            }
        } else if (attrType.match('menuModifier')) {
            column = 'has_modifier';
            if ($('#' + attrType).is(':checked')) {
                value = '3';
            } else {
                value = '0';
            }
        } else {

        }
    }
    $.ajax({
        url: baseUrl + 'menu/additional_attributes',
        type: 'POST',
        data: {
            table: table,
            id: $.trim(item),
            column: column,
            value: value
        },
        dataType: 'json',
        beforeSend: function (xhr) {
            $('.loader-' + item).show();
        },
        success: function (response) {
            if (response.status) {
                if (response.itemObj.deal_type === '3') {
                    $('#customDeal-' + item).attr('selected', 'false');
                    $('#customDeal-' + item).attr('disabled', 'disabled');
                    $('#fixedDeal-' + item).removeAttr('disabled');
                    $('#menuToppings-' + item).removeAttr('disabled');
                    $('#menuModifier-' + item).removeAttr('selected');
                }
                if (response.itemObj.deal_type === '2') {
                    $('#menuToppings-' + item).attr('selected', 'false');
                    $('#menuToppings-' + item).attr('disabled', 'disabled');
                    $('#menuModifier-' + item).attr('selected', 'false');
                    $('#menuModifier-' + item).attr('disabled', 'disabled');
                    $('#fixedDeal-' + item).attr('selected', 'false');
                    $('#fixedDeal-' + item).attr('disabled', 'disabled');
                    $('#customDeal-' + item).removeAttr('disabled');
                }

                if (response.itemObj.has_topping === '3') {
                    $('#customDeal-' + item).attr('selected', 'false');
                    $('#customDeal-' + item).attr('disabled', 'disabled');
                    $('#menuToppings-' + item).removeAttr('disabled');
                    $('#menuModifier-' + item).removeAttr('disabled');
                    $('#fixedDeal-' + item).removeAttr('disabled');
                }
                if (response.itemObj.has_modifier === '3') {
                    $('#customDeal-' + item).attr('selected', 'false');
                    $('#customDeal-' + item).attr('disabled', 'disabled');
                    $('#menuToppings-' + item).removeAttr('disabled');
                    $('#menuModifier-' + item).removeAttr('disabled');
                    $('#fixedDeal-' + item).removeAttr('disabled');
                }

                if (response.itemObj.deal_type === '0' && response.itemObj.has_topping === '0' && response.itemObj.has_modifier === '0') {
                    $('#fixedDeal-' + item).removeAttr('disabled');
                    $('#customDeal-' + item).removeAttr('disabled');
                    $('#menuToppings-' + item).removeAttr('disabled');
                    $('#menuModifier-' + item).removeAttr('disabled');
                }
                $('#' + attrType + '-Btn').toggle();
                $('.loader').hide();
            }
        }
    });
}

function attrPopup(containerId, width, category, menu, selection, set, url) {
    $.ajax({
        url: url,
        type: 'POST',
        data: {
            category: $.trim(category),
            menu: $.trim(menu),
            selection: $.trim(selection),
            set: $.trim(set),
        },
        beforeSend: function (xhr) {
            $('.page-loader').show();
        },
        success: function (output) {
            $('#popupContentHolder').html(output);
            if ($('#' + containerId).length > 0) {
                zamanEposPopupContent(containerId, width);
            }
            $('.page-loader').hide();
        }
    });
}
function decrementAttrQty34(qtyField, attCatmax, AttrCatcurrentQty) {
    if (document.getElementById(qtyField).value - 1 < 1)
        return;
    else
        document.getElementById(qtyField).value--;
}
function incrementAttrQty34(qtyField, attCatmax, AttrCatCurrentQty) {
    if (document.getElementById(qtyField).value - 1 < 1)
        return;
    else
        document.getElementById(qtyField).value--;
}
/* tests to see if string is in correct UK style postcode: AL1 1AB, BM1 5YZ etc. */
function isValidPostcode(p) {
    var postcodeRegEx = /[A-Z]{1,2}[A-Z0-9]{1,2} ?[0-9][A-Z]{2}/i;
    return postcodeRegEx.test(p);
}
/*	formats a VALID postcode nicely: AB120XY -> AB1 0XY */
function formatPostcode(p) {
    if (isValidPostcode(p)) {
        var postcodeRegEx = /(^[A-Z]{1,2}[A-Z0-9]{1,2})([0-9][A-Z]{2}$)/i;
        var result = p.replace(postcodeRegEx, "$1 $2");
        return result.toUpperCase();
    } else {
        return false;
    }
}
function extractUniqueItemsFromArray(arr) {
    var uniqueArray = arr.filter(function (item, pos) {
        return arr.indexOf(item) === pos;
    });
    return uniqueArray;
}

$(document).ready(function () {
    if ($('#Keyboard').length > 0) {
        $('#Keyboard').removeAttr('id');
    }
    //Table keyboards 
    zamanPrimaryNumpad('zamanPrimaryTableNumber', 'tablePrimaryNumKey', 'tablePrimaryActionKey');
    zamanSecondaryNumpad('zamanSecondaryTableNumber', 'tableSecondaryNumKey', 'tableSecondaryActionKey');
    //Waiting keyboards 
    zamanAlphaPad('waitingCustomerName', 'waitingAlphaKey', 'waitingAlphaActionKey');
    zamanPrimaryNumpad('waitingCustomerPhone', 'waitingPrimaryNumKey', 'waitingPrimaryActionKey');
    //Bar keyboards 
    zamanAlphaPad('barCustomerName', 'barAlphaKey', 'barAlphaActionKey');
    zamanPrimaryNumpad('barCustomerPhone', 'barPrimaryNumKey', 'barPrimaryActionKey');
    //Collection keyboards 
    zamanAlphaPad('collectionCustomerName', 'collectionAlphaKey', 'collectionAlphaActionKey');
    zamanPrimaryNumpad('collectionCustomerPhone', 'collectionPrimaryNumKey', 'collectionPrimaryActionKey');
    zamanSecondaryNumpad('collectionDeliveryTime', 'collectionSecondaryNumKey', 'collectionSecondaryActionKey');
    //Payment keyboard
    zamanPrimaryNumpad('zamanPrimaryPaymentValue', 'paymentPrimaryNumKey', 'paymentPrimaryActionKey');
    zamanSecondaryNumpad('zamanPaymentVoucherCode', 'paymentVoucherNumKey', 'paymentVoucherActionKey');
    zamanPrimaryNumpad('zamanRemotePrimaryPaymentValue', 'remotePaymentPrimaryNumKey', 'remotePaymentPrimaryActionKey');
    zamanSecondaryNumpad('zamanRemotePaymentVoucherCode', 'remotePaymentVoucherNumKey', 'remotePaymentVoucherActionKey');
    //Custom quantity Form keyboard
    zamanPrimaryNumpad('quantityCustomQuantity', 'quantityPrimaryNumKey', 'quantityPrimaryActionKey');
    //ccFee Form Keyboard
    zamanPrimaryNumpad('zamanccFeePrimaryNumpad', 'ccFeePrimaryNumKey', 'ccFeePrimaryActionKey');
    //cbFee Form Keyboard
    zamanPrimaryNumpad('zamancbFeePrimaryNumpad', 'cbFeePrimaryNumKey', 'cbFeePrimaryActionKey');
    //Misc keyboards 
    zamanAlphaPad('miscItemName', 'miscAlphaKey', 'miscAlphaActionKey');
    zamanPrimaryNumpad('miscItemPrice', 'miscPrimaryNumKey', 'miscPrimaryActionKey');
    zamanSecondaryNumpad('miscItemQty', 'miscSecondaryNumKey', 'miscSecondaryActionKey');
    //Topping keyboards 
    zamanAlphaPad('orderCustomToppingName', 'toppingAlphaKey', 'toppingAlphaActionKey');
    zamanPrimaryNumpad('orderCustomToppingPrice', 'toppingPrimaryNumKey', 'toppingPrimaryActionKey');
    zamanSecondaryNumpad('orderCustomToppingQuantity', 'toppingSecondaryNumKey', 'toppingSecondaryActionKey');
    //service charge keyboard 
    zamanPrimaryNumpad('orderServicheChargeAmount', 'serviceChargePrimaryNumKey', 'serviceChargePrimaryActionKey');
    //Special Discount Form 
    zamanPrimaryNumpad('orderSpecialDisocunt', 'specialDiscountPrimaryNumKey', 'specialDiscountPrimaryActionKey');
    //delivery Charge
    zamanPrimaryNumpad('zamanDeliveryChargePrimaryNumpad', 'deliveryChargePrimaryNumKey', 'deliveryChargePrimaryActionKey');
    zamanSecondaryNumpad('zamanCustomDeliveryWaitingTimeOnPopup', 'deliveryWaitingTimePrimaryNumKey', 'deliveryWaitingTimePrimaryActionKey');
    zamanPrimaryNumpad('zamanCustomDeliveryFeeOnPopup', 'customtDeliveryChargePrimaryNumKey', 'customtDeliveryChargePrimaryActionKey');
    zamanSecondaryNumpad('zamanCustomDeliveryMinOrderOnPopup', 'deliveryMinOorderPrimaryNumKeyCustom', 'deliveryMinOorderPrimaryActionKeyCustom');
    zamanPrimaryNumpad('zamanPasscodePrimaryNumpad', 'passCodePrimaryNumKey', 'passCodePrimaryActionKey');
    zamanPrimaryNumpad('eposCallerIdFormCustomerPhone', 'callerStaticPrimaryPhoneNumKey', 'callerStaticPrimaryPhoneActionKey');
    
    
    additionalValidationMethods();
    /*
     if ('serviceWorker' in navigator) {
     if (navigator.serviceWorker.controller) {
     console.log('service worker is enabled');
     } else {
     navigator.serviceWorker.register('./cache-manager.js').then(function (registration) {
     console.log('Registration successful, scope is:', registration.scope);
     }).catch(function (error) {
     console.log('Service worker registration failed, error:', error);
     });
     }
     }*/
});

