/*Application wide helper function*/
$.fn.clearForm = function () {
    return this.each(function () {
        var type = this.type, tag = this.tagName.toLowerCase();
        if (tag == 'form') {
            return $(':input', this).clearForm();
        }
        if (type == 'text' || type == 'password' || tag == 'textarea') {
            this.value = '';
        } else if (type == 'hidden') {
            this.value = '';
        } else if (type == 'checkbox' || type == 'radio') {
            this.checked = false;
        } else if (tag == 'select') {
            this.selectedIndex = -1;
        }
    });
};
function manageCartItemListAreaScroll() {
    if ($('#cartItemListArea').length > 0) {
        $('#cartItemListArea').animate({scrollTop: $('#cartItemListArea')[0].scrollHeight}, 1000);
    }
}
function closePopup() {
    $.colorbox.close();
}
function hasNet() {
    return navigator.onLine ? true : false;
}
function scrollBackTop() {
    $('html, body').animate({scrollTop: 0}, 'slow');
}
function errorPlacement(error, element) {
    var placement = $(element).data('error');
    if (placement) {
        $(placement).append(error);
    } else {
        error.insertAfter(element);
    }
}
function  resetForm(formId) {
    $('#' + formId).clearForm();
}
function additionalValidationMethods() {
    jQuery.validator.addMethod("alphaonly", function (value, element) {
        return this.optional(element) || /^[a-z\s]+$/i.test(value);
    }, "Only alphabetical characters,please ");

    $.validator.addMethod("alphanumeric", function (value, element) {
        return this.optional(element) || /^[\w\-\s]+$/i.test(value);
    }, "Letters, numbers, and underscores only please");

    $.validator.addMethod("nowhitespace", function (value, element) {
        return this.optional(element) || /^\S+$/i.test(value);
    }, "No white space please");

    jQuery.validator.addMethod('phone', function (value, element) {
        return this.optional(element) || value.length > 9 &&
                value.match(/^(((\+44)? ?(\(0\))? ?)|(0))( ?[0-9]{3,4}){3}$/);
    }, 'Invalid phone number');

    $.validator.addMethod("phoneUK", function (phone_number, element) {
        phone_number = phone_number.replace(/\(|\)|\s+|-/g, "");
        return this.optional(element) || phone_number.length > 9 &&
                phone_number.match(/^(?:(?:(?:00\s?|\+)44\s?)|(?:\(?0))(?:\d{2}\)?\s?\d{4}\s?\d{4}|\d{3}\)?\s?\d{3}\s?\d{3,4}|\d{4}\)?\s?(?:\d{5}|\d{3}\s?\d{3})|\d{5}\)?\s?\d{4,5})$/);
    }, "Please specify a valid phone number");

    $.validator.addMethod("postcodeUK", function (value, element) {
        return this.optional(element) || /^((([A-PR-UWYZ][0-9])|([A-PR-UWYZ][0-9][0-9])|([A-PR-UWYZ][A-HK-Y][0-9])|([A-PR-UWYZ][A-HK-Y][0-9][0-9])|([A-PR-UWYZ][0-9][A-HJKSTUW])|([A-PR-UWYZ][A-HK-Y][0-9][ABEHMNPRVWXY]))\s?([0-9][ABD-HJLNP-UW-Z]{2})|(GIR)\s?(0AA))$/i.test(value);
    }, "Please specify a valid UK postcode");

    $.validator.addMethod("username", function (value, element) {
        return this.optional(element) || /^[A-Za-z][a-z0-9\-\s]+$/i.test(value);
    }, "Username must contain only letters, numbers, or dashes.");

    $.validator.addMethod("email", function (value, element) {
        return this.optional(element) || /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/.test(value);
    }, "Invalid email address");

    $.validator.addMethod("time", function (value, element) {
        return this.optional(element) || /^([01]\d|2[0-3]|[0-9])(:[0-5]\d){1,2}$/.test(value);
    }, "Please enter a valid time, between 00:00 and 23:59");

    $.validator.addMethod("time12h", function (value, element) {
        return this.optional(element) || /^((0?[1-9]|1[012])(:[0-5]\d){1,2}(\ ?[AP]M))$/i.test(value);
    }, "Please enter a valid time in 12-hour am/pm format");

    $.validator.addMethod("dateITA", function (value, element) {
        var check = false,
                re = /^\d{1,2}\/\d{1,2}\/\d{4}$/,
                adata, gg, mm, aaaa, xdata;
        if (re.test(value)) {
            adata = value.split("/");
            gg = parseInt(adata[ 0 ], 10);
            mm = parseInt(adata[ 1 ], 10);
            aaaa = parseInt(adata[ 2 ], 10);
            xdata = new Date(Date.UTC(aaaa, mm - 1, gg, 12, 0, 0, 0));
            if ((xdata.getUTCFullYear() === aaaa) && (xdata.getUTCMonth() === mm - 1) && (xdata.getUTCDate() === gg)) {
                check = true;
            } else {
                check = false;
            }
        } else {
            check = false;
        }
        return this.optional(element) || check;
    }, $.validator.messages.date);
}
/*--------------------Modules------------------*/
var zamanDesign = (function () {
    var obj = {};
    obj.fixedHeder = function () {
        var header = document.getElementById("siteHeader");
        var sticky = header.offsetTop;
        if (window.pageYOffset > sticky) {
            header.classList.add("header-sticky");
        } else {
            header.classList.remove("header-sticky");
        }
    };
    obj.columnFixed = function () {
        if (document.getElementsByClassName("column-to-fix").length > 0) {
            var takeawayCategoryNavigation = document.getElementById("takeawayCategoryNavigation");
            var takeawayMenuList = document.getElementById("takeawayMenuList");
            var takeawayCustomerCart = document.getElementById("takeawayCustomerCart");
            if (takeawayCategoryNavigation && takeawayMenuList && takeawayCustomerCart) {
                var sidebarLeftOffset = takeawayCategoryNavigation.offsetTop;
                var sidebarRighttOffset = takeawayCustomerCart.takeawayCustomerCart;
                if (window.pageYOffset > sidebarLeftOffset || window.pageYOffset > sidebarRighttOffset) {
                    takeawayCategoryNavigation.classList.add('takeaway-left-sidebar-sticky');
                    takeawayCustomerCart.classList.add('takeaway-right-sidebar-sticky');
                    takeawayMenuList.classList.add('takeaway-mid-menu-scroll');
                } else {
                    takeawayCategoryNavigation.classList.remove('takeaway-left-sidebar-sticky');
                    takeawayCustomerCart.classList.remove('takeaway-right-sidebar-sticky');
                    takeawayMenuList.classList.remove('takeaway-mid-menu-scroll');
                }
            }
        }
    };
    obj.hidexs = function () {
        var x = window.matchMedia("(min-width: 768px)");
        if (x.matches) {
            $('.hide-xs').show();
        } else {
            $('.hide-xs').hide();
        }
    };
    obj.scrollPosition = function (position) {
        $('html, body').animate({
            scrollTop: parseInt($('#' + position).offset().top - 97)
        }, 500);
    };
    obj.scrollToBottom = function (id) {
        var scrolltArea = document.getElementById(id);
        scrolltArea.scrollTop = scrolltArea.scrollHeight;
    };
    return obj;
})();

var zamanOnlineCart = (function () {
    var toppingArr = [];
    var setItemArr = [];
    function topping(id, title, qty, price, category, set, total) {
        this.id = id;
        this.title = title;
        this.qty = qty;
        this.price = price;
        this.category = category;
        this.set = set;
        this.total = total;
    }
    function setItem(id, title, qty, set, setTitle) {
        this.id = id;
        this.title = title;
        this.qty = qty;
        this.set = set;
        this.setTitle = setTitle;
    }
    function saveTopping() {
        sessionStorage.setItem("Topping", JSON.stringify(toppingArr));
    }
    function saveSetItem() {
        sessionStorage.setItem("setItem", JSON.stringify(setItemArr));
    }
    function loadTopping() {
        toppingArr = JSON.parse(sessionStorage.getItem("Topping"));
        if (toppingArr === null) {
            toppingArr = [];
        }
    }
    function loadSetItem() {
        setItemArr = JSON.parse(sessionStorage.getItem("setItem"));
        if (setItemArr === null) {
            setItemArr = [];
        }
    }
    loadTopping();
    loadSetItem();
    var cartObj = {};
    cartObj.addTopping = function (attrData) {
        for (var i in toppingArr) {
            if (toppingArr[i].id === attrData['id'] && toppingArr[i].category === attrData['category']) {
                toppingArr[i].qty = attrData['qty'];
                toppingArr[i].total = (attrData['total']);
                saveTopping();
                return;
            }
        }
        var item = new topping(
                attrData.id,
                attrData.title,
                attrData.qty,
                attrData.price,
                attrData.category,
                attrData.set,
                attrData.total
                );
        toppingArr.push(item);
        saveTopping();
        loadTopping();
        return true;
    };
    cartObj.addSetItem = function (attrData) {
        for (var i in setItemArr) {
            if (setItemArr[i].id === attrData['id'] && setItemArr[i].set === attrData['set']) {
                setItemArr[i].qty = attrData['qty'];
                saveSetItem();
                loadSetItem();
                return;
            }
        }
        var item = new setItem(
                attrData.id,
                attrData.title,
                attrData.qty,
                attrData.set,
                attrData.setTitle,
                );
        setItemArr.push(item);
        saveSetItem();
        loadSetItem();
        return true;
    };
    cartObj.deleteTopping = function (attrData) {
        for (var i in toppingArr) {
            if (toppingArr[i].id === attrData['id'] && toppingArr[i].category === attrData['category']) {
                if (Number(attrData['qty']) <= 0) {
                    toppingArr.splice(i, 1);
                } else {
                    toppingArr[i].qty = attrData['qty'];
                    toppingArr[i].total = (attrData['total']);
                }
                saveTopping();
                loadTopping();
                return;
            }
        }
    };
    cartObj.deleteSetItem = function (attrData) {
        for (var i in setItemArr) {
            if (setItemArr[i].id === attrData['id'] && setItemArr[i].set === attrData['set']) {
                if (Number(attrData['qty']) <= 0) {
                    setItemArr.splice(i, 1);
                } else {
                    setItemArr[i].qty = attrData['qty'];
                }
                saveSetItem();
                loadSetItem();
                return;
            }
        }
    };
    cartObj.listTopping = function () {
        var listCopy = [];
        for (var i in toppingArr) {
            var item = toppingArr[i];
            var itemCopy = {};
            for (var p in item) {
                itemCopy[p] = item[p];
            }
            listCopy.push(itemCopy);
        }
        return listCopy;
    };
    cartObj.listSetItem = function () {
        var listCopy = [];
        for (var i in setItemArr) {
            var item = setItemArr[i];
            var itemCopy = {};
            for (var p in item) {
                itemCopy[p] = item[p];
            }
            listCopy.push(itemCopy);
        }
        return listCopy;
    };
    cartObj.clearTopping = function () {
        toppingArr = [];
        saveTopping();
        loadTopping();
    };
    cartObj.clearSetItem = function () {
        setItemArr = [];
        saveSetItem();
        loadSetItem();
    };
    return cartObj;
})();


/*Program initialization*/
window.onscroll = function () {
    zamanDesign.fixedHeder();
    var x = window.matchMedia("(min-width: 768px)");
    if (x.matches) {
        zamanDesign.columnFixed();
    }
};
$('document').ready(function () {
    manageCartItemListAreaScroll();
    zamanDesign.hidexs();
    additionalValidationMethods();
    if ($('.gurkha-feature').length > 0) {
        var x = window.matchMedia("(min-width: 768px)");
        if (x.matches) {
            $('.gurkha-feature').hover(function () {
                $(this).find('.gurkha-feature-inner-content').slideDown('slow').show();
            }, function () {
                $(this).find('.gurkha-feature-inner-content').hide();
            });
        }
    }
    var maxWidth = window.matchMedia("(max-width: 767px)");
    if (maxWidth.matches && $('.item-derection-icon').length > 0) {
        $('.item-derection-icon .icon').removeClass('icon-up-open-big');
        $('.item-derection-icon .icon').addClass('icon-down-open-big');
    }
});
