<div class="content">
    <section class="banner-2" id="pageHeaderBanner">
        <div class="container text-center banner-content ">
            <h1 class="text-uppercase common-page-heading page-title-2"><?php echo $current_section ?></h1>
        </div>
    </section>
    <?php if (trim($content)): ?>
        <section class="section-content-half">
            <div class="container">
                <div class="half-page-design">
                    <?php echo $content ?>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <section id="booking" class="common-page-bg-no">
        <div class="container">
            <div class="row">
                <div class="col c8">
                    <div class="sidebar page-left">
                        <div class="booking-form action-form">
                            <div> <?php $this->session->flashdata('success') ? print '<span class="success">' . $this->session->flashdata('success') . '</span>' : print '<strong>Book your table online</strong>' ?></div>
                            <form method="post" action="<?php echo site_url('takeaway/reservation_save') ?>" id="reservationForm">
                                <div class="row join-row-column">
                                    <div class="col c6">
                                        <div class="form-group first">
                                            <label class="btn-block">First Name</label>
                                            <div class="tab-group"><input data-error="#firstNameError" type="text" value="<?php isset($first_name) ? print $first_name : '' ?>"  name="first_name" placeholder="First name" class="smooth"></div>
                                            <div class="error tab-group" id="firstNameError"><?php $this->session->flashdata('first_name') ? print $this->session->flashdata('first_name') : '' ?></div>
                                        </div>
                                    </div>
                                    <div class="col c6">
                                        <div class="form-group second">
                                            <label class="btn-block">Last Name</label>
                                            <div class="tab-group"><input data-error="#lastNameError" type="text" value="<?php isset($last_name) ? print $last_name : '' ?>"  name="last_name" placeholder="Last Name" class="smooth"></div>
                                            <div class="error tab-group" id="lastNameError"><?php $this->session->flashdata('last_name') ? print $this->session->flashdata('last_name') : '' ?></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row join-row-column">
                                    <div class="col c6">
                                        <div class="form-group first">
                                            <label class="btn-block">Email Address</label>
                                            <div class="tab-group"><input data-error="#emailError" type="text" value="<?php isset($email) ? print $email : '' ?>"  name="email" placeholder="Email Address" class="smooth"></div>
                                            <div class="error tab-group" id="emailError"><?php $this->session->flashdata('email') ? print $this->session->flashdata('email') : '' ?></div>
                                        </div>
                                    </div>
                                    <div class="col c6">
                                        <div class="form-group second">
                                            <label class="btn-block">Phone</label>
                                            <div class="tab-group"><input data-error="#phoneError" type="text" value="<?php isset($phone) ? print $phone : '' ?>"  name="phone" placeholder="Phone" class="smooth"></div>
                                            <div class="error tab-group" id="phoneError"><?php $this->session->flashdata('phone') ? print $this->session->flashdata('phone') : '' ?></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row join-row-column">
                                    <div class="col c4">
                                        <div class="form-group first">
                                            <label class="btn-block">Booking Date</label>
                                            <div class="tab-group"><input data-error="#dateError" type="text" id="bookingDate" value="<?php isset($date) ? print $date : '' ?>"  name="date" placeholder="Date" class="smooth"></div>
                                            <div class="error tab-group" id="dateError"><?php $this->session->flashdata('date') ? print $this->session->flashdata('date') : '' ?></div>
                                        </div>
                                    </div>
                                    <div class="col c4">
                                        <div class="form-group first">
                                            <label class="btn-block">Time</label>
                                            <div class="tab-group"><input  data-error="#timeError" type="text" id="bookingTime" value="<?php isset($time) ? print $time : '' ?>"  name="time" placeholder="Time" class="smooth"></div>
                                            <div class="error tab-group" id="timeError"><?php $this->session->flashdata('time') ? print $this->session->flashdata('time') : '' ?></div>
                                        </div>
                                    </div>
                                    <div class="col c4">
                                        <div class="form-group">
                                            <label class="btn-block">Guest Quantity</label>
                                            <div class="tab-group"><input data-error="#guestQtyError" type="number" min="0" value="<?php isset($guest_qty) ? print $guest_qty : print '' ?>"  name="guest_qty" class="smooth"></div>
                                            <div class="error tab-group" id="guestQtyError"><?php $this->session->flashdata('guest_qty') ? print $this->session->flashdata('date') : '' ?></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row join-row-column">
                                    <div class="form-group">
                                        <label class="btn-block">Message</label>
                                        <div class="tab-group"><textarea rows="2" data-error="#noteError" name="note" class="smooth"><?php isset($message) ? print $message : '' ?></textarea></div>
                                        <div class="error tab-group" id="noteError"><?php $this->session->flashdata('message') ? print $this->session->flashdata('message') : '' ?></div>
                                    </div>
                                </div>
                                <div class="join-row-column">
                                    <div class="form-group">
                                        <div class="tab-group"><div class="g-recaptcha btn-block" data-sitekey="<?php echo $restaurantInfo['captchaSiteKey'] ?>"></div></div>
                                        <div class="error" id="grecaptcharesponseError"><?php $this->session->flashdata('g-recaptcha-response') ? print $this->session->flashdata('g-recaptcha-response') : '' ?></div>
                                    </div>
                                </div>
                                <div class="join-row-column clearfix">
                                    <div class="form-group">
                                        <button type="submit" class="btn  btn-c btn-lg btn-block text-center" onclick="submitReservation('reservationForm')">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col c4">
                    <div class="sidebar page-right">
                        <?php echo $this->load->view('components/opening_time') ?>
                        <?php echo $this->load->view('components/offer_dish') ?>
                    </div>
                </div>
            </div>
            <?php echo $this->load->view('components/offer_discount') ?>
        </div>
    </section>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $('#bookingDate').datetimepicker({
            timepicker: false,
            format: 'd/m/Y',
            minDate: '<?php echo date('d/m/Y', strtotime('today')) ?>',
            formatDate: 'd/m/Y'
        });
        $('#bookingTime').datetimepicker({
            datepicker: false,
            format: 'h:i a',
            formatTime: 'h:i a',
            step: 15
        });
    });
</script>
<script type="text/javascript">
    function submitReservation(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (!response.success) {
                            if (response.errors.first_name !== 'undefined') {
                                $('#firstNameError').text(response.errors.first_name);
                            }
                            if (response.errors.last_name !== 'undefined') {
                                $('#lastNameError').text(response.errors.last_name);
                            }
                            if (response.errors.email !== 'undefined') {
                                $('#emailError').text(response.errors.email);
                            }
                            if (response.errors.phone !== 'undefined') {
                                $('#phoneError').text(response.errors.phone);
                            }
                            if (response.errors.date !== 'undefined') {
                                $('#dateError').text(response.errors.date);
                            }
                            if (response.errors.time !== 'undefined') {
                                $('#timeError').text(response.errors.time);
                            }
                            if (response.errors.guest_qty !== 'undefined') {
                                $('#guestQtyError').text(response.errors.guest_qty);
                            }
                            if (response.errors.note !== 'undefined') {
                                $('#noteError').text(response.errors.note);
                            }
                            if (response.errors.grecaptcharesponse !== 'undefined') {
                                $('#grecaptcharesponseError').text(response.errors.grecaptcharesponse);
                            }
                        } else {
                            window.location.href = "<?php echo site_url('reservation') ?>";
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                first_name: {required: true, alphaonly: true},
                last_name: {required: true, alphaonly: true},
                email: {required: true, email: true},
                phone: {required: true, phone: true},
                date: {required: true},
                time: {required: true},
                guest_qty: {required: true, min: 1}
            },
            messages: {
                first_name: "First name is required",
                last_name: 'Last name is required',
                email: "Provide your valid email address",
                phone: 'Your valid phone number',
                date: 'Specify date',
                time: 'Specify time',
                guest_qty: 'Mention guest quantity'
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
</script>