<div class="content">
    <section class="banner-2" id="pageHeaderBanner">
        <div class="container text-center banner-content ">
            <h1 class="text-uppercase common-page-heading page-title-2"><?php echo $current_section ?></h1>
        </div>
    </section>
    <section id="customerAccountIndex" class="common-page-bg-no">
        <div class="container">
            <div class="row">
                <div class="col c3">
                    <?php echo $this->load->view('myaccount/nav') ?>
                </div>
                <div class="col c9">
                    <div class="block-form">
                        <div class="tab-item heading text-left"><span class="icon icon-lock-open">&nbsp;</span>Change Password</div>
                        <?php echo form_open('my-account/password', array('id' => 'CustomerChangePasswordForm')); ?>
                        <div class="form-group">
                            <label class="btn-block">New Password</label>
                            <div class="tab-group"><input data-error="#passwordError" type="password" id="userPassword" name="password" placeholder="New Password" class="smooth"></div>
                            <div class="error tab-group" id="passwordError"></div>
                        </div>
                        <div class="form-group">
                            <label class="btn-block">Confirm New Password</label>
                            <div class="tab-group"><input data-error="#confirmPasswordError" type="password" name="confirm_password" placeholder="Confirm New Password" class="smooth"></div>
                            <div class="error tab-group" id="confirmPasswordError"></div>
                        </div>
                        <div class="msg" id="successMessage" style="display: none;"></div>
                        <div class="join-row-column">
                            <div class="form-group">
                                <button type="submit" class="btn btn-add-to-cart btn-c btn-lg btn-block text-center" onclick="validateCustomerChangePassword('CustomerChangePasswordForm')">Submit</button>
                            </div>
                        </div>
                        <?php echo form_close() ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="v-gap-20"></div>
    </section>
</div>
<script type="text/javascript">
    function validateCustomerChangePassword(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (!response.success) {
                            $('#successMessage').text(response.message).show();
                        } else {
                            $('#successMessage').text(response.message).show();
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                password: {required: true},
                confirm_password: {equalTo: "#userPassword"}
            },
            messages: {
                password: "Your account password is required"
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
    $(document).ready(function () {
        resetForm('CustomerChangePasswordForm');
    });
</script>