<div class="content">
    <section class="banner-2" id="pageHeaderBanner">
        <div class="container text-center banner-content ">
            <h1 class="text-uppercase common-page-heading page-title-2"><?php echo $current_section ?></h1>
        </div>
    </section>
    <section id="customerAccountIndex" class="common-page-bg-no">
        <div class="container">
            <div class="row">
                <div class="col c3">
                    <?php echo $this->load->view('myaccount/nav') ?>
                </div>
                <div class="col c9">
                    <div class="block-form">
                        <div class="tab-item heading text-left"><span class="icon icon-book-open">&nbsp;Order Detail</span></div>
                        <div style="width: 99.5%; margin: 2px;">
                            <?php
                            $orderInfo = unserialize($order['orderInfo']);
                            $orderStatus = array('2' => 'Pending', '3' => 'Accepted', '4' => 'Rejected');
                            $orderStatusColor = array('2' => '#f900ff', '3' => '#009e12', '4' => '#ff0000')
                            ?>
                            <table class="table" style="background: #f2f2f2; padding: 1px;">
                                <tr style="background: #fff;">
                                    <td style="width: 50%; text-align: right; padding-right: 10px;">Ref</td>
                                    <td style="width: 50%; text-align: left; padding-left: 10px;"><?php echo $order['orderId'] . '/' . $order['sid'] ?></td>
                                </tr>
                                <tr style="background: #fff;">
                                    <td style="width: 50%; text-align: right; padding-right: 10px;">Order Type</td>
                                    <td style="width: 50%; text-align: left; padding-left: 10px;text-transform:capitalize"><?php echo $order['type'] ?></td>
                                </tr>
                                <?php if ($order['type'] === 'delivery'): ?>
                                    <tr style="background: #fff;">
                                        <td style="width: 50%; text-align: right; padding-right: 10px;">Customer Name</td>
                                        <td style="width: 50%; text-align: left; padding-left: 10px;"><?php echo $orderInfo['name'] ?></td>
                                    </tr>
                                    <tr style="background: #fff;">
                                        <td style="width: 50%; text-align: right; padding-right: 10px;">Customer Phone</td>
                                        <td style="width: 50%; text-align: left; padding-left: 10px;"><strong class="text-capitalize"><?php echo $orderInfo['phone'] ?></strong></td>
                                    </tr>
                                    <?php
                                    $deliveryAddress = '';
                                    $deliveryAddress .= trim($orderInfo['building']) ? $orderInfo['building'] . ', ' : '';
                                    $deliveryAddress .= trim($orderInfo['sector']) ? $orderInfo['sector'] . ' ' : '';
                                    $deliveryAddress .= trim($orderInfo['street']) ? $orderInfo['street'] . ', ' : '';
                                    $deliveryAddress .= trim($orderInfo['city']) ? $orderInfo['city'] . ', ' : '';
                                    $deliveryAddress .= trim($orderInfo['postcode']) ? $orderInfo['postcode'] : '';
                                    ?>
                                    <tr style="background: #fff;">
                                        <td style="width: 50%; text-align: right; padding-right: 10px;">Address</td>
                                        <td style="width: 50%; text-align: left; padding-left: 10px;"><?php echo $deliveryAddress ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if ($order['type'] === 'collection'): ?>
                                    <tr style="background: #fff;">
                                        <td style="width: 50%; text-align: right; padding-right: 10px;">Restaurant Name</td>
                                        <td style="width: 50%; text-align: left; padding-left: 10px;"><?php echo $this->config->item('general_name') ?></td>
                                    </tr>
                                    <tr style="background: #fff;">
                                        <td style="width: 50%; text-align: right; padding-right: 10px;">Restaurant Phone</td>
                                        <td style="width: 50%; text-align: left; padding-left: 10px;"><?php echo $restaurantInfo['general_phone'] ?></td>
                                    </tr>
                                    <tr style="background: #fff;">
                                        <td style="width: 50%; text-align: right; padding-right: 10px;">Address</td>
                                        <td style="width: 50%; text-align: left; padding-left: 10px;"><?php echo $restaurantInfo['address_street'] ?>, <?php echo $restaurantInfo['address_city'] ?>, <?php echo $restaurantInfo['address_postcode'] ?></td>
                                    </tr>
                                <?php endif; ?>
                                <tr style="background: #fff;">
                                    <td style="width: 50%; text-align: right; padding-right: 10px;">Order Date</td>
                                    <td style="width: 50%; text-align: left; padding-left: 10px;"><?php echo date('d/m/Y h:i A', strtotime($order['created_at'])) ?></td>
                                </tr>

                                <tr style="background: #fff;">
                                    <td style="width: 50%; text-align: right; padding-right: 10px;">Order Status</td>
                                    <td style="width: 50%; text-align: left; padding-left: 10px;"><span style="color: <?php echo $orderStatusColor[$order['status_online']] ?>"><?php echo $orderStatus[$order['status_online']] ?></span>
                                        <?php if ($order['status_online'] == '3'): ?>
                                            &nbsp;[<?php $order['type'] === 'collection' ? print $orderInfo['collectionTime'] : print $orderInfo['deliveryTime'] ?>]</td>
                                    <?php endif; ?>
                                </tr>
                                <tr style="background: #fff;">
                                    <?php $payment = trim($order['payment']) ? unserialize($order['payment']) : array() ?>
                                    <td style="width: 50%; text-align: right; padding-right: 10px;">Payment</td>
                                    <td style="width: 50%; text-align: left; padding-left: 10px;"><?php !empty($payment) ? print $payment[0]['type'] : print 'COD' ?></td>
                                </tr>
                            </table>
                            <table class="table" style="background: #f2f2f2; padding: 1px;">
                                <tr style="background: none;">
                                    <th style="width: 60%">Item</th>
                                    <th style="width: 10%">U.P</th>
                                    <th style="width: 7%">Qty</th>
                                    <th style="width: 23%;text-align: right; padding-right: 3px;">Price</th>
                                </tr>
                                <?php $cart = unserialize($order['cart']) ?>
                                <?php foreach ($cart as $item): ?>
                                    <tr style="background: #fff;">
                                        <td style="width: 60%;text-align: left;padding-left: 3px; ">
                                            <?php echo trim($item['selectionTitle']) ? $item['selectionTitle'] . '-' . $item['menuTitle'] : $item['menuTitle'] ?>
                                            <?php if (!empty($item['setItem']) || !empty($item['Topping'])): ?>
                                                <br/>
                                                <?php if (!empty($item['setItem'])): ?>
                                                    <?php foreach ($item['setItem'] as $aSetItem): ?>
                                                        &nbsp;<span class="icon icon-right-open">&nbsp;<?php echo $aSetItem['qty'] . ' ' . $aSetItem['title'] ?></span><br/>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                                <?php if (!empty($item['Topping'])): ?>
                                                    <?php foreach ($item['Topping'] as $atop): ?>
                                                        <?php if ($atop['total'] > 0): ?>
                                                            &nbsp;<span class="icon icon-right-open">&nbsp;<?php echo $atop['qty'] . ' ' . $atop['title'] ?></span> <span class="price"><?php echo to_currency($atop['total']) ?></span><br/>
                                                        <?php else: ?>
                                                            &nbsp;<span class="icon icon-right-open">&nbsp;<?php echo $atop['title'] ?></span><br/>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>  
                                            <?php endif; ?>
                                        </td>
                                        <td style="width: 10%; text-align: center;"><?php echo to_currency($item['price']) ?></td>
                                        <td style="width: 7%; text-align: center;"><?php echo $item['qty'] ?></td>
                                        <td style="width: 23%; text-align: right; padding-right: 3px;"><?php echo $item['total'] > 0 ? to_currency($item['total']) : 'Free' ?></td>
                                    </tr>
                                <?php endforeach; ?>
                                <tr style="background: #b3feb9;">
                                    <td colspan="3" style="text-align: right;padding-right: 3px; font-weight: bold;">Subtotal</td>
                                    <td colspan="1" style="text-align: right; padding-right: 3px;font-weight: bold;"><?php echo to_currency($order['subTotal']) ?></td>
                                </tr>
                                <tr style="background: transparent;">
                                    <td colspan="3" style="text-align: right;padding-right: 3px;">VAT</td>
                                    <td colspan="1" style="text-align: right; padding-right: 3px;">
                                        <?php
                                        if ($order['tax'] > 0) {
                                            echo to_currency($order['tax']);
                                        } else {
                                            if ($order['taxIsIncluded'] === 'yes') {
                                                echo "VAT included";
                                            }
                                        }
                                        ?>
                                </tr>
                                <?php if ($order['deliveryCharge'] > 0): ?>
                                    <tr style="background: transparent;">
                                        <td colspan="3" style="text-align: right;padding-right: 3px;">Delivery Charge</td>
                                        <td colspan="1" style="text-align: right; padding-right: 3px;"><?php echo to_currency($order['deliveryCharge']) ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if ($order['serviceCharge'] > 0): ?>
                                    <tr style="background: transparent;">
                                        <td colspan="3" style="text-align: right;padding-right: 3px;">Service Charge</td>
                                        <td colspan="1" style="text-align: right; padding-right: 3px;"><?php echo to_currency($order['serviceCharge']) ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if ($order['ccFee'] > 0): ?>
                                    <tr style="background: transparent;">
                                        <td colspan="3" style="text-align: right;padding-right: 3px;">ccFee</td>
                                        <td colspan="1" style="text-align: right; padding-right: 3px;"><?php echo to_currency($order['ccFee']) ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if ($order['cbFee'] > 0): ?>
                                    <tr style="background: transparent;">
                                        <td colspan="3" style="text-align: right;padding-right: 3px;">Bag</td>
                                        <td colspan="1" style="text-align: right; padding-right: 3px;"><?php echo to_currency($order['cbFee']) ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if ($order['discount'] > 0): ?>
                                    <tr style="background: transparent;">
                                        <td colspan="3" style="text-align: right;padding-right: 3px;">Discount</td>
                                        <td colspan="1" style="text-align: right; padding-right: 3px;"><?php echo to_currency($order['discount']) ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if ($order['promo'] > 0): ?>
                                    <tr style="background: transparent;">
                                        <td colspan="3" style="text-align: right;padding-right: 3px;">Promo</td>
                                        <td colspan="1" style="text-align: right; padding-right: 3px;"><?php echo to_currency($order['promo']) ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if ($order['multiDiscount'] > 0): ?>
                                    <tr style="background: transparent;">
                                        <td colspan="3" style="text-align: right;padding-right: 3px;">Multi Discount</td>
                                        <td colspan="1" style="text-align: right; padding-right: 3px;"><?php echo to_currency($order['multiDiscount']) ?></td>
                                    </tr>
                                <?php endif; ?>    
                                <tr style="background: #b3feb9;">
                                    <td colspan="3" style="text-align: right;padding-right: 3px; font-weight: bold">Total</td>
                                    <td colspan="1" style="text-align: right; padding-right: 3px; font-weight: bold"><?php echo to_currency($order['grandTotal']) ?></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
