<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name=viewport content="width=device-width, initial-scale=1.0, minimum-scale=0.5 maximum-scale=1.0">
        <title><?php echo $template['title'] ?></title>
        <script>  var baseUrl = '<?php echo base_url() ?>';</script>
        <?php if ($this->config->item('environment') === 'production'): ?>
            <link rel="stylesheet" href="<?php echo EPOS_RESOURCES_PATH ?>css/prod.css?v=<?php echo $this->config->item('version') ?>">
            <script type="text/javascript" src="<?php echo EPOS_RESOURCES_PATH ?>plugins/indexed-db/dexie.min.js?v=<?php echo $this->config->item('version') ?>"></script>
            <script type="text/javascript" src="<?php echo EPOS_RESOURCES_PATH ?>js/prod.js?v=<?php echo $this->config->item('version') ?>"></script>
        <?php else: ?>
            <link rel="stylesheet" href="<?php echo EPOS_RESOURCES_PATH ?>css/photon.min.css?v=<?php echo $this->config->item('version') ?>">
            <link rel="stylesheet" href="<?php echo EPOS_RESOURCES_PATH ?>plugins/jskeyboard/css/jsKeyboard.css?v=<?php echo $this->config->item('version') ?>">
            <link rel="stylesheet" href="<?php echo EPOS_RESOURCES_PATH ?>plugins/colorbox/colorbox.css?v=<?php echo $this->config->item('version') ?>">
            <link rel="stylesheet" href="<?php echo EPOS_RESOURCES_PATH ?>plugins/datetime/jquery.datetimepicker.min.css?v=<?php echo $this->config->item('version') ?>">
            <link rel="stylesheet" href="<?php echo EPOS_RESOURCES_PATH ?>plugins/jquery-editable/css/jquery-editable.css?v=<?php echo $this->config->item('version') ?>">
            <link rel="stylesheet" href="<?php echo EPOS_RESOURCES_PATH ?>css/custom.css?v=<?php echo $this->config->item('version') ?>">
            <script type="text/javascript" src="<?php echo EPOS_RESOURCES_PATH ?>plugins/indexed-db/dexie.min.js?v=<?php echo $this->config->item('version') ?>"></script>
            <script type="text/javascript" src="<?php echo EPOS_RESOURCES_PATH ?>js/jquery.min.js?v=<?php echo $this->config->item('version') ?>"></script>
        <?php endif; ?>
        <script>
            function checkApi() {
                var primary = '<?php echo base64_decode($this->input->cookie(preg_replace('/\s+/', '_', $this->config->item('general_name')) . 'pqr', true)); ?>';
                var secondary = '<?php echo base64_decode($this->input->cookie(preg_replace('/\s+/', '_', $this->config->item('general_name')) . 'mno', true)); ?>';
                var tertiary = '<?php echo base64_decode($this->input->cookie(preg_replace('/\s+/', '_', $this->config->item('general_name')) . 'xyz', true)); ?>';
                if ($.trim(primary) && $.trim(secondary) && $.trim(tertiary)) {
                    return true;
                } else {
                    return false;
                }
            }
            function isUserLoggedIn() {
                return zamanEposCart.isUserLoggedIn();
            }
            function checkInternetConnection() {
                if (navigator.onLine) {
                    return true;
                } else {
                    return false;
                }
            }
            function zamanEposNavigator(how, page, cssClass) {
                if (!$('.page-loader').is(":visible") || how === 'refresh' || how === 'verified') {
                    var usergroup = '<?php echo $this->session->userdata('group'); ?>';
                    var connection = checkInternetConnection();
                    if (connection && isUserLoggedIn() && (checkApi() || Number(usergroup) === 2)) {
                        playBeepSound();
                        if ($.trim(how) === $.trim('verified')) {
                            $('.page-loader').show();
                            window.location.href = page;
                        } else if ($.trim(how) === $.trim('logout')) {
                            //meetLogoutCondition(page);
                            if ($.trim(page) && zamanEposCart.userLoggedOut()) {
                                window.location.href = page;
                            }
                        } else {
                            $.ajax({
                                url: page,
                                type: 'POST',
                                beforeSend: function () {
                                    $('.page-loader').show();
                                },
                                success: function (pageContent) {
                                    $('.page-loader').hide();
                                    $("#bodyWindow").html(pageContent);
                                    if ($.trim(cssClass)) {
                                        $('.nav-group-item').removeClass('active');
                                        if ($('.nav-group-item.' + cssClass).length > 0) {
                                            $('.nav-group-item.' + cssClass).addClass('active');
                                        }
                                        $('.epos-header-nav').removeClass('active');
                                        if ($('.epos-header-nav.' + cssClass).length > 0) {
                                            $('.epos-header-nav.' + cssClass).addClass('active');
                                        }
                                    }
                                }
                            });
                        }
                    } else {
                        if (connection) {
                            window.location.href = '<?php echo site_url('user/login/index/' . $this->session->userdata('loginBranch') . '/' . $this->session->userdata('team')) ?>';
                        } else {
                            warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                        }
                    }
                }
            }
            if (typeof module === 'object') {
                window.module = module;
                module = undefined;
            }
        </script>
    </head>
    <body>
        <div class="window" id="bodyWindow">
            <?php echo $template['body'] ?>
        </div>
        <?php if ($this->config->item('environment') !== 'production'): ?>
            <script type="text/javascript" src="<?php echo EPOS_RESOURCES_PATH ?>js/jquery.validate.min.js?v=<?php echo $this->config->item('version') ?>"></script>
            <script type="text/javascript" src="<?php echo EPOS_RESOURCES_PATH ?>plugins/jskeyboard/js/jsKeyboard.js?v=<?php echo $this->config->item('version') ?>"></script>
            <script type="text/javascript" src="<?php echo EPOS_RESOURCES_PATH ?>plugins/colorbox/jquery.colorbox-min.js?v=<?php echo $this->config->item('version') ?>"></script>
            <script type="text/javascript" src="<?php echo EPOS_RESOURCES_PATH ?>plugins/datetime/jquery.datetimepicker.full.js?v=<?php echo $this->config->item('version') ?>"></script>
            <script type="text/javascript" src="<?php echo EPOS_RESOURCES_PATH ?>plugins/jquery-editable/js/jquery-editable-poshytip.js?v=<?php echo $this->config->item('version') ?>"></script>
            <script type="text/javascript" src="<?php echo EPOS_RESOURCES_PATH ?>js/jquery.address-suggest.js?v=<?php echo $this->config->item('version') ?>"></script>
            <script type="text/javascript" src="<?php echo EPOS_RESOURCES_PATH ?>js/printThis.js?v=<?php echo $this->config->item('version') ?>"></script>
            <script type="text/javascript" src="<?php echo EPOS_RESOURCES_PATH ?>js/zamandb.js?v=<?php echo $this->config->item('version') ?>"></script>
            <script type="text/javascript" src="<?php echo EPOS_RESOURCES_PATH ?>js/zamanCart.js?v=<?php echo $this->config->item('version') ?>"></script>
            <script type="text/javascript" src="<?php echo EPOS_RESOURCES_PATH ?>js/app.js?v=<?php echo $this->config->item('version') ?>"></script>
        <?php endif; ?>
        <script type="text/javascript">
            var buttonBeepSoundFile = '<?php echo EPOS_RESOURCES_PATH . 'beep.wav' ?>';
            var deskphoneRington = '<?php echo EPOS_RESOURCES_PATH . 'deskphone.mp3' ?>';
            var onlineOrderWarningAudio = '<?php echo EPOS_RESOURCES_PATH . 'onlineorder.mp3' ?>';
            if (window.module) {
                module = window.module;
            }
            $(document).ready(function () {
                var hasUserAccessUrl = '<?php echo $this->session->userdata('userAccessUrl') ?>';
                if ($.trim(hasUserAccessUrl)) {
                    if (!$.trim(localStorage.getItem('userAccessUrl'))) {
                        localStorage.setItem('userAccessUrl', '<?php echo $this->session->userdata('userAccessUrl') ?>');
                    }
                }
                resetUserData();
            });
            function resetUserData() {
                var userData = zamanEposCart.getUserData();
                var Owner = '<?php echo $this->session->userdata('owner') ?>';
                if (!jQuery.isEmptyObject(userData)) {
                    if (Number(Owner) !== Number(userData.owner)) {
                        var data = {};
                        data.branch = '<?php echo $this->session->userdata('branch') ?>';
                        data.owner = '<?php echo $this->session->userdata('owner') ?>';
                        data.team = '<?php echo $this->session->userdata('team') ?>';
                        data.group = '<?php echo $this->session->userdata('group') ?>';
                        data.name = '<?php echo $this->session->userdata('name') ?>';
                        data.userApps = JSON.parse('<?php echo json_encode($this->session->userdata('userApps')) ?>');
                        zamanEposCart.setUserData(data);
                    }
                } else {
                    if (Number(Owner) > 0) {
                        var data = {};
                        data.branch = '<?php echo $this->session->userdata('branch') ?>';
                        data.owner = '<?php echo $this->session->userdata('owner') ?>';
                        data.team = '<?php echo $this->session->userdata('team') ?>';
                        data.group = '<?php echo $this->session->userdata('group') ?>';
                        data.name = '<?php echo $this->session->userdata('name') ?>';
                        data.userApps = JSON.parse('<?php echo json_encode($this->session->userdata('userApps')) ?>');
                        zamanEposCart.setUserData(data);
                    }
                }
            }
            function playBeepSound() {
                if (isUserLoggedIn()) {
                    var beepSound = '<?php echo $this->session->userdata('beep') ?>';
                    if (beepSound === 'yes') {
                        var audioObject = new Audio(buttonBeepSoundFile);
                        if (!$.trim(audioObject.error)) {
                            audioObject.volume = Number('<?php echo $this->session->userdata('beepLabel') ?>');
                            audioObject.play();
                        } else {
                            return true;
                        }
                    } else {
                        return true;
                    }
                } else {
                    var audioObject = new Audio(buttonBeepSoundFile);
                    if (!$.trim(audioObject.error)) {
                        audioObject.volume = 0.2;
                        audioObject.play();
                    } else {
                        return true;
                    }
                }
            }
            function meetLogoutCondition(page) {
                $('.page-loader').show();
                zamanEposDb.epos_order.orderBy('orderId').filter(function (order) {
                    var userData = zamanEposCart.getUserData();
                    return Number(order.status) < 5 && Number(order.owner) === Number(userData.owner) && Number(order.branch) === Number(userData.branch) && Number(order.team) === Number(userData.team);
                }).toArray().then(function (orders) {
                    if (orders.length >= 1) {
                        $('.page-loader').hide();
                        warning('<?php echo $this->lang->line('logout') . ' ' . $this->lang->line('warning') ?>', '<?php echo $this->lang->line('logout_order_unclosed_msg') ?>', '<?php echo $this->lang->line('ok') ?>');
                    } else {
                        if ($.trim(page) && zamanEposCart.userLoggedOut()) {
                            window.location.href = page;
                        }
                    }
                });
            }
            function ifUserCanCreateOrderInEpos() {
                var userData = zamanEposCart.getUserData();
                var branch = '<?php echo $this->session->userdata('branch') ?>';
                var team = '<?php echo $this->session->userdata('team') ?>';
                if (Number(userData.branch) === Number(branch) && Number(userData.team) === Number(team)) {
                    return true;
                } else {
                    return false;
                }
            }
            function palyDeskPhone() {
                var audioObject = new Audio(deskphoneRington);
                if (!$.trim(audioObject.error)) {
                    audioObject.volume = 0.3;
                    audioObject.play();
                } else {
                    return true;
                }
            }
            function palyNewOnlineOrderWarningAudio() {
                var audioObject = new Audio(onlineOrderWarningAudio);
                if (!$.trim(audioObject.error)) {
                    audioObject.volume = 0.9;
                    audioObject.play();
                } else {
                    return true;
                }
            }
        </script>
    </body>
</html>
