<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane">
            <div class="pane content-configuration">
                <div class="caption">
                    <?php $this->load->view('user/nav') ?>
                </div>
                <div class="page-content">
                    <?php
                    $userTypes = array(
                        '2' => $this->lang->line('super_admin'),
                        '3' => $this->lang->line('owner_account'),
                        '4' => $this->lang->line('branch_manager'),
                        '5' => $this->lang->line('team_manager'),
                        '6' => $this->lang->line('table_handler'),
                        '7' => $this->lang->line('waiting_terminal'),
                        '8' => $this->lang->line('bar_terminal'),
                        '9' => $this->lang->line('bakery_terminal'),
                        '10' => $this->lang->line('drinks_terminal'),
                        '11' => $this->lang->line('collection_point'),
                        '12' => $this->lang->line('kitchen_terminal'),
                        '13' => $this->lang->line('driver_account'),
                        '15' => $this->lang->line('web_admin'),
                    );
                    ?>
                    <table class="report-table text-center">
                        <caption><i class="icon icon-list"></i>&nbsp;<?php echo $this->lang->line('user') ?></caption>
                        <thead class="table-bg">
                            <tr>
                                <?php if ($this->session->userdata('group') === '2'): ?>
                                    <th><?php echo $this->lang->line('id') ?></th>
                                <?php endif; ?>
                                <th><?php echo $this->lang->line('display') . ' ' . $this->lang->line('name') ?></th>
                                <th><?php echo $this->lang->line('employee') . ' ' . $this->lang->line('name') ?></th>
                                <th><?php echo $this->lang->line('username') ?></th>
                                <th><?php echo $this->lang->line('user_type') ?></th>
                                <?php if ($this->session->userdata('group') <= 3): ?>
                                    <th><?php echo $this->lang->line('branch') ?></th>
                                <?php endif; ?>
                                <th><?php echo $this->lang->line('team') ?></th>
                                <th><?php echo $this->lang->line('service') ?></th>
                                <th><?php echo $this->lang->line('status') ?></th>
                                <th><?php echo $this->lang->line('action') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($users)): ?>
                                <?php foreach ($users as $auser): ?>
                                    <tr>
                                        <?php if ($this->session->userdata('group') === '2'): ?>
                                            <td><?php echo $auser->id ?></td>
                                        <?php endif; ?>
                                        <td><?php echo $auser->display ?></td>
                                        <td><?php
                                            $employeeObj = get_single_record('employee', array('id' => $auser->employee));
                                            $employeeName = $auser->display;
                                            if (!empty($employeeObj)) {
                                                $employeeName = $employeeObj->first_name . ' ' . $employeeObj->last_name;
                                            }
                                            echo $employeeName;
                                            ?></td>
                                        <?php if ($this->session->userdata('owner') == $auser->id || $this->session->userdata('group') <= 4): ?>
                                            <td><?php echo $auser->username ?></td>
                                        <?php else : ?>
                                            <td><?php echo $this->lang->line('hidden') ?></td>
                                        <?php endif; ?>
                                        <td><?php echo $userTypes[$auser->group] ?></td>
                                        <?php if ($this->session->userdata('group') <= 3): ?>
                                            <td><?php echo get_title('branch', array('id' => $auser->branch)) ?></td>
                                        <?php endif; ?>
                                        <td><?php echo get_title('userteam', array('id' => $auser->team)) ?></td>
                                        <td><?php
                                            $apps = isset($auser->onapp) && trim($auser->onapp) ? unserialize($auser->onapp) : array('all');
                                            $appString = '';
                                            if (!empty($apps)) {
                                                foreach ($apps as $anApp)
                                                    $appString .= ucwords($anApp) . ' ';
                                            } echo $appString;
                                            ?></td>
                                        <td><?php echo $auser->status === '3' ? $this->lang->line('active') : $this->lang->line('inactive') ?></td>
                                        <?php if ($this->session->userdata('owner') == $auser->id || $this->session->userdata('group') <= 4): ?>
                                            <td><span class="icon icon-pencil" onclick="zamanEposNavigator('user', '<?php echo site_url('user/add/' . $auser->id) ?>', 'userIndex')"></span></td>
                                        <?php else: ?>
                                            <td><span class="icon icon-cancel"></span></td>
                                            <?php endif; ?>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr><td colspan="9"><?php echo sprintf($this->lang->line('not_found'), $this->lang->line('user')) ?></td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer'); ?>

