<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="caption">
                <div class="caption-inner" style="padding: 9px;" onclick="zamanEposNavigator('voucher', '<?php echo site_url('settings/voucher') ?>', '')"><?php echo $this->lang->line('voucher') ?></div>
            </div>
            <?php echo form_open('settings/save_voucher', array('id' => 'giftVoucherForm')); ?>
            <div class="pane-one-third block">
                <div class="block-inner">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('title') ?></label>
                        <input type="text" name="title" value="<?php !empty($loaded_plan) ? print $loaded_plan['title'] : print 'Gift Voucher' ?>" class="form-control" placeholder="<?php echo $this->lang->line('title') ?>" >
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('code') ?></label>
                        <input type="text" name="code" class="form-control" value="<?php !empty($loaded_plan) ? print $loaded_plan['code'] : print $vouchercode ?>">
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('applicant_name') ?></label>
                        <input type="text" name="holder" class="form-control" placeholder="<?php echo $this->lang->line('applicant_name') ?>">
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('phone') ?></label>
                        <input type="text" name="phone" class="form-control" placeholder="<?php echo $this->lang->line('phone') ?>">
                    </div>
                </div>
            </div>
            <div class="pane-one-third block">
                <div class="block-inner">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('street_address') ?></label>
                        <input type="text" name="address" class="form-control" placeholder="<?php echo $this->lang->line('street_address') ?>">
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('city') ?></label>
                        <input type="text" name="city" class="form-control" placeholder="<?php echo $this->lang->line('city') ?>">
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('region') ?></label>
                        <input type="text" name="region" class="form-control" placeholder="<?php echo $this->lang->line('region') ?>">
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('country') ?></label>
                        <input type="text" name="country" class="form-control" placeholder="<?php echo $this->lang->line('country') ?>">
                    </div>
                </div>
            </div>
            <div class="pane-one-third block">
                <div class="block-inner">
                    <div class="form-group">
                        <label><?php echo $this->lang->line('amount') ?></label>
                        <input type="text" name="amount" class="form-control" placeholder="<?php echo $this->lang->line('amount') ?>">
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('start_date') ?></label>
                        <input type="text" name="start" class="form-control" id="voucherStartDate" placeholder="<?php echo $this->lang->line('start_date') ?>">
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('end_date') ?></label>
                        <input type="text" name="end" class="form-control" id="voucherEndDate" placeholder="<?php echo $this->lang->line('end_date') ?>">
                    </div>
                    <div class="form-group">
                        <label><?php echo $this->lang->line('status') ?></label>
                        <select name="status" class="form-control">
                            <option value="0"><?php echo $this->lang->line('select') ?></option>
                            <option value="2"><?php echo $this->lang->line('inactive') ?></option>
                            <option value="3"><?php echo $this->lang->line('active') ?></option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="tab-group config-submit">
                <button type="submit" onclick="saveGiftVoucher('giftVoucherForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
            </div>
            <?php echo form_close() ?>
            <div class="setting-general-keyboard text-center"></div>
            <div class="clearfix padded-top-more text-right"><span class="icon icon-keyboard btn-keyboard-close" onclick="zamanToogleEposVirtualKeyboard('setting-general-keyboard')">&nbsp;<?php echo $this->lang->line('open_virtual_keyboard') ?></span></div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $('document').ready(function () {
        $('#voucherStartDate').datetimepicker({
            timepicker: false,
            format: 'd/m/Y',
            minDate: '<?php echo date('d/m/Y', strtotime('today')) ?>',
            formatDate: 'Y/m/d'
        });
        $('#voucherEndDate').datetimepicker({
            timepicker: false,
            format: 'd/m/Y',
            minDate: '<?php echo date('d/m/Y', strtotime('today')) ?>',
            formatDate: 'Y/m/d'
        });
    });
    function saveGiftVoucher(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                $('.page-loader').hide();
                                if (response.status) {
                                    zamanDbEposVoucher('mono');
                                    warning('<?php echo $this->lang->line('success') ?>', '<?php echo $this->lang->line('data_saved_successfully') ?>', '<?php echo $this->lang->line('ok') ?>');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                                }
                            }
                        });
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    title: {required: true, alphanumeric: true},
                    code: {number: true, required: true},
                    holder: {alphanumeric: true, required: true},
                    phone: {number: true, required: true},
                    amount: {number: true, required: true},
                    start: {required: true},
                    end: {required: true},
                    status: {number: true, min: 2, max: 3, required: true}
                },
                messages: {
                    title: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('title')) ?>',
                    code: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('code')) ?>',
                    holder: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('applicant_name')) ?>',
                    phone: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('phone')) ?>',
                    amount: '<?php echo sprintf($this->lang->line('item_required_in_number'), $this->lang->line('amount')) ?>',
                    start: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('start_date')) ?>',
                    end: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('end_date')) ?>',
                    status: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('status')) ?>',
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
</script>
<?php
$this->load->view('settings/partials/footer')?>