<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <?php if ($this->session->userdata('group') <= 4): ?>
                <div class="caption">
                    <div class="caption-inner" style="padding: 9px;" onclick="zamanEposNavigator('voucher', '<?php echo site_url('settings/voucheradd') ?>', 'voucher')"><?php echo $this->lang->line('add_voucher') ?></div>
                </div>
            <?php else: ?>
                <div class="caption">
                    <div class="caption-inner" style="padding: 9px;"><?php echo $this->lang->line('voucher') ?></div>
                </div>
            <?php endif; ?>
            <table class="report-table text-center">
                <thead class="table-bg">
                    <tr>
                        <th colspan="7">
                            <input class="form-control" id="voucherCode" value="<?php echo $voucherCode ?>" placeholder="Serach by code..."/>
                        </th>
                        <th colspan="<?php $this->session->userdata('group') <= 5 ? print 3 : print 2; ?>"><span class="btn btn-large btn-primary" style="width:100%" onclick="filterVoucher()"><?php echo $this->lang->line('search') ?></span></th>
                    </tr>
                    <tr>
                        <th><?php echo $this->lang->line('title') ?></th>
                        <th><?php echo $this->lang->line('code') ?></th>
                        <th><?php echo $this->lang->line('applicant_name') ?></th>
                        <th><?php echo $this->lang->line('phone') ?></th>
                        <th><?php echo $this->lang->line('amount') ?></th>
                        <th><?php echo $this->lang->line('balance') ?></th>
                        <th><?php echo $this->lang->line('date_validity') ?></th>
                        <th><?php echo $this->lang->line('status') ?></th>
                        <?php if ($this->session->userdata('group') <= 5): ?>
                            <th><?php echo $this->lang->line('print') ?></th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($vouchers)): ?>
                        <?php foreach ($vouchers as $aVoucher): ?>
                            <tr>
                                <td><?php echo $aVoucher->title ?></td>
                                <td><?php echo $aVoucher->code ?></td>
                                <td><?php echo $aVoucher->holder ?></td>
                                <td><?php echo $aVoucher->phone ?></td>
                                <td><?php echo to_currency($aVoucher->amount) ?></td>
                                <td><?php echo to_currency($aVoucher->balance) ?></td>
                                <td><?php echo date('d/m/Y', strtotime($aVoucher->start)) ?> - <?php echo date('d/m/Y', strtotime($aVoucher->end)) ?> </td>
                                <?php if (new DateTime(date('Y-m-d')) < new DateTime($aVoucher->end) && $aVoucher->status == '3'): ?>
                                    <td><?php echo $this->lang->line('active') ?></td>
                                <?php else: ?>
                                    <td><?php echo $this->lang->line('used') ?></td>
                                <?php endif; ?>
                                <?php if ($this->session->userdata('group') <= 5): ?>
                                    <td><span class="icon icon-print" onclick="printVoucher('<?php echo $aVoucher->id ?>')"></span></td>
                                    <?php endif; ?>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><th colspan="7"><?php echo sprintf($this->lang->line('not_found'), $this->lang->line('voucher')) ?></th></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<script>
    function filterVoucher() {
        var voucherCode = $.trim($('#voucherCode').val()) ? $('#voucherCode').val() : 0;
        if (voucherCode) {
            zamanEposNavigator('voucher', '<?php echo site_url('settings/voucher/') ?>' + voucherCode, 'voucher');
        }
    }
    function printVoucher(id) {
        $.ajax({
            url: '<?php echo site_url('settings/printVoucher/') ?>' + id,
            beforeSend: function (xhr) {
                $('.page-loader').show();
            },
            success: function (response) {
                $('.page-loader').hide();
            }
        });
    }
</script>