<div style="display: none;">
    <div id="switchBranch">
        <div class="popup-header toolbar-header">
            <div class="popup-title">Switch Branch</div>
            <div class="popup-close-btn" onclick="zamanEposPopupcloser()"><span class="icon icon-cancel"></span></div>
        </div>
        <div class="popup-content">
            <?php echo form_open('settings/switchbranch', array('id' => 'switchBranchForm', 'enctype' => 'multipart/form-data')); ?>
            <div class="neworder-table-guest collection-phone ccfee">
                <div class="form-group">
                    <?php $branches = get_record_list('branch', array('status' => '3')) ?>
                    <select class="form-control" name="branch">
                        <option value="0">Select Branch </option>
                        <?php foreach ($branches as $aBranch): ?>
                            <option value="<?php echo $aBranch->id ?>" <?php $aBranch->id == $this->session->userdata('branch') ? print'selected' : '' ?>><?php echo $aBranch->title ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="clearfix"></div>
                <br/> <hr/>
                <div class="tab-group config-submit">
                    <button type="submit" onclick="zamanSwitchBranch('switchBranchForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
                </div>
            </div>
            <?php echo form_close() ?>
        </div>
    </div>
</div>
<script type="text/javascript">
    function zamanSwitchBranchPopup() {
        zamanEposDb.epos_order.count(function (count) {
            if (count > 0) {
                warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('unclosed_order_msg_on_forging') ?>', '<?php echo $this->lang->line('ok') ?>')
            } else {
                $.colorbox({
                    inline: true,
                    scrolling: false,
                    href: "#switchBranch",
                    width: '40%',
                    height: '175px',
                    maxWidth: "100%",
                    open: true,
                    closeButton: false,
                    transition: 'elastic',
                    overlayClose: false,
                    onClosed: function () {
                        resetForm('switchBranchForm');
                    }
                });
            }
        });
    }
    function zamanSwitchBranch(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            success: function (response) {
                                if (response.status) {
                                    zamanEposCart.setUserData(response.userData);
                                    zamanEposPopupcloser();
                                    //loadDataFromRemoteSourceOnBranchSwitching();
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                rules: {branch: {required: true, number: true, min: 1}},
                messages: {branch: '<?php echo $this->lang->line('select_branch') ?>'},
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }

    function loadDataFromRemoteSourceOnBranchSwitching() {
        Dexie.exists('zamanEposDb').then(function (exists) {
            if (!exists) {
                initializeZamanDbTableStructure();
                zamanEposDb.open();
                startForgingRemoteDatabase();
            } else {
                zamanEposDb.epos_order.count(function (count) {
                    if (count > 0) {
                        warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('unclosed_order_msg_on_forging') ?>', '<?php echo $this->lang->line('ok') ?>')
                    } else {
                        $('.page-loader').show();
                        zamanEposDb.close();
                        zamanEposDb.delete().then(function () {
                            initializeZamanDbTableStructure();
                            zamanEposDb.open();
                            startForgingRemoteDatabaseOnBranchSwitching();
                        }).catch(function (err) {
                            $('.page-loader').hide();
                            console.log(err);
                        });
                    }
                });
            }
        });
    }
    function startForgingRemoteDatabaseOnBranchSwitching() {
        if (checkInternetConnection()) {
            $.ajax({
                url: "<?php echo site_url('user/changeOwnerUpdateStatus') ?>",
                type: 'GET',
                dataType: 'JSON',
                success: function (response) {
                    if (response.status) {
                        $('#forgeLocalDataFromRemote').hide();
                        $('#pleaseWait').show();
                        initiateAllZamanEposTables();
                    } else {
                        warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                }
            });
        } else {
            warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
        }
    }
</script>