<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane">
            <div id="pleaseWait" class="tab-group page-order-tab" style="width: 100%; display: none;">
                <div  class="tab-item order-process-status-2" style="font-size: 10px; padding: 10px" id="systemUpdateInformationHook"><?php echo $this->lang->line('system_updating_msg') ?></div>
            </div>
            <div class="menu-list special-modify-btn-groups dashboard-icon-list">
                <div class="menu-button config-dashboard-icon" onclick="zamanEposNavigator('', '<?php echo site_url('settings/branch') ?>', '')">
                    <div class="config-dashboard-icon-inner">
                        <div class="text-center dashboard-icon-block"><span class="number-icon">&nbsp;</span></div>
                        <div class="text-center dashboard-icon-block icon icon-address"></div>
                        <div class="text-center dashboard-icon-block"><?php echo $this->lang->line('branch') ?></div>
                    </div>
                </div>
                <div class="menu-button config-dashboard-icon" onclick="zamanEposNavigator('', '<?php echo site_url('settings/service') ?>', '')">
                    <div class="config-dashboard-icon-inner">
                        <div class="text-center dashboard-icon-block"><span class="number-icon">&nbsp;</span></div>
                        <div class="text-center dashboard-icon-block icon icon-renren"></div>
                        <div class="text-center dashboard-icon-block"><?php echo $this->lang->line('restaurant_service') ?></div>
                    </div>
                </div>
                <div class="menu-button config-dashboard-icon" onclick="zamanEposNavigator('', '<?php echo site_url('settings/paymentoption') ?>', '')">
                    <div class="config-dashboard-icon-inner">
                        <div class="text-center dashboard-icon-block"><span class="number-icon">&nbsp;</span></div>
                        <div class="text-center dashboard-icon-block icon icon-cc"></div>
                        <div class="text-center dashboard-icon-block"><?php echo $this->lang->line('payment_type') ?></div>
                    </div>
                </div>
                <div class="menu-button config-dashboard-icon" onclick="zamanEposNavigator('', '<?php echo site_url('settings/paymentstripe') ?>', '')">
                    <div class="config-dashboard-icon-inner">
                        <div class="text-center dashboard-icon-block"><span class="number-icon">&nbsp;</span></div>
                        <div class="text-center dashboard-icon-block icon icon-tools"></div>
                        <div class="text-center dashboard-icon-block">Stripe Settings</div>
                    </div>
                </div>
                <div class="menu-button config-dashboard-icon" onclick="zamanEposNavigator('', '<?php echo site_url('settings/localization') ?>', '')">
                    <div class="config-dashboard-icon-inner">
                        <div class="text-center dashboard-icon-block"><span class="number-icon">&nbsp;</span></div>
                        <div class="text-center dashboard-icon-block icon icon-calendar"></div>
                        <div class="text-center dashboard-icon-block"><?php echo $this->lang->line('localization') ?></div>
                    </div>
                </div>
                <div class="menu-button config-dashboard-icon" onclick="zamanEposNavigator('', '<?php echo site_url('settings/pagination') ?>', '')">
                    <div class="config-dashboard-icon-inner">
                        <div class="text-center dashboard-icon-block"><span class="number-icon">&nbsp;</span></div>
                        <div class="text-center dashboard-icon-block icon icon-gauge"></div>
                        <div class="text-center dashboard-icon-block"><?php echo $this->lang->line('pagination') ?></div>
                    </div>
                </div>
                <div class="menu-button config-dashboard-icon" onclick="updateNotificationStatus('<?php echo $this->config->item('znotifysystemupdate') ?>')">
                    <div class="config-dashboard-icon-inner">
                        <div class="text-center dashboard-icon-block"><span class="number-icon">&nbsp;</span></div>
                        <div class="text-center dashboard-icon-block icon icon-alert"></div>
                        <div class="text-center dashboard-icon-block"><?php echo $this->lang->line('notify_update') ?>&nbsp;<span style="color: #ddfc0d">(<?php $this->config->item('znotifysystemupdate') === 'yes' ? print $this->lang->line('disabled') : print $this->lang->line('enabled') ?>)</span></div>
                    </div>
                </div>
                <div class="menu-button config-dashboard-icon" onclick="clearDatabase()">
                    <div class="config-dashboard-icon-inner">
                        <div class="text-center dashboard-icon-block"><span class="number-icon">&nbsp;</span></div>
                        <div class="text-center dashboard-icon-block icon icon-erase"></div>
                        <div class="text-center dashboard-icon-block"><?php echo $this->lang->line('clear_database') ?></div>
                    </div>
                </div>
                <div class="menu-button config-dashboard-icon" onclick="forgeLocalDb()">
                    <div class="config-dashboard-icon-inner">
                        <div class="text-center dashboard-icon-block"><span class="number-icon">&nbsp;</span></div>
                        <div class="text-center dashboard-icon-block icon icon-database"></div>
                        <div class="text-center dashboard-icon-block"><?php echo $this->lang->line('forge_local_storage') ?></div>
                    </div>
                </div>
                <div class="menu-button config-dashboard-icon" onclick="changeEnvironment('<?php echo $this->config->item('environment') === 'development' ? 'production' : 'development' ?>')">
                    <div class="config-dashboard-icon-inner">
                        <div class="text-center dashboard-icon-block"><span class="number-icon">&nbsp;</span></div>
                        <div class="text-center dashboard-icon-block icon icon-down-circled"></div>
                        <div class="text-center dashboard-icon-block"><?php echo $this->config->item('environment') === 'development' ? $this->lang->line('change_to_prod') : $this->lang->line('change_to_dev') ?></div>
                    </div>
                </div>
                <div class="menu-button config-dashboard-icon" onclick="zamanSVNControllerPopup()">
                    <div class="config-dashboard-icon-inner">
                        <div class="text-center dashboard-icon-block"><span class="number-icon">&nbsp;</span></div>
                        <div class="text-center dashboard-icon-block icon icon-cc"></div>
                        <div class="text-center dashboard-icon-block"><?php echo sprintf($this->lang->line('svn'), $this->config->item('version')) ?></div>
                    </div>
                </div>
                <div class="menu-button config-dashboard-icon" onclick="zamanEposNavigator('', '<?php echo site_url('settings/api') ?>', '')">
                    <div class="config-dashboard-icon-inner">
                        <div class="text-center dashboard-icon-block"><span class="number-icon">&nbsp;</span></div>
                        <div class="text-center dashboard-icon-block icon icon-tools"></div>
                        <div class="text-center dashboard-icon-block"><?php echo $this->lang->line('api_settings') ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<?php $this->load->view('settings/settings/svn') ?>
<?php $this->load->view('settings/settings/secretKey') ?>
<script type="text/javascript">
    function changeEnvironment(to) {
        if (checkInternetConnection()) {
            $.ajax({
                url: '<?php echo site_url('settings/changeEnvironment') ?>',
                type: 'POST',
                dataType: 'JSON',
                data: {environment: to},
                beforeSend: function (xhr) {
                    $('.page-loader').show();
                },
                success: function (response) {
                    if (response.status) {
                        window.location.reload();
                    } else {
                        warning('<?php echo $this->lang->line('error') ?>', '<?php $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                }
            });
        } else {
            warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
        }
    }
    function updateNotificationStatus(status) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.ajax({
                    url: '<?php echo site_url('settings/save') ?>',
                    type: 'POST',
                    dataType: 'JSON',
                    data: {
                        znotifysystemupdate: status === 'yes' ? 'no' : 'yes'
                    },
                    beforeSend: function (xhr) {
                        $('.page-loader').show();
                    },
                    success: function (response) {
                        $('.page-loader').hide();
                        if (response.status) {
                            zamanEposNavigator('', '<?php echo site_url('settings/controllPanel') ?>', '');
                        } else {
                            warning('<?php echo $this->lang->line('error') ?>', '<?php $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
    function clearDatabase() {
        if (!$('.page-loader').is(":visible")) {
            $.confirm({
                title: '<?php echo $this->lang->line('warning') ?>',
                message: '<?php echo $this->lang->line('clearing_database_msg') ?>',
                buttons: {
                    '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                        'class': 'positive',
                        'action': function () {
                            zamanDatabaseClearSecretPopup();
                        }
                    },
                    '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                        'class': 'negative',
                        'action': function () {}
                    }
                }
            });
        }
    }
    function forgeLocalDb() {
        if (!$('.page-loader').is(":visible")) {
            loadDataFromRemoteSource();
        }
    }

    function loadDataFromRemoteSource() {
        Dexie.exists('zamanEposDb').then(function (exists) {
            if (!exists) {
                initializeZamanDbTableStructure();
                zamanEposDb.open();
                startForgingRemoteDatabase();
            } else {
                zamanEposDb.epos_order.count(function (count) {
                    if (count > 0) {
                        warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('unclosed_order_msg_on_forging') ?>', '<?php echo $this->lang->line('ok') ?>')
                    } else {
                        $('.page-loader').show();
                        zamanEposDb.close();
                        zamanEposDb.delete().then(function () {
                            initializeZamanDbTableStructure();
                            zamanEposDb.open();
                            startForgingRemoteDatabase();
                        }).catch(function (err) {
                            $('.page-loader').hide();
                            console.log(err);
                        });
                    }
                });
            }
        });
    }
    function startForgingRemoteDatabase() {
        if (checkInternetConnection()) {
            $.ajax({
                url: "<?php echo site_url('user/changeOwnerUpdateStatus') ?>",
                type: 'GET',
                dataType: 'JSON',
                success: function (response) {
                    if (response.status) {
                        $('#forgeLocalDataFromRemote').hide();
                        $('#pleaseWait').show();
                        initiateAllZamanEposTables();
                    } else {
                        warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                }
            });
        } else {
            warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
        }
    }

</script>