<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Settings extends Epos_Template {

    function __construct() {
        parent::__construct();
        $this->load->model('Settings_Model');
        if ($this->Settings_Model->isThisUserAnEposLogger() && (($this->cookies && !empty($this->cookies)) || ($this->session->userdata('group') == 2))) {
            return true;
        } else {
            redirect('user/login/index/' . $this->session->userdata('branch') . '/' . $this->session->userdata('team'));
        }
    }

    public function index($how = false) {
        $this->page_title = $this->lang->line('setting');
        $data['refresh'] = base_url(uri_string());
        $data['services'] = $this->Settings_Model->get_single('service', array('branch' => $this->session->userdata('branch')))->row_array();
        if ($how && $how === 'verified') {
            $this->render('settings/settings/index', $data);
        } else {
            $this->load->view('settings/settings/index', $data, false);
        }
    }

    public function switchbranch() {
        $currentBranch = $this->session->userdata('branch');
        $changedBranch = $this->input->post('branch');
        if ($currentBranch === $changedBranch) {
            echo json_encode(array('status' => false, 'message' => $this->lang->line('branch_already_selected')));
        } else {
            $this->session->set_userdata('branch', $changedBranch);
            if ($changedBranch === $this->session->userdata('branch')) {
                $hasTeam = $this->Settings_Model->get_single('epos_userteam', array('branch' => $changedBranch))->row();
                $userData['branch'] = $this->session->userdata('branch');
                $userData['owner'] = $this->session->userdata('owner');
                $userData['team'] = !empty($hasTeam) ? $hasTeam->id : $this->session->userdata('team');
                $userData['group'] = $this->session->userdata('group');
                $userData['name'] = $this->session->userdata('name');
                $userData['userApps'] = $this->session->userdata('userApps');
                echo json_encode(array('status' => true, 'userData' => $userData));
            } else {
                echo json_encode(array('status' => false, 'message' => $this->lang->line('data_saving_failed')));
            }
        }
    }

    public function general() {
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('general');
        $data['refresh'] = base_url(uri_string());
        $data['loaded_plan'] = $this->Settings_Model->get_single('branch', array('id' => $this->session->userdata('branch')))->row_array();
        $data['currencies'] = currencies();
        $this->load->view('settings/settings/general', $data, false);
    }

    public function localization() {
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('localization');
        $languages = directory_map('./application/language', 1, FALSE);
        $timezones = timezone_list();
        $data['refresh'] = base_url(uri_string());
        $data['languages'] = $languages;
        $data['timezones'] = $timezones;
        $data['currencies'] = currencies();
        $this->load->view('settings/settings/localization', $data, false);
    }

    public function get_currency_symbol() {
        $currency = $this->input->post('currency');
        echo json_encode(array('value' => get_currency_symbol($currency)));
    }

    public function branch() {
        $data['plans'] = $this->Settings_Model->get_list('branch')->result();
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('branch');
        $data['refresh'] = base_url(uri_string());
        $this->load->view('settings/settings/branch', $data, false);
    }

    public function branchadd($id = null) {
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('add_delivery_plan');
        $data['countries'] = $this->Settings_Model->get_list('lcountry', null, null, 0, 0, 'position', 'ASC')->result();
        $data['regions'] = array();
        if (!empty($data['countries'])) {
            $data['regions'] = $this->Settings_Model->get_list('lregion', array('country' => $data['countries'][0]->id), null, 0, 0, 'position', 'ASC')->result();
        }
        $data['cities'] = array();
        if (!empty($data['regions'])) {
            $data['cities'] = $this->Settings_Model->get_list('lcity', array('region' => $data['regions'][0]->id), null, null, 0, 'position', 'ASC')->result();
        }
        $data['areas'] = array();
        if (!empty($data['cities'])) {
            $data['areas'] = $this->Settings_Model->get_list('larea', array('city' => $data['cities'][0]->id), null, null, 0, 'position', 'ASC')->result();
        }
        $data['loaded_plan'] = array();
        if ($id != null && (int) $id > 0) {
            $data['loaded_plan'] = $this->Settings_Model->get_single('branch', array('id' => $id))->row_array();
        }
        $data['refresh'] = base_url(uri_string());
        $data['currencies'] = currencies();
        $this->load->view('settings/settings/branchadd', $data, false);
    }

    public function getCountryRegions() {
        $countryText = $this->input->post('country');
        $country = $this->Settings_Model->get_single('lcountry', array('title' => $countryText))->row()->id;
        $data = $this->Settings_Model->get_list('lregion', array('country' => $country), array('id', 'title'))->result();
        $status = !empty($data) ? true : false;
        echo json_encode(array('status' => $status, 'regions' => $data));
    }

    public function getRegionCities() {
        $regionText = $this->input->post('region');
        $region = $this->Settings_Model->get_single('lregion', array('title' => $regionText))->row()->id;
        $data = $this->Settings_Model->get_list('lcity', array('region' => $region), array('id', 'title'))->result();
        $status = !empty($data) ? true : false;
        echo json_encode(array('status' => $status, 'cities' => $data));
    }

    public function getCityAreas() {
        $cityText = $this->input->post('city');
        $city = $this->Settings_Model->get_single('lcity', array('title' => $cityText))->row()->id;
        $data = $this->Settings_Model->get_list('larea', array('city' => $city), array('id', 'title'))->result();
        $status = !empty($data) ? true : false;
        echo json_encode(array('status' => $status, 'areas' => $data));
    }

    public function save_branch() {
        $data = $this->preparePostedData();
        $status = false;
        $message = null;
        if (!empty($data['terminal'])) {
            $data['terminal'] = serialize($data['terminal']);
        }
        if (isset($data['id']) && $data['id'] > 0) {
            $id = $data['id'];
            unset($data['id']);
            $status = $this->Settings_Model->save_branch($data, $id);
            if (isset($data['tax_option']) && isset($data['discount_option'])) {
                $this->change_tax_discount_option($data);
            }
            $this->Settings_Model->notifyupdate('zamanDbEposBranch');
        } else {
            $doesExist = $this->Settings_Model->count_rows('branch', array('address_country' => trim($data['address_country']), 'address_region' => trim($data['address_region']), 'address_city' => trim($data['address_city']), 'address_area' => trim($data['address_area']), 'address_street' => trim($data['address_street'])));
            if ($doesExist > 0) {
                $message = sprintf($this->lang->line('item_already_taken'), $data['title']);
            } else {
                $status = $this->Settings_Model->save_branch($data, null);
                if (isset($data['tax_option']) && isset($data['discount_option'])) {
                    $this->change_tax_discount_option($data);
                }
                $this->Settings_Model->notifyupdate('zamanDbEposBranch');
            }
        }
        if ($status) {
            $message = $this->lang->line('data_saved_successfully');
        } else {
            $message = $message != null ? $message : $this->lang->line('data_saving_failed');
        }
        echo json_encode(array('status' => $status ? true : false, 'message' => $message));
    }

    private function change_tax_discount_option($data) {
        if (!empty($data)) {
            $s1 = $this->db->update('menu', array('tax_option' => $data['tax_option'], 'discount_option' => $data['discount_option']), array('branch' => $this->session->userdata('branch')));
            $s2 = $this->db->update('menuselection', array('tax_option' => $data['tax_option'], 'discount_option' => $data['discount_option']), array('branch' => $this->session->userdata('branch')));
            if ($this->config->item('znotifysystemupdate') === 'yes' && ($s1 || $s2)) {
                $this->Settings_Model->notifyupdate('zamanDbEposMenu');
                $this->Settings_Model->notifyupdate('zamanDbEposMenuSelection');
            }
        }
    }

    public function service($branch = null) {
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('service');
        $data['refresh'] = base_url(uri_string());
        $data['services'] = $this->db->get('service')->result();
        $data['branches'] = $this->Settings_Model->get_list('branch', array('status' => '3'))->result();
        if ($branch != null && (int) $branch > 0) {
            $data['branchService'] = $this->Settings_Model->get_single('service', array('branch' => (int) $branch))->row_array();
        }
        $this->load->view('settings/settings/service', $data, false);
    }

    public function servicesave() {
        $data = $this->preparePostedData();
        $success = false;
        $doesBranchExits = $this->Settings_Model->exists('service', 'branch', $data['branch']);
        if ($doesBranchExits) {
            $success = $this->db->update('service', $data, array('branch' => $data['branch']));
        } else {
            $success = $this->db->insert('service', $data);
        }
        $message = $success ? $this->lang->line('data_saved_successfully') : $this->lang->line('data_saving_failed');
        echo json_encode(array('status' => $success, 'message' => $message));
    }

    public function servicetime($schedule = null) {
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('service_time');
        $data['refresh'] = base_url(uri_string());
        $data['serviceTimeHeads'] = $this->Settings_Model->get_list('servicetimehead', array('branch' => $this->session->userdata('branch')), null, null, 0, 'Title', 'ASC')->result();
        $data['services'] = $this->Settings_Model->get_single('service', array('branch' => $this->session->userdata('branch')))->row_array();
        $daysParam = array();
        if ($schedule != null && (int) $schedule > 0) {
            $timesSchedule = $this->Settings_Model->get_list('servicetime', array('schedule' => $schedule, 'branch' => $this->session->userdata('branch')))->result();
            foreach ($timesSchedule as $ats) {
                $daysParam[$ats->day] = $ats;
            }
        }
        $data['activeScheduler'] = $schedule;
        $data['daysParams'] = $daysParam;

        $this->load->view('settings/settings/servicetime', $data, false);
    }

    public function saveServiceTimeHead() {
        $data = $this->preparePostedData();
        $data['branch'] = $this->session->userdata('branch');
        $status = $this->db->insert('servicetimehead', $data);
        echo json_encode(array('status' => $status));
    }

    public function checkServiceTimeHead() {
        $column = $this->input->post('column');
        $value = $this->input->post('value');
        $result = $this->db->where(array($column => $value, 'branch' => $this->session->userdata('branch')))->count_all_results('servicetimehead') > 0;
        if ($result) {
            echo json_encode(sprintf($this->lang->line('item_already_taken'), $value));
        } else {
            echo json_encode(true);
        }
    }

    public function servicetimesave() {
        $schedule = $this->input->post('schedule');
        $days = array();
        $days['Sun'] = array(
            'day' => 'Sun',
            'opened' => $this->input->post('Sun_opened'),
            'start' => $this->input->post('Sun_start'),
            'end' => $this->input->post('Sun_end'),
            'service' => implode(',', $this->input->post('Sun_service')),
            'branch' => $this->session->userdata('branch'),
            'schedule' => $schedule
        );
        $days['Mon'] = array(
            'day' => 'Mon',
            'opened' => $this->input->post('Mon_opened'),
            'start' => $this->input->post('Mon_start'),
            'end' => $this->input->post('Mon_end'),
            'service' => implode(',', $this->input->post('Mon_service')),
            'branch' => $this->session->userdata('branch'),
            'schedule' => $schedule
        );
        $days['Tue'] = array(
            'day' => 'Tue',
            'opened' => $this->input->post('Tue_opened'),
            'start' => $this->input->post('Tue_start'),
            'end' => $this->input->post('Tue_end'),
            'service' => implode(',', $this->input->post('Tue_service')),
            'branch' => $this->session->userdata('branch'),
            'schedule' => $schedule
        );
        $days['Wed'] = array(
            'day' => 'Wed',
            'opened' => $this->input->post('Wed_opened'),
            'start' => $this->input->post('Wed_start'),
            'end' => $this->input->post('Wed_end'),
            'service' => implode(',', $this->input->post('Wed_service')),
            'branch' => $this->session->userdata('branch'),
            'schedule' => $schedule
        );
        $days['Thu'] = array(
            'day' => 'Thu',
            'opened' => $this->input->post('Thu_opened'),
            'start' => $this->input->post('Thu_start'),
            'end' => $this->input->post('Thu_end'),
            'service' => implode(',', $this->input->post('Thu_service')),
            'branch' => $this->session->userdata('branch'),
            'schedule' => $schedule
        );
        $days['Fri'] = array(
            'day' => 'Fri',
            'opened' => $this->input->post('Fri_opened'),
            'start' => $this->input->post('Fri_start'),
            'end' => $this->input->post('Fri_end'),
            'service' => implode(',', $this->input->post('Fri_service')),
            'branch' => $this->session->userdata('branch'),
            'schedule' => $schedule
        );
        $days['Sat'] = array(
            'day' => 'Sat',
            'opened' => $this->input->post('Sat_opened'),
            'start' => $this->input->post('Sat_start'),
            'end' => $this->input->post('Sat_end'),
            'service' => implode(',', $this->input->post('Sat_service')),
            'branch' => $this->session->userdata('branch'),
            'schedule' => $schedule
        );
        $this->db->trans_start();
        foreach ($days as $key => $aday) {
            if ($this->db->where(array('day' => $key, 'branch' => $aday['branch'], 'schedule' => $aday['schedule']))->count_all_results('servicetime') > 0) {
                $this->db->update('servicetime', $aday, array('day' => $key, 'branch' => $aday['branch'], 'schedule' => $aday['schedule']));
            } else {
                $this->db->insert('servicetime', $aday);
            }
        }
        $this->db->trans_complete();
        echo json_encode(array('status' => $this->db->trans_status()));
    }

    public function deleteServiceTime($id) {
        $this->db->trans_start();
        $this->db->delete('servicetime', array('schedule' => $id, 'branch' => $this->session->userdata('branch')));
        $status = $this->db->delete('servicetimehead', array('id' => $id, 'branch' => $this->session->userdata('branch')));
        $this->db->trans_complete();
        echo json_encode(array('status' => $this->db->trans_status() && $status));
    }

    public function deliveryplan() {
        $data['plans'] = $this->Settings_Model->get_list('deliveryplan', array('branch' => $this->session->userdata('branch')))->result();
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('delivery_plan');
        $data['refresh'] = base_url(uri_string());
        $this->load->view('settings/settings/deliveryplan', $data, false);
    }

    public function save_deliveryplan() {
        $data = $this->preparePostedData();
        $data['area'] = strtoupper($data['area']);
        $data['title'] = $data['area'];
        $update = empty($data['update']) ? 'yes' : 'no';
        if ($update === 'no') {
            unset($data['update']);
        }
        $status = false;
        $message = null;
        if (isset($data['id']) && $data['id'] > 0) {
            $id = $data['id'];
            unset($data['id']);
            $status = $this->Settings_Model->save_deliveryplan($data, $id);
        } else {
            $doesExist = $this->db->where(array('area' => $data['area'], 'branch' => $this->session->userdata('branch')))->count_all_results('deliveryplan') > 0;
            if ($doesExist > 0) {
                $message = sprintf($this->lang->line('item_already_taken'), $data['area']);
            } else {
                $data['branch'] = $this->session->userdata('branch');
                $status = $this->Settings_Model->save_deliveryplan($data, null);
            }
        }
        $plan = null;
        if ($status) {
            $plan = $this->Settings_Model->get_single('deliveryplan', array('id' => $status))->row();
            if ($this->config->item('znotifysystemupdate') === 'yes' && $update === 'yes') {
                $this->Settings_Model->notifyupdate('zamanDbEposDeliveryplan');
            }
            $message = $this->lang->line('data_saved_successfully');
        } else {
            $message = $message != null ? $message : $this->lang->line('data_saving_failed');
        }
        if ($plan) {
            $plan->branchTitle = get_title('branch', array('id' => $plan->branch));
            $plan->statusTitle = $plan->status === '3' ? $this->lang->line('active') : $this->lang->line('inactive');
        }
        echo json_encode(array('status' => $status ? true : false, 'message' => $message, 'plan' => $plan));
    }

    public function deleteDeliveryPlan() {
        $id = $this->input->post('id');
        if ($this->db->delete('deliveryplan', array('id' => $id))) {
            echo json_encode(array('status' => true));
        } else {
            echo json_encode(array('status' => false));
        }
    }

    public function updateDeliveryCell() {
        $column = $this->input->post('name');
        $value = $this->input->post('value');
        $pk = $this->input->post('pk');
        $result = $this->db->update('deliveryplan', array($column => $value), array('id' => $pk, 'branch' => $this->session->userdata('branch')));
        if ($this->config->item('znotifysystemupdate') === 'yes' && $result) {
            $this->Settings_Model->notifyupdate('zamanDbEposDeliveryplan');
        }

        echo json_encode(array('status' => $result));
    }

    public function discountplan() {
        $data['plans'] = $this->Settings_Model->get_list('discountplan', array('branch' => $this->session->userdata('branch')))->result();
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('discount_plan');
        $data['refresh'] = base_url(uri_string());
        $this->load->view('settings/settings/discountplan', $data, false);
    }

    public function discountplanadd($id = null) {
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('add_discount_plan');
        $data['loaded_plan'] = array();
        if ($id != null && (int) $id > 0) {
            $data['loaded_plan'] = $this->Settings_Model->get_single('discountplan', array('id' => trim($id), 'branch' => $this->session->userdata('branch')))->row_array();
        }
        $data['refresh'] = base_url(uri_string());
        $this->load->view('settings/settings/discountplanadd', $data, false);
    }

    public function save_discountplan() {
        $data = $this->preparePostedData();
        $data['onday'] = serialize($data['onday']);
        $data['onapp'] = serialize($data['onapp']);
        $data['onitem'] = serialize($data['onitem']);
        $status = false;
        if (isset($data['id']) && (int) $data['id'] > 0) {
            $id = $data['id'];
            unset($data['id']);
            $endDateObj = DateTime::createFromFormat('d/m/Y', $data['end_date']);
            $data['end_date'] = $endDateObj->format('Y-m-d');
            $status = $this->Settings_Model->save_discountplan($data, $id);
        } else {
            $startDateObj = DateTime::createFromFormat('d/m/Y', $data['start_date']);
            $endDateObj = DateTime::createFromFormat('d/m/Y', $data['end_date']);
            $data['start_date'] = $startDateObj->format('Y-m-d');
            $data['end_date'] = $endDateObj->format('Y-m-d');
            $data['branch'] = $this->session->userdata('branch');
            $status = $this->Settings_Model->save_discountplan($data, null);
        }
        if ($status && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Settings_Model->notifyupdate('zamanDbEposDiscountplan');
        }

        echo json_encode(array('status' => $status ? true : false));
    }

    public function deleteDiscountPlan($id) {
        if ((int) $id > 0) {
            echo json_encode(array('status' => $this->db->delete('discountplan', array('id' => $id))));
        }
    }

    public function promo() {
        $data['plans'] = $this->Settings_Model->get_list('discountpromo', array('branch' => $this->session->userdata('branch')))->result();
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('promotional_offer');
        $data['refresh'] = base_url(uri_string());
        $this->load->view('settings/settings/promo', $data, false);
    }

    public function promoadd($id = null) {
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('add_promotional_offer');
        $data['loaded_plan'] = array();
        $data['promocode'] = $this->Settings_Model->get_promo_code(7);
        if ($id != null && (int) $id > 0) {
            $data['loaded_plan'] = $this->Settings_Model->get_single('discountpromo', array('id' => trim($id)))->row_array();
        }
        $data['refresh'] = base_url(uri_string());
        $this->load->view('settings/settings/promoadd', $data, false);
    }

    public function save_promoplan() {
        $data = $this->preparePostedData();
        $data['onday'] = serialize($data['onday']);
        $data['onapp'] = serialize($data['onapp']);
        $data['onitem'] = serialize($data['onitem']);
        $status = false;
        if (isset($data['id']) && (int) $data['id'] > 0) {
            $id = $data['id'];
            unset($data['id']);
            $endDateObj = DateTime::createFromFormat('d/m/Y', $data['end_date']);
            $data['end_date'] = $endDateObj->format('Y-m-d');
            $status = $this->Settings_Model->save_promoplan($data, $id);
        } else {
            $startDateObj = DateTime::createFromFormat('d/m/Y', $data['start_date']);
            $endDateObj = DateTime::createFromFormat('d/m/Y', $data['end_date']);
            $data['start_date'] = $startDateObj->format('Y-m-d');
            $data['end_date'] = $endDateObj->format('Y-m-d');
            $data['branch'] = $this->session->userdata('branch');
            $status = $this->Settings_Model->save_promoplan($data, null);
        }
        echo json_encode(array('status' => $status ? true : false, 'id' => $status));
    }

    public function multidiscount() {
        $data['plans'] = $this->Settings_Model->get_list('discountmulti', array('branch' => $this->session->userdata('branch')))->result();
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('multi_discount');
        $data['refresh'] = base_url(uri_string());
        $this->load->view('settings/settings/multidiscount', $data, false);
    }

    public function multidiscountadd($id = null) {
        $data['categories'] = $this->Settings_Model->get_list('menucategory', array('status' => 3, 'branch' => $this->session->userdata('branch')))->result();
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('add_multi_discount');
        if ($id != null && (int) $id > 0) {
            $data['loaded_plan'] = $this->Settings_Model->get_single('discountmulti', array('id' => trim($id), 'branch' => $this->session->userdata('branch')))->row_array();
        }
        $data['refresh'] = base_url(uri_string());
        $this->load->view('settings/settings/multidiscountadd', $data, false);
    }

    public function save_multidiscount() {
        $data = $this->preparePostedData();
        $data['onday'] = serialize($data['onday']);
        $data['onapp'] = serialize($data['onapp']);
        $status = false;
        if (isset($data['id']) && (int) $data['id'] > 0) {
            $id = $data['id'];
            unset($data['id']);
            $endDateObj = DateTime::createFromFormat('d/m/Y', $data['end_date']);
            $data['end_date'] = $endDateObj->format('Y-m-d');
            $status = $this->Settings_Model->save_multidiscount($data, $id);
        } else {
            $startDateObj = DateTime::createFromFormat('d/m/Y', $data['start_date']);
            $endDateObj = DateTime::createFromFormat('d/m/Y', $data['end_date']);
            $data['start_date'] = $startDateObj->format('Y-m-d');
            $data['end_date'] = $endDateObj->format('Y-m-d');
            $data['branch'] = $this->session->userdata('branch');
            $status = $this->Settings_Model->save_multidiscount($data, null);
        }
        if ($status && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Settings_Model->notifyupdate('zamanDbEposDiscountmulti');
        }
        echo json_encode(array('status' => $status ? true : false, 'id' => $status));
    }

    public function itemOffer() {
        $data['refresh'] = base_url(uri_string());
        $data['itemOffers'] = $this->Settings_Model->get_list('discountitem')->result();
        $this->load->view('settings/settings/itemoffer', $data, false);
    }

    public function itemOfferAdd($id = null) {
        $data['refresh'] = base_url(uri_string());
        if ($id) {
            $data['thisOffer'] = $this->Settings_Model->get_single('discountitem', array('id' => $id))->row_array();
        }
        $data['menucategory'] = $this->Settings_Model->get_list('menucategory', array('status' => 3, 'branch' => $this->session->userdata('branch')), array('id', 'title'), null, 0, 'position', 'ASC')->result();
        $this->load->view('settings/settings/itemofferadd', $data, false);
    }

    public function saveItemOffer() {
        $status = false;
        $data = array(
            'title' => $this->input->post('title'),
            'order' => $this->input->post('order'),
            'qty' => $this->input->post('qty'),
            'type' => serialize($this->input->post('type')),
            'item' => serialize($this->input->post('items')),
            'status' => $this->input->post('status'),
            'branch' => $this->session->userdata('branch'),
        );
        if (!empty($this->input->post('id'))) {
            $status = $this->Settings_Model->save_itemoffer($data, $this->input->post('id'));
        } else {
            $status = $this->Settings_Model->save_itemoffer($data);
        }
        if (trim($this->config->item('znotifysystemupdate')) == 'yes') {
            $this->Settings_Model->notifyupdate('zamanDbEposDiscountItem');
        }
        echo json_encode(array('status' => $status));
    }

    public function deleteItemOffer($id) {
        $status = $this->db->delete('discountitem', array('id' => $id));
        if ($this->config->item('znotifysystemupdate') === 'yes' && $status) {
            $this->Settings_Model->notifyupdate('zamanDbEposDiscountItem');
        }
        echo json_encode(array('status' => $status ? true : false));
    }

    public function getmenusbycat() {
        $category = $this->input->post('id');
        $data = $this->Settings_Model->get_list('menu', array('category' => $category, 'branch' => $this->session->userdata('branch')), array('id', 'title'))->result();
        $status = !empty($data) ? true : false;
        echo json_encode(array('status' => $status, 'menus' => $data));
    }

    public function getselectionsbymenu() {
        $menu = $this->input->post('id');
        $data = $this->Settings_Model->get_list('menuselection', array('menu' => $menu, 'branch' => $this->session->userdata('branch')), array('id', 'title'))->result();
        $status = !empty($data) ? true : false;
        echo json_encode(array('status' => $status, 'selections' => $data));
    }

    public function voucher($code = null) {
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('voucher');
        $data['refresh'] = base_url(uri_string());
        $data['voucherCode'] = '';
        if ($code) {
            $data['vouchers'] = $this->Settings_Model->get_list('voucher', array('code' => $code, 'branch' => $this->session->userdata('branch'), 'team' => $this->session->userdata('team')))->result();
            $data['voucherCode'] = $code;
        } else {
            $data['vouchers'] = $this->Settings_Model->get_list('voucher', array('branch' => $this->session->userdata('branch'), 'team' => $this->session->userdata('team')))->result();
        }
        $this->load->view('settings/settings/voucher', $data, false);
    }

    public function voucheradd($id = null) {
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('add_voucher');
        $data['refresh'] = base_url(uri_string());
        $data['loaded_plan'] = array();
        $data['vouchercode'] = $this->Settings_Model->get_voucher_code(7);
        if ($id != null && (int) $id > 0) {
            $data['loaded_plan'] = $this->Settings_Model->get_single('voucher', array('id' => trim($id), 'branch' => $this->session->userdata('branch')))->row_array();
        }
        $this->load->view('settings/settings/voucheradd', $data, false);
    }

    public function save_voucher() {
        $data = $this->preparePostedData();
        $status = false;
        if (isset($data['id']) && (int) $data['id'] > 0) {
            $id = $data['id'];
            unset($data['id']);
            $endDateObj = DateTime::createFromFormat('d/m/Y', $data['end']);
            $data['end'] = $endDateObj->format('Y-m-d');
            $status = $this->Settings_Model->save_voucher($data, $id);
        } else {
            $startDateObj = DateTime::createFromFormat('d/m/Y', $data['start']);
            $endDateObj = DateTime::createFromFormat('d/m/Y', $data['end']);
            $data['start'] = $startDateObj->format('Y-m-d');
            $data['end'] = $endDateObj->format('Y-m-d');
            $data['balance'] = $data['amount'];
            $data['branch'] = $this->session->userdata('branch');
            $data['team'] = $this->session->userdata('team');
            $status = $this->Settings_Model->save_voucher($data, null);
        }
        if ($this->config->item('znotifysystemupdate') === 'yes') {
            $this->Settings_Model->notifyupdate('zamanDbEposVoucher');
        }
        echo json_encode(array('status' => $status ? true : false, 'id' => $status));
    }

    public function printVoucher($id) {
        $status = $this->db->update('voucher', array('isPrinted' => 'no'), array('id' => $id));
        echo json_encode(array('status' => $status ? true : false));
    }

    public function paymentoption($id = null) {
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('payment_type');
        $data['paymentOption'] = array();
        if ($id != null && (int) $id > 0) {
            $data['paymentOption'] = $this->db->where('id', (int) $id)->get('paymentoption')->row_array();
        }
        $data['paymentOptions'] = $this->db->get('paymentoption')->result();
        $data['refresh'] = base_url(uri_string());
        $this->load->view('settings/settings/paymentoption', $data, false);
    }

    public function checkpaymentoption() {
        $column = $this->input->post('column');
        $value = $this->input->post('value');
        $update = $this->input->post('update');
        $result = $this->Settings_Model->checkpaymentOption($column, $value, $update);
        if ($result) {
            echo json_encode(sprintf($this->lang->line('item_already_taken'), $value));
        } else {
            echo json_encode(true);
        }
    }

    public function save_paymentoptions() {
        $data = $this->preparePostedData();
        $status = false;
        if (isset($data['id']) && (int) $data['id'] > 0) {
            $id = $data['id'];
            unset($data['id']);
            $status = $this->Settings_Model->save_paymentoptions($data, $id);
        } else {
            $status = $this->Settings_Model->save_paymentoptions($data, null);
        }
        if ($this->config->item('znotifysystemupdate') === 'yes') {
            $this->Settings_Model->notifyupdate('zamanDbEposPaymentoption');
        }
        echo json_encode(array('status' => $status ? true : false, 'id' => $status));
    }

    public function paymentstripe() {
        $data['stripe'] = $this->Settings_Model->get_list('paymentstripe', array('branch' => $this->session->userdata('branch')))->row_array();
        $this->page_title = $this->lang->line('setting');
        $data['refresh'] = base_url(uri_string());
        $this->load->view('settings/settings/paymentstripe', $data, false);
    }

    public function paymentstripe_save() {
        $data = $this->preparePostedData();
        $status = false;
        if (!empty($data['id'])) {
            $status = $this->Settings_Model->save_paymentstripe($data, $data['id']);
        } else {
            $exist = $this->Settings_Model->get_single('paymentstripe', array('branch' => $this->session->userdata('branch')))->row();
            if (!empty($exist)) {
                $status = false;
            } else {
                $data['branch'] = $this->session->userdata('branch');
                $status = $this->Settings_Model->save_paymentstripe($data);
            }
        }
        echo json_encode(array('status' => $status, 'message' => 'Gateway already exists'));
    }

    public function pagination() {
        $this->page_title = $this->lang->line('setting') . ' | ' . $this->lang->line('pagination');
        $data['refresh'] = base_url(uri_string());
        $this->load->view('settings/settings/pagination', $data, false);
    }

    public function save() {
        $data = $this->preparePostedData();
        $uploadStatus = true;
        $uploadErrorMessage = null;
        $result = false;
        if (!empty($_FILES['general_logo'])) {
            $config = array('upload_path' => './uploads/', 'allowed_types' => 'gif|jpg|png|jpeg', 'max_size' => '1000', 'max_width' => '650', 'max_height' => '450', 'overwrite' => true);
            $uploadStatus = $this->uploadimage($config, 'general_logo');
            $uploadErrorMessage = $uploadStatus ? null : $this->upload->display_errors();
            $upload_data = $this->upload->data();
            if ($uploadStatus && !empty($upload_data['orig_name'])) {
                $data['general_logo'] = $upload_data['raw_name'] . $upload_data['file_ext'];
            }
        }
        if ($uploadStatus && $uploadErrorMessage == null) {
            $result = $this->Appconfig->batch_save($data);
        }
        if ($uploadStatus && $uploadErrorMessage == null && $result) {
            if ($this->config->item('znotifysystemupdate') === 'yes') {
                $this->Settings_Model->notifyupdate('zamanDbEposConfiguration');
            }
            echo json_encode(array('status' => true, 'message' => $this->lang->line('data_saved_successfully')));
        } else {
            $message = $uploadErrorMessage != null ? $uploadErrorMessage : $this->lang->line('data_saving_failed');
            echo json_encode(array('status' => false, 'message' => $message));
        }
    }

    public function remove_logo() {
        $data = $this->input->post();
        $status = checkfile($data['path'], $data['image']);
        if ($status) {
            $result = $this->Appconfig->batch_save(array($data['dbkey'] => ''));
            unlink(realpath($data['path'] . $data['image']));
            if (!checkfile($data['path'], $data['image']) && $result) {
                echo json_encode(array('status' => $result, 'message' => $this->lang->line('delete_success')));
            } else {
                echo json_encode(array('status' => false, 'message' => $this->lang->line('delete_failed')));
            }
        }
    }

    public function changeEnvironment() {
        $environment = $this->input->post('environment');
        $status = false;
        if ($environment === 'development' || $environment === 'production') {
            $status = $this->db->update('configuration', array('value' => $environment), array('key' => 'environment'));
        }
        echo json_encode(array('status' => $status));
    }

    public function terminal() {
        $data['refresh'] = base_url(uri_string());
        $this->load->view('settings/settings/terminal', $data, false);
    }

    public function controllPanel() {
        $data['refresh'] = base_url(uri_string());
        $this->load->view('settings/settings/controllPanel', $data, false);
    }

    public function api() {
        $data['refresh'] = base_url(uri_string());
        $data['thisBranchApi'] = $this->Settings_Model->get_single('apisetting', array('branch' => $this->session->userdata('branch')))->row_array();
        $this->load->view('settings/settings/api', $data, false);
    }

    public function api_save() {
        $data = $this->preparePostedData();
        $status = false;
        if (isset($data['id'])) {
            $id = $data['id'];
            unset($data['id']);
            $status = $this->db->update('apisetting', $data, array('id' => $id));
        } else {
            $data['branch'] = $this->session->userdata('branch');
            $status = $this->db->insert('apisetting', $data);
        }
        $msg = $status ? $this->lang->line('data_saved_successfully') : $this->lang->line('data_saving_failed');
        echo json_encode(array('status' => $status, 'message' => $msg));
    }

    function clearPrintingPool() {
        $status = $this->db->truncate('printing');
        echo json_encode(array('status' => $status));
    }

    function cleardatabse() {
        $secret = $this->input->post('secret');
        if (trim($secret) && $secret === 'ecse100200152') {
            echo json_encode(array('status' => $this->clearDataStorageOnlyBySuperAdmin()));
        } else {
            echo json_encode(array('status' => false));
        }
    }

    private function clearDataStorageOnlyBySuperAdmin() {
        if ($this->session->userdata('group') === '2') {
            $this->db->truncate('booking');
            $this->db->truncate('branch');
            $this->db->truncate('callerphone');
            $this->db->truncate('command');
            $this->db->truncate('customer');
            $this->db->truncate('customer_address');
            $this->db->truncate('deliveryplan');
            $this->db->truncate('discountitem');
            $this->db->truncate('discountmulti');
            $this->db->truncate('discountplan');
            $this->db->truncate('discountpromo');
            $this->db->truncate('employee');
            $this->db->truncate('employeeattendance');
            $this->db->truncate('employeedept');
            $this->db->truncate('employeemanager');
            $this->db->truncate('employeepost');
            $this->db->truncate('employeesalarysheet');
            $this->db->truncate('expense');
            $this->db->truncate('expenseledger');
            $this->db->truncate('ktchmsg');
            $this->db->truncate('menu');
            $this->db->truncate('menuattr');
            $this->db->truncate('menuattrcategory');
            $this->db->truncate('menucategory');
            $this->db->truncate('menuconvert');
            $this->db->truncate('menufixeddeal');
            $this->db->truncate('menuselection');
            $this->db->truncate('menuset');
            $this->db->truncate('menusetitem');
            $this->db->truncate('modifier');
            $this->db->truncate('modifiercategory');
            $this->db->truncate('modifiermenu');
            $this->db->truncate('nattr');
            $this->db->truncate('nattrcategory');
            $this->db->truncate('nset');
            $this->db->truncate('nsetitem');
            $this->db->truncate('order');
            $this->db->truncate('printing');
            $this->db->truncate('service');
            $this->db->truncate('servicetime');
            $this->db->truncate('servicetimehead');
            $this->db->truncate('transactionsummary');
            $this->db->truncate('updates');
            $this->db->truncate('useractivity');
            $this->db->truncate('userextension');
            $this->db->truncate('userlogtime');
            $this->db->truncate('userteam');
            $this->db->truncate('voucher');
            $this->db->delete('user', array('group<>' => '2'));
            return true;
        } else {
            return false;
        }
    }

    public function page() {
        $data['refresh'] = base_url(uri_string());
        $data['list'] = $this->Settings_Model->get_list('page')->result();
        $this->load->view('settings/settings/page', $data, false);
    }

    public function page_edit($id) {
        $data['refresh'] = base_url(uri_string());
        $data['page'] = $this->Settings_Model->get_single('page', array('id' => $id))->row_array();
        $this->load->view('settings/settings/page_edit', $data, false);
    }

}
