<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Booking extends Epos_Template {

    function __construct() {
        parent::__construct();
        $this->load->model('Report_Model');
        if ($this->Report_Model->isThisUserAnEposLogger() && (($this->cookies && !empty($this->cookies)) || ($this->session->userdata('group') == 2))) {
            return true;
        } else {
            redirect('user/login/index/' . $this->session->userdata('branch') . '/' . $this->session->userdata('team'));
        }
    }

    public function index($dateFrom = null, $dateTo = null, $branch = null) {
        $start_date = DateTime::createFromFormat('d-m-Y', trim($dateFrom) ? $dateFrom : date('d-m-Y', strtotime('today')));
        $end_date = $start_date;
        if (trim($dateTo)) {
            $end_date = DateTime::createFromFormat('d-m-Y', trim($dateTo) ? $dateTo : date('d-m-Y', strtotime('today')));
        }
        $start_date_value = $start_date->format('Y-m-d');
        $end_date_value = $end_date->format('Y-m-d');
        if (strtotime($end_date_value) < strtotime($start_date_value)) {
            $end_date_value = $start_date_value;
        }
        $activeBranch = null;
        if (trim($branch)) {
            $activeBranch = $branch;
        } else {
            $activeBranch = $this->session->userdata('branch');
        }
        $orderList = $this->Report_Model->get_booking($start_date_value, $end_date_value, $activeBranch)->result();
        $data['orderList'] = $orderList;
        $data['refresh'] = base_url(uri_string());

        $data['filterData'] = array($dateFrom, $dateTo, $activeBranch);
        $data['branches'] = $this->Report_Model->get_list('branch', array('status' => 3), array('id', 'title'))->result();
        if ($dateFrom === 'verified') {
            $this->render('report/booking', $data);
        } else {
            $this->load->view('report/booking', $data, false);
        }
    }

    public function delete($id) {
        if ((int) $id > 0) {
            echo json_encode(array('status' => $this->db->delete('booking', array('id' => $id))));
        }
    }

}
