<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane">
            <div class="content-inner">
                <div class="content-form" style="width: 80%; float: left; background: #087692; padding: 20px;">
                    <table class="report-table">
                        <caption>Review List</caption>
                        <?php if (!empty($list)): ?>
                            <tr class="table-bg">
                                <th style="width: 20%" class="text-center">Customer Name</th>
                                <th style="width: 10%" class="text-center">Status</th>
                                <th style="width: 10%" class="text-center">Ratting</th>
                                <th style="width: 50%" class="text-center">Message</th>
                                <th style="width: 10%" class="text-center">Action</th>
                            </tr>
                            <?php foreach ($list as $review): ?>
                                <tr>
                                    <td style="width: 20%"><?php echo $review->name ?></td>
                                    <td style="width: 10%" class="text-center"><?php echo $review->status == 3 ? 'Approved' : 'Disapproved' ?></td>
                                    <td style="width: 10%" class="text-center"><?php echo $review->rating ?></td>
                                    <td style="width: 50%"><?php echo $review->message ?></td>
                                    <td class="text-center" style="width: 10%">
                                        <?php if ($review->status == 3): ?>
                                            <a href="javascript:void(0)" onclick='changeReviewStatus("disapprove", "<?php echo $review->id ?>")'>Disapprove</a>
                                        <?php else: ?>
                                            <a href="javascript:void(0)" onclick='changeReviewStatus("approve", "<?php echo $review->id ?>")'>Approve</a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </table>
                </div>
                <div class="content-sidebar-nav" style="width: 20%; float: right;">
                    <?php $this->load->view('page/page_nav') ?>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="setting-general-keyboard text-center"></div>
<?php $this->load->view('settings/partials/footer') ?>
<script type="text/javascript">
    function changeReviewStatus(status, id) {
        $.ajax({
            url: '<?php echo site_url('page/changeReviewStatus') ?>',
            dataType: 'json',
            type: 'POST',
            data: {status: status, id: id},
            success: function (response) {
                if (response.status) {
                    zamanEposNavigator('page', '<?php echo site_url('page/riviewlist') ?>', 'page');
                } else {
                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                }
            }
        });
    }
</script>
