<?php
$menuType = array('2' => 'Non Kitchen', '3' => 'Kitchen');
$menuStatus = array('2' => 'Inactive', '3' => 'Active');
$menuOnline = array('2' => 'No', '3' => 'Yes');
?>
<div class="pane category-list-block list-block">
    <div class="caption" onclick="zamanEposBlockHideAndShow('categoryFormBlock')">
        <div class="caption-inner"><?php echo $this->lang->line('add_new_category') ?></div>
    </div>
    <div class="block-inner" id="categoryFormBlock" style="display: none;">
        <?php echo form_open('menu/category/save/', array('id' => 'menuCategoryForm')); ?>
        <?php if (!empty($loaded_category)): ?>
            <input type="hidden" name="id" value="<?php echo $loaded_category['id'] ?>">
            <input type="hidden" id="updateCategory" value="yes">
            <input type="hidden" id="oldCategoryTitle" value="<?php echo $loaded_category['title'] ?>">
            <input type="hidden" id="oldCategoryCode" value="<?php echo $loaded_category['code'] ?>">
        <?php endif; ?>
        <div class="pane" style="border: none; padding-left: 3px;">
            <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('title') ?></div>
            <div class="form-group pane">
                <input value="<?php !empty($loaded_category) ? print $loaded_category['title'] : '' ?>"  type="text" data-error="#menuCategoryFormTitle" name="title" id="categoryTitle" class="form-control" placeholder="<?php echo $this->lang->line('title') ?>">
                <div class="clearfix" id="menuCategoryFormTitle"></div>
            </div>
        </div>
        <div class="pane" style="border: none;padding-left: 3px;">
            <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('description') ?></div>
            <div class="form-group pane">
                <textarea name="content" class="form-control"><?php !empty($loaded_category) ? print $loaded_category['content'] : '' ?></textarea>
            </div>
        </div>
        <div class="pane" style="border: none;padding-left: 3px;">
            <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('send_terminal') ?></div>
            <div class="form-group pane">
                <label><input  data-error="#menuCategoryFormType" type="radio" name="type" value="kitchen" <?php !empty($loaded_category) && $loaded_category['type'] == 'kitchen' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('kitchen') ?></label>
                <!--&nbsp;&nbsp;<label><input data-error="#menuCategoryFormType" name="type" type="radio" value="bar" <?php !empty($loaded_category) && $loaded_category['type'] == 'bar' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('bar') ?></label>-->
                <label><input  data-error="#menuCategoryFormType" type="radio" name="type" value="drinks" <?php !empty($loaded_category) && $loaded_category['type'] == 'drinks' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('drinks') ?></label>
                <!--<label><input  data-error="#menuCategoryFormType" type="radio" name="type" value="bakery" <?php !empty($loaded_category) && $loaded_category['type'] == 'bakery' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('bakery') ?></label>-->
                <div class="clearfix" id="menuCategoryFormType"></div>
            </div>
        </div>
        <div class="pane">
            <div class="tab-group">
                <div class="tab-item" style="padding: 5px" onclick="resetForm('menuCategoryForm')"><?php echo $this->lang->line('clear_form_add_new') ?></div>
                <div class="tab-item" style="padding: 5px;" onclick="showItemOption('hide-category-option')"><?php echo $this->lang->line('more_option') ?></div>
            </div>
        </div>
        <div class="pane hide-category-option" style="border: none; padding-left: 3px;">
            <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('code') ?></div>
            <div class="form-group pane">
                <input value="<?php !empty($loaded_category) ? print $loaded_category['code'] : '' ?>" type="text" data-error="#menuCategoryFormCode" name="code" id="categoryCode" class="form-control" placeholder="<?php echo $this->lang->line('code') ?>">
                <div class="clearfix" id="menuCategoryFormCode"></div>
            </div>
        </div>    
        <div class="pane hide-category-option" style="border: none; padding-left: 3px;">
            <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('unit') ?></div>
            <div class="form-group pane">
                <select name="unit" data-error="#menuCategoryFormUnit" class="form-control" id="categoryUnit">
                    <option value="<?php echo $this->lang->line('pc') ?>" <?php !empty($loaded_category) && $loaded_category['unit'] == $this->lang->line('pc') ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('pc') ?></option>
                    <option value="<?php echo $this->lang->line('mg') ?>" <?php !empty($loaded_category) && $loaded_category['unit'] == $this->lang->line('mg') ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('mg') ?></option>
                    <option value="<?php echo $this->lang->line('g') ?>" <?php !empty($loaded_category) && $loaded_category['unit'] == $this->lang->line('g') ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('g') ?></option>
                    <option value="<?php echo $this->lang->line('kg') ?>" <?php !empty($loaded_category) && $loaded_category['unit'] == $this->lang->line('kg') ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('kg') ?></option>
                    <option value="<?php echo $this->lang->line('mt') ?>" <?php !empty($loaded_category) && $loaded_category['unit'] == $this->lang->line('mt') ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('mt') ?></option>
                    <option value="<?php echo $this->lang->line('inch') ?>" <?php !empty($loaded_category) && $loaded_category['unit'] == $this->lang->line('inch') ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('inch') ?></option>
                    <option value="<?php echo $this->lang->line('ft') ?>" <?php !empty($loaded_category) && $loaded_category['unit'] == $this->lang->line('ft') ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('ft') ?></option>
                    <option value="<?php echo $this->lang->line('yard') ?>" <?php !empty($loaded_category) && $loaded_category['unit'] == $this->lang->line('yard') ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('yard') ?></option>
                    <option value="<?php echo $this->lang->line('metre') ?>" <?php !empty($loaded_category) && $loaded_category['unit'] == $this->lang->line('metre') ? print 'selected="selected"' : '' ?>><?php echo $this->lang->line('metre') ?></option>
                </select>
                <div class="clearfix" id="menuCategoryFormUnit"></div>
            </div>
        </div>      
        <div class="pane hide-category-option" style="border: none; padding-left: 3px;">
            <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('tax') ?>(<?php echo $this->lang->line('percent') ?>)</div>
            <div class="form-group pane">
                <input value="<?php !empty($loaded_category) ? print $loaded_category['tax'] : '' ?>" data-error="#menuCategoryFormTax" type="text" name="tax" class="form-control" value="0" placeholder="<?php echo $this->lang->line('tax') . ' ' . $this->lang->line('percent') ?>">
                <div class="clearfix" id="menuCategoryFormTax"></div>
            </div>
        </div>  
        <div class="pane hide-category-option" style="border: none; padding-left: 3px;">
            <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('discount') ?>(<?php echo $this->lang->line('percent') ?>)</div>
            <div class="form-group pane">
                <input value="<?php !empty($loaded_category) ? print $loaded_category['discount'] : '' ?>"  data-error="#menuCategoryFormDiscount" type="text" name="discount" class="form-control" value="0" placeholder="<?php echo $this->lang->line('discount') . ' ' . $this->lang->line('percent') ?>">
                <div class="clearfix" id="menuCategoryFormDiscount"></div>
            </div>
        </div>   
        <div class="pane hide-category-option" style="border: none; padding-left: 3px;">
            <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('show') ?></div>
            <div class="form-group pane">
                <label class="text-capitalize"><input type="checkbox" value="3" name="inline" <?php !empty($loaded_category) && $loaded_category['inline'] == 3 ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('in') ?>&nbsp;</label>
                <label class="text-capitalize"><input type="checkbox" value="3" name="online" <?php !empty($loaded_category) && $loaded_category['online'] == 3 ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('out') ?></label>
            </div>
        </div> 
        <div class="pane hide-category-option" style="border: none; padding-left: 3px;">
            <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('status') ?></div>
            <div class="form-group pane">
                <label><input data-error="#menuCategoryFormStatus" type="radio" name="status" value="3" <?php !empty($loaded_category) && $loaded_category['status'] == 3 ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('active') ?></label>
                <label><input data-error="#menuCategoryFormStatus" type="radio" name="status" value="2" <?php !empty($loaded_category) && $loaded_category['status'] == 2 ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('inactive') ?></label>
                <div class="clearfix" id="menuCategoryFormStatus"></div>
            </div>
        </div>
        <div class="pane hide-category-option" style="border: none; padding-left: 3px;">
            <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('is_featured') ?></div>
            <div class="form-group pane">
                <label><input data-error="#menuCategoryFormIsfeatured" type="radio" name="featured" value="yes" <?php !empty($loaded_category) && $loaded_category['featured'] == 'yes' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('yes') ?></label>
                <label><input data-error="#menuCategoryFormIsfeatured" type="radio" name="featured" value="no" <?php !empty($loaded_category) && $loaded_category['featured'] == 'no' ? print 'checked="checked"' : '' ?>>&nbsp;<?php echo $this->lang->line('no') ?></label>
                <div class="clearfix" id="menuCategoryFormIsfeatured"></div>
            </div>
        </div>
        <div class="pane hide-category-option" style="border: none; padding-left: 3px;">
            <div class="pane-one-third pane-form-label"><?php echo $this->lang->line('image') ?></div>
            <div class="form-group pane">
                <div class="block thumbnail text-center">
                    <?php if (!empty($loaded_category) && trim($loaded_category['image'])): ?>
                        <img src="<?php echo EPOS_UPLOAD_PATH . 'menucategory/' . $loaded_category['image'] ?>" alt="<?php echo $loaded_category['title'] ?>">
                        <span class="icon icon-trash text-right clearfix" onclick="deleteImage('<?php echo $loaded_category['id'] ?>', 'image', '<?php echo $loaded_category['image'] ?>', 'menucategory', './uploads/menucategory/', '<?php echo site_url('menu/deleteImage') ?>')">&nbsp;<?php echo $this->lang->line('remove') ?></span>
                    <?php endif; ?>
                </div>
                <input type="file" name="image" class="form-control">
            </div>
        </div> 
        <div class="pane" style="border: none;">
            <div class="tab-group config-submit">
                <button type="submit" onclick="menuCategoryForm('menuCategoryForm');"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save_category') ?></button>
            </div>
        </div>    
        <?php echo form_close() ?>
    </div>
    <?php if (!empty($menu_category)): ?>
        <div class="clearfix item-group">
            <div class="accordion-wrapper" id="categoryAccordionWrapper">
                <?php foreach ($menu_category as $category): ?>
                    <div class="tab blue">
                        <input id="<?php echo'category-' . $category->id ?>" type="checkbox" name="tabs">
                        <label for="<?php echo'category-' . $category->id ?>"><?php echo $category->title ?></label>
                        <div class="tab-content">
                            <div class="tab-group">
                                <div class="tab-item" style="padding: 5px;" onclick="zamanEposNavigator('', '<?php echo site_url('menu/index/' . $category->id) ?>', 'menuIndex')"><span class="icon icon-pencil"></span></div>
                                <div class="tab-item" style="padding: 5px;" onclick="sortMenuCategory('<?php echo $category->id ?>', '<?php echo $category->position ?>', '<?php echo 'down' ?>')"><?php echo $this->lang->line('order') ?>&nbsp;<span class="icon icon-up-open-big"></span></div>
                                <div class="tab-item" style="padding: 5px;" onclick="sortMenuCategory('<?php echo $category->id ?>', '<?php echo $category->position ?>', '<?php echo 'up' ?>')"><?php echo $this->lang->line('order') ?>&nbsp;<span class="icon icon-down-open-big"></span></div>
                                <?php if ($this->session->userdata('group') <= 2): ?>
                                    <div class="tab-item" style="padding: 5px;" onclick="deleteACategory('<?php echo $category->id ?>', '<?php echo $category->title . ' ' . $this->lang->line('category') ?>')"><span class="icon icon-trash"></span></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
                <?php if ($this->session->userdata('group') === '2'): ?>
                    <div class="tab-group config-submit">
                        <button onclick="deleteAllCategory()"><span class="icon icon-trash"></span>&nbsp;<?php echo $this->lang->line('delete_all_categories') ?></button>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
</div>
<script type="text/javascript">
    function menuCategoryForm(formId) {
        if (!$('.page-loader').is(":visible")) {
            $('#' + formId).validate({
                submitHandler: function () {
                    var myform = document.getElementById(formId);
                    var formdata = new FormData(myform);
                    if (checkInternetConnection()) {
                        $.ajax({
                            url: $('#' + formId).attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function () {
                                $('.page-loader').show();
                            },
                            success: function (response) {
                                if (response.status) {
                                    $('.page-loader').hide();
                                    zamanEposNavigator('', '<?php echo site_url('menu/index/') ?>' + response.category, 'menuIndex');
                                } else {
                                    warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                                }
                            }
                        });
                    } else {
                        warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                    }
                },
                errorClass: "has-error",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    title: {
                        required: true,
                        remote: {url: "<?php echo site_url('menu/category/checkme') ?>",
                            type: "post",
                            data: {value: function () {
                                    return $("#categoryTitle").val();
                                }, column: 'title', old: function () {
                                    if ($('#oldCategoryTitle').length > 0) {
                                        return $('#oldCategoryTitle').val();
                                    } else {
                                        return 'none';
                                    }
                                }, update: function () {
                                    if ($('#updateCategory').length > 0) {
                                        return 'yes';
                                    } else {
                                        return 'no';
                                    }
                                }
                            }
                        }
                    },
                    code: {
                        number: true,
                        nowhitespace: true,
                        min: 1,
                        max: 999,
                        remote: {url: "<?php echo site_url('menu/category/checkme') ?>",
                            type: "post",
                            data: {
                                value: function () {
                                    return $("#categoryCode").val();
                                },
                                column: 'code',
                                old: function () {
                                    if ($('#oldCategoryCode').length > 0) {
                                        return $('#oldCategoryCode').val();
                                    } else {
                                        return 'none';
                                    }
                                },
                                update: function () {
                                    if ($('#updateCategory').length > 0) {
                                        return 'yes';
                                    } else {
                                        return 'no';
                                    }
                                }
                            }
                        }
                    },
                    type: {required: true},
                    tax: {number: true, min: 0},
                    discount: {number: true, min: 0}
                },
                messages: {
                    title: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('title')) ?>',
                    code: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('code')) ?>',
                    type: '<?php echo sprintf($this->lang->line('item_required'), $this->lang->line('type')) ?>',
                    tax: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('tax')) ?>',
                    discount: '<?php echo sprintf($this->lang->line('invalid_value'), $this->lang->line('discount')) ?>'
                },
                errorPlacement: function (error, element) {
                    errorPlacement(error, element);
                }
            });
        }
    }
    function sortMenuCategory(id, position, func) {
        if (!$('.page-loader').is(":visible")) {
            if (checkInternetConnection()) {
                $.ajax({
                    url: '<?php echo site_url('menu/category/sortme') ?>',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        id: id,
                        position: position,
                        func: func
                    },
                    beforeSend: function (xhr) {
                        $('.page-loader').show();
                    },
                    success: function (response) {
                        $('.page-loader').hide();
                        if (response.status) {
                            zamanEposNavigator('', '<?php echo site_url('menu') ?>', 'menuIndex');
                        } else {
                            warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                        }
                    }
                });
            } else {
                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
            }
        }
    }
    function deleteACategory(id, title) {
        if (!$('.page-loader').is(":visible")) {
            $.confirm({
                title: '<?php echo $this->lang->line('warning') ?>',
                message: '<?php echo $this->lang->line('delete_warning_message') ?>' + title,
                buttons: {
                    '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                        'class': 'negative',
                        'action': function () {
                            if (checkInternetConnection()) {
                                $.ajax({
                                    url: '<?php echo site_url('menu/category/delete/') ?>' + id,
                                    type: 'GET',
                                    dataType: 'json',
                                    beforeSend: function (xhr) {
                                        $('.page-loader').show();
                                    },
                                    success: function (response) {
                                        $('.page-loader').hide();
                                        if (response.status) {
                                            zamanEposNavigator('', '<?php echo site_url('menu') ?>', 'menuIndex');
                                        } else {
                                            warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                                        }
                                    }
                                });
                            } else {
                                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                            }
                        }
                    },
                    '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                        'class': 'negative',
                        'action': function () {}
                    }
                }
            });
        }
    }
    function deleteAllCategory() {
        if (!$('.page-loader').is(":visible")) {
            $.confirm({
                title: '<?php echo $this->lang->line('warning') ?>',
                message: '<?php echo $this->lang->line('delete_warning_message_all') . ' ' . $this->lang->line('categories') ?>',
                buttons: {
                    '<span class="icon icon-check">&nbsp;<?php echo $this->lang->line('yes') ?></span>': {
                        'class': 'positive',
                        'action': function () {
                            if (checkInternetConnection()) {
                                $.ajax({
                                    url: '<?php echo site_url('menu/category/deleteAll') ?>',
                                    type: 'GET',
                                    dataType: 'json',
                                    beforeSend: function (xhr) {
                                        $('.page-loader').show();
                                    },
                                    success: function (response) {
                                        $('.page-loader').hide();
                                        if (response.status) {
                                            zamanEposNavigator('', '<?php echo site_url('menu') ?>', 'menuIndex');
                                        } else {
                                            warning('<?php echo $this->lang->line('error') ?>', '<?php echo $this->lang->line('data_saving_failed') ?>', '<?php echo $this->lang->line('close') ?>');
                                        }
                                    }
                                });
                            } else {
                                warning('<?php echo $this->lang->line('lost_connection') ?>', '<?php echo $this->lang->line('lost_connection_message') ?>', '<?php echo $this->lang->line('close') ?>');
                            }
                        }
                    },
                    '<span class="icon icon-cancel">&nbsp;<?php echo $this->lang->line('no') ?></span>': {
                        'class': 'negative',
                        'action': function () {}
                    }
                }
            });
        }
    }
</script>