<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Nattr extends Epos_Template {

    private $branch = 0;

    function __construct() {
        parent::__construct();
        $this->load->model('Nattr_Model');
        if ($this->Nattr_Model->isThisUserAnEposLogger() && (($this->cookies && !empty($this->cookies)) || ($this->session->userdata('group') == 2))) {
            $this->branch = $this->session->userdata('branch');
            return true;
        } else {
            redirect('user/login/index/' . $this->session->userdata('branch') . '/' . $this->session->userdata('team'));
        }
    }

    public function index($category = null, $attr = null) {
        $data['nattrcategory'] = $this->Nattr_Model->get_list('nattrcategory', array('branch' => $this->session->userdata('branch')), null, null, 0, 'position', 'ASC')->result();
        $data['refresh'] = site_url('menu/nattr');
        if (!empty($data['nattrcategory'])) {
            if ($category != null && (int) $category > 0) {
                $data['loaded_category'] = $this->Nattr_Model->get_single('nattrcategory', array('id' => trim($category), 'branch' => $this->session->userdata('branch')))->row_array();
                $data['loaded_category_attr'] = $this->Nattr_Model->get_list('nattr', array('nattrcategory' => trim($data['loaded_category']['id']), 'branch' => $this->session->userdata('branch')), null, null, 0, 'position', 'ASC')->result();
            } else {
                $data['loaded_category'] = objectToArray($data['nattrcategory'][0]);
                $data['loaded_category_attr'] = $this->Nattr_Model->get_list('nattr', array('nattrcategory' => trim($data['loaded_category']['id']), 'branch' => $this->session->userdata('branch')), null, null, 0, 'position', 'ASC')->result();
            }
            if ($attr !== null && (int) $attr > 0) {
                $data['loaded_attr'] = $this->Nattr_Model->get_single('nattr', array('id' => trim($attr), 'nattrcategory' => trim($category), 'branch' => $this->session->userdata('branch')))->row_array();
            } else {
                if (!empty($data['loaded_category_attr'][0])) {
                    $data['loaded_attr'] = objectToArray($data['loaded_category_attr'][0]);
                } else {
                    $data['loaded_attr'] = array();
                }
            }
        }
        $this->load->view('menu/nattr/index', $data);
    }

    public function save($category = null) {
        if ($category != null && $this->Nattr_Model->exists('nattrcategory', 'id', trim($category))) {
            $data = $this->preparePostedData();
            $data['nattrcategory'] = trim($category);
            $insert_id = null;
            $result = true;
            if (!isset($data['id']) || $data['id'] == NULL) {
                $data['created_by'] = $this->session->userdata('owner');
                $data['branch'] = $this->session->userdata('branch');
                $data['status'] = 3;
                $insert_id = $this->Nattr_Model->save($data, NULL);
                if ($insert_id) {
                    $activity = array(
                        'activity' => ucfirst($this->session->userdata('name')) . ' has added  topping ' . $data['title']
                    );
                    $this->Nattr_Model->posactivity($activity);
                }
                $result = $insert_id ? $this->Nattr_Model->save(array('position' => $insert_id), $insert_id) : false;
            } else {
                $id = $data['id'];
                unset($data['id']);
                $insert_id = $this->Nattr_Model->save($data, $id);
                if ($insert_id) {
                    $activity = array(
                        'activity' => ucfirst($this->session->userdata('name')) . ' has updated topping ' . $data['title']
                    );
                    $this->Nattr_Model->posactivity($activity);
                }
            }
            if ($insert_id && $this->config->item('znotifysystemupdate') === 'yes') {
                $this->Nattr_Model->notifyupdate('zamanDbEposNattr');
            }
            $message = $insert_id && $result ? $this->lang->line('data_saved_successfully') : $this->lang->line('data_saving_failed');
            echo json_encode(array('status' => $insert_id && $result, 'message' => $message, 'category' => trim($category), 'nattr' => $insert_id));
        }
    }

    public function checkme() {
        $column = $this->input->post('column');
        $value = $this->input->post('value');
        $update = $this->input->post('update');
        $result = $this->Nattr_Model->checkme($column, $value, $update);
        if ($result) {
            echo json_encode(sprintf($this->lang->line('item_already_taken'), $value));
        } else {
            echo json_encode(true);
        }
    }

    public function savecategory() {
        $data = $this->preparePostedData();
        $insert_id = null;
        $result = true;
        if (!isset($data['id']) || $data['id'] == NULL) {
            $data['created_by'] = $this->session->userdata('owner');
            $data['branch'] = $this->session->userdata('branch');
            $data['status'] = 3;
            $insert_id = $this->Nattr_Model->savecategory($data, NULL);
            if ($insert_id) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('name')) . ' has added  topping category ' . $data['title']
                );
                $this->Nattr_Model->posactivity($activity);
            }
            $result = $insert_id ? $this->Nattr_Model->savecategory(array('position' => $insert_id), $insert_id) : false;
        } else {
            $id = $data['id'];
            unset($data['id']);
            $insert_id = $this->Nattr_Model->savecategory($data, $id);
            if ($insert_id) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('name')) . ' has updated  topping category ' . $data['title']
                );
                $this->Nattr_Model->posactivity($activity);
            }
        }
        if ($insert_id && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Nattr_Model->notifyupdate('zamanDbEposNattrCategory');
        }
        $message = $insert_id && $result ? $this->lang->line('data_saved_successfully') : $this->lang->line('data_saving_failed');

        echo json_encode(array('status' => $insert_id && $result, 'message' => $message, 'category' => $insert_id));
    }

    public function checkcategory() {
        $column = $this->input->post('column');
        $value = $this->input->post('value');
        $update = $this->input->post('update');
        $result = $this->Nattr_Model->checkcategory($column, $value, $update);
        if ($result) {
            echo json_encode(sprintf($this->lang->line('item_already_taken'), $value));
        } else {
            echo json_encode(true);
        }
    }

    public function sortcategory() {
        $func = $this->input->post('func');
        $id = $this->input->post('id');
        $position = $this->input->post('position');
        $newPosition = $position;
        if ($func == 'up') {
            $newPosition = $position + 1;
        }
        if ($func == 'down' && $position > 1) {
            $newPosition = $position - 1;
        }
        $MinMax = $this->Nattr_Model->get_min_max('nattrcategory', 'position')->row();
        if (true === in_array($newPosition, range($MinMax->min, $MinMax->max))) {
            $s1 = $this->db->update('nattrcategory', array('position' => $position), array('position' => $newPosition));
            $s2 = $this->db->update('nattrcategory', array('position' => $newPosition), array('id' => $id));
            if ($s1 && $s2 && $this->config->item('znotifysystemupdate') === 'yes') {
                $this->Nattr_Model->notifyupdate('zamanDbEposNattrCategory');
            }
            echo json_encode(array('status' => $s1 && $s2));
        }
    }

    public function deleteCategory($id) {
        $hasDeleted = $this->db->where(array('nattrcategory' => $id, 'branch' => $this->session->userdata('branch')))->delete('nattr');
        $status = $this->db->where(array('id' => $id, 'branch' => $this->session->userdata('branch')))->delete('nattrcategory');
        if ($hasDeleted) {
            if ($this->config->item('znotifysystemupdate') === 'yes') {
                $this->Nattr_Model->notifyupdate('zamanDbEposNattrCategory');
                $this->Nattr_Model->notifyupdate('zamanDbEposNattr');
            }
            $activity = array(
                'activity' => ucfirst($this->session->userdata('name')) . ' has deleted a topping category #' . $id
            );
            $this->Nattr_Model->posactivity($activity);
        }
        echo json_encode(array('status' => $status));
    }

}
