<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Menu extends Epos_Template {

    private $branch = 0;

    function __construct() {
        parent::__construct();
        $this->load->model('Menu_Model');
        if ($this->Menu_Model->isThisUserAnEposLogger() && (($this->cookies && !empty($this->cookies)) || ($this->session->userdata('group') == 2))) {
            $this->branch = $this->session->userdata('branch');
            return true;
        } else {
            redirect('user/login/index/' . $this->session->userdata('branch') . '/' . $this->session->userdata('team'));
        }
    }

    public function index($category = null, $menu = null, $selection = null) {
        $data = array();
        $data['menu_category'] = $this->Menu_Model->get_list('menucategory', array('branch' => $this->branch), null, null, 0, 'position', 'ASC')->result();
        $urlString = 'menu';
        if (!empty($data['menu_category'])) {
            if ($category != null && (int) $category > 0) {
                $urlString .= '/index/' . $category;
                $data['loaded_category'] = $this->Menu_Model->get_single('menucategory', array('id' => trim($category), 'branch' => $this->branch))->row_array();
                $data['loaded_category_menus'] = $this->Menu_Model->get_list('menu', array('category' => trim($data['loaded_category']['id']), 'branch' => $this->branch), null, null, 0, 'position', 'ASC')->result();
            } else {
                $data['loaded_category'] = objectToArray($data['menu_category'][0]);
                $data['loaded_category_menus'] = $this->Menu_Model->get_list('menu', array('category' => trim($data['loaded_category']['id']), 'branch' => $this->branch), null, null, 0, 'position', 'ASC')->result();
                $urlString .= '/index/' . $data['loaded_category']['id'];
            }
            if ($menu !== null && (int) $menu > 0) {
                $urlString .= '/' . $menu;
                $data['loaded_menu'] = $this->Menu_Model->get_single('menu', array('id' => trim($menu), 'category' => trim($category), 'branch' => $this->branch))->row_array();
            } else {
                if (!empty($data['loaded_category_menus'][0])) {
                    $data['loaded_menu'] = objectToArray($data['loaded_category_menus'][0]);
                    $urlString .= '/' . $data['loaded_menu']['id'];
                } else {
                    $data['loaded_menu'] = array();
                }
            }
            if (!empty($data['loaded_menu'])) {
                $data['loaded_menu_selection'] = $this->Menu_Model->get_list('menuselection', array('category' => trim($data['loaded_category']['id']), 'menu' => trim($data['loaded_menu']['id']), 'branch' => $this->branch), null, null, 0, 'position', 'ASC')->result();
            }
            if ($selection != null && (int) $selection > 0) {
                $urlString .= '/' . $selection;
                $data['loaded_selection'] = $this->Menu_Model->get_single('menuselection', array('id' => trim($selection), 'menu' => trim($menu), 'category' => trim($category), 'branch' => $this->branch))->row_array();
            }
        }
        $data['refresh'] = site_url($urlString);
        $this->load->view('menu/menu/index', $data, false);
    }

    public function save($category = null) {
        if ($category != null && $this->Menu_Model->exists('menucategory', 'id', trim($category))) {
            $data = $this->preparePostedData();
            $data['category'] = trim($category);
            $uploadErrorMessage = '';
            if (!empty($_FILES['image'])) {
                $config = array('upload_path' => './uploads/menu/', 'allowed_types' => 'gif|jpg|png|jpeg', 'max_size' => '1000', 'max_width' => '650', 'max_height' => '450', 'overwrite' => true);
                $uploadStatus = $this->uploadimage($config, 'image');
                $uploadErrorMessage = $uploadStatus ? null : $this->upload->display_errors();
                $upload_data = $this->upload->data();
                if ($uploadStatus && !empty($upload_data['orig_name'])) {
                    $data['image'] = $upload_data['raw_name'] . $upload_data['file_ext'];
                }
            }
            $insert_id = null;
            $result = true;
            if ((int) $data['tax'] > 0) {
                $data['tax_option'] = 4;
            }
            if ((int) $data['discount'] > 0) {
                $data['discount_option'] = 5;
            }
            if (!isset($data['id']) || $data['id'] == NULL) {
                $data['status'] = 3;
                $data['online'] = 3;
                $data['created_by'] = $this->session->userdata('owner');
                $data['branch'] = $this->branch;
                $insert_id = $this->Menu_Model->save($data, NULL);
                if ($insert_id) {
                    $activity = array(
                        'activity' => ucfirst($this->session->userdata('name')) . ' added menu ' . $data['title']
                    );
                    $this->Menu_Model->posactivity($activity);
                }
                $result = $insert_id ? $this->Menu_Model->save(array('position' => $insert_id), $insert_id) : false;
            } else {
                if (empty($data['inline'])) {
                    $data['inline'] = 2;
                }
                if (empty($data['online'])) {
                    $data['online'] = 2;
                }
                if (empty($data['breakfast'])) {
                    $data['breakfast'] = 'no';
                }
                if (empty($data['launch'])) {
                    $data['launch'] = 'no';
                }
                if (empty($data['dinner'])) {
                    $data['dinner'] = 'no';
                }
                $id = $data['id'];
                unset($data['id']);
                $insert_id = $this->Menu_Model->save($data, $id);
                if ($insert_id) {
                    $activity = array(
                        'activity' => ucfirst($this->session->userdata('name')) . ' updated menu ' . $data['title']
                    );
                    $this->Menu_Model->posactivity($activity);
                }
            }
            if ($insert_id && $this->config->item('znotifysystemupdate') === 'yes') {
                $this->Menu_Model->notifyupdate('zamanDbEposMenu');
            }
            $message = $insert_id && $result ? $this->lang->line('data_saved_successfully') : $this->lang->line('data_saving_failed') . ' ' . $uploadErrorMessage;
            echo json_encode(array('status' => $insert_id && $result, 'message' => $message, 'category' => trim($category), 'menu' => $insert_id));
        }
    }

    public function checkme() {
        $column = $this->input->post('column');
        $value = $this->input->post('value');
        $update = $this->input->post('update');
        $result = $this->Menu_Model->checkme($column, $value, $update);
        if ($result) {
            echo json_encode(sprintf($this->lang->line('item_already_taken'), $value));
        } else {
            echo json_encode(true);
        }
    }

    public function sortme() {
        $func = $this->input->post('func');
        $id = $this->input->post('id');
        $position = $this->input->post('position');
        $newPosition = $position;
        if ($func == 'up') {
            $newPosition = $position + 1;
        }
        if ($func == 'down' && $position > 1) {
            $newPosition = $position - 1;
        }
        $MinMax = $this->Menu_Model->get_min_max('menu', 'position')->row();
        if (true === in_array($newPosition, range($MinMax->min, $MinMax->max))) {
            $s1 = $this->db->update('menu', array('position' => $position), array('position' => $newPosition));
            $s2 = $this->db->update('menu', array('position' => $newPosition), array('id' => $id));
            if ($s1 && $s2 && $this->config->item('znotifysystemupdate') === 'yes') {
                $this->Menu_Model->notifyupdate('zamanDbEposMenu');
            }
            echo json_encode(array('status' => $s1 && $s2));
        }
    }

    public function topping() {
        $data = array();
        $data['category'] = $category = $this->input->post('category');
        $data['menu'] = $menu = $this->input->post('menu');
        $data['selection'] = $selection = $this->input->post('selection');
        $data['set'] = $set = $this->input->post('set');
        $data['nattr'] = $this->Menu_Model->get_list('nattr', array('branch' => $this->session->userdata('branch')), array('id', 'nattrcategory', 'title', 'price'), null, 0, 'nattrcategory', 'ASC')->result();
        $toppingsCatagory = array();
        foreach ($data['nattr'] as $attr) {
            $toppingsCatagory[$attr->nattrcategory][] = $attr;
        }
        $data['nattr'] = $toppingsCatagory;
        $data['toppingHeads'] = $this->Menu_Model->get_list('menuattrcategory', array('category' => $category, 'menu' => $menu, 'selection' => $selection, 'set' => $set, 'branch' => $this->session->userdata('branch')), array('id', 'title', 'min', 'max', 'free', 'rel', 'rel_with', 'status'), null, 0, 'id', 'ASC')->result();
        $this->load->view('menu/menu/topping', $data, false);
    }

    public function checktoppinghead() {
        $data = $this->preparePostedData();
        $data['branch'] = $this->session->userdata('branch');
        $return = $this->Menu_Model->get_single('menuattrcategory', $data)->result();
        if ($return) {
            echo json_encode(sprintf($this->lang->line('item_already_taken'), $data['title']));
        } else {
            echo json_encode(true);
        }
    }

    public function save_toppinghead() {
        $data = $this->preparePostedData();
        $data['branch'] = $this->session->userdata('branch');
        $data['created_by'] = $this->session->userdata('owner');
        if (isset($data['rel_with'])) {
            unset($data['rel_with']);
        }
        $id = $this->Menu_Model->savetoppingshead($data);
        if ($id && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Menu_Model->notifyupdate('zamanDbEposMenuAttrCategory');
        }

        if ($id && !empty($_POST['rel_with'])) {
            $postedRel = $this->input->post('rel_with');
            if (count($postedRel) >= 1) {
                array_push($postedRel, $id);
                foreach ($postedRel as $head) {
                    $this->db->update('menuattrcategory', array('rel_with' => implode('-', $postedRel)), array('id' => $head, 'branch' => $this->session->userdata('branch')));
                };
            }
        }
        $return = $this->Menu_Model->get_single('menuattrcategory', array('id' => $id, 'branch' => $this->session->userdata('branch')))->row_array();
        echo json_encode(array('status' => $id > 0 ? true : false, 'item' => $return));
    }

    function updatetoppingheadcell() {
        $column = $this->input->post('name');
        $value = $this->input->post('value');
        $pk = $this->input->post('pk');
        $status = true;
        $result = false;
        if (trim($column) === 'min' || trim($column) === 'max' || trim($column) === 'free') {
            if ((int) $value < 0) {
                $status = false;
            } else {
                $status = true;
            }
        }
        if (trim($column) === 'title') {
            if (trim($value) == null || trim($value) == '') {
                $status = false;
            } else {
                $oldToppingHead = $this->Menu_Model->get_single('menuattrcategory', array('id' => $pk, 'branch' => $this->session->userdata('branch')))->row();
                if ($oldToppingHead->title !== trim($value)) {
                    $compareToppingHead = $this->Menu_Model->get_list('menuattrcategory', array('title' => $value, 'category' => $oldToppingHead->category, 'menu' => $oldToppingHead->menu, 'selection' => $oldToppingHead->selection, 'set' => $oldToppingHead->set, 'branch' => $this->session->userdata('branch')))->result();
                    $status = empty($compareToppingHead) ? true : false;
                }
            }
        }
        if (true === $status) {
            $result = $this->db->update('menuattrcategory', array($column => $value), array('id' => $pk, 'branch' => $this->session->userdata('branch')));
            if ($result && $this->config->item('znotifysystemupdate') === 'yes') {
                $this->Menu_Model->notifyupdate('zamanDbEposMenuAttrCategory');
            }
        }
        echo json_encode(array('status' => $status && $result));
    }

    function deletetoppingcategory() {
        $id = $this->input->post('id');
        if ($id && (int) $id > 0) {
            $result1 = $this->db->delete('menuattr', array('menuttrcategory' => trim($id), 'branch' => $this->session->userdata('branch')));
            $result2 = $this->db->delete('menuattrcategory', array('id' => trim($id), 'branch' => $this->session->userdata('branch')));
            if ($result1 && $result2 && $this->config->item('znotifysystemupdate') === 'yes') {
                $this->Menu_Model->notifyupdate('zamanDbEposMenuAttrCategory');
                $this->Menu_Model->notifyupdate('zamanDbEposMenuAttr');
            }
            echo json_encode(array('status' => $result1 && $result2));
        }
    }

    public function savemenutopping() {
        $category = $this->input->post('menuttrcategory');
        $checked = $this->input->post('checked');
        $title = $this->input->post('title');
        $price = $this->input->post('price');
        $qty = $this->input->post('qty');
        $is_default = $this->input->post('is_default');
        $organized_data = array();
        $index = 0;
        foreach ($checked as $achecked) {
            $organized_data[$index]['title'] = $title[$achecked];
            $organized_data[$index]['price'] = $price[$achecked];
            $organized_data[$index]['qty'] = $qty[$achecked];
            $organized_data[$index]['is_default'] = $is_default[$achecked];
            $organized_data[$index]['menuttrcategory'] = $category;
            $organized_data[$index]['branch'] = $this->session->userdata('branch');
            $organized_data[$index]['created_by'] = $this->session->userdata('owner');
            $index++;
        }
        $reusult = array();
        if (!empty($organized_data)) {
            foreach ($organized_data as $toppingObj) {
                if ($this->Menu_Model->count_rows('menuattr', array('title' => $toppingObj['title'], 'menuttrcategory' => $toppingObj['menuttrcategory']))) {
                    continue;
                } else {
                    $reusult[] = $this->Menu_Model->savemenutopping($toppingObj);
                }
            }
        }
        if (count($reusult) > 0) {
            $savedToppings = array();
            foreach ($reusult as $atop) {
                $savedToppings[] = $this->Menu_Model->get_single('menuattr', array('id' => $atop, 'branch' => $this->session->userdata('branch')), array('id', 'title', 'price', 'qty', 'is_default', 'menuttrcategory'))->row();
            }
            if ($this->config->item('znotifysystemupdate') === 'yes') {
                $this->Menu_Model->notifyupdate('zamanDbEposMenuAttr');
            }
            echo json_encode(array('status' => true, 'message' => $this->lang->line('data_saved_successfully'), 'head' => $savedToppings[0]->menuttrcategory, 'items' => $savedToppings));
        } else {
            echo json_encode(array('status' => false, 'message' => $this->lang->line('data_saving_failed')));
        }
    }

    function deletetopping() {
        $id = $this->input->post('id');
        if ($id && (int) $id > 0) {
            $result = $this->db->delete('menuattr', array('id' => trim($id), 'branch' => $this->session->userdata('branch')));
            if ($result && $this->config->item('znotifysystemupdate') === 'yes') {
                $this->Menu_Model->notifyupdate('zamanDbEposMenuAttr');
            }
            echo json_encode(array('status' => $result));
        }
    }

    function updatetoppingcell() {
        $column = $this->input->post('name');
        $value = $this->input->post('value');
        $pk = $this->input->post('pk');
        $status = true;
        $result = false;
        if (trim($column) === 'price' || trim($column) === 'qty') {
            if (!is_numeric($value) || $value < 0) {
                $status = false;
            } else {
                $status = true;
            }
        }
        if (trim($column) === 'title') {
            if (trim($value) == null || trim($value) == '') {
                $status = false;
            } else {
                $oldTopping = $this->Menu_Model->get_single('menuattr', array('id' => $pk, 'branch' => $this->session->userdata('branch')))->row();
                if ($oldTopping->title !== trim($value)) {
                    $compareTopping = $this->Menu_Model->get_list('menuattr', array('title' => $value, 'menuttrcategory' => $oldTopping->menuttrcategory, 'branch' => $this->session->userdata('branch')))->result();
                    $status = empty($compareTopping) ? true : false;
                }
            }
        }
        if (true === $status) {
            $result = $this->db->update('menuattr', array($column => $value), array('id' => $pk, 'branch' => $this->session->userdata('branch')));
            if ($result && $this->config->item('znotifysystemupdate') === 'yes') {
                $this->Menu_Model->notifyupdate('zamanDbEposMenuAttr');
            }
        }
        echo json_encode(array('status' => $status && $result));
    }

    public function updatemenusptop() {
        $menu = trim($this->input->post('menu'));
        $sp_or_top = trim($this->input->post('sp_or_top'));
        $status = $this->db->update('menu', array('sp_or_top' => $sp_or_top), array('id' => $menu, 'branch' => $this->session->userdata('branch')));
        if ($status && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Menu_Model->notifyupdate('zamanDbEposMenu');
        }
        echo json_encode(array('status' => $status));
    }

    public function additional_attributes() {
        $id = trim($this->input->post('id'));
        $table = trim($this->input->post('table'));
        $column = trim($this->input->post('column'));
        $value = trim($this->input->post('value'));
        $status = false;
        if ((int) $value >= 2 && (int) $value <= 3) {
            if (trim($column) === 'deal_type') {
                if ((int) $value === 3) {
                    $status = $this->db->update(trim($table), array('deal_type' => (int) $value), array('id' => (int) $id, 'branch' => $this->session->userdata('branch')));
                } else {
                    $status = $this->db->update(trim($table), array('deal_type' => (int) $value, 'has_topping' => (int) 0, 'has_modifier' => (int) 0), array('id' => (int) $id, 'branch' => $this->session->userdata('branch')));
                }
            } else {
                $checkDealType = $this->Menu_Model->get_single($table, array('id' => $id, 'branch' => $this->session->userdata('branch')))->row()->deal_type;
                if (trim($column) === 'has_topping') {
                    $status = $this->db->update(trim($table), array('deal_type' => (int) $checkDealType === 2 ? (int) 2 : (int) 0, 'has_topping' => (int) $value), array('id' => (int) $id, 'branch' => $this->session->userdata('branch')));
                }
                if (trim($column) === 'has_modifier') {
                    $status = $this->db->update(trim($table), array('deal_type' => (int) $checkDealType === 2 ? (int) 2 : (int) 0, 'has_modifier' => (int) $value), array('id' => (int) $id, 'branch' => $this->session->userdata('branch')));
                }
            }
            if ($status && $this->config->item('znotifysystemupdate') === 'yes') {
                if ($table === 'menu') {
                    $this->Menu_Model->notifyupdate('zamanDbEposMenu');
                }
                if ($table === 'menuselection') {
                    $this->Menu_Model->notifyupdate('zamanDbEposMenuSelection');
                }
            }
        } else {
            if (trim($column) === 'deal_type') {
                $status = $this->db->update(trim($table), array('deal_type' => (int) 0), array('id' => (int) $id, 'branch' => $this->session->userdata('branch')));
            } else {
                if (trim($column) === 'has_topping') {
                    $status = $this->db->update(trim($table), array('has_topping' => (int) 0), array('id' => (int) $id, 'branch' => $this->session->userdata('branch')));
                }
                if (trim($column) === 'has_modifier') {
                    $status = $this->db->update(trim($table), array('has_modifier' => (int) 0), array('id' => (int) $id, 'branch' => $this->session->userdata('branch')));
                }
            }
            if ($status && $this->config->item('znotifysystemupdate') === 'yes') {
                if ($table === 'menu') {
                    $this->Menu_Model->notifyupdate('zamanDbEposMenu');
                }
                if ($table === 'menuselection') {
                    $this->Menu_Model->notifyupdate('zamanDbEposMenuSelection');
                }
            }
        }
        $item = array();
        if ($status) {
            $item = $this->Menu_Model->get_single($table, array('id' => $id, 'branch' => $this->session->userdata('branch')), array('id', 'deal_type', 'has_topping', 'has_modifier'))->row_array();
        }
        echo json_encode(array('status' => $status, 'itemObj' => $item, 'id' => $id));
    }

    public function updateselectionsptop() {
        $selection = trim($this->input->post('selection'));
        $sp_or_top = trim($this->input->post('sp_or_top'));
        $status = $this->db->update('menuselection', array('sp_or_top' => $sp_or_top), array('id' => $selection, 'branch' => $this->session->userdata('branch')));
        if ($status && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Menu_Model->notifyupdate('zamanDbEposMenuSelection');
        }
        echo json_encode(array('status' => $status));
    }

    public function itemmodifier() {
        $data = array();
        $data['category'] = $category = $this->input->post('category');
        $data['menu'] = $menu = $this->input->post('menu');
        $data['selection'] = $selection = $this->input->post('selection');
        $data['set'] = $set = $this->input->post('set');
        $data['nattr'] = $this->Menu_Model->get_list('modifier', array('branch' => $this->session->userdata('branch')), array('id', 'title'), null, 0, 'id', 'ASC')->result();
        $column = null;
        $value = null;
        if ((int) $set > 0) {
            $column = 'set';
            $value = (int) $set;
        } else if ((int) $selection > 0) {
            $column = 'selection';
            $value = (int) $selection;
        } else {
            $column = 'menu';
            $value = (int) $menu;
        }
        if ($column != null && $value > 0) {
            $data['modifiersHeads'] = $this->Menu_Model->get_list('modifiercategory', array($column => $value, 'branch' => $this->session->userdata('branch')), array('id', 'title', 'status', 'category', 'menu', 'selection', 'set'), null, 0, 'id', 'ASC')->result();
        }
        $this->load->view('menu/menu/modifier', $data, false);
    }

    public function checkmodifierhead() {
        $data = $this->preparePostedData();
        $data['branch'] = $this->session->userdata('branch');
        $return = $this->Menu_Model->get_single('modifiercategory', $data)->result();
        if ($return) {
            echo json_encode(sprintf($this->lang->line('item_already_taken'), $data['title']));
        } else {
            echo json_encode(true);
        }
    }

    public function save_modifierhead() {
        $data = $this->preparePostedData();
        $data['branch'] = $this->session->userdata('branch');
        $data['created_by'] = $this->session->userdata('owner');
        $id = $this->Menu_Model->savemodifiershead($data);
        if ($id && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Menu_Model->notifyupdate('zamanDbEposModifierCategory');
        }
        $return = $this->Menu_Model->get_single('modifiercategory', array('id' => $id, 'branch' => $this->session->userdata('branch')))->row_array();
        echo json_encode(array('status' => $id > 0 ? true : false, 'item' => $return));
    }

    function updatemodifierheadcell() {
        $column = $this->input->post('name');
        $value = $this->input->post('value');
        $pk = $this->input->post('pk');
        $status = true;
        $result = false;
        if (trim($column) === 'title') {
            if (trim($value) == null || trim($value) == '') {
                $status = false;
            } else {
                $oldModifierHead = $this->Menu_Model->get_single('modifiercategory', array('id' => $pk, 'branch' => $this->session->userdata('branch')))->row();
                if ($oldModifierHead->title !== trim($value)) {
                    $compareModifierHead = $this->Menu_Model->get_list('modifiercategory', array('title' => $value, 'category' => $oldModifierHead->category, 'menu' => $oldModifierHead->menu, 'selection' => $oldModifierHead->selection, 'set' => $oldModifierHead->set, 'branch' => $this->session->userdata('branch')))->result();
                    $status = empty($compareModifierHead) ? true : false;
                }
            }
        }
        if (true === $status) {
            $result = $this->db->update('modifiercategory', array($column => $value), array('id' => $pk, 'branch' => $this->session->userdata('branch')));
        }
        if ($result && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Menu_Model->notifyupdate('zamanDbEposModifierCategory');
        }
        echo json_encode(array('status' => $status && $result));
    }

    function deletemodifiercategory() {
        $id = $this->input->post('id');
        if ($id && (int) $id > 0) {
            $result1 = $this->db->delete('modifiermenu', array('modcategory' => trim($id), 'branch' => $this->session->userdata('branch')));
            $result2 = $this->db->delete('modifiercategory', array('id' => trim($id), 'branch' => $this->session->userdata('branch')));
            if ($this->config->item('znotifysystemupdate') === 'yes') {
                $this->Menu_Model->notifyupdate('zamanDbEposModifierCategory');
                $this->Menu_Model->notifyupdate('zamanDbEposModifierMenu');
            }
            echo json_encode(array('status' => $result1 && $result2));
        }
    }

    public function savemenumodifier() {
        $category = $this->input->post('modcategory');
        $checked = $this->input->post('checked');
        $title = $this->input->post('title');
        $organized_data = array();
        $index = 0;
        foreach ($checked as $achecked) {
            $organized_data[$index]['title'] = $title[$achecked];
            $organized_data[$index]['modcategory'] = $category;
            $organized_data[$index]['created_by'] = $this->session->userdata('owner');
            $organized_data[$index]['branch'] = $this->session->userdata('branch');
            $index++;
        }
        $reusult = array();
        if (!empty($organized_data)) {
            foreach ($organized_data as $Obj) {
                if ($this->Menu_Model->count_rows('modifiermenu', array('title' => $Obj['title'], 'modcategory' => $Obj['modcategory'], 'branch' => $this->session->userdata('branch')))) {
                    continue;
                } else {
                    $reusult[] = $this->Menu_Model->savemenumodifier($Obj);
                }
            }
        }
        if (count($reusult) > 0) {
            $savedModifiers = array();
            foreach ($reusult as $atop) {
                $savedModifiers[] = $this->Menu_Model->get_single('modifiermenu', array('id' => $atop, 'branch' => $this->session->userdata('branch')), array('id', 'title', 'modcategory', 'status'))->row();
            }
            if ($this->config->item('znotifysystemupdate') === 'yes') {
                $this->Menu_Model->notifyupdate('zamanDbEposModifierMenu');
            }
            echo json_encode(array('status' => true, 'message' => $this->lang->line('data_saved_successfully'), 'head' => $savedModifiers[0]->modcategory, 'items' => $savedModifiers));
        } else {
            echo json_encode(array('status' => false, 'message' => $this->lang->line('data_saving_failed')));
        }
    }

    function deleteModifier() {
        $id = $this->input->post('id');
        if ($id && (int) $id > 0) {
            $result = $this->db->delete('modifiermenu', array('id' => trim($id), 'branch' => $this->session->userdata('branch')));
            if ($result && $this->config->item('znotifysystemupdate') === 'yes') {
                $this->Menu_Model->notifyupdate('zamanDbEposModifierMenu');
            }
            echo json_encode(array('status' => $result));
        }
    }

    function updatemodifiercell() {
        $column = $this->input->post('name');
        $value = $this->input->post('value');
        $pk = $this->input->post('pk');
        $status = true;
        $result = false;

        if (trim($column) === 'title') {
            if (trim($value) == null || trim($value) == '') {
                $status = false;
            } else {
                $oldModifier = $this->Menu_Model->get_single('modifiermenu', array('id' => $pk, 'branch' => $this->session->userdata('branch')))->row();
                if ($oldModifier->title !== trim($value)) {
                    $compareTopping = $this->Menu_Model->get_list('modifiermenu', array('title' => $value, 'modcategory' => $oldModifier->modcategory, 'branch' => $this->session->userdata('branch')))->result();
                    $status = empty($compareTopping) ? true : false;
                }
            }
        }
        if (true === $status) {
            $result = $this->db->update('modifiermenu', array($column => $value), array('id' => $pk));
        }
        if ($result && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Menu_Model->notifyupdate('zamanDbEposModifierMenu');
        }
        echo json_encode(array('status' => $status && $result));
    }

    public function fixeddeal() {
        $data = array();
        $data['category'] = $category = $this->input->post('category');
        $data['menu'] = $menu = $this->input->post('menu');
        $data['selection'] = $selection = $this->input->post('selection');
        $data['set'] = $set = $this->input->post('set');
        if ((int) $selection <= 0) {
            $menus = $this->Menu_Model->get_list('menu', array('status' => 3, 'id<>' => (int) $menu, 'branch' => $this->session->userdata('branch')))->result();
        } else {
            $menus = $this->Menu_Model->get_list('menu', array('status' => 3, 'branch' => $this->session->userdata('branch')))->result();
        }

        $menuSelections = array();
        foreach ($menus as $amenu) {
            $menuSelections[$amenu->id] = $this->Menu_Model->get_list('menuselection', array('status' => 3, 'menu' => $amenu->id))->result();
        }
        $data['menus'] = $menus;
        $data['selections'] = $menuSelections;
        $deal = (int) $selection > 0 ? (int) $selection : (int) $menu;
        $data['fixedDealItems'] = $this->Menu_Model->get_list('menufixeddeal', array('deal' => $deal, 'branch' => $this->session->userdata('branch')))->result();

        $column = null;
        $value = null;
        if ((int) $set > 0) {
            $column = 'set';
            $value = (int) $set;
        } else if ((int) $selection > 0) {
            $column = 'selection';
            $value = (int) $selection;
        } else {
            $column = 'menu';
            $value = (int) $menu;
        }
        if ($column != null && $value > 0) {
            $data['toppingHeads'] = $this->Menu_Model->get_list('menuattrcategory', array($column => $value, 'branch' => $this->session->userdata('branch')), array('id', 'title', 'min', 'max', 'free', 'rel', 'status'), null, 0, 'id', 'ASC')->result();
            $data['modifiersHeads'] = $this->Menu_Model->get_list('modifiercategory', array($column => $value, 'branch' => $this->session->userdata('branch')), array('id', 'title', 'status', 'category', 'menu', 'selection', 'set'), null, 0, 'id', 'ASC')->result();
        }

        $this->load->view('menu/menu/fixeddeal', $data, false);
    }

    public function getfixeddealitem() {
        $combo = $this->input->post('combo');
        $comboExplode = explode('_', $combo);
        $category = $comboExplode[0];
        $menu = $comboExplode[1];
        $selection = $comboExplode[2];
        $item = null;
        if ((int) $selection > 0) {
            $item = $this->Menu_Model->get_single('menuselection', array('id' => (int) $selection, 'menu' => (int) $menu, 'category' => (int) $category, 'branch' => $this->session->userdata('branch')))->row();
            $item->menuTitle = get_title('menu', array('id' => $item->menu, 'branch' => $this->session->userdata('branch')));
        } else {
            $item = $this->Menu_Model->get_single('menu', array('id' => (int) $menu, 'category' => (int) $category, 'branch' => $this->session->userdata('branch')))->row();
            $item->menuTitle = false;
        }
        if (!empty($item)) {
            echo json_encode(array('status' => true, 'item' => $item));
        } else {
            echo json_encode(array('status' => false, 'item' => $item));
        }
    }

    public function save_fixeddealitem() {
        $category = $this->input->post('category');
        $menu = $this->input->post('menu');
        $selection = $this->input->post('selection');
        $deal = (int) $selection > 0 ? $selection : $menu;
        $result = array();
        if (isset($_POST['items']) && !empty($_POST['items'])) {
            $uniqueItems = array_unique($this->input->post('items'));
            foreach ($uniqueItems as $item) {
                $exploded = explode('_', $item);
                $item_category = $exploded[0];
                $item_menu = $exploded[1];
                $item_selection = $exploded[2];
                $checked = $this->Menu_Model->get_single('menufixeddeal', array('deal' => $deal, 'category' => $item_category, 'menu' => $item_menu, 'selection' => $item_selection, 'branch' => $this->session->userdata('branch')))->row();
                if (!empty($checked)) {
                    continue;
                } else {
                    $data = array(
                        'branch' => $this->session->userdata('branch'),
                        'deal' => $deal,
                        'category' => $item_category,
                        'menu' => $item_menu,
                        'selection' => $item_selection,
                        'deal_category' => $category,
                        'deal_menu' => $menu,
                        'deal_selection' => $selection,
                        'status' => 3,
                        'created_by' => $this->session->userdata('owner')
                    );
                    $result[] = $this->db->insert('menufixeddeal', $data);
                }
            }
        }
        if (count($result) > 0 && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Menu_Model->notifyupdate('zamanDbEposFixedDealItems');
        }
        echo json_encode(array('status' => count($result) > 0 ? true : false));
    }

    function deletefixeddealitem() {
        $id = $this->input->post('id');
        $status = $this->db->delete('menufixeddeal', array('id' => $id, 'branch' => $this->session->userdata('branch')));
        if ($status && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Menu_Model->notifyupdate('zamanDbEposFixedDealItems');
        }
        echo json_encode(array('status' => $status));
    }

    function updatefixedheaditemcell() {
        $column = $this->input->post('name');
        $value = $this->input->post('value');
        $pk = $this->input->post('pk');
        $status = true;
        $result = false;
        if (trim($column) === 'qty' || trim($column) === 'max' || trim($column) === 'free') {
            if (!is_numeric($value) || $value <= 0) {
                $status = false;
            } else {
                $status = true;
            }
        }
        if ($status) {
            $result = $this->db->update('menufixeddeal', array($column => $value), array('id' => (int) $pk, 'branch' => $this->session->userdata('branch')));
        }
        if ($result && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Menu_Model->notifyupdate('zamanDbEposFixedDealItems');
        }
        echo json_encode(array('status' => $status));
    }

    function customdeal() {
        $data = array();
        $data['category'] = $category = $this->input->post('category');
        $data['menu'] = $menu = $this->input->post('menu');
        $data['selection'] = $selection = $this->input->post('selection');
        $data['set'] = $set = $this->input->post('set');
        $data['menuset'] = $this->Menu_Model->get_list('menuset', array('category' => $category, 'menu' => $menu, 'selection' => $selection, 'branch' => $this->session->userdata('branch')))->result();
        $data['menucategory'] = $this->Menu_Model->get_list('menucategory', array('status' => 3, 'branch' => $this->session->userdata('branch')), array('id', 'title'), null, 0, 'position', 'ASC')->result();
        $this->load->view('menu/menu/customdeal', $data, false);
    }

    function checkmenuset() {
        $title = $this->input->post('title');
        $category = $this->input->post('category');
        $menu = $this->input->post('menu');
        $selection = $this->input->post('selection');
        $result = $this->Menu_Model->get_list('menuset', array('category' => $category, 'menu' => $menu, 'selection' => $selection, 'title' => $title, 'branch' => $this->session->userdata('branch')))->result();
        if (!empty($result)) {
            echo json_encode(sprintf($this->lang->line('item_already_taken'), $title));
        } else {
            echo json_encode(true);
        }
    }

    function save_customdealset() {
        $data = $this->preparePostedData();
        $data['branch'] = $this->session->userdata('branch');
        unset($data['set']);
        $result = $this->Menu_Model->get_list('menuset', array('category' => $data['category'], 'menu' => $data['menu'], 'selection' => $data['selection'], 'title' => $data['title'], 'branch' => $this->session->userdata('branch')))->result();
        if (!empty($result)) {
            echo json_encode(array('status' => false, 'message' => sprintf($this->lang->line('item_already_taken'), $data['title'])));
        } else {
            if (isset($data['rel_with'])) {
                unset($data['rel_with']);
            }
            $id = $this->Menu_Model->savemenuset($data);
            if ($id && $this->config->item('znotifysystemupdate') === 'yes') {
                $this->Menu_Model->notifyupdate('zamanDbEposMenuSet');
            }
            if ($id && !empty($_POST['rel_with'])) {
                $postedRel = $this->input->post('rel_with');
                if (count($postedRel) >= 1) {
                    array_push($postedRel, $id);
                    foreach ($postedRel as $head) {
                        $this->db->update('menuset', array('rel_with' => implode('-', $postedRel)), array('id' => $head, 'branch' => $this->session->userdata('branch')));
                    };
                }
            }
            echo json_encode(array('status' => $id > 0 ? true : false));
        }
    }

    function updatetmenusetcell() {
        $column = $this->input->post('name');
        $value = $this->input->post('value');
        $pk = $this->input->post('pk');
        $status = true;
        $result = false;
        if (trim($column) === 'min' || trim($column) === 'max') {
            if ((int) $value < 0) {
                $status = false;
            } else {
                $status = true;
            }
        }
        if (trim($column) === 'title') {
            if (trim($value) == null || trim($value) == '') {
                $status = false;
            } else {
                $oldMenuSet = $this->Menu_Model->get_single('menuset', array('id' => $pk, 'branch' => $this->session->userdata('branch')))->row();
                if ($oldMenuSet->title !== trim($value)) {
                    $compareMenuSet = $this->Menu_Model->get_list('menuset', array('title' => $value, 'category' => $oldMenuSet->category, 'menu' => $oldMenuSet->menu, 'selection' => $oldMenuSet->selection, 'branch' => $this->session->userdata('branch')))->result();
                    $status = empty($compareMenuSet) ? true : false;
                }
            }
        }
        if (true === $status) {
            $result = $this->db->update('menuset', array($column => (int) $value), array('id' => $pk, 'branch' => $this->session->userdata('branch')));
        }
        if ($result && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Menu_Model->notifyupdate('zamanDbEposMenuSet');
        }
        echo json_encode(array('status' => $status && $result));
    }

    public function getmenusetitems($id = null) {
        $data = array();
        if ($id && $id > 0) {
            $data['blockCategory'] = $this->Menu_Model->get_single('menucategory', array('id' => trim($id), 'branch' => $this->session->userdata('branch')), array('id', 'title'))->row_array();
            $data['menus'] = $menus = $this->Menu_Model->get_list('menu', array('category' => trim($id), 'status' => 3, 'branch' => $this->session->userdata('branch')), array('id', 'title', 'category'), null, 0, 'title', 'ASC')->result();
            $selections = array();
            if (!empty($menus)) {
                foreach ($menus as $amenu) {
                    $selections[$amenu->id] = $this->Menu_Model->get_list('menuselection', array('menu' => $amenu->id, 'status' => 3, 'branch' => $this->session->userdata('branch')), array('id', 'title', 'menu', 'category'), null, 0, 'position', 'ASC')->result();
                }
            }
            $data['selections'] = $selections;
            $this->load->view('menu/menu/menusetitemsblock', $data);
        }
    }

    function deletemenuset() {
        $id = $this->input->post('id');
        if ($id && (int) $id > 0) {
            $result1 = $this->db->delete('menusetitem', array('set' => trim($id), 'branch' => $this->session->userdata('branch')));
            $result2 = $this->db->delete('menuset', array('id' => trim($id), 'branch' => $this->session->userdata('branch')));
            if ($this->config->item('znotifysystemupdate') === 'yes') {
                $this->Menu_Model->notifyupdate('zamanDbEposMenuSet');
                $this->Menu_Model->notifyupdate('zamanDbEposMenuSetItem');
            }
            echo json_encode(array('status' => $result1 && $result2));
        }
    }

    public function save_menusetitems() {
        $set = $this->input->post('set');
        $items = $this->input->post('items');
        $result = array();
        if (!empty($items)) {
            $items = array_unique($items);
            if (!empty($items)) {
                foreach ($items as $item) {
                    $explode = explode('_', $item);
                    $category = $explode[0];
                    $menu = $explode[1];
                    $selection = $explode[2];
                    $checked = $this->Menu_Model->get_list('menusetitem', array('set' => $set, 'category' => $category, 'menu' => $menu, 'selection' => $selection, 'branch' => $this->session->userdata('branch')))->result();
                    if (!empty($checked)) {
                        continue;
                    } else {
                        $result[] = $this->Menu_Model->savemenusetitems(array('set' => $set, 'category' => $category, 'menu' => $menu, 'selection' => $selection));
                    }
                }
            }
        }
        if (count($result) > 0 && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Menu_Model->notifyupdate('zamanDbEposMenuSetItem');
        }
        echo json_encode(array('status' => count($result) > 0 ? true : false));
    }

    function updatetmenusetitemcell() {
        $column = $this->input->post('name');
        $value = $this->input->post('value');
        $pk = $this->input->post('pk');
        $status = true;
        $result = false;
        if (trim($column) === 'qty' || trim($column) === 'status') {
            if (!is_numeric($value) || $value <= 0) {
                $status = false;
            } else {
                $status = true;
            }
        }
        if ($status) {
            $result = $this->db->update('menusetitem', array($column => $value), array('id' => (int) $pk, 'branch' => $this->session->userdata('branch')));
        }
        if ($result && $this->config->item('znotifysystemupdate') === 'yes') {
            $this->Menu_Model->notifyupdate('zamanDbEposMenuSetItem');
        }
        echo json_encode(array('status' => $status));
    }

    function deletemenusetitem() {
        $id = $this->input->post('id');
        if ($id && (int) $id > 0) {
            $result = $this->db->delete('menusetitem', array('id' => trim($id), 'branch' => $this->session->userdata('branch')));
            if ($result && $this->config->item('znotifysystemupdate') === 'yes') {
                $this->Menu_Model->notifyupdate('zamanDbEposMenuSetItem');
            }
            echo json_encode(array('status' => $result));
        }
    }

    public function quickedit() {
        $menuCategory = $this->Menu_Model->get_list('menucategory', array('branch' => $this->session->userdata('branch')), null, null, 0, 'position', 'ASC')->result();
        $menus = array();
        $menuSelections = array();
        if (!empty($menuCategory)) {
            foreach ($menuCategory as $mc) {
                $menus[$mc->id] = $menusCollection = $this->Menu_Model->get_list('menu', array('category' => $mc->id, 'branch' => $this->session->userdata('branch')))->result();
                if (!empty($menusCollection)) {
                    foreach ($menusCollection as $amenu) {
                        $menuSelections[$amenu->id] = $this->Menu_Model->get_list('menuselection', array('menu' => $amenu->id, 'branch' => $this->session->userdata('branch')))->result();
                    }
                }
            }
        }
        $data['categories'] = $menuCategory;
        $data['menus'] = $menus;
        $data['selections'] = $menuSelections;
        $data['refresh'] = site_url('menu/quickedit');
        $data['branchArray'] = $this->Menu_Model->get_single('branch', array('id' => $this->session->userdata('branch')))->row_array();
        $this->load->view('menu/menu/quickedit', $data, false);
    }

    function quickeditcell($table = null) {
        if ($table != null && ($table == 'menu' || $table == 'menucategory' || $table == 'menuselection') && $this->input->post() && $this->session->userdata('group') <= 5) {
            $column = $this->input->post('name');
            $value = $this->input->post('value');
            $pk = $this->input->post('pk');
            $status = true;
            $result = false;
            if (trim($column) === 'base_price' ||
                    trim($column) === 'in_price' ||
                    trim($column) === 'out_price' ||
                    trim($column) === 'discount' ||
                    trim($column) === 'discount_option' ||
                    trim($column) === 'tax' ||
                    trim($column) === 'tax_option' ||
                    trim($column) === 'online' ||
                    trim($column) === 'inline' ||
                    trim($column) === 'status') {
                if (!is_numeric($value) || $value < 0) {
                    $status = false;
                } else {
                    $status = true;
                }
            }
            if (trim($column) === 'title') {
                if (trim($value) == null || trim($value) == '') {
                    $status = false;
                } else {
                    $oldTitle = $this->Menu_Model->get_single($table, array('id' => $pk, 'branch' => $this->session->userdata('branch')))->row();
                    if ($oldTitle->title !== trim($value)) {
                        $replacedTitleAgain = $this->Menu_Model->get_single($table, array('title' => $value, 'branch' => $this->session->userdata('branch')))->row();
                        if (!empty($replacedTitleAgain)) {
                            $status = false;
                        } else {
                            $status = true;
                        }
                    }
                }
            }
            if (trim($column) === 'code') {
                if (trim($value) == null || trim($value) == '') {
                    $status = false;
                } else {
                    $oldTitle = $this->Menu_Model->get_single($table, array('id' => $pk, 'branch' => $this->session->userdata('branch')))->row();
                    if ($oldTitle->title !== trim($value)) {
                        $replacedTitleAgain = $this->Menu_Model->get_single($table, array('code' => $value, 'branch' => $this->session->userdata('branch')))->row();
                        if (!empty($replacedTitleAgain)) {
                            $status = false;
                        } else {
                            $status = true;
                        }
                    }
                }
            }


            if (true === $status) {
                $result = $this->db->update($table, array($column => $value), array('id' => $pk, 'branch' => $this->session->userdata('branch')));
            }
            if ($result && $this->config->item('znotifysystemupdate') === 'yes') {
                if ($table === 'menucategory') {
                    $this->Menu_Model->notifyupdate('zamanDbEposMenuCategory');
                }
                if ($table === 'menu') {
                    $this->Menu_Model->notifyupdate('zamanDbEposMenu');
                }
                if ($table === 'menuselection') {
                    $this->Menu_Model->notifyupdate('zamanDbEposMenuSelection');
                }
            }
            echo json_encode(array('status' => $status && $result));
        }
    }

    public function cumulativeFact() {
        if ($this->input->post()) {
            $action = $this->input->post('action');
            $field = $this->input->post('field');
            $field_value = $this->input->post('value');
            $field_value_arr = explode('-', $field_value);
            $table = $field_value_arr[0];
            $value = $field_value_arr[1];
            $status = false;
            if (trim($action) === trim('add')) {
                $status = $this->db->update($table, array($field => '2'), array('id' => $value, 'branch' => $this->session->userdata('branch')));
            }
            if (trim($action) === trim('remove')) {
                $status = $this->db->update($table, array($field => '0'), array('id' => $value, 'branch' => $this->session->userdata('branch')));
            }
            if ($status && $this->config->item('znotifysystemupdate') === 'yes') {
                if ($table === 'menu') {
                    $this->Menu_Model->notifyupdate('zamanDbEposMenu');
                }
                if ($table === 'menuselection') {
                    $this->Menu_Model->notifyupdate('zamanDbEposMenuSelection');
                }
            }
            echo json_encode(array('status' => $status ? true : false));
        }
    }

    public function change_tax_discount_option() {
        $column = $this->input->post('col');
        $value = $this->input->post('value');
        if (trim($column) && trim((int) $value) >= 0) {
            $this->db->trans_start();
            $this->db->update('branch', array($column => $value), array('id' => $this->session->userdata('branch')));
            $this->db->update('menu', array($column => $value), array('branch' => $this->session->userdata('branch')));
            $this->db->update('menuselection', array($column => $value), array('branch' => $this->session->userdata('branch')));
            if ($this->config->item('znotifysystemupdate') === 'yes') {
                $this->Menu_Model->notifyupdate('zamanDbEposBranch');
                $this->Menu_Model->notifyupdate('zamanDbEposMenu');
                $this->Menu_Model->notifyupdate('zamanDbEposMenuSelection');
            }
            $this->db->trans_complete();
            echo json_encode(array('status' => $this->db->trans_status()));
        }
    }

    public function deleteImage() {
        $data = $this->input->post();
        $status = checkfile($data['path'], $data['image']);
        if ($status) {
            $result = $this->db->update($data['dbtable'], array($data['dbkey'] => ''), array('id', $data['row']));
            unlink(realpath($data['path'] . $data['image']));
            if (!checkfile($data['path'], $data['image']) && $result) {
                echo json_encode(array('status' => $result, 'message' => $this->lang->line('delete_success')));
            } else {
                echo json_encode(array('status' => false, 'message' => $this->lang->line('delete_failed')));
            }
        }
    }

    function delete($id = null, $all = false) {
        $row = $this->db->where('id', (int) $id)->get('menu')->row();
        if (!empty($row)) {
            //delete all selection 
            $selections = $this->db->where('menu', (int) $row->id)->get('menuselection')->result();
            if (!empty($selections)) {
                foreach ($selections as $aselection) {
                    if (trim($aselection->image)) {
                        $status = checkfile('./uploads/menuselection/', $aselection->image);
                        if ($status) {
                            unlink(realpath('./uploads/menuselection/' . $aselection->image));
                        }
                    }
                    $this->db->where('id', $aselection->id)->delete('menuselection');
                }
                if ($this->config->item('znotifysystemupdate') === 'yes') {
                    $this->Menu_Model->notifyupdate('zamanDbEposMenuSelection');
                }
            }
            //Delete associated Toppings
            $toppinsCategory = $this->db->where('menu', $row->id)->get('menuattrcategory')->result();
            if (!empty($toppinsCategory)) {
                foreach ($toppinsCategory as $tc) {
                    $this->db->where('menuttrcategory', $tc->id)->delete('menuattr');
                }
                $this->db->where('menu', $row->id)->delete('menuattrcategory');
                if ($this->config->item('znotifysystemupdate') === 'yes') {
                    $this->Menu_Model->notifyupdate('zamanDbEposMenuAttrCategory');
                    $this->Menu_Model->notifyupdate('zamanDbEposMenuAttr');
                }
            }
            //Delete associated Modifier
            $modifierCategory = $this->db->where('menu', $row->id)->get('modifiercategory')->result();
            if (!empty($modifierCategory)) {
                foreach ($modifierCategory as $mc) {
                    $this->db->where('modcategory', $mc->id)->delete('modifiermenu');
                }
                $this->db->where('menu', $row->id)->delete('modifiercategory');
                if ($this->config->item('znotifysystemupdate') === 'yes') {
                    $this->Menu_Model->notifyupdate('zamanDbEposModifierCategory');
                    $this->Menu_Model->notifyupdate('zamanDbEposModifierMenu');
                }
            }
            //Delete associated Sets and set element
            $menuSet = $this->db->where('menu', $row->id)->get('menuset')->result();
            if (!empty($menuSet)) {
                foreach ($menuSet as $ms) {
                    $this->db->where('set', $ms->id)->delete('menusetitem');
                }
                $this->db->where('menu', $row->id)->delete('menuset');
                if ($this->config->item('znotifysystemupdate') === 'yes') {
                    $this->Menu_Model->notifyupdate('zamanDbEposMenuSet');
                    $this->Menu_Model->notifyupdate('zamanDbEposMenuSetItem');
                }
            }
            //Delete associated fixed deal element
            $fixedDealItems = $this->Menu_Model->get_list('menufixeddeal', array('deal_menu' => $row->id))->result();
            if (!empty($fixedDealItems)) {
                $this->db->where('deal_menu', $row->id);
                $this->db->or_where('menu', $row->id);
                $menufixeddealDeleteStatus = $this->db->delete('menufixeddeal');
                if ($menufixeddealDeleteStatus && $this->config->item('znotifysystemupdate') === 'yes') {
                    $this->Menu_Model->notifyupdate('zamanDbEposFixedDealItems');
                }
            } else {
                $this->db->where('menu', $row->id)->delete('menufixeddeal');
            }
            //Delete associated image
            if (trim($row->image)) {
                $status = checkfile('./uploads/menu/', $row->image);
                if ($status) {
                    unlink(realpath('./uploads/menu/' . $row->image));
                }
            }
        }
        $hasDeletedId = $this->Menu_Model->deleteMenu($id);
        if ($hasDeletedId) {
            if ($this->config->item('znotifysystemupdate') === 'yes') {
                $this->Menu_Model->notifyupdate('zamanDbEposMenu');
            }
            $activity = array(
                'activity' => ucfirst($this->session->userdata('name')) . ' deleted menu ' . $row->title
            );
            $this->Menu_Model->posactivity($activity);
        }
        if ($all) {
            return $hasDeletedId;
        } else {
            echo json_encode(array('status' => $hasDeletedId));
        }
    }

    function deleteAll($category) {
        $rows = $this->Menu_Model->get_list('menu', array('category' => (int) $category, 'branch' => $this->session->userdata('branch')), array('id'))->result();
        $status = false;
        if (!empty($rows)) {
            foreach ($rows as $arow) {
                $status = $this->delete($arow->id, true);
            }
        }
        echo json_encode(array('status' => $status));
    }

}
