<script type="text/javascript">
    function zamanOrderCartFreeItemControllerPopup(rule) {
        if (rule.item.length > 0) {
            $('#placeOrderTypeBlock').hide();
            clearEposWorkArea();
            $('.breadcurmb-category').html('<span style="color:#ddfc0d;">Choose Free Item</span>');
            $('.breadcurmb-menu').html('');
            $('.menu-category.menu-button-inner').removeClass('active');
            $('#eposCategoryMenuList').html('');
            rule.item.forEach(function (obj) {
                var itemObj = obj.split('_');
                zamanEposDb.transaction('rw', [zamanEposDb.epos_menucategory, zamanEposDb.epos_menu, zamanEposDb.epos_menuselection], function () {
                    zamanEposDb.epos_menucategory.get({'id': itemObj[0]}).then(function (categoryObj) {
                        zamanEposDb.epos_menu.get({'id': itemObj[1]}).then(function (menuObject) {
                            zamanEposDb.epos_menuselection.get({'id': itemObj[2]}).then(function (menuSelectionObject) {
                                var itemHtml = '';
                                if (typeof (menuSelectionObject) !== 'undefined') {
                                    itemHtml = `<div class="menu-button free-item-btn"><div class="menu-button-inner" onclick="addFreeDishOnCart(` + categoryObj.id + `,` + menuObject.id + `,` + menuSelectionObject.id + `,` + rule.order + `)">` + menuSelectionObject.title + `-` + menuObject.title + `</div></div>`;
                                } else {
                                    itemHtml = `<div class="menu-button free-item-btn"><div class="menu-button-inner" onclick="addFreeDishOnCart(` + categoryObj.id + `,` + menuObject.id + `,0,` + rule.order + `)">` + menuObject.title + `</div></div>`;
                                }
                                $('#eposCategoryMenuList').append(itemHtml);
                            });
                        });
                    });
                });
            });
        }
    }
    function addFreeDishOnCart(category, menu, selection, rule) {
        zamanEposDb.epos_menucategory.get({'id': category.toString()}).then(function (categoryObj) {
            zamanEposDb.epos_menu.get({'id': menu.toString()}).then(function (menuObject) {
                if (selection > 0) {
                    zamanEposDb.epos_menuselection.get({'id': selection.toString()}).then(function (selectionObject) {
                        addFreeDishOnCartNow(categoryObj, menuObject, selectionObject, rule);
                    });
                } else {
                    addFreeDishOnCartNow(categoryObj, menuObject, {}, rule);
                }
            });
        });
    }
    function addFreeDishOnCartNow(categoryObject, menuObject, selectionObject, rule) {
        var currentOrderId = zamanEposCart.getEposCurrentId();
        zamanEposDb.epos_order.get({orderId: Number(currentOrderId)}).then(function (anOrder) {
            var cartData = new Array();
            cartData.category = Number(categoryObject.id);
            cartData.categoryTitle = categoryObject.title;
            cartData.type = categoryObject.type;
            cartData.menu = Number(menuObject.id);
            cartData.menuTitle = menuObject.title;
            cartData.selection = !jQuery.isEmptyObject(selectionObject) ? selectionObject.id : 0;
            cartData.selectionTitle = !jQuery.isEmptyObject(selectionObject) ? selectionObject.title : '';
            cartData.price = 0;
            cartData.tax = 0;
            cartData.taxPercent = 0;
            cartData.discountOption = 0;
            cartData.discount = Number(0);
            cartData.qty = 1;
            cartData.setItem = zamanEposCart.listSetItem();
            cartData.Topping = zamanEposCart.listItemTopping();
            cartData.modifier = zamanEposCart.listItemModifier();
            cartData.sent = 'no';
            cartData.newQty = anOrder.status === '2' ? 0 : 1;
            var exitingCart = anOrder.cart;
            if (exitingCart.length > 0 && anOrder.status === '2') {
                for (var i in exitingCart) {
                    if (exitingCart[i].category === cartData.category && exitingCart[i].menu === cartData.menu && exitingCart[i].selection === cartData.selection) {
                        cartData.sent = 'yes';
                        cartData.newQty = 1;
                        break;
                    } else {
                        continue;
                    }
                }
            }
            cartData.basePrice = 0;
            cartData.inPrice = 0;
            cartData.outPrice = 0;
            cartData.printat = Number(!jQuery.isEmptyObject(selectionObject) ? selectionObject.printat : menuObject.printat);
            cartData.isFree = 'yes';
            cartData.isFreeRule = rule;
            zamanEposCart.clearPreRuleFreeItem(rule);
            var cartLine = zamanEposCart.addItem(cartData);
            zamanEposCart.setEposCartNewQty(currentOrderId, cartData.newQty);
            clearAllOptions();
            displayEposCart();
            setCartLine(cartLine);
            var itemOfferExitParam = zamanEposCart.getItemOfferExitParam();
            var itemOfferExitParamFreeQty = zamanEposCart.getItemOfferFreeItem();
            console.log(itemOfferExitParam, itemOfferExitParamFreeQty);
            if (Number(itemOfferExitParamFreeQty) < Number(itemOfferExitParam.qty)) {
                var RemainingQty = Number(itemOfferExitParam.qty) - Number(itemOfferExitParamFreeQty);
                ('#eposCategoryMenuList').html('');
                $('.breadcurmb-category').html('<span style="color:#ddfc0d;">Choose Free Item' + RemainingQty + ' more</span>');
            } else {
                $('#eposCategoryMenuList').html('');
                $('.breadcurmb-category').html('<span style="color:#ddfc0d;">No more</span>');
            }
        });
    }

</script>