<?php $this->load->view('settings/partials/header') ?>
<div class="window-content">
    <div class="page-loader" style="display: none;"></div>
    <div class="pane-group">
        <?php $this->load->view('settings/partials/sidebar') ?>
        <div class="pane content-configuration">
            <div class="caption">
                <?php $this->load->view('employee/nav') ?>
            </div>
            <?php echo form_open('employee/saveDepartment', array('id' => 'employeeDepartmentForm')); ?>
            <div class="form-group">
                <label>Add New Department</label>
                <?php if (!empty($thisDept)): ?>
                    <input type="hidden" name="id" value='<?php echo $thisDept['id'] ?>' />
                    <input type="hidden" id="updateDepartmentTitle" value="yes">
                    <input type="hidden" id="oldDepartmentTitle" value="<?php echo $thisDept['title'] ?>">
                    <input name="title"  id="departmentTitle" value="<?php echo $thisDept['title'] ?>" type="text" class="form-control" placeholder="Department Name">
                <?php else: ?>
                    <input name="title" id="departmentTitle" type="text" class="form-control" placeholder="Department Name">
                <?php endif; ?>
            </div>
            <div class="tab-group config-submit">
                <button type="submit" onclick="saveDepartment('employeeDepartmentForm')"><span class="icon icon-folder"></span>&nbsp;<?php echo $this->lang->line('save') ?></button>
            </div>
            <?php form_close() ?>
            <table class="report-table text-center">
                <thead class="table-bg">
                    <tr>
                        <th><?php echo $this->lang->line('serial') ?></th>
                        <th><?php echo $this->lang->line('name') ?></th>
                        <?php if ($this->session->userdata('group') <= 3): ?>
                            <th><?php echo $this->lang->line('branch') ?></th>
                        <?php endif ?>
                        <th><?php echo $this->lang->line('action') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($departments)): ?>
                        <?php $index = 1; ?>
                        <?php foreach ($departments as $aDept): ?>
                            <tr>
                                <td><?php echo $index ?></td>
                                <td><?php echo $aDept->title ?></td>
                                <?php if ($this->session->userdata('group') <= 3): ?>
                                    <td><?php echo get_title('branch', array('id' => $aDept->branch)) ?></td>
                                <?php endif ?>
                                <td><span class="icon icon-pencil" onclick="zamanEposNavigator('', '<?php echo site_url('employee/department/' . $aDept->id) ?>','')"></span></td>
                            </tr>
                            <?php $index++ ?>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="<?php $this->session->userdata('group') <= '3' ? print 4 : print 3 ?>"><?php echo sprintf($this->lang->line('not_found'), $this->lang->line('department')) ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <div class="setting-general-keyboard text-center"></div>
            <div class="clearfix padded-top-more text-right"><span class="icon icon-keyboard btn-keyboard-close" onclick="zamanToogleEposVirtualKeyboard('setting-general-keyboard')">&nbsp;<?php echo $this->lang->line('open_virtual_keyboard') ?></span></div>
        </div>
    </div>
</div>
<?php $this->load->view('settings/partials/footer') ?>
<script type="text/javascript">
    function saveDepartment(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        $('.page-loader').show();
                    },
                    success: function (response) {
                        $('.page-loader').hide();
                        if (response.status) {
                            zamanEposNavigator('', '<?php echo site_url('employee/department') ?>','');
                        } else {
                            warning('<?php echo $this->lang->line('error') ?>', response.message, '<?php echo $this->lang->line('ok') ?>');
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            ignore: ":hidden",
            rules: {
                title: {
                    required: true,
                    alphanumeric: true,
                    remote: {
                        url: "<?php echo site_url('employee/checkDepartment') ?>",
                        type: "post",
                        data: {
                            value: function () {
                                return $("#departmentTitle").val();
                            },
                            column: 'title',
                            old: function () {
                                if ($('#oldDepartmentTitle').length > 0) {
                                    return $('#oldDepartmentTitle').val();
                                } else {
                                    return 'none';
                                }
                            },
                            update: function () {
                                if ($('#updateDepartmentTitle').length > 0) {
                                    return 'yes';
                                } else {
                                    return 'no';
                                }
                            }
                        }
                    }
                }
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
</script>