<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Employee extends Epos_Template {

    function __construct() {
        parent::__construct();
        $this->load->model('Employee_Model');
        if ($this->Employee_Model->isThisUserAnEposLogger() && (($this->cookies && !empty($this->cookies)) || ($this->session->userdata('group') == 2))) {
            return true;
        } else {
            redirect('user/login/index/' . $this->session->userdata('branch') . '/' . $this->session->userdata('team'));
        }
    }

    public function index($id = null, $dept = null, $manager = null, $branchid = null) {
        $branch = $branchid ? $branchid : $this->session->userdata('branch');
        $this->page_title = $this->lang->line('employee');
        $data['employees'] = $this->Employee_Model->getEmployees((int) $id, $dept, $manager, $branch)->result();
        $data['filterData'] = array('id' => $id, 'dept' => $dept, 'manager' => $manager, 'branch' => $branch);
        $data['departments'] = $this->Employee_Model->get_list('employeedept',array('branch'=>$branch))->result();
        $data['managers'] = $this->Employee_Model->get_list('employeemanager', array('branch' => $branch))->result();
        $data['refresh'] = base_url(uri_string());
        $this->load->view('employee/index', $data, false);
    }

    public function getDepartmentManager() {
        $dept = $this->input->post('dept');
        $branch = $this->session->userdata('branch');
        $managers = $this->Employee_Model->get_list('employeemanager', array('dept' => $dept, 'branch' => $branch), array('id', 'title'))->result();
        $status = !empty($managers) ? true : false;
        echo json_encode(array('status' => $status, 'managers' => $managers));
    }

    public function add($id = null) {
        $this->page_title = $this->lang->line('employee') . ' | ' . $this->lang->line('add');
        $data['departments'] = $this->Employee_Model->get_list('employeedept', array('branch' => $this->session->userdata('branch')))->result();
        $data['managers'] = $this->Employee_Model->get_list('employeemanager', array('branch' => $this->session->userdata('branch')))->result();
        if ($id && (int) $id > 0) {
            $data['thisEmployee'] = $this->Employee_Model->get_single('employee', array('id' => $id,'branch' => $this->session->userdata('branch')))->row_array();
        }
        $data['refresh'] = base_url(uri_string());
        $this->load->view('employee/add', $data, false);
    }

    public function view($id = null) {
        $this->page_title = $this->lang->line('employee') . ' | ' . $this->lang->line('add');
        if ($id && (int) $id > 0) {
            $data['thisEmployee'] = $this->Employee_Model->get_single('employee')->row_array();
        }
        $data['refresh'] = base_url(uri_string());
        $this->load->view('employee/view', $data, false);
    }

    public function saveEmployee() {
        $data = $this->preparePostedData();
        $insert_id = null;
        $uploadStatus = true;
        $uploadErrorMessage = null;
        if (!empty($_FILES['photo'])) {
            $config = array('upload_path' => './uploads/', 'allowed_types' => 'gif|jpg|png|jpeg', 'max_size' => '1000', 'max_width' => '650', 'max_height' => '450', 'overwrite' => true);
            $uploadStatus = $this->uploadimage($config, 'photo');
            $uploadErrorMessage = $uploadStatus ? null : $this->upload->display_errors();
            $upload_data = $this->upload->data();
            if ($uploadStatus && !empty($upload_data['orig_name'])) {
                $data['photo'] = $upload_data['raw_name'] . $upload_data['file_ext'];
            }
        }
        if (!isset($data['id']) || $data['id'] == NULL) {
            $data['branch'] = $this->session->userdata('branch');
            $insert_id = $this->Employee_Model->saveEmployee($data, NULL);
            if ($insert_id) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('name')) . ' has created an employee #' . $data['first_name'] . ' ' . $data['last_name']
                );
                $this->Employee_Model->posactivity($activity);
            }
        } else {
            $id = $data['id'];
            unset($data['id']);
            $insert_id = $this->Employee_Model->saveEmployee($data, $id);
            if ($insert_id) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('name')) . ' has created an employee #' . $data['first_name'] . ' ' . $data['last_name']
                );
                $this->Employee_Model->posactivity($activity);
            }
        }

        $message = $insert_id ? $this->lang->line('data_saved_successfully') : $this->lang->line('data_saving_failed');
        echo json_encode(array('status' => $insert_id, 'message' => $message, 'id' => $insert_id));
    }

    public function removeEmployeePhoto($id) {
        $data = $this->input->post();
        $status = checkfile($data['path'], $data['image']);
        if ($status) {
            $result = $this->Employee_Model->saveEmployee(array('photo' => ''), $id);
            unlink(realpath($data['path'] . $data['image']));
            if (!checkfile($data['path'], $data['image']) && $result) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('name')) . ' has deleted an employee #' . $id . ' photo'
                );
                $this->Employee_Model->posactivity($activity);
                echo json_encode(array('status' => $result, 'id' => $id, 'message' => $this->lang->line('delete_success')));
            } else {
                echo json_encode(array('status' => false, 'message' => $this->lang->line('delete_failed')));
            }
        }
    }

    public function department($id = null) {
        $this->page_title = $this->lang->line('employee') . ' | ' . $this->lang->line('department');
        $data['departments'] = $this->Employee_Model->get_list('employeedept', array('branch' => $this->session->userdata('branch')))->result();
        if ($id) {
            $data['thisDept'] = $this->Employee_Model->get_single('employeedept', array('id' => $id, 'branch' => $this->session->userdata('branch')))->row_array();
        }
        $data['refresh'] = base_url(uri_string());
        $this->load->view('employee/department', $data, false);
    }

    public function checkDepartment() {
        $column = $this->input->post('column');
        $value = $this->input->post('value');
        $update = $this->input->post('update');
        $result = $this->Employee_Model->checkDepartment($column, $value, $update);
        if ($result) {
            echo json_encode(sprintf($this->lang->line('item_already_taken'), $value));
        } else {
            echo json_encode(true);
        }
    }

    public function saveDepartment() {
        $data = $this->preparePostedData();
        $insert_id = null;
        if (!isset($data['id']) || $data['id'] == NULL) {
            $data['branch'] = $this->session->userdata('branch');
            $insert_id = $this->Employee_Model->saveDepartment($data, NULL);
            if ($insert_id) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('name')) . ' has created department #' . $data['title']
                );
                $this->Employee_Model->posactivity($activity);
            }
        } else {
            $id = $data['id'];
            unset($data['id']);
            $insert_id = $this->Employee_Model->saveDepartment($data, $id);
            if ($insert_id) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('name')) . ' has updated department #' . $data['title']
                );
                $this->Employee_Model->posactivity($activity);
            }
        }
        $message = $insert_id ? $this->lang->line('data_saved_successfully') : $this->lang->line('data_saving_failed');
        echo json_encode(array('status' => $insert_id, 'message' => $message, 'department' => $insert_id));
    }

    public function manager($id = null) {
        $this->page_title = $this->lang->line('employee') . ' | ' . $this->lang->line('manager');
        $data['departments'] = $this->Employee_Model->get_list('employeedept', array('branch' => $this->session->userdata('branch')))->result();
        $data['managers'] = $this->Employee_Model->get_list('employeemanager', array('branch' => $this->session->userdata('branch')))->result();
        if ($id) {
            $data['thisManager'] = $this->Employee_Model->get_single('employeemanager', array('id' => $id, 'branch' => $this->session->userdata('branch')))->row_array();
        }
        $data['refresh'] = base_url(uri_string());
        $this->load->view('employee/manager', $data, false);
    }

    public function checkManager() {
        $column = $this->input->post('column');
        $value = $this->input->post('value');
        $update = $this->input->post('update');
        $result = $this->Employee_Model->checkManager($column, $value, $update);
        if ($result) {
            echo json_encode(sprintf($this->lang->line('item_already_taken'), $value));
        } else {
            echo json_encode(true);
        }
    }

    public function saveManager() {
        $data = $this->preparePostedData();
        $insert_id = null;
        if (!isset($data['id']) || $data['id'] == NULL) {
            $data['branch'] = $this->session->userdata('branch');
            $insert_id = $this->Employee_Model->saveManager($data, NULL);
            if ($insert_id) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('name')) . ' has created manager ' . $data['title']
                );
                $this->Employee_Model->posactivity($activity);
            }
        } else {
            $id = $data['id'];
            unset($data['id']);
            $insert_id = $this->Employee_Model->saveManager($data, $id);
            if ($insert_id) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('name')) . ' has updated manager ' . $data['title']
                );
                $this->Employee_Model->posactivity($activity);
            }
        }
        $message = $insert_id ? $this->lang->line('data_saved_successfully') : $this->lang->line('data_saving_failed');
        echo json_encode(array('status' => $insert_id, 'message' => $message, 'manager' => $insert_id));
    }

    public function attendance() {
        $this->page_title = $this->lang->line('employee') . ' | ' . $this->lang->line('attendance');
        $data['refresh'] = base_url(uri_string());
        $this->load->view('employee/attendance', $data, false);
    }

    public function payroll() {
        $this->page_title = $this->lang->line('employee') . ' | ' . $this->lang->line('payroll');
        $data['refresh'] = base_url(uri_string());
        $this->load->view('employee/payroll', $data, false);
    }

}
